/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.PlayerControlGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByWaterGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityWaterJet;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityIoray
extends EntityCreatureRideable
implements IMob,
IGroupPredator {
    WanderGoal wanderAI;
    AttackRangedGoal rangedAttackAI;
    EntityWaterJet projectile = null;
    EntityWaterJet abilityProjectile = null;

    public EntityIoray(EntityType<? extends EntityIoray> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new StayByWaterGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayerControlGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeGoal(this).setLongMemory(false).setMaxChaseDistanceSq(4.0f));
        this.rangedAttackAI = new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f).setMountedAttacking(false);
        this.field_70714_bg.func_75776_a(5, (Goal)this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(6, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.wanderAI = new WanderGoal(this);
        this.field_70714_bg.func_75776_a(8, (Goal)this.wanderAI.setPauseRate(60));
        this.field_70714_bg.func_75776_a(9, (Goal)new BegGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(AnimalEntity.class));
            this.field_70715_bh.func_75776_a(8, (Goal)new AttackTargetingGoal(this).setTargetClass(SquidEntity.class));
        }
        this.field_70715_bh.func_75776_a(9, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        rider.func_195064_c(new EffectInstance(Effects.field_76427_o, 105, 1));
        super.riderEffects(rider);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.6;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return false;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.setTime(20);
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = new EntityWaterJet(ProjectileManager.getInstance().oldProjectileTypes.get(EntityWaterJet.class), this.func_130014_f_(), (LivingEntity)this, 20, 10);
            this.projectile.setOffset(0.0, 0.0, 1.0);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)this.projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaRecoveryMax() * 2.0f) {
            return;
        }
        if (this.hasAttackTarget()) {
            this.func_70624_b(null);
        }
        if (this.abilityProjectile != null && this.abilityProjectile.func_70089_S()) {
            this.abilityProjectile.setTime(20);
        } else {
            this.abilityProjectile = null;
        }
        if (this.abilityProjectile == null) {
            if (this.func_184179_bs() == null || !(this.func_184179_bs() instanceof LivingEntity)) {
                return;
            }
            this.abilityProjectile = new EntityWaterJet(ProjectileManager.getInstance().oldProjectileTypes.get(EntityWaterJet.class), this.func_130014_f_(), (LivingEntity)this.func_184179_bs(), 25, 20, (Entity)this);
            this.abilityProjectile.setOffset(0.0, 1.0, 1.0);
            this.func_184185_a(this.abilityProjectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)this.abilityProjectile);
        }
        this.applyStaminaCost();
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76427_o, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack) || ObjectLists.inItemList("cookedfish", testStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

