/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByWaterGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.ParentTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityIka
extends EntityCreatureAgeable
implements IGroupAnimal {
    WanderGoal wanderAI;

    public EntityIka(EntityType<? extends EntityIka> entityType, World world) {
        super((EntityType<? extends EntityCreatureAgeable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.babySpawnChance = 0.01;
        this.canGrow = true;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this).setSink(true));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal(this).setItemList("Vegetables"));
        this.field_70714_bg.func_75776_a(3, (Goal)new StayByWaterGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidGoal(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MateGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal(this).setSpeed(1.0));
        this.wanderAI = new WanderGoal(this);
        this.field_70714_bg.func_75776_a(7, (Goal)this.wanderAI);
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (Goal)new ParentTargetingGoal(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupPredator.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70090_H()) {
                this.wanderAI.setPauseRate(20);
            } else {
                this.wanderAI.setPauseRate(0);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        float waterSpeed = 1.0f;
        if (this.func_70090_H()) {
            waterSpeed = 2.0f;
        } else if (this.waterContact()) {
            waterSpeed = 1.5f;
        }
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return waterSpeed * 0.75f;
        }
        return waterSpeed;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        BlockState blockState = this.func_130014_f_().func_180495_p(pos);
        if (blockState.func_177230_c() == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(pos)) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    @Override
    public boolean canBeTempted() {
        if (this.func_70086_ai() <= -100) {
            return false;
        }
        return super.canBeTempted();
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return false;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f) {
            return 0.25f;
        }
        return 1.0f;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        if (this.func_70086_ai() <= -100) {
            return false;
        }
        return ObjectLists.inItemList("Vegetables", testStack);
    }
}

