/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RiderRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityPoisonRay;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityEyewig
extends EntityCreatureRideable {
    AttackRangedGoal rangedAttackAI;
    EntityPoisonRay abilityProjectile = null;
    EntityPoisonRay projectile = null;

    public EntityEyewig(EntityType<? extends EntityEyewig> entityType, World world) {
        super((EntityType<? extends EntityCreatureRideable>)entityType, world);
        this.attribute = CreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackMeleeGoal(this).setLongMemory(false).setMaxChaseDistanceSq(4.0f));
        this.rangedAttackAI = new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f).setMountedAttacking(false);
        this.field_70714_bg.func_75776_a(6, (Goal)this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(7, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RiderRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RiderAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(7, (Goal)new AttackTargetingGoal(this).setTargetClass(ChickenEntity.class));
        }
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaRecoveryMax() * 2.0f) {
            return;
        }
        if (this.hasAttackTarget()) {
            this.func_70624_b(null);
        }
        if (this.abilityProjectile != null && this.abilityProjectile.func_70089_S()) {
            this.abilityProjectile.setTime(20);
        } else {
            this.abilityProjectile = null;
        }
        if (this.abilityProjectile == null) {
            if (this.func_184179_bs() == null || !(this.func_184179_bs() instanceof LivingEntity)) {
                return;
            }
            this.abilityProjectile = new EntityPoisonRay(ProjectileManager.getInstance().oldProjectileTypes.get(EntityPoisonRay.class), this.func_130014_f_(), (LivingEntity)this.func_184179_bs(), 25, 20, (Entity)this);
            this.abilityProjectile.setOffset(0.0, 0.5, 0.0);
            this.func_184185_a(this.abilityProjectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)this.abilityProjectile);
        }
        this.applyStaminaCost();
    }

    @Override
    public void attackRanged(Entity target, float range) {
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.setTime(20);
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = new EntityPoisonRay(ProjectileManager.getInstance().oldProjectileTypes.get(EntityPoisonRay.class), this.func_130014_f_(), (LivingEntity)this, 20, 10);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)this.projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean func_213398_dR() {
        if (this.isTamed()) {
            return super.func_213398_dR();
        }
        if (this.func_130014_f_() != null && this.func_130014_f_().func_72935_r()) {
            return this.testLightLevel() < 2;
        }
        return super.func_213398_dR();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }
}

