/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.api.IGroupShadow;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityBloodleech;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityEpion
extends EntityCreatureTameable
implements IMob,
IGroupShadow {
    public boolean epionGreifing = true;

    public EntityEpion(EntityType<? extends EntityEpion> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEAD;
        this.hasAttackSound = false;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setRange(14.0f).setMinChaseDistance(6.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && !this.isTamed() && !this.isFlying() && (this.field_70122_E || this.func_70090_H()) && this.func_70089_S()) {
            int explosionRadius = 2;
            if (this.subspecies != null) {
                explosionRadius = 3;
            }
            explosionRadius = Math.max(2, Math.round((float)explosionRadius * (float)this.sizeScale));
            if (this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.epionGreifing) {
                this.func_130014_f_().func_217385_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionRadius, Explosion.Mode.BREAK);
            }
            this.func_70106_y();
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityBloodleech.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        float brightness;
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        return !this.daylightBurns() || !this.func_130014_f_().func_72935_r() || !this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") || !this.epionGreifing || !((brightness = this.func_70013_c()) > 0.5f) || !this.func_130014_f_().func_175710_j(this.func_180425_c());
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean daylightBurns() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!"Vampire Bat".equals(this.func_200201_e())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_vampirebat";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

