/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.creature.EntityTreant;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityEnt
extends EntityCreatureTameable
implements IMob,
IGroupPlant {
    public EntityEnt(EntityType<? extends EntityEnt> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsUnderground = false;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackMeleeGoal(this).setTargetClass(PlayerEntity.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpClasses(EntityTreant.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupFire.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70086_ai() >= 0) {
            if (this.func_70090_H()) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 2));
            } else if (this.func_203008_ap()) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 1));
            }
        }
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityTreant) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        float leeching = Math.max(1.0f, this.getAttackDamage(damageScale));
        this.func_70691_i(leeching);
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            LivingEntity entityLiving;
            Item heldItem = null;
            if (damageSrc.func_76346_g() instanceof PlayerEntity) {
                PlayerEntity entityPlayer = (PlayerEntity)damageSrc.func_76346_g();
                if (!entityPlayer.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                    heldItem = entityPlayer.func_184586_b(Hand.MAIN_HAND).func_77973_b();
                }
            } else if (damageSrc.func_76346_g() instanceof LivingEntity && !(entityLiving = (LivingEntity)damageSrc.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(Hand.MAIN_HAND).func_77973_b();
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 2.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if ("Twisted Ent".equals(this.func_200201_e())) {
            String textureName = this.getTextureName() + "_twisted";
            if (AssetManager.getTexture(textureName) == null) {
                AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
            }
            return AssetManager.getTexture(textureName);
        }
        if ("Salty Tree".equals(this.func_200201_e())) {
            String textureName = this.getTextureName() + "_saltytree";
            if (AssetManager.getTexture(textureName) == null) {
                AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
            }
            return AssetManager.getTexture(textureName);
        }
        return super.getTexture();
    }
}

