/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.creature.EntityVespid;
import com.lycanitesmobs.core.entity.creature.EntityVespidQueen;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityPoop;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.localisation.LanguageManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityConba
extends EntityCreatureTameable
implements IMob {
    AttackRangedGoal aiAttackRanged;
    AttackMeleeGoal aiAttackMelee;
    AvoidGoal aiAvoid;
    public boolean vespidInfection = false;
    public int vespidInfectionTime = 0;

    public EntityConba(EntityType<? extends EntityConba> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.aiAttackMelee = new AttackMeleeGoal(this).setLongMemory(true).setEnabled(false);
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiAttackMelee);
        this.aiAttackRanged = new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(10.0f).setChaseTime(-1);
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiAttackRanged);
        this.aiAvoid = new AvoidGoal(this).setNearSpeed(1.5).setFarSpeed(1.3).setNearDistance(5.0).setFarDistance(9.0);
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiAvoid);
        this.field_70714_bg.func_75776_a(4, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AvoidTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public String getSpeciesName() {
        String entityName;
        String infection = "";
        if (this.vespidInfection && (entityName = this.creatureInfo.getName()) != null) {
            infection = LanguageManager.translate("entity." + this.creatureInfo.modInfo.modid + "." + entityName + ".infected") + " ";
        }
        return infection + super.getSpeciesName();
    }

    @Override
    public String getTextureName() {
        if (this.vespidInfection) {
            return super.getTextureName() + "_infected";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            if (this.hasAvoidTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(1.0f, 0.6, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 0.6);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.vespidInfection && "theswarm".equals(this.spawnEventType)) {
                this.vespidInfection = true;
            }
            if (this.vespidInfection && !this.func_130014_f_().field_72995_K) {
                this.aiAttackMelee.setEnabled(true);
                this.aiAttackRanged.setEnabled(false);
                if (this.vespidInfectionTime++ >= 1200) {
                    this.spawnVespidSwarm();
                    this.func_70106_y();
                }
            } else {
                this.aiAttackMelee.setEnabled(false);
                this.aiAttackRanged.setEnabled(true);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.vespidInfection = this.extraAnimation01();
            if (this.vespidInfection) {
                for (int i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void func_70619_bc() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() != this.getAvoidTarget()) {
            this.setAvoidTarget(this.func_70638_az());
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityVespid || target instanceof EntityVespidQueen) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityPoop.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.vespidInfection) {
            this.spawnVespidSwarm();
        }
        super.func_70645_a(damageSource);
    }

    public void spawnVespidSwarm() {
        int j = 2 + this.field_70146_Z.nextInt(5) + this.func_130014_f_().func_175659_aa().func_151525_a() - 1;
        for (int k = 0; k < j; ++k) {
            float f = ((float)(k % 2) - 0.5f) * this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 4.0f;
            float f1 = ((float)(k / 2) - 0.5f) * this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 4.0f;
            EntityVespid vespid = (EntityVespid)CreatureManager.getInstance().getCreature("vespid").createEntity(this.func_130014_f_());
            vespid.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            vespid.applySubspecies(this.getSubspeciesIndex());
            vespid.setGrowingAge(vespid.growthTime);
            vespid.spawnEventType = this.spawnEventType;
            this.func_130014_f_().func_217376_c((Entity)vespid);
            if (this.func_70638_az() == null) continue;
            vespid.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean extraAnimation01() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.vespidInfection;
        }
        return this.extraAnimation01;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("VespidInfection")) {
            this.vespidInfection = nbtTagCompound.func_74767_n("VespidInfection");
        }
        if (nbtTagCompound.func_74764_b("VespidInfectionTime")) {
            this.vespidInfectionTime = nbtTagCompound.func_74762_e("VespidInfectionTime");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("VespidInfection", this.vespidInfection);
        if (this.vespidInfection) {
            nbtTagCompound.func_74768_a("VespidInfectionTime", this.vespidInfectionTime);
        }
    }
}

