/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.EntityProjectileRapidFire;
import com.lycanitesmobs.core.entity.creature.EntityAegis;
import com.lycanitesmobs.core.entity.creature.EntityArgus;
import com.lycanitesmobs.core.entity.creature.EntityDjinn;
import com.lycanitesmobs.core.entity.creature.EntityGeonach;
import com.lycanitesmobs.core.entity.creature.EntityJengu;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowFuseGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FuseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityCinder
extends EntityCreatureTameable
implements IMob,
IGroupFire,
IFusable {
    public float inWallDamageAbsorbed = 0.0f;
    protected IFusable fusionTarget;

    public EntityCinder(EntityType<? extends EntityCinder> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsInBlock = false;
        this.hasAttackSound = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowFuseGoal(this).setLostDistance(16.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(5.0f).setMinChaseDistance(2.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupIce.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupWater.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(SnowGolemEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPlant.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
        this.field_70715_bh.func_75776_a(7, (Goal)new FuseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.inWallDamageAbsorbed >= 10.0f) {
            this.transform(CreatureManager.getInstance().getEntityType("volcan"), null, false);
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof IGroupFire) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ArrayList<EntityProjectileRapidFire> projectiles = new ArrayList<EntityProjectileRapidFire>();
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("ember");
        EntityProjectileRapidFire projectileEntry = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectiles.add(projectileEntry);
        EntityProjectileRapidFire projectileEntry2 = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry2.offsetX += 1.0;
        projectiles.add(projectileEntry2);
        EntityProjectileRapidFire projectileEntry3 = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry3.offsetX -= 1.0;
        projectiles.add(projectileEntry3);
        EntityProjectileRapidFire projectileEntry4 = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry4.offsetZ += 1.0;
        projectiles.add(projectileEntry4);
        EntityProjectileRapidFire projectileEntry5 = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry5.offsetZ -= 1.0;
        projectiles.add(projectileEntry5);
        EntityProjectileRapidFire projectileEntry6 = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry6.offsetY += 1.0;
        projectiles.add(projectileEntry6);
        EntityProjectileRapidFire projectileEntry7 = new EntityProjectileRapidFire(ObjectManager.specialEntityTypes.get(EntityProjectileRapidFire.class), projectileInfo, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry7.offsetY -= 1.0;
        projectiles.add(projectileEntry7);
        for (EntityProjectileRapidFire projectile : projectiles) {
            projectile.setProjectileScale(1.0f);
            projectile.field_70163_u -= (double)(this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 4.0f);
            float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
            double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
            double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 0.6f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(EntityItemCustom entityitem) {
        entityitem.setCanBurn(false);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    public IFusable getFusionTarget() {
        return this.fusionTarget;
    }

    @Override
    public void setFusionTarget(IFusable fusionTarget) {
        this.fusionTarget = fusionTarget;
    }

    @Override
    public EntityType<? extends LivingEntity> getFusionType(IFusable fusable) {
        if (fusable instanceof EntityJengu) {
            return CreatureManager.getInstance().getEntityType("xaphan");
        }
        if (fusable instanceof EntityGeonach) {
            return CreatureManager.getInstance().getEntityType("volcan");
        }
        if (fusable instanceof EntityDjinn) {
            return CreatureManager.getInstance().getEntityType("zephyr");
        }
        if (fusable instanceof EntityAegis) {
            return CreatureManager.getInstance().getEntityType("aegis");
        }
        if (fusable instanceof EntityArgus) {
            return CreatureManager.getInstance().getEntityType("argus");
        }
        return null;
    }
}

