/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import net.minecraft.block.LogBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityCalpod
extends EntityCreatureBase
implements IMob,
IGroupPrey {
    private int calpodSwarmLimit = 5;
    private boolean calpodGreifing = true;

    public EntityCalpod(EntityType<? extends EntityCalpod> entityType, World world) {
        super(entityType, world);
        this.attribute = CreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidGoal(this).setNearSpeed(2.0).setFarSpeed(1.5).setNearDistance(5.0).setFarDistance(10.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(1, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupHunter.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupAlpha.class));
    }

    @Override
    public void func_70636_d() {
        float distance;
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.updateTick % 40L == 0L) {
            this.allyUpdate();
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.calpodGreifing && (distance = this.func_70638_az().func_70032_d((Entity)this)) <= this.func_213305_a((Pose)Pose.STANDING).field_220315_a + 1.0f) {
            this.destroyAreaBlock((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, LogBlock.class, true, 0);
        }
        super.func_70636_d();
    }

    public void allyUpdate() {
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.calpodSwarmLimit > 0 && this.nearbyCreatureCount(this.getClass(), 64.0) < this.calpodSwarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.125f) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        EntityCreatureBase minion = (EntityCreatureBase)this.creatureInfo.createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        minion.setMinion(true);
        minion.applySubspecies(this.getSubspeciesIndex());
        this.func_130014_f_().func_217376_c((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof IGroupAlpha || target instanceof IGroupPredator) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        this.allyUpdate();
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }
}

