/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.creature.EntityBelph;
import com.lycanitesmobs.core.entity.creature.EntityRahovart;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireOrb;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireball;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBehemoth
extends EntityCreatureTameable
implements IMob,
IGroupDemon {
    protected static final DataParameter<Integer> HELLFIRE_ENERGY = EntityDataManager.func_187226_a(EntityBehemoth.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int hellfireEnergy = 0;
    public List<EntityHellfireOrb> hellfireOrbs = new ArrayList<EntityHellfireOrb>();

    public EntityBehemoth(EntityType<? extends EntityBehemoth> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEAD;
        this.hasAttackSound = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(8.0f).setChaseTime(-1));
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderGoal(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpClasses(EntityBelph.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
        } else {
            try {
                this.hellfireEnergy = (Integer)this.field_70180_af.func_187225_a(HELLFIRE_ENERGY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.func_130014_f_().field_72995_K && this.hellfireEnergy > 0) {
            EntityRahovart.updateHellfireOrbs((LivingEntity)this, this.updateTick, 3, this.hellfireEnergy, 1.0f, this.hellfireOrbs);
        }
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0) {
            int trailHeight = 1;
            int trailWidth = 1;
            if (this.getSubspeciesIndex() >= 3) {
                trailWidth = 3;
            }
            for (int y = 0; y < trailHeight; ++y) {
                Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block == null || block != Blocks.field_150350_a && block != Blocks.field_150480_ab && block != Blocks.field_150433_aE && block != Blocks.field_196804_gh && block != ObjectManager.getBlock("frostfire") && block != ObjectManager.getBlock("icefire") && block != ObjectManager.getBlock("scorchfire") && block != ObjectManager.getBlock("doomfire")) continue;
                if (trailWidth == 1) {
                    this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), ObjectManager.getBlock("hellfire").func_176223_P());
                    continue;
                }
                for (int x = -(trailWidth / 2); x < trailWidth / 2 + 1; ++x) {
                    for (int z = -(trailWidth / 2); z < trailWidth / 2 + 1; ++z) {
                        this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(x, y, z), ObjectManager.getBlock("hellfire").func_176223_P());
                    }
                }
            }
        }
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityBelph) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityHellfireball.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!"Krampus".equals(this.func_200201_e())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_krampus";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

