/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.actions.SwimmingGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.ParentTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAspid
extends EntityCreatureAgeable
implements IGroupAnimal {
    public EntityAspid(EntityType<? extends EntityAspid> entityType, World world) {
        super((EntityType<? extends EntityCreatureAgeable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.attackCooldownMax = 10;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimmingGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidGoal(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MateGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal(this).setItemList("Mushrooms"));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(2, (Goal)new ParentTargetingGoal(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new AvoidTargetingGoal(this).setTargetClass(IGroupPredator.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && (this.field_70173_aa % 10 == 0 || this.isMoving() && this.field_70173_aa % 5 == 0)) {
            int trailHeight = 2;
            if (this.func_70631_g_()) {
                trailHeight = 1;
            }
            for (int y = 0; y < trailHeight; ++y) {
                Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block != Blocks.field_150350_a && block != Blocks.field_150433_aE && block != ObjectManager.getBlock("poisoncloud")) continue;
                this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), ObjectManager.getBlock("poisoncloud").func_176223_P());
            }
        }
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        if (this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() != Blocks.field_150350_a) {
            BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        if (!this.hasAttackTarget() && !this.hasMaster()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("Mushrooms", testStack);
    }
}

