/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerAttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerRevengeTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.projectile.EntityScorchfireball;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAfrit
extends EntityCreatureTameable
implements IMob,
IGroupFire {
    protected boolean wantsToLand;
    protected boolean isLanded;

    public EntityAfrit(EntityType<? extends EntityAfrit> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = false;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setRange(14.0f).setMinChaseDistance(5.0f).setCheckSight(false));
        this.field_70714_bg.func_75776_a(3, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal(this).setStrayDistance(16.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal(this).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerRevengeTargetingGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerAttackTargetingGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupIce.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupWater.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(SnowGolemEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPlant.class));
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isLanded) {
                this.wantsToLand = false;
                if (this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                    this.leap(1.0, 1.0);
                    this.isLanded = false;
                }
            } else if (this.wantsToLand) {
                if (!this.isLanded && this.isSafeToLand()) {
                    this.isLanded = true;
                }
            } else if (this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                this.wantsToLand = true;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.wantsToLand || !this.isLanded) {
            BlockPos groundPos = wanderPosition.func_177977_b();
            while (groundPos.func_177956_o() > 0 && this.func_130014_f_().func_180495_p(groundPos).func_177230_c() == Blocks.field_150350_a) {
                groundPos = groundPos.func_177977_b();
            }
            if (this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
                return groundPos.func_177984_a();
            }
        }
        return super.getWanderPosition(wanderPosition);
    }

    @Override
    public double getFlightOffset() {
        if (!this.wantsToLand) {
            super.getFlightOffset();
        }
        return 0.0;
    }

    @Override
    public boolean func_213358_a(EntityType targetType) {
        return super.func_213358_a(targetType);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityScorchfireball.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.8f, 2.0f, 6.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        return !this.isLanded;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void applyDropEffects(EntityItemCustom entityitem) {
        entityitem.setCanBurn(false);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }
}

