/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByWaterGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.OwnerDefenseTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAbtu
extends EntityCreatureTameable
implements IMob,
IGroupPredator {
    WanderGoal wanderAI;
    int swarmLimit = 5;

    public EntityAbtu(EntityType<? extends EntityAbtu> entityType, World world) {
        super((EntityType<? extends EntityCreatureTameable>)entityType, world);
        this.attribute = CreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.9;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new StayByWaterGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.wanderAI = new WanderGoal(this);
        this.field_70714_bg.func_75776_a(6, (Goal)this.wanderAI.setPauseRate(0));
        this.field_70714_bg.func_75776_a(10, (Goal)new WatchClosestGoal((MobEntity)this).setTargetClass(PlayerEntity.class));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookIdleGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new RevengeTargetingGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (Goal)new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackTargetingGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupPrey.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetingGoal(this).setTargetClass(AnimalEntity.class));
        }
        this.field_70715_bh.func_75776_a(6, (Goal)new OwnerDefenseTargetingGoal(this));
    }

    @Override
    public void func_70636_d() {
        if (this.hasAttackTarget() && this.updateTick % 20L == 0L) {
            this.allyUpdate();
        }
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.func_70631_g_() && (this.func_70090_H() || this.field_70122_E) && this.func_70681_au().nextInt(10) == 0) {
            this.leap(4.0f, 0.6, (Entity)this.func_70638_az());
        }
        super.func_70636_d();
    }

    public void allyUpdate() {
        float spawnChance;
        float random;
        if (this.func_130014_f_().field_72995_K || this.func_70631_g_()) {
            return;
        }
        if (this.swarmLimit > 0 && this.nearbyCreatureCount(this.getClass(), 64.0) < this.swarmLimit && (random = this.field_70146_Z.nextFloat()) <= (spawnChance = 0.25f)) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        EntityAbtu minion = new EntityAbtu((EntityType<? extends EntityAbtu>)this.func_200600_R(), this.func_130014_f_());
        minion.setGrowingAge(minion.growthTime);
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        minion.setMinion(true);
        minion.applySubspecies(this.getSubspeciesIndex());
        this.func_130014_f_().func_217376_c((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        this.allyUpdate();
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return false;
    }
}

