/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityProjectileBase
extends ThrowableEntity {
    public String entityName = "projectile";
    public ModInfo modInfo;
    public long updateTick;
    public boolean movement = true;
    public float projectileScale = 1.0f;
    public int projectileLife = 200;
    public int damage = 1;
    public int pierce = 1;
    public double weight = 1.0;
    public double knockbackChance = 1.0;
    public boolean waterProof = false;
    public boolean lavaProof = false;
    public boolean cutsGrass = false;
    public boolean ripper = false;
    public boolean pierceBlocks = false;
    public int animationFrame = 0;
    public int animationFrameMax = 0;
    public int textureTiling = 1;
    public float textureScale = 1.0f;
    public float textureOffsetY = 0.0f;
    public boolean clientOnly = false;
    protected static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityProjectileBase.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityProjectileBase(EntityType<? extends EntityProjectileBase> entityType, World world) {
        super(entityType, world);
        this.setup();
    }

    public EntityProjectileBase(EntityType<? extends EntityProjectileBase> entityType, World world, LivingEntity entityLiving) {
        this(entityType, world);
        this.func_70107_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
        this.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, 1.1f, 1.0f);
        this.setup();
    }

    public EntityProjectileBase(EntityType<? extends EntityProjectileBase> entityType, World world, double x, double y, double z) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
        this.setup();
    }

    public void setup() {
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
    }

    public void func_70071_h_() {
        ++this.updateTick;
        if (!this.movement) {
            this.field_174854_a = false;
            this.field_71088_bW = this.func_82147_ab();
        }
        double initX = this.field_70165_t;
        double initY = this.field_70163_u;
        double initZ = this.field_70161_v;
        super.func_70071_h_();
        if (!this.movement) {
            this.field_70165_t = initX;
            this.field_70163_u = initY;
            this.field_70161_v = initZ;
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.waterProof && this.func_70090_H()) {
                this.func_70106_y();
            } else if (!this.lavaProof && this.func_180799_ab()) {
                this.func_70106_y();
            }
        }
        if ((!this.func_130014_f_().field_72995_K || this.clientOnly) && this.projectileLife-- <= 0) {
            this.func_70106_y();
        }
        if (this.func_130014_f_().field_72995_K) {
            this.projectileScale = ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
        }
        if (this.animationFrameMax > 0) {
            this.animationFrame = this.animationFrame == this.animationFrameMax || this.animationFrame < 0 ? 0 : ++this.animationFrame;
        }
    }

    public boolean func_180799_ab() {
        return false;
    }

    protected float func_70185_h() {
        return (float)this.weight * 0.03f;
    }

    public void func_174830_Y() {
    }

    protected void func_70184_a(RayTraceResult rayTraceResult) {
        boolean collided = false;
        boolean entityCollision = false;
        boolean blockCollision = false;
        BlockPos impactPos = this.func_180425_c();
        Entity entityHit = null;
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY && rayTraceResult instanceof EntityRayTraceResult) {
            entityHit = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
        }
        if (entityHit != null) {
            LivingEntity target2;
            if (this.func_85052_h() != null && entityHit == this.func_85052_h()) {
                return;
            }
            boolean doDamage = true;
            if (entityHit instanceof LivingEntity) {
                doDamage = this.canDamage((LivingEntity)entityHit);
            }
            if (!(this.func_130014_f_().field_72995_K || this.func_85052_h() != null && entityHit == this.func_85052_h())) {
                this.onEntityCollision(entityHit);
            }
            if (doDamage && entityHit instanceof LivingEntity && this.onEntityLivingDamage(target2 = (LivingEntity)entityHit)) {
                boolean attackSuccess = false;
                float damage = this.getDamage((Entity)target2);
                if (damage != 0.0f) {
                    float damageInit = damage;
                    double targetKnockbackResistance = 0.0;
                    boolean stopKnockback = false;
                    if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance) && target2 instanceof LivingEntity) {
                        targetKnockbackResistance = target2.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                        target2.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                        stopKnockback = true;
                    }
                    if (this.func_85052_h() instanceof EntityCreatureBase) {
                        EntityCreatureBase creatureThrower = (EntityCreatureBase)this.func_85052_h();
                        attackSuccess = creatureThrower.doRangedDamage((Entity)target2, this, damage);
                    } else {
                        double pierceDamage = this.pierce;
                        if ((double)damage <= pierceDamage) {
                            attackSuccess = target2.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), damage);
                        } else {
                            int hurtResistantTimeBefore = target2.field_70172_ad;
                            target2.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), (float)pierceDamage);
                            target2.field_70172_ad = hurtResistantTimeBefore;
                            damage = (float)((double)damage - pierceDamage);
                            attackSuccess = target2.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
                        }
                    }
                    this.onDamage(target2, damageInit, attackSuccess);
                    if (stopKnockback) {
                        target2.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
                    }
                }
            }
            collided = true;
            entityCollision = true;
            impactPos = entityHit.func_180425_c();
            if (!this.func_130014_f_().field_72995_K && this.canDestroyBlock(impactPos)) {
                try {
                    this.placeBlock(this.func_130014_f_(), impactPos);
                }
                catch (Exception target2) {}
            }
        } else if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && rayTraceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            impactPos = blockRayTraceResult.func_216350_a();
            BlockState blockState = this.func_130014_f_().func_180495_p(impactPos);
            if (blockState.func_177230_c() instanceof TallGrassBlock || blockState.func_177230_c() == Blocks.field_196804_gh) {
                if (this.cutsGrass) {
                    this.field_70170_p.func_175655_b(impactPos, false);
                }
            } else {
                collided = blockState.func_185904_a().func_76220_a();
                if (!this.waterProof && blockState.func_185904_a() == Material.field_151586_h) {
                    collided = true;
                }
                if (!this.lavaProof && blockState.func_185904_a() == Material.field_151587_i) {
                    collided = true;
                }
            }
            if (collided) {
                blockCollision = true;
                if (!this.func_130014_f_().field_72995_K && this.canDestroyBlock(impactPos.func_177984_a())) {
                    try {
                        this.placeBlock(this.func_130014_f_(), impactPos.func_177984_a());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (collided) {
            boolean blockPierced;
            if (!this.func_130014_f_().field_72995_K) {
                this.onImpactComplete(impactPos);
            } else {
                this.onImpactVisuals();
            }
            boolean entityPierced = this.ripper && entityCollision;
            boolean bl = blockPierced = this.pierceBlocks && blockCollision;
            if (!(this.func_130014_f_().field_72995_K || entityPierced || blockPierced)) {
                this.func_70106_y();
                if (this.getImpactSound() != null) {
                    this.func_184185_a(this.getImpactSound(), 1.0f, 1.0f / (this.func_130014_f_().field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            }
        }
    }

    public boolean canDamage(LivingEntity targetEntity) {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        LivingEntity owner = this.func_85052_h();
        if (owner != null) {
            EntityCreatureBase ownerCreature;
            if (owner instanceof EntityCreatureBase && !(ownerCreature = (EntityCreatureBase)owner).func_213336_c(targetEntity)) {
                return false;
            }
            if (owner instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)owner, (Entity)targetEntity))) {
                return false;
            }
            if (!this.func_130014_f_().func_73046_m().func_71219_W() && owner instanceof PlayerEntity) {
                EntityCreatureTameable tamedTarget;
                if (targetEntity instanceof PlayerEntity) {
                    return false;
                }
                if (targetEntity instanceof EntityCreatureTameable && (tamedTarget = (EntityCreatureTameable)targetEntity).isTamed()) {
                    return false;
                }
            }
            if (owner.func_184191_r((Entity)targetEntity) && CreatureManager.getInstance().config.friendlyFire) {
                return false;
            }
        }
        return true;
    }

    public void onDamage(LivingEntity target, float damage, boolean attackSuccess) {
    }

    public void onEntityCollision(Entity entity) {
    }

    public boolean onEntityLivingDamage(LivingEntity entityLiving) {
        return true;
    }

    public boolean canDestroyBlock(BlockPos pos) {
        return this.func_130014_f_().func_175623_d(pos) && this.func_130014_f_().func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public void placeBlock(World world, BlockPos pos) {
    }

    public void onImpactComplete(BlockPos impactPos) {
    }

    public void onImpactVisuals() {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        return false;
    }

    public void setProjectileScale(float scale) {
        this.projectileScale = scale;
        if (this.func_130014_f_().field_72995_K && !this.clientOnly) {
            return;
        }
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            this.projectileScale = (float)((double)this.projectileScale * ((EntityCreatureBase)this.func_85052_h()).sizeScale);
        }
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(this.projectileScale));
    }

    public float getProjectileScale() {
        return this.projectileScale;
    }

    public float getTextureOffsetY() {
        return 0.0f;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public float getDamage(Entity entity) {
        float damage = this.damage;
        if (this.func_85052_h() != null && (this.func_85052_h() instanceof PlayerEntity || this.func_85052_h().func_184179_bs() instanceof PlayerEntity) && !(entity instanceof PlayerEntity)) {
            damage *= 1.2f;
        }
        return damage;
    }

    public void setPierce(int pierce) {
        this.pierce = pierce;
    }

    public int getPierce() {
        return this.pierce;
    }

    public int getEffectDuration(int seconds) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            return Math.round((float)((EntityCreatureBase)this.func_85052_h()).getEffectDuration(seconds) / 5.0f);
        }
        return seconds * 20;
    }

    public float getEffectStrength(float value) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)this.func_85052_h()).getEffectStrength(value);
        }
        return value;
    }

    public double[] getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public double[] getFacingPosition(Entity entity, double distance, double angleOffset) {
        double angle = Math.toRadians(entity.field_70177_z) + angleOffset;
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount};
        return coords;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("ProjectileScale", this.projectileScale);
        compound.func_74768_a("ProjectileLife", this.projectileLife);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ProjectileScale")) {
            this.setProjectileScale(compound.func_74760_g("ProjectileScale"));
        }
        if (compound.func_74764_b("ProjectileLife")) {
            this.projectileLife = compound.func_74762_e("ProjectileLife");
        }
    }

    public String getTextureName() {
        return this.entityName.toLowerCase();
    }

    public ResourceLocation getTexture() {
        if (AssetManager.getTexture(this.getTextureName()) == null) {
            AssetManager.addTexture(this.getTextureName(), this.modInfo, "textures/items/" + this.getTextureName() + ".png");
        }
        return AssetManager.getTexture(this.getTextureName());
    }

    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound(this.entityName);
    }

    public SoundEvent getImpactSound() {
        return ObjectManager.getSound(this.entityName + "_impact");
    }
}

