/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.MinionEntityDamageSource;
import com.lycanitesmobs.core.entity.goals.actions.SitGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.item.consumable.ItemTreat;
import com.lycanitesmobs.core.localisation.LanguageManager;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityCreatureTameable
extends EntityCreatureAgeable {
    public float hunger = this.getCreatureHungerMax();
    public float stamina = this.getStaminaMax();
    public float staminaRecovery = 0.5f;
    public float sittingGuardRange = 16.0f;
    public UUID ownerUUID;
    public SitGoal aiSit;
    protected static final DataParameter<Byte> TAMED = EntityDataManager.func_187226_a(EntityCreatureTameable.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(EntityCreatureTameable.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> HUNGER = EntityDataManager.func_187226_a(EntityCreatureTameable.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> STAMINA = EntityDataManager.func_187226_a(EntityCreatureTameable.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityCreatureTameable(EntityType<? extends EntityCreatureTameable> entityType, World world) {
        super((EntityType<? extends EntityCreatureAgeable>)entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_ID, Optional.empty());
        this.field_70180_af.func_187214_a(HUNGER, (Object)Float.valueOf(this.getCreatureHungerMax()));
        this.field_70180_af.func_187214_a(STAMINA, (Object)Float.valueOf(this.getStaminaMax()));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.aiSit = new SitGoal(this);
    }

    @Override
    public ITextComponent func_200200_C_() {
        if (!this.isTamed() || !CreatureManager.getInstance().config.ownerTags) {
            return super.func_200200_C_();
        }
        String ownerName = this.getOwnerName();
        String ownerSuffix = "'s ";
        if (ownerName != null && ownerName.length() > 0 && ("s".equals(ownerName.substring(ownerName.length() - 1)) || "S".equals(ownerName.substring(ownerName.length() - 1)))) {
            ownerSuffix = "' ";
        }
        String ownedName = ownerName + ownerSuffix + this.getFullName();
        if (this.func_145818_k_()) {
            return super.func_200200_C_();
        }
        return new TranslationTextComponent(ownedName, new Object[0]);
    }

    public boolean func_145818_k_() {
        if (!CreatureManager.getInstance().config.ownerTags) {
            return false;
        }
        return super.func_145818_k_();
    }

    @Override
    protected boolean canDespawnNaturally() {
        if (this.isTamed()) {
            return false;
        }
        return super.canDespawnNaturally();
    }

    @Override
    public boolean despawnCheck() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.getPetEntry() != null) {
            if (this.getPetEntry().entity != this && this.getPetEntry().entity != null) {
                return true;
            }
            if (this.getPetEntry().host == null || !this.getPetEntry().host.func_70089_S()) {
                return true;
            }
        }
        if (this.isTamed() && !this.isTemporary) {
            return false;
        }
        return super.despawnCheck();
    }

    @Override
    public boolean isPersistant() {
        return this.isTamed() || super.isPersistant();
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        if (this.isTamed() && player == this.getPlayerOwner()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public void testLeash(float distance) {
        if (this.isSitting() && distance > 10.0f) {
            this.func_110160_i(true, true);
        } else {
            super.testLeash(distance);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.staminaUpdate();
    }

    public void staminaUpdate() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.stamina < this.getStaminaMax() && this.staminaRecovery >= this.getStaminaRecoveryMax() / 2.0f) {
            this.setStamina(Math.min(this.stamina + this.staminaRecovery, this.getStaminaMax()));
        }
        if (this.staminaRecovery < this.getStaminaRecoveryMax()) {
            this.staminaRecovery = Math.min(this.staminaRecovery + this.getStaminaRecoveryMax() / (float)this.getStaminaRecoveryWarmup(), this.getStaminaRecoveryMax());
        }
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(PlayerEntity player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (!this.func_130014_f_().field_72995_K && this.isTamed() && (itemStack == null || player.func_70093_af()) && player == this.getPlayerOwner()) {
            commands.put(EntityCreatureBase.COMMAND_PIORITIES.MAIN.id, "GUI");
        }
        if (!this.func_130014_f_().field_72995_K && itemStack != null && !player.func_70093_af()) {
            String equipSlot;
            if (!this.isTamed() && this.isTamingItem(itemStack) && CreatureManager.getInstance().config.tamingEnabled) {
                commands.put(EntityCreatureBase.COMMAND_PIORITIES.IMPORTANT.id, "Tame");
            }
            if (this.isTamed() && this.isHealingItem(itemStack) && this.func_110143_aJ() < this.func_110138_aP()) {
                commands.put(EntityCreatureBase.COMMAND_PIORITIES.ITEM_USE.id, "Feed");
            }
            if (this.isTamed() && !this.func_70631_g_() && this.canEquip() && player == this.getPlayerOwner() && (equipSlot = this.inventory.getSlotForEquipment(itemStack)) != null && (this.inventory.getEquipmentStack(equipSlot) == null || this.inventory.getEquipmentStack(equipSlot).func_77973_b() != itemStack.func_77973_b())) {
                commands.put(EntityCreatureBase.COMMAND_PIORITIES.EQUIPPING.id, "Equip Item");
            }
        }
        return commands;
    }

    @Override
    public void performCommand(String command, PlayerEntity player, ItemStack itemStack) {
        if (command.equals("GUI")) {
            this.playTameSound();
            this.openGUI(player);
        }
        if (command.equals("Tame")) {
            this.tame(player);
            this.consumePlayersItem(player, itemStack);
        }
        if (command.equals("Feed")) {
            int healAmount = 4;
            if (itemStack.func_77973_b().func_219971_r()) {
                healAmount = itemStack.func_77973_b().func_219967_s().func_221466_a();
            }
            this.func_70691_i(healAmount);
            this.playEatSound();
            if (this.func_130014_f_().field_72995_K) {
                BasicParticleType particle = ParticleTypes.field_197633_z;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                for (int i = 0; i < 25; ++i) {
                    this.func_130014_f_().func_195594_a((IParticleData)particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
                }
            }
            this.consumePlayersItem(player, itemStack);
        }
        if (command.equals("Equip Item")) {
            ItemStack equippedItem = this.inventory.getEquipmentStack(this.inventory.getSlotForEquipment(itemStack));
            if (equippedItem != null) {
                this.dropItem(equippedItem);
            }
            ItemStack equipStack = itemStack.func_77946_l();
            equipStack.func_190920_e(1);
            this.inventory.setEquipmentStack(equipStack.func_77946_l());
            this.consumePlayersItem(player, itemStack);
        }
        if (command.equals("Sit")) {
            this.playTameSound();
            this.func_70624_b(null);
            this.clearMovement();
            this.setSitting(!this.isSitting());
            this.field_70703_bu = false;
        }
        super.performCommand(command, player, itemStack);
    }

    @Override
    public boolean canNameTag(PlayerEntity player) {
        if (!this.isTamed()) {
            return super.canNameTag(player);
        }
        if (player == this.getPlayerOwner()) {
            return super.canNameTag(player);
        }
        return false;
    }

    @Override
    public void performGUICommand(PlayerEntity player, byte guiCommandID) {
        if (!this.petControlsEnabled()) {
            return;
        }
        if (player != this.getOwner()) {
            return;
        }
        if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.PVP.id) {
            this.setPVP(!this.isPVP());
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.PASSIVE.id) {
            this.setPassive(true);
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.DEFENSIVE.id) {
            this.setPassive(false);
            this.setAssist(false);
            this.setAggressive(false);
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.ASSIST.id) {
            this.setPassive(false);
            this.setAssist(true);
            this.setAggressive(false);
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.AGGRESSIVE.id) {
            this.setPassive(false);
            this.setAssist(true);
            this.setAggressive(true);
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.FOLLOW.id) {
            this.setSitting(false);
            this.setFollowing(true);
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.WANDER.id) {
            this.setSitting(false);
            this.setFollowing(false);
        } else if (guiCommandID == EntityCreatureBase.PET_COMMAND_ID.SIT.id) {
            this.setSitting(true);
            this.setFollowing(false);
        }
        this.playTameSound();
        if (this.petEntry != null && this.petEntry.summonSet != null) {
            this.petEntry.summonSet.updateBehaviour(this);
        }
        super.performGUICommand(player, guiCommandID);
    }

    public Team func_96124_cp() {
        Entity owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity target) {
        if (this.func_130014_f_().field_72995_K) {
            return super.func_184191_r(target);
        }
        if (this.isTamed()) {
            EntityCreatureTameable tamedTarget;
            if (target == this.getPlayerOwner() || target == this.getOwner()) {
                return true;
            }
            if (!(!(target instanceof PlayerEntity) || this.func_130014_f_().func_73046_m().func_71219_W() && this.isPVP())) {
                return true;
            }
            if (target instanceof EntityCreatureTameable ? (tamedTarget = (EntityCreatureTameable)target).isTamed() && (!this.func_130014_f_().func_73046_m().func_71219_W() || !this.isPVP() || tamedTarget.getPlayerOwner() == this.getPlayerOwner()) : target instanceof TameableEntity && (tamedTarget = (TameableEntity)target).func_70902_q() != null && (!this.func_130014_f_().func_73046_m().func_71219_W() || !this.isPVP() || tamedTarget.func_70902_q() == this.getOwner())) {
                return true;
            }
            if (this.getPlayerOwner() != null) {
                if (this.getPlayerOwner().func_184187_bx() == target) {
                    return true;
                }
                return this.getPlayerOwner().func_184191_r(target);
            }
            if (this.getOwner() != null) {
                if (this.getOwner().func_184187_bx() == target) {
                    return true;
                }
                return this.getOwner().func_184191_r(target);
            }
            return false;
        }
        return super.func_184191_r(target);
    }

    public boolean func_213358_a(EntityType targetType) {
        if (this.isPassive()) {
            return false;
        }
        return super.func_213358_a(targetType);
    }

    @Override
    public boolean func_213336_c(LivingEntity targetEntity) {
        if (this.isPassive()) {
            return false;
        }
        if (this.isTamed()) {
            if (this.getOwner() == targetEntity) {
                return false;
            }
            if (!this.func_130014_f_().field_72995_K) {
                EntityCreatureTameable targetTameable;
                boolean canPVP;
                boolean bl = canPVP = this.func_130014_f_().func_73046_m().func_71219_W() && this.isPVP();
                if (targetEntity instanceof PlayerEntity && !canPVP) {
                    return false;
                }
                if (targetEntity instanceof EntityCreatureTameable && (targetTameable = (EntityCreatureTameable)targetEntity).isTamed()) {
                    if (!canPVP) {
                        return false;
                    }
                    if (targetTameable.getOwner() == this.getOwner()) {
                        return false;
                    }
                }
            }
        }
        return super.func_213336_c(targetEntity);
    }

    @Override
    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource) {
        if (this.isTamed() && this.getOwner() != null) {
            if (nestedDamageSource == null) {
                nestedDamageSource = new EntityDamageSource("mob", (Entity)this);
            }
            return new MinionEntityDamageSource(nestedDamageSource, this.getOwner());
        }
        return super.getDamageSource(nestedDamageSource);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        Entity entity;
        if (this.func_180431_b(damageSrc)) {
            return false;
        }
        if (!this.isPassive()) {
            this.setSitting(false);
        }
        if ((entity = damageSrc.func_76364_f()) instanceof ThrowableEntity) {
            entity = ((ThrowableEntity)entity).func_85052_h();
        }
        if (this.isTamed() && this.getOwner() == entity) {
            return false;
        }
        return super.func_70097_a(damageSrc, damage);
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if ("inWall".equals(type) && this.isTamed()) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    public void setOwnerId(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.field_70180_af.func_187227_b(OWNER_ID, Optional.ofNullable(ownerUUID));
        this.setTamed(ownerUUID != null);
    }

    @Override
    public Entity getOwner() {
        UUID uuid = this.getOwnerId();
        if (uuid == null) {
            return super.getOwner();
        }
        return this.func_130014_f_().func_217371_b(uuid);
    }

    public void setPlayerOwner(PlayerEntity player) {
        this.setOwnerId(player.func_110124_au());
    }

    @Override
    public UUID getOwnerId() {
        if (this.func_130014_f_().field_72995_K) {
            try {
                return this.getUUIDFromDataManager(OWNER_ID).orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.ownerUUID;
    }

    public Entity getPlayerOwner() {
        if (this.func_130014_f_().field_72995_K) {
            Entity owner = this.getOwner();
            if (owner instanceof PlayerEntity) {
                return owner;
            }
            return null;
        }
        if (this.ownerUUID == null) {
            return null;
        }
        return this.func_130014_f_().func_217371_b(this.ownerUUID);
    }

    public String getOwnerName() {
        Entity owner = this.getOwner();
        if (owner != null) {
            if (owner instanceof PlayerEntity) {
                return owner.func_145748_c_().toString();
            }
            return owner.func_145748_c_().toString();
        }
        return "";
    }

    @Override
    public boolean isTamed() {
        try {
            return (this.getByteFromDataManager(TAMED) & TAMED_ID.IS_TAMED.id) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setTamed(boolean isTamed) {
        byte tamed = this.getByteFromDataManager(TAMED);
        if (isTamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamed | TAMED_ID.IS_TAMED.id)));
            this.spawnEventType = "";
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamed - (tamed & TAMED_ID.IS_TAMED.id))));
        }
        this.func_174805_g(isTamed);
    }

    public boolean isTamingItem(ItemStack itemstack) {
        ItemTreat itemTreat;
        if (itemstack.func_190926_b() || this.creatureInfo.creatureType == null) {
            return false;
        }
        if (itemstack.func_77973_b() instanceof ItemTreat && (itemTreat = (ItemTreat)itemstack.func_77973_b()).getCreatureType() == this.creatureInfo.creatureType) {
            return this.creatureInfo.isTameable();
        }
        return false;
    }

    public boolean tame(PlayerEntity player) {
        if (!this.func_130014_f_().field_72995_K && !this.isRareSubspecies()) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                ExtendedPlayer extendedPlayer;
                this.setPlayerOwner(player);
                this.onTamedByPlayer();
                this.unsetTemporary();
                String tameMessage = LanguageManager.translate("message.pet.tamed");
                tameMessage = tameMessage.replace("%creature%", this.getSpeciesName());
                player.func_145747_a((ITextComponent)new TranslationTextComponent(tameMessage, new Object[0]));
                this.playTameEffect(this.isTamed());
                if (this.field_71088_bW > this.func_82147_ab()) {
                    this.field_71088_bW = this.func_82147_ab();
                }
                if ((extendedPlayer = ExtendedPlayer.getForPlayer(player)) != null) {
                    extendedPlayer.getBeastiary().discoverCreature((Entity)this, 2, false);
                }
            } else {
                String tameFailedMessage = LanguageManager.translate("message.pet.tamefail");
                tameFailedMessage = tameFailedMessage.replace("%creature%", this.getSpeciesName());
                player.func_145747_a((ITextComponent)new TranslationTextComponent(tameFailedMessage, new Object[0]));
                this.playTameEffect(this.isTamed());
            }
        }
        return this.isTamed();
    }

    public void onTamedByPlayer() {
        this.refreshStats();
        this.clearMovement();
        this.func_70624_b(null);
        this.setSitting(false);
        this.setFollowing(true);
        this.setPassive(false);
        this.setAggressive(false);
        this.setPVP(true);
        this.playTameSound();
    }

    @Override
    public void onCreateBaby(EntityCreatureAgeable partner, EntityCreatureAgeable baby) {
        if (this.isTamed() && this.getOwner() instanceof PlayerEntity && partner instanceof EntityCreatureTameable && baby instanceof EntityCreatureTameable) {
            EntityCreatureTameable partnerTameable = (EntityCreatureTameable)partner;
            EntityCreatureTameable babyTameable = (EntityCreatureTameable)baby;
            if (partnerTameable.getPlayerOwner() == this.getPlayerOwner()) {
                babyTameable.setPlayerOwner((PlayerEntity)this.getOwner());
            }
        }
        super.onCreateBaby(partner, baby);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte status) {
        if (status == 7) {
            this.playTameEffect(true);
        } else if (status == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(status);
        }
    }

    public boolean isHealingItem(ItemStack testStack) {
        return false;
    }

    public boolean petControlsEnabled() {
        return false;
    }

    public byte behaviourBitMask() {
        return this.getByteFromDataManager(TAMED);
    }

    public boolean isSitting() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.MOVE_SIT.id) != 0;
    }

    public void setSitting(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.MOVE_SIT.id)));
            this.setHome((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.sittingGuardRange);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.MOVE_SIT.id))));
            this.detachHome();
        }
    }

    public boolean isFollowing() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.MOVE_FOLLOW.id) != 0;
    }

    public void setFollowing(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.MOVE_FOLLOW.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.MOVE_FOLLOW.id))));
        }
    }

    public boolean isPassive() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.STANCE_PASSIVE.id) != 0;
    }

    public void setPassive(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_PASSIVE.id)));
            this.func_70624_b(null);
            this.setStealth(0.0f);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_PASSIVE.id))));
        }
    }

    @Override
    public boolean func_213398_dR() {
        if (!this.isTamed()) {
            return super.func_213398_dR();
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.STANCE_AGGRESSIVE.id) != 0;
    }

    public void setAggressive(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_AGGRESSIVE.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_AGGRESSIVE.id))));
        }
    }

    public boolean isAssisting() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.STANCE_ASSIST.id) != 0;
    }

    public void setAssist(boolean set) {
        if (!this.petControlsEnabled()) {
            set = true;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_ASSIST.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_ASSIST.id))));
        }
    }

    public boolean isPVP() {
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.PVP.id) != 0;
    }

    public void setPVP(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.PVP.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.PVP.id))));
        }
    }

    public float getCreatureHunger() {
        if (this.func_130014_f_() == null) {
            return this.getCreatureHungerMax();
        }
        if (!this.func_130014_f_().field_72995_K) {
            return this.hunger;
        }
        try {
            return this.getFloatFromDataManager(HUNGER);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setCreatureHunger(float setHunger) {
        this.hunger = setHunger;
    }

    public float getCreatureHungerMax() {
        return 20.0f;
    }

    public float getStamina() {
        if (this.func_130014_f_() != null && this.func_130014_f_().field_72995_K) {
            try {
                this.stamina = this.getFloatFromDataManager(STAMINA);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stamina;
    }

    public void setStamina(float setStamina) {
        this.stamina = setStamina;
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(STAMINA, (Object)Float.valueOf(setStamina));
        }
    }

    public float getStaminaMax() {
        return 100.0f;
    }

    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public int getStaminaRecoveryWarmup() {
        return 200;
    }

    public float getStaminaCost() {
        return 1.0f;
    }

    public void applyStaminaCost() {
        float newStamina = this.getStamina() - this.getStaminaCost();
        if (newStamina < 0.0f) {
            newStamina = 0.0f;
        }
        this.setStamina(newStamina);
        this.staminaRecovery = 0.0f;
    }

    public float getStaminaPercent() {
        return this.getStamina() / this.getStaminaMax();
    }

    public String getStaminaType() {
        return "energy";
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partner) {
        EntityCreatureAgeable spawnedBaby = super.createChild(partner);
        UUID ownerId = this.getOwnerId();
        if (ownerId != null && spawnedBaby != null && spawnedBaby instanceof EntityCreatureTameable) {
            EntityCreatureTameable tamedBaby = (EntityCreatureTameable)spawnedBaby;
            tamedBaby.setOwnerId(ownerId);
        }
        return spawnedBaby;
    }

    @Override
    public boolean canBeTempted() {
        return !this.isTamed();
    }

    @Override
    public boolean func_82171_bF() {
        return this.isTamed();
    }

    protected void playTameEffect(boolean success) {
        BasicParticleType particle = ParticleTypes.field_197633_z;
        if (!success) {
            particle = ParticleTypes.field_197601_L;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.func_130014_f_().func_195594_a((IParticleData)particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
        }
    }

    @Override
    public boolean canBeColored(PlayerEntity player) {
        if (player == null) {
            return true;
        }
        return this.isTamed() && player == this.getPlayerOwner();
    }

    @Override
    public boolean showBossInfo() {
        if (this.isTamed()) {
            return false;
        }
        return super.showBossInfo();
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_186855_b("OwnerId")) {
            this.setOwnerId(nbtTagCompound.func_186857_a("OwnerId"));
        } else {
            this.setOwnerId(null);
        }
        if (nbtTagCompound.func_74764_b("Sitting")) {
            this.setSitting(nbtTagCompound.func_74767_n("Sitting"));
        } else {
            this.setSitting(false);
        }
        if (nbtTagCompound.func_74764_b("Following")) {
            this.setFollowing(nbtTagCompound.func_74767_n("Following"));
        } else {
            this.setFollowing(true);
        }
        if (nbtTagCompound.func_74764_b("Passive")) {
            this.setPassive(nbtTagCompound.func_74767_n("Passive"));
        } else {
            this.setPassive(false);
        }
        if (nbtTagCompound.func_74764_b("Aggressive")) {
            this.setAggressive(nbtTagCompound.func_74767_n("Aggressive"));
        } else {
            this.setAggressive(false);
        }
        if (nbtTagCompound.func_74764_b("PVP")) {
            this.setPVP(nbtTagCompound.func_74767_n("PVP"));
        } else {
            this.setPVP(true);
        }
        if (nbtTagCompound.func_74764_b("Hunger")) {
            this.setCreatureHunger(nbtTagCompound.func_74760_g("Hunger"));
        } else {
            this.setCreatureHunger(this.getCreatureHungerMax());
        }
        if (nbtTagCompound.func_74764_b("Stamina")) {
            this.setStamina(nbtTagCompound.func_74760_g("Stamina"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        if (this.getOwnerId() != null) {
            nbtTagCompound.func_186854_a("OwnerId", this.getOwnerId());
        }
        nbtTagCompound.func_74757_a("Sitting", this.isSitting());
        nbtTagCompound.func_74757_a("Following", this.isFollowing());
        nbtTagCompound.func_74757_a("Passive", this.isPassive());
        nbtTagCompound.func_74757_a("Aggressive", this.func_213398_dR());
        nbtTagCompound.func_74757_a("PVP", this.isPVP());
        nbtTagCompound.func_74776_a("Hunger", this.getCreatureHunger());
        nbtTagCompound.func_74776_a("Stamina", this.getStamina());
    }

    @Override
    public int func_70627_aG() {
        if (this.isTamed()) {
            return 600;
        }
        return super.func_70627_aG();
    }

    @Override
    protected SoundEvent func_184639_G() {
        String sound = "_say";
        if (this.isTamed() && this.func_110143_aJ() < this.func_110138_aP()) {
            sound = "_beg";
        }
        return ObjectManager.getSound(this.getSoundName() + sound);
    }

    public void playTameSound() {
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_tame"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playEatSound() {
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_eat"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public static enum TAMED_ID {
        IS_TAMED(1),
        MOVE_SIT(2),
        MOVE_FOLLOW(4),
        STANCE_PASSIVE(8),
        STANCE_AGGRESSIVE(16),
        STANCE_ASSIST(32),
        PVP(64);

        public final byte id;

        private TAMED_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

