/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.core.container.ContainerCreature;
import com.lycanitesmobs.core.container.CreatureContainerProvider;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityFear;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.goals.actions.MoveRestrictionGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AttackTargetingGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeTargetingGoal;
import com.lycanitesmobs.core.entity.navigate.CreatureMoveController;
import com.lycanitesmobs.core.entity.navigate.CreaturePathNavigator;
import com.lycanitesmobs.core.entity.navigate.DirectNavigator;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ExtraMobBehaviour;
import com.lycanitesmobs.core.info.ItemDrop;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.spawner.SpawnerEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityCreatureBase
extends CreatureEntity {
    public static final IAttribute DEFENSE = new RangedAttribute(null, "generic.defense", 4.0, 0.0, 1024.0).func_111117_a("Defense").func_111112_a(true);
    public static final IAttribute RANGED_SPEED = new RangedAttribute(null, "generic.rangedSpeed", 4.0, 0.0, 1024.0).func_111117_a("Ranged Speed").func_111112_a(true);
    public CreatureInfo creatureInfo;
    public CreatureStats creatureStats;
    public Subspecies subspecies = null;
    public CreatureAttribute attribute = CreatureAttribute.UNDEAD;
    public ExtraMobBehaviour extraMobBehaviour;
    public String spawnEventType = "";
    public int spawnEventCount = -1;
    public PetEntry petEntry;
    public boolean altarSummoned = false;
    public boolean forceBossHealthBar = false;
    public long updateTick = 0L;
    public EntitySize creatureSize;
    public double sizeScale = 1.0;
    public float hitAreaWidthScale = 1.0f;
    public float hitAreaHeightScale = 1.0f;
    protected int level = 1;
    protected int attackCooldownMax = 5;
    protected int attackCooldown = 0;
    public byte attackPhaseMax = 0;
    public byte attackPhase = 0;
    public int battlePhase = 0;
    public int fleeTime = 200;
    public int currentFleeTime = 0;
    public float fleeHealthPercent = 0.0f;
    public int damageMax = 0;
    protected int growingAge;
    public float damageTakenThisSec = 0.0f;
    public float healthLastTick = -1.0f;
    public float damageLimit = 0.0f;
    public int bossRange = 60;
    public boolean isAggressiveByDefault = true;
    public boolean spreadFire = false;
    public boolean stealthPrev = false;
    public int currentBlockingTime = 0;
    public int blockingTime = 60;
    public LivingEntity pickupEntity;
    public boolean solidCollision = false;
    protected BlockPos homePosition = new BlockPos(0, 0, 0);
    protected float homeDistanceMax = -1.0f;
    protected BlockPos arenaCenter = null;
    public boolean firstSpawn = true;
    public boolean spawnsInBlock = false;
    public boolean spawnsUnderground = true;
    public boolean spawnsOnLand = true;
    public boolean spawnsInWater = false;
    public boolean isLavaCreature = false;
    public boolean isMinion = false;
    public boolean isTemporary = false;
    public int temporaryDuration = 0;
    public boolean forceNoDespawn = false;
    public boolean spawnedRare = false;
    public boolean spawnedAsBoss = false;
    private boolean leashAIActive = false;
    private Goal leashMoveTowardsRestrictionAI = new MoveRestrictionGoal(this);
    public DirectNavigator directNavigator;
    private LivingEntity masterTarget;
    private LivingEntity parentTarget;
    private LivingEntity avoidTarget;
    private LivingEntity fixateTarget;
    private UUID fixateUUID = null;
    public List<PlayerEntity> guiViewers = new ArrayList<PlayerEntity>();
    public int guiRefreshTick = 0;
    public int guiRefreshTime = 2;
    public boolean hasAttackSound = false;
    public boolean hasStepSound = true;
    public boolean hasJumpSound = false;
    public int flySoundSpeed = 0;
    public boolean extraAnimation01 = false;
    public ServerBossInfo bossInfo;
    public float onlyRenderTicks = -1.0f;
    public boolean initialized = false;
    protected static final DataParameter<Byte> TARGET = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ATTACK_PHASE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ANIMATION_STATE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> ANIMATION_ATTACK_COOLDOWN_MAX = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> STEALTH = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> BABY = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> SUBSPECIES = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<BlockPos>> ARENA = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187201_k);
    public static final DataParameter<ItemStack> EQUIPMENT_HEAD = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_CHEST = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_LEGS = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_FEET = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_BAG = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_SADDLE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (IDataSerializer)DataSerializers.field_187196_f);
    public InventoryCreature inventory;
    public List<ItemDrop> drops = new ArrayList<ItemDrop>();
    public List<ItemDrop> savedDrops = new ArrayList<ItemDrop>();
    public AttackTargetingGoal aiTargetPlayer = new AttackTargetingGoal(this).setTargetClass(PlayerEntity.class);
    public RevengeTargetingGoal aiDefendAnimals = new RevengeTargetingGoal(this).setHelpClasses(AnimalEntity.class);

    public EntityCreatureBase(EntityType<? extends EntityCreatureBase> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = this.createMoveController();
        if (!this.canBurn()) {
            this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
            if (this.canBreatheUnderlava()) {
                this.func_184644_a(PathNodeType.LAVA, 1.0f);
                if (!this.canBreatheAir()) {
                    this.func_184644_a(PathNodeType.LAVA, 8.0f);
                }
            }
        }
        if (this.waterDamage()) {
            this.func_184644_a(PathNodeType.WATER, -1.0f);
        } else if (this.func_70648_aU()) {
            this.func_184644_a(PathNodeType.WATER, 1.0f);
            if (!this.canBreatheAir()) {
                this.func_184644_a(PathNodeType.WATER, 8.0f);
            }
        }
        if (this.canWade() && this.func_70661_as() instanceof CreaturePathNavigator) {
            CreaturePathNavigator pathNavigator = (CreaturePathNavigator)this.func_70661_as();
            pathNavigator.func_212239_d(true);
        }
    }

    public EntityType func_200600_R() {
        return this.creatureInfo.getEntityType();
    }

    protected void func_110147_ax() {
        this.creatureInfo = CreatureManager.getInstance().getCreature(((Object)((Object)this)).getClass());
        this.creatureSize = new EntitySize((float)this.creatureInfo.width, (float)this.creatureInfo.height, false);
        this.creatureStats = new CreatureStats(this);
        this.extraMobBehaviour = new ExtraMobBehaviour(this);
        this.directNavigator = new DirectNavigator(this);
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(DEFENSE);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(RANGED_SPEED);
        this.applyStats();
    }

    public void applyStats() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.creatureStats.getHealth());
        this.func_110148_a(DEFENSE).func_111128_a(this.creatureStats.getDefense());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.creatureStats.getArmor());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.creatureStats.getSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.creatureStats.getKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.creatureStats.getSight());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.creatureStats.getDamage());
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(this.creatureStats.getAttackSpeed());
        this.func_110148_a(RANGED_SPEED).func_111128_a(this.creatureStats.getRangedSpeed());
    }

    public void refreshStats() {
        this.applyStats();
        this.func_70606_j((float)this.creatureStats.getHealth());
        this.refreshBossHealthName();
    }

    public void setupMob() {
        this.setSizeScale(this.creatureInfo.sizeScale);
        this.field_70138_W = 0.5f;
        this.field_70728_aV = this.creatureInfo.experience;
        this.inventory = new InventoryCreature(this.func_200200_C_().toString(), this);
        this.loadItemDrops();
        ItemEquipmentPart itemEquipmentPart = ItemEquipmentPart.MOB_PART_DROPS.get(this.creatureInfo.getEntityId());
        if (itemEquipmentPart != null) {
            this.drops.add(new ItemDrop(itemEquipmentPart.getRegistryName().toString(), itemEquipmentPart.dropChance).setMaxAmount(1));
        }
        this.setAttackCooldownMax(this.attackCooldownMax);
    }

    public void loadItemDrops() {
        this.drops.addAll(this.creatureInfo.drops);
        this.drops.addAll(CreatureManager.getInstance().config.getGlobalDrops());
    }

    public void addSavedItemDrop(ItemDrop itemDrop) {
        this.drops.add(itemDrop);
        this.savedDrops.add(itemDrop);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_PHASE, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION_STATE, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION_ATTACK_COOLDOWN_MAX, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(STEALTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(SUBSPECIES, (Object)0);
        this.field_70180_af.func_187214_a(ARENA, Optional.empty());
        InventoryCreature.registerData(this.field_70180_af);
        this.initialized = true;
    }

    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return this.func_200201_e();
        }
        return new TranslationTextComponent(this.getFullName(), new Object[0]);
    }

    public String getFullName() {
        String name = "";
        if (!"".equals(this.getAgeName())) {
            name = name + this.getAgeName() + " ";
        }
        if (!"".equals(this.getSubspeciesTitle())) {
            name = name + this.getSubspeciesTitle() + " ";
        }
        return name + this.getSpeciesName() + this.getLevelName();
    }

    public String getSpeciesName() {
        return this.creatureInfo.getTitle();
    }

    public String getSubspeciesTitle() {
        if (this.getSubspecies() != null) {
            return this.getSubspecies().getTitle();
        }
        return "";
    }

    public String getLevelName() {
        if (this.getLevel() < 2) {
            return "";
        }
        return " " + LanguageManager.translate("entity.level") + " " + this.getLevel();
    }

    public String getAgeName() {
        return "";
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public boolean func_213393_a(IWorld world, SpawnReason spawnReason, BlockPos blockPos) {
        return this.checkSpawnVanilla(this.func_130014_f_(), spawnReason, this.func_180425_c());
    }

    public int func_70641_bl() {
        return this.creatureInfo.creatureSpawn.spawnGroupMax;
    }

    public boolean checkSpawnVanilla(World world, SpawnReason spawnReason, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        if (spawnReason != SpawnReason.NATURAL && spawnReason != SpawnReason.SPAWNER) {
            return true;
        }
        LycanitesMobs.logDebug("MobSpawns", " ~O==================== Vanilla Spawn Check: " + this.creatureInfo.getName() + " ====================O~");
        LycanitesMobs.logDebug("MobSpawns", "Attempting to Spawn: " + this.creatureInfo.getName());
        LycanitesMobs.logDebug("MobSpawns", "Target Spawn Location: " + pos);
        LycanitesMobs.logDebug("MobSpawns", "Checking if creature is enabled...");
        if (!this.creatureInfo.enabled || !this.creatureInfo.creatureSpawn.enabled) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for peaceful difficulty...");
        if (!this.creatureInfo.peaceful && this.func_130014_f_().func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking gamerules...");
        if (!this.func_130014_f_().func_82736_K().func_82766_b("doMobSpawning")) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Fixed spawn check (light level, collisions)...");
        if (!this.fixedSpawnCheck(world, pos)) {
            return false;
        }
        if (spawnReason == SpawnReason.SPAWNER) {
            LycanitesMobs.logDebug("MobSpawns", "Spawned from Mob Spawner, skipping other checks.");
            LycanitesMobs.logDebug("MobSpawns", "Vanilla Spawn Check Passed!");
            return true;
        }
        LycanitesMobs.logDebug("MobSpawns", "No Mob Spawner found.");
        LycanitesMobs.logDebug("MobSpawns", "Global Spawn Check (Master Dimension List, etc)...");
        if (!CreatureManager.getInstance().spawnConfig.isAllowedGlobal(world)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Environment spawn check (dimension, group limit, ground type, water, lava, underground)...");
        if (!this.environmentSpawnCheck(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Vanilla Spawn Check Passed!");
        return true;
    }

    public boolean fixedSpawnCheck(World world, BlockPos pos) {
        if (!this.checkSpawnLightLevel(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking collision...");
        if (!this.checkSpawnCollision(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Counting mobs of the same kind, max allowed is: " + this.creatureInfo.creatureSpawn.spawnAreaLimit);
        return this.checkSpawnGroupLimit(world, pos, CreatureManager.getInstance().spawnConfig.spawnLimitRange);
    }

    public boolean environmentSpawnCheck(World world, BlockPos pos) {
        if (this.creatureInfo.creatureSpawn.worldDayMin > 0.0) {
            int currentDay = (int)Math.floor((double)world.func_82737_E() / 24000.0);
            LycanitesMobs.logDebug("MobSpawns", "Checking game time, currently on day: " + currentDay + ", must be at least day: " + this.creatureInfo.creatureSpawn.worldDayMin + ".");
            if ((double)currentDay < this.creatureInfo.creatureSpawn.worldDayMin) {
                return false;
            }
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking dimension.");
        if (!this.isNativeDimension(this.func_130014_f_())) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for liquid (water, lava, ooze, etc).");
        if (!this.spawnsInWater && this.func_130014_f_().func_72953_d(this.func_174813_aQ())) {
            return false;
        }
        if (!this.spawnsOnLand && !this.func_130014_f_().func_72953_d(this.func_174813_aQ())) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for underground.");
        if (!this.spawnsUnderground && this.isBlockUnderground(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for nearby bosses.");
        return this.checkSpawnBoss(world, pos);
    }

    public boolean isNativeDimension(World world) {
        return this.creatureInfo.creatureSpawn.isAllowedDimension(world);
    }

    public boolean checkSpawnCollision(World world, BlockPos pos) {
        return this.spawnsInBlock || this.func_130014_f_().func_195585_a((Entity)this, VoxelShapes.func_197881_a((AxisAlignedBB)this.func_174813_aQ()));
    }

    public boolean checkSpawnLightLevel(World world, BlockPos pos) {
        if (this.creatureInfo.creatureSpawn.spawnsInDark && this.creatureInfo.creatureSpawn.spawnsInLight) {
            return true;
        }
        if (!this.creatureInfo.creatureSpawn.spawnsInDark && !this.creatureInfo.creatureSpawn.spawnsInLight) {
            return false;
        }
        byte light = this.testLightLevel(pos);
        if (this.creatureInfo.creatureSpawn.spawnsInDark && light <= 1) {
            return true;
        }
        return this.creatureInfo.creatureSpawn.spawnsInLight && light >= 2;
    }

    public boolean checkSpawnGroupLimit(World world, BlockPos pos, double range) {
        if (range <= 0.0) {
            return true;
        }
        int typesLimit = CreatureManager.getInstance().spawnConfig.typeSpawnLimit;
        int speciesLimit = this.creatureInfo.creatureSpawn.spawnAreaLimit;
        if (typesLimit <= 0 && speciesLimit <= 0) {
            return true;
        }
        List<EntityCreatureBase> targets = this.getNearbyEntities(EntityCreatureBase.class, EntityCreatureBase.class, range);
        int typesFound = 0;
        int speciesFound = 0;
        for (EntityCreatureBase targetCreature : targets) {
            if (targetCreature.creatureInfo.peaceful == this.creatureInfo.peaceful) {
                ++typesFound;
            }
            if (!this.creatureInfo.entityClass.isAssignableFrom(((Object)((Object)targetCreature)).getClass())) continue;
            ++speciesFound;
        }
        if (range > 0.0) {
            if (typesLimit > 0 && typesFound >= typesLimit) {
                return false;
            }
            if (speciesLimit > 0 && speciesFound >= speciesLimit) {
                return false;
            }
        }
        return true;
    }

    public boolean checkSpawnBoss(World world, BlockPos pos) {
        List<EntityCreatureBase> bosses = this.getNearbyEntities(EntityCreatureBase.class, IGroupBoss.class, CreatureManager.getInstance().spawnConfig.spawnLimitRange);
        return bosses.size() == 0;
    }

    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData livingEntityData, @Nullable CompoundNBT compoundNBT) {
        livingEntityData = super.func_213386_a(world, difficultyInstance, spawnReason, livingEntityData, compoundNBT);
        return livingEntityData;
    }

    protected boolean canDespawnNaturally() {
        if (this.creatureInfo.creatureSpawn.despawnForced) {
            return true;
        }
        if (!this.creatureInfo.creatureSpawn.despawnNatural) {
            return false;
        }
        if (this.creatureInfo.boss || this.isRareSubspecies()) {
            return false;
        }
        return !this.isPersistant() && !this.func_110167_bD() && (!this.func_145818_k_() || !"".equals(this.spawnEventType));
    }

    public boolean isPersistant() {
        return this.forceNoDespawn;
    }

    public void func_110163_bv() {
        super.func_110163_bv();
        this.forceNoDespawn = true;
    }

    public boolean despawnCheck() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (!this.creatureInfo.enabled) {
            return true;
        }
        if (this.isTemporary && this.temporaryDuration-- <= 0) {
            return true;
        }
        if (!this.creatureInfo.peaceful && this.func_130014_f_().func_175659_aa() == Difficulty.PEACEFUL && !this.func_145818_k_()) {
            return true;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(this.func_130014_f_());
        if (worldExt != null && !"".equals(this.spawnEventType) && this.spawnEventCount >= 0 && this.spawnEventCount != worldExt.getWorldEventCount()) {
            if (this.func_110167_bD() || this.isPersistant()) {
                this.spawnEventType = "";
                this.spawnEventCount = -1;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isBlockUnderground(int x, int y, int z) {
        if (this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return false;
        }
        for (int j = y; j < this.func_130014_f_().func_72940_L(); ++j) {
            Material blockMaterial = this.func_130014_f_().func_180495_p(new BlockPos(x, j, z)).func_185904_a();
            if (blockMaterial == Material.field_151579_a || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151585_k || blockMaterial == Material.field_151582_l) continue;
            return true;
        }
        return false;
    }

    public boolean isBoss() {
        return this.isBossAlways() || this.spawnedAsBoss;
    }

    public boolean isBossAlways() {
        return this.creatureInfo.boss;
    }

    public boolean func_184222_aU() {
        return !this.isBoss();
    }

    public void createBossInfo(BossInfo.Color color, boolean darkenSky) {
        String name = this.getFullName();
        if (this.isBoss()) {
            name = name + " (Phase " + (this.getBattlePhase() + 1) + ")";
        }
        this.bossInfo = (ServerBossInfo)new ServerBossInfo((ITextComponent)new TranslationTextComponent(name, new Object[0]), color, BossInfo.Overlay.PROGRESS).func_186741_a(darkenSky);
    }

    public BossInfo getBossInfo() {
        if (this.bossInfo == null && this.showBossInfo() && !this.func_130014_f_().field_72995_K) {
            if (this.isBoss()) {
                this.createBossInfo(BossInfo.Color.RED, false);
            } else {
                this.createBossInfo(BossInfo.Color.GREEN, false);
            }
        }
        return this.bossInfo;
    }

    public void refreshBossHealthName() {
        if (this.bossInfo != null) {
            String name = this.getFullName();
            name = name + " (Phase " + (this.getBattlePhase() + 1) + ")";
            this.bossInfo.func_186739_a((ITextComponent)new TranslationTextComponent(name, new Object[0]));
        }
    }

    public void summonMinion(LivingEntity minion, double angle, double distance) {
        double angleRadians = Math.toRadians(angle);
        double x = this.field_70165_t + (((double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a + distance) * Math.cos(angleRadians) - Math.sin(angleRadians));
        double y = this.field_70163_u + 1.0;
        double z = this.field_70161_v + (((double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a + distance) * Math.sin(angleRadians) + Math.cos(angleRadians));
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        this.func_130014_f_().func_217376_c((Entity)minion);
        if (minion instanceof EntityCreatureBase) {
            ((EntityCreatureBase)minion).setMinion(true);
            ((EntityCreatureBase)minion).applySubspecies(this.getSubspeciesIndex());
            ((EntityCreatureBase)minion).setMasterTarget((LivingEntity)this);
            ((EntityCreatureBase)minion).spawnEventType = this.spawnEventType;
        }
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    public void onMinionUpdate(LivingEntity minion, long tick) {
    }

    public void onMinionDeath(LivingEntity minion) {
    }

    public void setMinion(boolean minion) {
        this.isMinion = minion;
    }

    public boolean isMinion() {
        return this.isMinion;
    }

    public void setTemporary(int duration) {
        this.temporaryDuration = duration;
        this.isTemporary = true;
    }

    public void unsetTemporary() {
        this.isTemporary = false;
        this.temporaryDuration = 0;
    }

    public boolean isBoundPet() {
        return this.hasPetEntry();
    }

    public boolean hasPetEntry() {
        return this.getPetEntry() != null;
    }

    public PetEntry getPetEntry() {
        return this.petEntry;
    }

    public void setPetEntry(PetEntry petEntry) {
        this.petEntry = petEntry;
    }

    public boolean isPetType(String type) {
        if (!this.hasPetEntry()) {
            return false;
        }
        return type.equals(this.getPetEntry().getType());
    }

    public void onFirstSpawn() {
        if (this.hasPetEntry() || this.isMinion()) {
            return;
        }
        this.applyLevel(this.getStartingLevel());
        if (CreatureManager.getInstance().config.subspeciesSpawn && !this.creatureInfo.creatureSpawn.disableSubspecies) {
            this.getRandomSubspecies();
        }
        if (CreatureManager.getInstance().config.randomSizes) {
            this.getRandomSize();
        }
    }

    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.isMinion()) {
            Subspecies randomSubspecies = this.creatureInfo.getRandomSubspecies((LivingEntity)this, this.spawnedRare);
            if (randomSubspecies != null) {
                LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " to " + randomSubspecies.getTitle());
                this.applySubspecies(randomSubspecies.index);
            } else {
                LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " to base species.");
                this.applySubspecies(0);
            }
        }
    }

    public void getRandomSize() {
        double range = CreatureManager.getInstance().config.randomSizeMax - CreatureManager.getInstance().config.randomSizeMin;
        double randomScale = range * this.func_70681_au().nextDouble();
        double scale = CreatureManager.getInstance().config.randomSizeMin + randomScale;
        if (this.subspecies != null) {
            scale *= this.subspecies.getScale();
        }
        this.setSizeScale(scale);
    }

    public int getAge() {
        if (this.field_70170_p.field_72995_K) {
            return this.getBoolFromDataManager(BABY) ? -1 : 1;
        }
        return this.growingAge;
    }

    @Nonnull
    public EntitySize func_213305_a(Pose pose) {
        if (pose == Pose.SLEEPING) {
            return field_213377_as;
        }
        if (this.creatureSize == null) {
            return super.func_213305_a(pose);
        }
        return this.creatureSize.func_220313_a(this.func_213355_cm());
    }

    public void setSizeScale(double scale) {
        this.sizeScale = scale;
    }

    public float func_213355_cm() {
        return (float)this.sizeScale;
    }

    public int getLevel() {
        if (this.func_130014_f_().field_72995_K) {
            return this.getIntFromDataManager(LEVEL);
        }
        return this.level;
    }

    public int getStartingLevel() {
        int startingLevelMin = Math.max(1, CreatureManager.getInstance().config.startingLevelMin);
        if (CreatureManager.getInstance().config.startingLevelMax > startingLevelMin) {
            return startingLevelMin + this.func_70681_au().nextInt(CreatureManager.getInstance().config.startingLevelMax - startingLevelMin);
        }
        if (CreatureManager.getInstance().config.levelPerDay > 0.0 && CreatureManager.getInstance().config.levelPerDayMax > 0) {
            int day = (int)Math.floor((double)this.func_130014_f_().func_82737_E() / 23999.0);
            double levelGain = Math.min(CreatureManager.getInstance().config.levelPerDay * (double)day, (double)CreatureManager.getInstance().config.levelPerDayMax);
            startingLevelMin += (int)Math.floor(levelGain);
        }
        if (CreatureManager.getInstance().config.levelPerLocalDifficulty > 0.0) {
            double levelGain = this.func_130014_f_().func_175649_E(this.func_180425_c()).func_180168_b();
            startingLevelMin += Math.max(0, (int)Math.floor(levelGain - 1.5));
        }
        return startingLevelMin;
    }

    public void applyLevel(int level) {
        this.setLevel(level);
        this.refreshStats();
    }

    public void setLevel(int level) {
        this.level = level;
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public void addLevel(int level) {
        this.applyLevel(this.level + level);
    }

    public int getMeleeCooldown() {
        return Math.round((float)(1.0 / this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0));
    }

    public int getRangedCooldown() {
        return Math.round((float)(1.0 / this.func_110148_a(RANGED_SPEED).func_111126_e() * 20.0));
    }

    public int getEffectDuration(int seconds) {
        return Math.round((float)seconds * (float)this.creatureStats.getEffect() * 20.0f);
    }

    public int getEffectAmplifier(float scale) {
        return Math.round((float)this.creatureStats.getAmplifier());
    }

    public int getEffectStrength(float value) {
        return Math.round(value * (float)this.creatureStats.getAmplifier());
    }

    public void applySubspecies(int subspeciesIndex) {
        this.setSubspecies(subspeciesIndex);
        this.refreshStats();
    }

    public void setSubspecies(int subspeciesIndex) {
        this.subspecies = this.creatureInfo.getSubspecies(subspeciesIndex);
        if (this.subspecies != null) {
            float scaledExp = this.creatureInfo.experience;
            if ("uncommon".equals(this.subspecies.rarity)) {
                scaledExp = Math.round((float)((double)this.creatureInfo.experience * Subspecies.uncommonExperienceScale));
            } else if ("rare".equals(this.subspecies.rarity)) {
                scaledExp = Math.round((float)((double)this.creatureInfo.experience * Subspecies.rareExperienceScale));
            }
            this.field_70728_aV = Math.round(scaledExp);
            if ("rare".equals(this.subspecies.rarity)) {
                this.damageLimit = 40.0f;
                this.damageMax = 25;
            }
        }
    }

    @Nullable
    public Subspecies getSubspecies() {
        return this.subspecies;
    }

    public int getSubspeciesIndex() {
        return this.getSubspecies() != null ? this.getSubspecies().index : 0;
    }

    public boolean isRareSubspecies() {
        return this.getSubspecies() != null && "rare".equals(this.getSubspecies().rarity);
    }

    public void updateBattlePhase() {
    }

    public int getBattlePhase() {
        return this.battlePhase;
    }

    public void setBattlePhase(int phase) {
        if (this.getBattlePhase() == phase) {
            return;
        }
        this.battlePhase = phase;
        this.refreshBossHealthName();
        this.playPhaseSound();
    }

    public LivingEntity transform(EntityType<? extends LivingEntity> transformType, Entity partner, boolean destroyPartner) {
        if (transformType == null) {
            return null;
        }
        LivingEntity transformedEntity = (LivingEntity)transformType.func_200721_a(this.func_130014_f_());
        if (transformedEntity == null) {
            return null;
        }
        if (transformedEntity instanceof EntityCreatureBase) {
            EntityCreatureBase transformedCreature = (EntityCreatureBase)transformedEntity;
            transformedCreature.firstSpawn = false;
            if (this.isTemporary) {
                transformedCreature.setTemporary(this.temporaryDuration);
            }
            if (this.isMinion()) {
                transformedCreature.setMinion(true);
            }
            if (this.hasMaster()) {
                transformedCreature.setMasterTarget(this.getMasterTarget());
            }
            if (partner != null && partner instanceof EntityCreatureBase) {
                EntityCreatureBase partnerCreature = (EntityCreatureBase)partner;
                Subspecies fusionSubspecies = transformedCreature.creatureInfo.getChildSubspecies((LivingEntity)this, this.getSubspeciesIndex(), partnerCreature.getSubspecies());
                transformedCreature.applySubspecies(fusionSubspecies != null ? fusionSubspecies.index : 0);
                transformedCreature.setSizeScale(this.sizeScale + partnerCreature.sizeScale);
                int transformedLevel = this.getLevel();
                if ("lowest".equalsIgnoreCase(CreatureManager.getInstance().config.elementalFusionLevelMix)) {
                    if (transformedLevel > partnerCreature.getLevel()) {
                        transformedLevel = partnerCreature.getLevel();
                    }
                } else if ("highest".equalsIgnoreCase(CreatureManager.getInstance().config.elementalFusionLevelMix)) {
                    if (transformedLevel < partnerCreature.getLevel()) {
                        transformedLevel = partnerCreature.getLevel();
                    }
                } else {
                    transformedLevel += partnerCreature.getLevel();
                }
                transformedCreature.applyLevel(Math.round((float)transformedLevel * (float)CreatureManager.getInstance().config.elementalFusionLevelMultiplier));
                if (transformedCreature instanceof EntityCreatureTameable) {
                    EntityCreatureTameable fusionTameable = (EntityCreatureTameable)transformedCreature;
                    Entity owner = null;
                    if (this instanceof EntityCreatureTameable) {
                        owner = ((EntityCreatureTameable)this).getPlayerOwner();
                    }
                    if (owner != null) {
                        transformedCreature.applyLevel(transformedLevel);
                        fusionTameable.setPlayerOwner((PlayerEntity)owner);
                    } else {
                        Entity partnerOwner = null;
                        if (partnerCreature instanceof EntityCreatureTameable) {
                            partnerOwner = ((EntityCreatureTameable)partnerCreature).getPlayerOwner();
                        }
                        if (partnerOwner != null) {
                            transformedCreature.applyLevel(transformedLevel);
                            fusionTameable.setPlayerOwner((PlayerEntity)partnerOwner);
                            if (partnerCreature.isTemporary) {
                                transformedCreature.setTemporary(partnerCreature.temporaryDuration);
                            }
                            transformedCreature.setMinion(partnerCreature.isMinion());
                            if (partnerCreature.hasMaster()) {
                                transformedCreature.setMasterTarget(partnerCreature.getMasterTarget());
                            }
                        }
                    }
                }
            } else {
                transformedCreature.applySubspecies(this.getSubspeciesIndex());
                transformedCreature.setSizeScale(this.sizeScale);
                transformedCreature.applyLevel(this.getLevel());
                if (transformedCreature instanceof EntityCreatureTameable) {
                    EntityCreatureTameable fusionTameable = (EntityCreatureTameable)transformedCreature;
                    if (this.getOwner() != null && this.getOwner() instanceof PlayerEntity) {
                        fusionTameable.setPlayerOwner((PlayerEntity)this.getOwner());
                    }
                }
            }
        }
        transformedEntity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        this.func_130014_f_().func_217376_c((Entity)transformedEntity);
        this.func_70106_y();
        if (partner != null && destroyPartner) {
            partner.func_70106_y();
        }
        return transformedEntity;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.onSyncUpdate();
        if (this.despawnCheck()) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            this.func_70106_y();
        }
        if (this.func_70027_ad() && !this.canBurn()) {
            this.func_70066_B();
        }
        if (!this.canWalk() && !this.isFlying() && !this.func_70090_H() && this.isMoving() || !this.canMove()) {
            this.clearMovement();
        }
        if (!this.func_130014_f_().field_72995_K || this.func_184186_bw()) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (!this.field_70122_E && this.flySoundSpeed > 0 && this.field_70173_aa % 20 == 0) {
                this.playFlySound();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isFlying() && this.hasAttackTarget() && this.updateTick % 40L == 0L) {
            this.leap(0.0, 0.4);
        }
        if (this.bossInfo != null) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L) {
            for (PlayerEntity player : this.func_130014_f_().func_217369_A()) {
                ExtendedPlayer extendedPlayer;
                if (!(this.func_70032_d((Entity)player) <= 3.0f) || (extendedPlayer = ExtendedPlayer.getForPlayer(player)) == null) continue;
                extendedPlayer.getBeastiary().discoverCreature((Entity)this, 1, false);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.guiViewers.size() <= 0) {
            this.guiRefreshTick = 0;
        }
        if (!this.func_130014_f_().field_72995_K && this.guiRefreshTick > 0 && --this.guiRefreshTick <= 0) {
            this.refreshGUIViewers();
            this.guiRefreshTick = 0;
        }
    }

    protected void func_70619_bc() {
        if (this.useDirectNavigator()) {
            this.directNavigator.updateFlight();
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        float brightness;
        if (this.damageLimit > 0.0f) {
            if (this.healthLastTick < 0.0f) {
                this.healthLastTick = this.func_110143_aJ();
            }
            if (this.healthLastTick - this.func_110143_aJ() > this.damageLimit) {
                this.func_70606_j(this.healthLastTick);
            }
            this.healthLastTick = this.func_110143_aJ();
            if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L) {
                this.damageTakenThisSec = 0.0f;
            }
        }
        super.func_70636_d();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            if (this.attackCooldown > this.getAttackCooldownMax()) {
                this.triggerAttackCooldown();
            }
        }
        this.updateBattlePhase();
        this.func_82168_bl();
        if (this.currentBlockingTime > 0) {
            --this.currentBlockingTime;
        }
        if (this.currentBlockingTime < 0) {
            this.currentBlockingTime = 0;
        }
        if (!this.func_130014_f_().field_72995_K && this.firstSpawn) {
            this.onFirstSpawn();
            this.firstSpawn = false;
        }
        if (!this.func_130014_f_().field_72995_K && !this.hasFixateTarget() && this.fixateUUID != null) {
            double range = 64.0;
            List connections = this.func_130014_f_().func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(range, range, range));
            for (LivingEntity possibleFixateTarget : connections) {
                if (possibleFixateTarget == this || !possibleFixateTarget.func_110124_au().equals(this.fixateUUID)) continue;
                this.setFixateTarget(possibleFixateTarget);
                break;
            }
            this.fixateUUID = null;
        }
        if (this.hasFixateTarget()) {
            this.func_70624_b(this.getFixateTarget());
        }
        if (this.hasAttackTarget() && this.func_70638_az() instanceof PlayerEntity) {
            PlayerEntity targetPlayer = (PlayerEntity)this.func_70638_az();
            if (targetPlayer.field_71075_bZ.field_75102_a) {
                this.func_70624_b(null);
            }
        }
        if (this.hasAvoidTarget() && this.currentFleeTime-- <= 0) {
            this.setAvoidTarget(null);
        }
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, this.getFallingMod(), 1.0));
        }
        if (!this.func_130014_f_().field_72995_K && this.daylightBurns() && this.func_130014_f_().func_72935_r() && (brightness = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            boolean shouldBurn = true;
            ItemStack helmet = this.inventory.getEquipmentStack("head");
            if (helmet != null) {
                if (helmet.func_77984_f()) {
                    helmet.func_196085_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                        this.setCurrentItemOrArmor(4, ItemStack.field_190927_a);
                    }
                }
                shouldBurn = false;
            }
            if (shouldBurn) {
                this.func_70015_d(8);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.waterDamage() && this.func_70026_G() && !this.func_180799_ab()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70089_S() && !this.canBreatheAir()) {
            this.func_70050_g(this.func_207300_l(this.func_70086_ai()));
            if (this.func_70086_ai() <= -200) {
                this.func_70050_g(-160);
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        float light = this.func_70013_c();
        if (!this.creatureInfo.creatureSpawn.spawnsInLight && light > 0.5f) {
            this.field_70708_bq += 2;
        } else if (!this.creatureInfo.creatureSpawn.spawnsInDark && light <= 0.5f) {
            this.field_70708_bq += 2;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isStealthed() && !this.func_82150_aj()) {
                this.func_82142_c(true);
            } else if (!this.isStealthed() && this.func_82150_aj() && !this.func_70644_a(Effects.field_76441_p)) {
                this.func_82142_c(false);
            }
        }
        if (this.isStealthed()) {
            if (this.stealthPrev != this.isStealthed()) {
                this.startStealth();
            }
            this.onStealth();
        } else if (this.func_82150_aj() && !this.func_70644_a(Effects.field_76441_p) && !this.func_130014_f_().field_72995_K) {
            this.func_82142_c(false);
        }
        this.stealthPrev = this.isStealthed();
        if (this.field_70173_aa % 20 == 0 && !this.func_130014_f_().field_72995_K && this.func_70089_S() && this.canPickupItems()) {
            this.pickupItems();
        }
        if (!this.func_130014_f_().field_72995_K && this.pickupEntity != null) {
            if (!this.pickupEntity.func_70089_S()) {
                this.dropPickupEntity();
            } else if (Math.sqrt(this.func_70032_d((Entity)this.pickupEntity)) > 32.0) {
                this.dropPickupEntity();
            }
        }
        this.getBossInfo();
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityCreatureBase) {
            ((EntityCreatureBase)this.getMasterTarget()).onMinionUpdate((LivingEntity)this, this.updateTick);
        }
        ++this.updateTick;
    }

    public void onSyncUpdate() {
        if (!this.func_130014_f_().field_72995_K) {
            byte targets = 0;
            if (this.func_70638_az() != null) {
                targets = (byte)(targets + TARGET_BITS.ATTACK.id);
            }
            if (this.getMasterTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.MASTER.id);
            }
            if (this.getParentTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.PARENT.id);
            }
            if (this.getAvoidTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.AVOID.id);
            }
            if (this.func_184179_bs() != null) {
                targets = (byte)(targets + TARGET_BITS.RIDER.id);
            }
            if (this.getPickupEntity() != null) {
                targets = (byte)(targets + TARGET_BITS.PICKUP.id);
            }
            this.field_70180_af.func_187227_b(TARGET, (Object)targets);
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(ATTACK_PHASE, (Object)this.attackPhase);
        }
        if (!this.func_130014_f_().field_72995_K) {
            byte animations = 0;
            if (this.isAttackOnCooldown()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.ATTACKED.id);
            }
            if (this.field_70122_E) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.GROUNDED.id);
            }
            if (this.field_70171_ac) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.IN_WATER.id);
            }
            if (this.isBlocking()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.BLOCKING.id);
            }
            if (this.isMinion()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.MINION.id);
            }
            if (this.extraAnimation01()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.EXTRA01.id);
            }
            this.field_70180_af.func_187227_b(ANIMATION_STATE, (Object)animations);
        } else if (this.func_130014_f_().field_72995_K) {
            byte animationState = this.getByteFromDataManager(ANIMATION_STATE);
            if ((animationState & ANIMATION_STATE_BITS.ATTACKED.id) > 0) {
                if (!this.isAttackOnCooldown()) {
                    this.triggerAttackCooldown();
                }
            } else {
                this.resetAttackCooldown();
            }
            this.field_70122_E = (animationState & ANIMATION_STATE_BITS.GROUNDED.id) > 0;
            this.field_70171_ac = (animationState & ANIMATION_STATE_BITS.IN_WATER.id) > 0;
            boolean bl = this.extraAnimation01 = (animationState & ANIMATION_STATE_BITS.EXTRA01.id) > 0;
        }
        if (this.func_130014_f_().field_72995_K) {
            boolean bl = this.isMinion = (this.getByteFromDataManager(ANIMATION_STATE) & ANIMATION_STATE_BITS.MINION.id) > 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(SUBSPECIES, (Object)((byte)this.getSubspeciesIndex()));
        } else if (this.getSubspeciesIndex() != this.getByteFromDataManager(SUBSPECIES)) {
            this.applySubspecies(this.getByteFromDataManager(SUBSPECIES));
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf((float)this.sizeScale));
        } else if (this.sizeScale != (double)this.getFloatFromDataManager(SIZE)) {
            this.setSizeScale(this.getFloatFromDataManager(SIZE));
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(ARENA, this.getArenaCenter() != null ? Optional.of(this.getArenaCenter()) : Optional.empty());
        }
    }

    public AxisAlignedBB func_70046_E() {
        if (this.solidCollision) {
            return this.func_174813_aQ();
        }
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return super.func_70114_g(entity);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this);
        }
        double radius = (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 2.0;
        double height = this.func_213305_a((Pose)Pose.STANDING).field_220316_b;
        this.func_174826_a(new AxisAlignedBB(x - radius, y, z - radius, x + radius, y + height, z + radius));
    }

    public float getBlockPathWeight(int x, int y, int z) {
        if (this.creatureInfo.creatureSpawn.spawnsInDark && !this.creatureInfo.creatureSpawn.spawnsInLight) {
            return 0.5f - this.func_130014_f_().func_205052_D(new BlockPos(x, y, z));
        }
        if (this.creatureInfo.creatureSpawn.spawnsInLight && !this.creatureInfo.creatureSpawn.spawnsInDark) {
            return this.func_130014_f_().func_205052_D(new BlockPos(x, y, z)) - 0.5f;
        }
        return 0.0f;
    }

    public boolean useDirectNavigator() {
        return false;
    }

    public boolean shouldSwim() {
        if (!this.func_70090_H() && !this.func_180799_ab()) {
            return false;
        }
        if (this.canWade() && this.func_70648_aU()) {
            BlockState blockState;
            boolean targetInWater = true;
            if (this.func_70638_az() != null) {
                targetInWater = this.func_70638_az().func_70090_H();
            } else if (this.getParentTarget() != null) {
                targetInWater = this.getParentTarget().func_70090_H();
            } else if (this.getMasterTarget() != null) {
                targetInWater = this.getMasterTarget().func_70090_H();
            }
            return targetInWater || !(blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177984_a())).func_177230_c().isAir(blockState, (IBlockReader)this.func_130014_f_(), this.func_180425_c().func_177984_a());
        }
        return this.isStrongSwimmer();
    }

    public void func_213352_e(Vec3d direction) {
        if (this.useDirectNavigator()) {
            this.directNavigator.flightMovement(direction.func_82615_a(), direction.func_82616_c());
            this.updateLimbSwing();
            return;
        }
        if (this.shouldSwim()) {
            this.travelSwimming(direction);
        } else if (this.isFlying()) {
            this.travelFlying(direction);
        } else {
            super.func_213352_e(direction);
        }
    }

    public void travelFlying(Vec3d direction) {
        double flightDampening = 0.91f;
        if (this.field_70122_E) {
            BlockState groundState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b());
            flightDampening = groundState.getSlipperiness((IWorldReader)this.func_130014_f_(), this.func_180425_c().func_177977_b(), (Entity)this) * 0.91f;
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_216372_d(flightDampening, flightDampening, flightDampening));
        this.updateLimbSwing();
    }

    public void travelSwimming(Vec3d direction) {
        super.func_213309_a(0.1f, direction);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        if (!this.isMoving() && this.func_70638_az() == null && !this.isFlying()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
        }
        this.updateLimbSwing();
    }

    public void updateLimbSwing() {
        this.field_184618_aE = this.field_70721_aZ;
        double distanceX = this.field_70165_t - this.field_70169_q;
        double distanceZ = this.field_70161_v - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 4.0f;
        if (distance > 1.0f) {
            distance = 1.0f;
        }
        this.field_70721_aZ += (distance - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    protected PathNavigator func_175447_b(World world) {
        return new CreaturePathNavigator(this, world);
    }

    protected MovementController createMoveController() {
        return new CreatureMoveController(this);
    }

    public PathNavigator func_70661_as() {
        return super.func_70661_as();
    }

    public MovementController func_70605_aq() {
        return super.func_70605_aq();
    }

    public void clearMovement() {
        if (!this.useDirectNavigator() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        } else {
            this.directNavigator.clearTargetPosition(1.0);
        }
    }

    protected void func_110159_bB() {
        super.func_110159_bB();
        if (this.func_110167_bD() && this.func_110166_bE().func_130014_f_() == this.func_130014_f_()) {
            Entity entity = this.func_110166_bE();
            this.setHome((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, 5.0f);
            float distance = this.func_70032_d(entity);
            this.testLeash(distance);
            if (!this.leashAIActive) {
                this.field_70714_bg.func_75776_a(2, this.leashMoveTowardsRestrictionAI);
                if (!this.isStrongSwimmer()) {
                    this.func_184644_a(PathNodeType.WATER, 0.0f);
                }
                this.leashAIActive = true;
            }
            if (distance > 4.0f) {
                this.func_70661_as().func_75497_a(entity, 1.0);
            }
            if (distance > 6.0f) {
                double d0 = (entity.field_70165_t - this.field_70165_t) / (double)distance;
                double d1 = (entity.field_70163_u - this.field_70163_u) / (double)distance;
                double d2 = (entity.field_70161_v - this.field_70161_v) / (double)distance;
                this.func_213317_d(this.func_213322_ci().func_72441_c(d0 * Math.abs(d0) * 0.4, d1 * Math.abs(d1) * 0.4, d2 * Math.abs(d2) * 0.4));
            }
            if (distance > 10.0f) {
                this.func_110160_i(true, true);
            }
        } else if (!this.func_110167_bD() && this.leashAIActive) {
            this.leashAIActive = false;
            this.field_70714_bg.func_85156_a(this.leashMoveTowardsRestrictionAI);
            if (!this.isStrongSwimmer()) {
                this.func_184644_a(PathNodeType.WATER, PathNodeType.WATER.func_186289_a());
            }
            this.detachHome();
        }
    }

    public boolean func_96092_aw() {
        return !this.isStrongSwimmer();
    }

    public boolean isMoving() {
        if (!this.useDirectNavigator()) {
            return this.func_70661_as().func_75505_d() != null;
        }
        return !this.directNavigator.atTargetPosition();
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void testLeash(float distance) {
    }

    public void func_70659_e(float speed) {
        super.func_70659_e(speed * this.getAISpeedModifier());
    }

    public float getAISpeedModifier() {
        return 1.0f;
    }

    public double getFallingMod() {
        return 1.0;
    }

    protected float func_189749_co() {
        if (!this.func_96092_aw()) {
            return 1.0f;
        }
        return 0.8f;
    }

    public void leap(double distance, double leapHeight) {
        float yaw = this.field_70177_z;
        float pitch = this.field_70125_A;
        double angle = Math.toRadians(yaw);
        double xAmount = -Math.sin(angle);
        double yAmount = leapHeight;
        double zAmount = Math.cos(angle);
        if (this.isFlying()) {
            yAmount = Math.sin(Math.toRadians(pitch)) * distance + this.func_213322_ci().func_82617_b() * 0.2;
        }
        this.func_70024_g(xAmount * distance + this.func_213322_ci().func_82615_a() * 0.2, yAmount, zAmount * distance + this.func_213322_ci().func_82616_c() * 0.2);
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    public void leap(float range, double leapHeight, Entity target) {
        if (target == null) {
            return;
        }
        this.leap(range, leapHeight, target.func_180425_c());
    }

    public void leap(float range, double leapHeight, BlockPos targetPos) {
        if (targetPos == null) {
            return;
        }
        double distance = targetPos.func_177951_i((Vec3i)this.func_180425_c());
        if (distance > 4.0 && distance <= (double)(range * range)) {
            double xDist = targetPos.func_177958_n() - this.func_180425_c().func_177958_n();
            double zDist = targetPos.func_177952_p() - this.func_180425_c().func_177952_p();
            if (xDist == 0.0) {
                xDist = 0.05;
            }
            if (zDist == 0.0) {
                zDist = 0.05;
            }
            double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            this.func_70024_g(xDist / xzDist * 0.5 * 0.8 + this.func_213322_ci().func_82615_a() * 0.2, leapHeight, zDist / xzDist * 0.5 * 0.8 + this.func_213322_ci().func_82616_c() * 0.2);
            ForgeHooks.onLivingJump((LivingEntity)this);
        }
    }

    public void strafe(double distance, double leapHeight) {
        boolean opposite = false;
        if (distance < 0.0) {
            distance = -distance;
            opposite = true;
        }
        float yaw = this.field_70177_z + (opposite ? -90.0f : 90.0f);
        float pitch = this.field_70125_A;
        double angle = Math.toRadians(yaw);
        double xAmount = -Math.sin(angle);
        double yAmount = leapHeight;
        double zAmount = Math.cos(angle);
        if (this.isFlying()) {
            yAmount = Math.sin(Math.toRadians(pitch)) * distance + this.func_213322_ci().func_82617_b() * 0.2;
        }
        this.func_70024_g(xAmount * distance + this.func_213322_ci().func_82615_a() * 0.2, yAmount, zAmount * distance + this.func_213322_ci().func_82616_c() * 0.2);
    }

    public void setHome(int x, int y, int z, float distance) {
        this.setHomePosition(x, y, z);
        this.setHomeDistanceMax(distance);
    }

    public void setHomePosition(int x, int y, int z) {
        this.homePosition = new BlockPos(x, y, z);
    }

    public void setHomeDistanceMax(float newDist) {
        this.homeDistanceMax = newDist;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public float getHomeDistanceMax() {
        return this.homeDistanceMax;
    }

    public void detachHome() {
        this.setHomeDistanceMax(-1.0f);
    }

    public boolean hasHome() {
        return this.getHomePosition() != null && this.getHomeDistanceMax() >= 0.0f;
    }

    public boolean positionNearHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return true;
        }
        return this.getDistanceFromHome(x, y, z) < (double)(this.getHomeDistanceMax() * this.getHomeDistanceMax());
    }

    public double getDistanceFromHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return 0.0;
        }
        return this.homePosition.func_177951_i(new Vec3i(x, y, z));
    }

    public double getDistanceFromHome() {
        return this.homePosition.func_177951_i((Vec3i)this.func_180425_c());
    }

    public boolean hasArenaCenter() {
        return this.getArenaCenter() != null;
    }

    public void setArenaCenter(BlockPos pos) {
        this.arenaCenter = pos;
    }

    public BlockPos getArenaCenter() {
        return this.arenaCenter;
    }

    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        return wanderPosition;
    }

    public int restrictYHeightFromGround(BlockPos coords, int minY, int maxY) {
        int groundY = this.getGroundY(coords);
        int airYMax = Math.min(this.getAirY(coords), groundY + maxY);
        int airYMin = Math.min(airYMax, groundY + minY);
        if (airYMin >= airYMax) {
            return airYMin;
        }
        return airYMin + this.func_70681_au().nextInt(airYMax - airYMin);
    }

    public int getGroundY(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y <= 0) {
            return 0;
        }
        BlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock.func_177230_c().isAir(startBlock, (IBlockReader)this.func_130014_f_(), pos)) {
            BlockState possibleGroundBlock;
            int possibleGroundY = Math.max(0, y - 1);
            while (possibleGroundY >= 0 && (possibleGroundBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleGroundY, pos.func_177952_p()))).func_177230_c().isAir(possibleGroundBlock, (IBlockReader)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleGroundY, pos.func_177952_p()))) {
                y = possibleGroundY--;
            }
        }
        return y;
    }

    public int getAirY(BlockPos pos) {
        int yMax;
        int y = pos.func_177956_o();
        if (y >= (yMax = this.func_130014_f_().func_72940_L() - 1)) {
            return yMax;
        }
        if (this.func_130014_f_().func_175710_j(pos)) {
            return yMax;
        }
        BlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock.func_177230_c().isAir(startBlock, (IBlockReader)this.func_130014_f_(), pos)) {
            BlockState possibleGroundBlock;
            int possibleAirY = Math.min(yMax, y + 1);
            while (possibleAirY <= yMax && (possibleGroundBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleAirY, pos.func_177952_p()))).func_177230_c().isAir(possibleGroundBlock, (IBlockReader)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleAirY, pos.func_177952_p()))) {
                y = possibleAirY++;
            }
        }
        return y;
    }

    public int getWaterSurfaceY(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y <= 0) {
            return 0;
        }
        int yMax = this.func_130014_f_().func_72940_L() - 1;
        if (y >= yMax) {
            return yMax;
        }
        int yLimit = 24;
        yMax = Math.min(yMax, y + yLimit);
        BlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock.func_185904_a() == Material.field_151586_h) {
            int possibleSurfaceY = y;
            ++possibleSurfaceY;
            while (possibleSurfaceY <= yMax) {
                BlockState possibleSurfaceBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleSurfaceY, pos.func_177952_p()));
                if (possibleSurfaceBlock.func_177230_c().isAir(possibleSurfaceBlock, (IBlockReader)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleSurfaceY, pos.func_177952_p()))) {
                    return possibleSurfaceY;
                }
                if (possibleSurfaceBlock.func_185904_a() != Material.field_151586_h) {
                    return possibleSurfaceY - 1;
                }
                ++possibleSurfaceY;
            }
            return Math.max(possibleSurfaceY - 1, y);
        }
        return y;
    }

    public boolean func_213358_a(EntityType<?> entityType) {
        return CreatureManager.getInstance().config.mobsAttackVillagers || entityType != EntityType.field_200756_av;
    }

    public boolean func_213336_c(LivingEntity targetEntity) {
        if (!CreatureManager.getInstance().config.mobsAttackVillagers && targetEntity instanceof VillagerEntity) {
            return false;
        }
        if (targetEntity instanceof PlayerEntity) {
            PlayerEntity targetPlayer = (PlayerEntity)targetEntity;
            if (targetPlayer.field_71075_bZ.field_75102_a) {
                return false;
            }
        }
        if (this.func_184191_r((Entity)targetEntity)) {
            return false;
        }
        if (targetEntity instanceof EntityCreatureBase) {
            EntityCreatureBase targetCreature = (EntityCreatureBase)targetEntity;
            if (targetCreature.getMasterTarget() == this) {
                return false;
            }
            if (!(this instanceof IGroupBoss) && !this.isTamed()) {
                if (targetEntity instanceof IGroupBoss) {
                    return false;
                }
                if (this.isRareSubspecies()) {
                    return false;
                }
            }
        }
        return this.isStrongSwimmer() || !this.isFlying() || !targetEntity.func_70090_H();
    }

    public double getMeleeAttackRange() {
        double range = (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 1.55;
        if (this.isFlying()) {
            range += 0.5;
        }
        return range;
    }

    public LivingEntity getMasterAttackTarget() {
        if (this.masterTarget == null) {
            return null;
        }
        if (this.masterTarget instanceof MobEntity) {
            return ((MobEntity)this.masterTarget).func_70638_az();
        }
        return null;
    }

    public LivingEntity getParentAttackTarget() {
        if (this.parentTarget == null) {
            return null;
        }
        if (this.parentTarget instanceof MobEntity) {
            return ((MobEntity)this.parentTarget).func_70638_az();
        }
        return null;
    }

    public void func_70604_c(LivingEntity entityLivingBase) {
        boolean aggressiveOverride = CreatureManager.getInstance().config.animalsFightBack;
        if (!aggressiveOverride && this.extraMobBehaviour != null) {
            aggressiveOverride = this.extraMobBehaviour.aggressiveOverride;
        }
        if (!aggressiveOverride && this.fleeHealthPercent > 0.0f && this.func_110143_aJ() / this.func_110138_aP() <= this.fleeHealthPercent) {
            this.setAvoidTarget(entityLivingBase);
        } else {
            super.func_70604_c(entityLivingBase);
        }
    }

    public boolean attackMelee(Entity target, double damageScale) {
        if (this.isBlocking() && !this.canAttackWhileBlocking()) {
            return false;
        }
        if (this.attackEntityAsMob(target, damageScale)) {
            if (this.spreadFire && this.func_70027_ad() && (double)this.field_70146_Z.nextFloat() < this.creatureStats.getEffect()) {
                target.func_70015_d(this.getEffectDuration(4) / 20);
            }
            if (target instanceof LivingEntity && this.creatureStats.getAmplifier() >= 0.0) {
                this.applyDebuffs((LivingEntity)target, 1, 1);
            }
            this.triggerAttackCooldown();
            this.playAttackSound();
            return true;
        }
        return false;
    }

    public void attackRanged(Entity target, float range) {
        if (this.isBlocking() && !this.canAttackWhileBlocking()) {
            return;
        }
        this.triggerAttackCooldown();
        this.playAttackSound();
    }

    public boolean doRangedDamage(Entity target, ThrowableEntity projectile, float damage) {
        boolean success;
        double pierceDamage;
        if ((double)(damage = (float)((double)damage * (this.creatureStats.getDamage() / 2.0))) <= (pierceDamage = this.creatureStats.getPierce())) {
            success = target.func_70097_a(this.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)projectile, (Entity)this).func_76348_h()).func_151518_m(), damage);
        } else {
            int hurtResistantTimeBefore = target.field_70172_ad;
            target.func_70097_a(this.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)projectile, (Entity)this).func_76348_h()).func_151518_m(), (float)pierceDamage);
            target.field_70172_ad = hurtResistantTimeBefore;
            damage = (float)((double)damage - pierceDamage);
            success = target.func_70097_a(this.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)projectile, (Entity)this)), damage);
        }
        if (success && target instanceof LivingEntity && this.creatureStats.getAmplifier() >= 0.0) {
            this.applyDebuffs((LivingEntity)target, 1, 1);
        }
        return success;
    }

    public EntityProjectileBase fireProjectile(String projectileName, Entity target, float range, float angle, Vec3d offset, float velocity, float scale, float inaccuracy) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(projectileName);
        if (projectileInfo == null) {
            return null;
        }
        return this.fireProjectile(projectileInfo.createProjectile(this.func_130014_f_(), (LivingEntity)this), target, range, angle, offset, velocity, scale, inaccuracy);
    }

    public EntityProjectileBase fireProjectile(Class<? extends EntityProjectileBase> projectileClass, Entity target, float range, float angle, Vec3d offset, float velocity, float scale, float inaccuracy) {
        EntityProjectileBase projectile = ProjectileManager.getInstance().createOldProjectile(projectileClass, this.func_130014_f_(), (LivingEntity)this);
        return this.fireProjectile(projectile, target, range, angle, offset, velocity, scale, inaccuracy);
    }

    public EntityProjectileBase fireProjectile(EntityProjectileBase projectile, Entity target, float range, float angle, Vec3d offset, float velocity, float scale, float inaccuracy) {
        if (projectile == null) {
            return null;
        }
        projectile.field_70165_t += offset.field_72450_a * this.sizeScale;
        projectile.field_70163_u -= (double)(this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 4.0f) + offset.field_72448_b * this.sizeScale;
        projectile.field_70161_v += offset.field_72449_c * this.sizeScale;
        projectile.setProjectileScale(scale);
        Vec3d facing = this.getFacingPositionDouble(this.field_70165_t, this.field_70163_u, this.field_70161_v, range, angle);
        double distanceX = facing.field_72450_a - this.field_70165_t;
        double distanceY = 0.0;
        double distanceZ = facing.field_72449_c - this.field_70161_v;
        if (target != null) {
            double targetX = target.field_70165_t - this.field_70165_t;
            double targetZ = target.field_70161_v - this.field_70161_v;
            double newX = targetX * Math.cos(angle) - targetZ * Math.sin(angle);
            double newY = targetX * Math.sin(angle) + targetZ * Math.cos(angle);
            targetX = newX + this.field_70165_t;
            targetZ = newY + this.field_70161_v;
            distanceX = targetX - this.field_70165_t;
            distanceY = target.func_174813_aQ().field_72338_b + (double)target.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.25 - projectile.field_70163_u;
            distanceZ = targetZ - this.field_70161_v;
        }
        float distanceXZ = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 0.1f;
        projectile.func_70186_c(distanceX, distanceY + (double)distanceXZ, distanceZ, velocity, inaccuracy);
        if (projectile.getLaunchSound() != null) {
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        return projectile;
    }

    public byte getAttackPhase() {
        return this.getByteFromDataManager(ATTACK_PHASE);
    }

    public void setAttackPhase(byte setAttackPhase) {
        this.attackPhase = setAttackPhase;
    }

    public void nextAttackPhase() {
        this.attackPhase = (byte)(this.attackPhase + 1);
        if (this.attackPhase > this.attackPhaseMax - 1) {
            this.attackPhase = 0;
        }
    }

    public boolean attackEntityAsMob(Entity target, double damageScale) {
        boolean attackSuccess;
        if (!this.func_70089_S()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (!this.func_70685_l(target)) {
            return false;
        }
        float damage = this.getAttackDamage(damageScale);
        int i = 0;
        boolean targetIsShielding = false;
        if (target instanceof PlayerEntity) {
            PlayerEntity targetPlayer = (PlayerEntity)target;
            ItemStack playerActiveItemStack = targetPlayer.func_184587_cr() ? targetPlayer.func_184607_cu() : ItemStack.field_190927_a;
            targetIsShielding = !playerActiveItemStack.func_190926_b() && playerActiveItemStack.func_77973_b().isShield(playerActiveItemStack, (LivingEntity)targetPlayer);
        }
        double pierceDamage = this.creatureStats.getPierce();
        if (targetIsShielding) {
            pierceDamage = 0.0;
        }
        if ((double)damage <= pierceDamage) {
            attackSuccess = target.func_70097_a(this.getDamageSource(null).func_76348_h().func_151518_m(), damage);
        } else {
            int hurtResistantTimeBefore = target.field_70172_ad;
            target.func_70097_a(this.getDamageSource(null).func_76348_h().func_151518_m(), (float)pierceDamage);
            target.field_70172_ad = hurtResistantTimeBefore;
            damage = (float)((double)damage - pierceDamage);
            attackSuccess = target.func_70097_a(this.getDamageSource(null), damage);
        }
        if (attackSuccess) {
            int fireEnchantDuration;
            if (i > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if ((fireEnchantDuration = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                target.func_70015_d(fireEnchantDuration * 4);
            }
            if (target instanceof PlayerEntity && this.canInteruptShields(true)) {
                PlayerEntity targetPlayer = (PlayerEntity)target;
                if (targetIsShielding && this.canInteruptShields(false)) {
                    ItemStack playerActiveItemStack = targetPlayer.func_184587_cr() ? targetPlayer.func_184607_cu() : ItemStack.field_190927_a;
                    targetPlayer.func_184811_cZ().func_185145_a(playerActiveItemStack.func_77973_b(), 100);
                    this.field_70170_p.func_72960_a((Entity)targetPlayer, (byte)30);
                }
            }
        }
        return attackSuccess;
    }

    public float getAttackDamage(double damageScale) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        damage = (float)((double)damage * damageScale);
        return damage;
    }

    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource) {
        if (nestedDamageSource != null) {
            return nestedDamageSource;
        }
        return DamageSource.func_76358_a((LivingEntity)this);
    }

    public boolean canInteruptShields(boolean checkAbility) {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.func_180431_b(damageSrc)) {
            return false;
        }
        if (!this.isInvulnerableTo(damageSrc.func_76355_l(), damageSrc, damage)) {
            return false;
        }
        if (!this.isInvulnerableTo(damageSrc.func_76346_g())) {
            return false;
        }
        damage *= this.getDamageModifier(damageSrc);
        damage = this.getDamageAfterDefense(damage);
        if ((this.isBoss() || this.isRareSubspecies()) && !(damageSrc.func_76346_g() instanceof PlayerEntity)) {
            damage *= 0.25f;
        }
        if (super.func_70097_a(damageSrc, damage)) {
            this.onDamage(damageSrc, damage);
            Entity entity = damageSrc.func_76364_f();
            if (entity instanceof ThrowableEntity) {
                entity = ((ThrowableEntity)entity).func_85052_h();
            }
            if (entity instanceof LivingEntity && this.getRider() != entity && this.func_184187_bx() != entity) {
                if (entity != this) {
                    this.func_70604_c((LivingEntity)entity);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public float getDamageAfterDefense(float damage) {
        float defense = (float)this.creatureStats.getDefense();
        float minDamage = 0.0f;
        if (this.isBlocking()) {
            if (defense <= 0.0f) {
                defense = 1.0f;
            }
            defense *= (float)this.getBlockingMultiplier();
        }
        damage = Math.max(damage - defense, 1.0f);
        if (this.damageMax > 0) {
            damage = Math.min(damage, (float)this.damageMax);
        }
        return Math.max(damage, minDamage);
    }

    public void onDamage(DamageSource damageSrc, float damage) {
        this.damageTakenThisSec += damage;
    }

    public float getDamageModifier(DamageSource damageSrc) {
        return 1.0f;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70729_aU) {
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof PlayerEntity) {
                try {
                    PlayerEntity player = (PlayerEntity)damageSource.func_76346_g();
                    if (this.isBoss() || this.func_70681_au().nextDouble() <= CreatureManager.getInstance().config.beastiaryAddOnDeathChance) {
                        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
                        playerExt.getBeastiary().discoverCreature((Entity)this, 2, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityCreatureBase) {
            ((EntityCreatureBase)this.getMasterTarget()).onMinionDeath((LivingEntity)this);
        }
    }

    public boolean func_213398_dR() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.aggressiveOverride) {
            return true;
        }
        return this.isAggressiveByDefault;
    }

    public boolean isProtective(Entity entity) {
        return true;
    }

    public boolean hasAttackTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_70638_az() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.ATTACK.id) > 0;
    }

    public LivingEntity getMasterTarget() {
        return this.masterTarget;
    }

    public void setMasterTarget(LivingEntity setTarget) {
        this.masterTarget = setTarget;
    }

    public boolean hasMaster() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getMasterTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.MASTER.id) > 0;
    }

    public LivingEntity getParentTarget() {
        return this.parentTarget;
    }

    public void setParentTarget(LivingEntity setTarget) {
        this.parentTarget = setTarget;
    }

    public boolean hasParent() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getParentTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.PARENT.id) > 0;
    }

    public LivingEntity getAvoidTarget() {
        return this.avoidTarget;
    }

    public void setAvoidTarget(LivingEntity setTarget) {
        this.currentFleeTime = this.fleeTime;
        this.avoidTarget = setTarget;
    }

    public boolean hasAvoidTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getAvoidTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.AVOID.id) > 0;
    }

    public LivingEntity getFixateTarget() {
        return this.fixateTarget;
    }

    public void setFixateTarget(LivingEntity target) {
        this.fixateTarget = target;
    }

    public boolean hasFixateTarget() {
        return this.getFixateTarget() != null;
    }

    public Entity getOwner() {
        return null;
    }

    public UUID getOwnerId() {
        return null;
    }

    public LivingEntity getRider() {
        if (this.func_184179_bs() instanceof LivingEntity) {
            return (LivingEntity)this.func_184179_bs();
        }
        return null;
    }

    public void setRiderTarget(Entity setTarget) {
        this.func_184200_o(setTarget);
    }

    public boolean hasRiderTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_184179_bs() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.RIDER.id) > 0;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected boolean func_184228_n(Entity entity) {
        if (this.isBoss()) {
            return false;
        }
        return super.func_184228_n(entity);
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean canBeTargetedBy(LivingEntity entity) {
        if (this.isBoss() && entity instanceof EntityCreatureBase) {
            EntityCreatureTameable entityTameable;
            EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
            return entityCreature instanceof EntityCreatureTameable && (entityTameable = (EntityCreatureTameable)entity).getPlayerOwner() != null;
        }
        return true;
    }

    public BlockPos getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public BlockPos getFacingPosition(Entity entity, double distance, double angleOffset) {
        return this.getFacingPosition(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, distance, (double)entity.field_70177_z + angleOffset);
    }

    public BlockPos getFacingPosition(double x, double y, double z, double distance, double angle) {
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        return new BlockPos(x + distance * xAmount, y, z + distance * zAmount);
    }

    public Vec3d getFacingPositionDouble(double x, double y, double z, double distance, double angle) {
        if (distance == 0.0) {
            distance = 1.0;
        }
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        return new Vec3d(x + distance * xAmount, y, z + distance * zAmount);
    }

    public boolean isTamed() {
        return false;
    }

    public boolean isHostile() {
        return this.func_213398_dR();
    }

    public boolean canMove() {
        return !this.isBlocking();
    }

    public boolean canWalk() {
        return true;
    }

    public boolean canWade() {
        return true;
    }

    public boolean func_204231_K() {
        if (this.isLavaCreature) {
            return this.func_180799_ab();
        }
        return super.func_204231_K();
    }

    public boolean shouldFloat() {
        return !this.func_70648_aU() && !this.canBreatheUnderlava();
    }

    public boolean shouldDive() {
        return this.func_70648_aU() || this.canBreatheUnderlava();
    }

    public boolean isStrongSwimmer() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.swimmingOverride;
    }

    public boolean canClimb() {
        return false;
    }

    public boolean isFlying() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.flightOverride;
    }

    public int getFlyingHeight() {
        if (!this.isFlying()) {
            return 20;
        }
        return 0;
    }

    public boolean isSafeToLand() {
        if (this.field_70122_E) {
            return true;
        }
        if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a().func_76220_a()) {
            return true;
        }
        return this.func_130014_f_().func_180495_p(this.func_180425_c().func_177979_c(2)).func_185904_a().func_76220_a();
    }

    public double getFlightOffset() {
        return 0.0;
    }

    public boolean canBeTempted() {
        return !this.isRareSubspecies();
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public void onEat() {
    }

    public boolean canStealth() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.stealthOverride;
    }

    public float getStealth() {
        return this.getFloatFromDataManager(STEALTH);
    }

    public void setStealth(float setStealth) {
        setStealth = Math.min(setStealth, 1.0f);
        setStealth = Math.max(setStealth, 0.0f);
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(STEALTH, (Object)Float.valueOf(setStealth));
        }
    }

    public boolean isStealthed() {
        return this.getStealth() >= 1.0f;
    }

    public void startStealth() {
    }

    public void onStealth() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof MobEntity && ((MobEntity)this.func_70638_az()).func_70638_az() != null) {
            ((MobEntity)this.func_70638_az()).func_70624_b(null);
        }
    }

    public boolean func_70617_f_() {
        if (this.isFlying() || this.isStrongSwimmer() && this.func_70090_H()) {
            return false;
        }
        if (this.canClimb()) {
            return (this.getByteFromDataManager(CLIMBING) & 1) != 0;
        }
        return super.func_70617_f_();
    }

    public void setBesideClimbableBlock(boolean collided) {
        if (this.canClimb()) {
            byte climbing = this.getByteFromDataManager(CLIMBING);
            climbing = collided ? (byte)(climbing | 1) : (byte)(climbing & 0xFFFFFFFE);
            this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
        }
    }

    public boolean isBesideClimbableBlock() {
        return (this.getByteFromDataManager(CLIMBING) & 1) != 0;
    }

    public void func_180430_e(float fallDistance, float damageMultiplier) {
        if (this.isFlying()) {
            return;
        }
        fallDistance -= this.getFallResistance();
        if (this.getFallResistance() >= 100.0f) {
            fallDistance = 0.0f;
        }
        super.func_180430_e(fallDistance, damageMultiplier);
    }

    protected void func_184231_a(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.func_184231_a(y, onGround, state, pos);
        }
    }

    public void setBlocking() {
        this.currentBlockingTime = this.blockingTime;
    }

    public boolean isBlocking() {
        if (this.func_130014_f_().field_72995_K) {
            return (this.getByteFromDataManager(ANIMATION_STATE) & ANIMATION_STATE_BITS.BLOCKING.id) > 0;
        }
        return this.currentBlockingTime > 0;
    }

    public boolean canAttackWhileBlocking() {
        return false;
    }

    public int getBlockingMultiplier() {
        return 4;
    }

    public boolean canPickupEntity(LivingEntity entity) {
        if (this.getPickupEntity() == entity) {
            return false;
        }
        if (entity instanceof IGroupBoss || entity instanceof IGroupHeavy) {
            return false;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity == null) {
            return false;
        }
        if (entity.func_184187_bx() != null && !(entity.func_184187_bx() instanceof BoatEntity) && !(entity.func_184187_bx() instanceof MinecartEntity) || entity.func_184179_bs() != null) {
            return false;
        }
        if (ObjectManager.getEffect("weight") != null && entity.func_70644_a((Effect)ObjectManager.getEffect("weight"))) {
            return false;
        }
        return extendedEntity.pickedUpByEntity == null || extendedEntity.pickedUpByEntity instanceof EntityFear;
    }

    public void pickupEntity(LivingEntity entity) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity((Entity)this);
        }
        this.pickupEntity = entity;
        this.clearMovement();
    }

    public LivingEntity getPickupEntity() {
        return this.pickupEntity;
    }

    public boolean hasPickupEntity() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getPickupEntity() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.PICKUP.id) > 0;
    }

    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 0.0, 0.0};
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop) {
        this.destroyArea(x, y, z, strength, drop, 0);
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop, int range) {
        this.destroyArea(x, y, z, strength, drop, range, null, 0);
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop, int range, PlayerEntity player, int chain) {
        range = Math.max(range - 1, 0);
        int w = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) - range);
        while ((double)w <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
            int d = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) - range);
            while ((double)d <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
                int h = 0;
                while ((double)h <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220316_b)) {
                    BlockPos breakPos = new BlockPos(x + w, y + h, z + d);
                    BlockState blockState = this.func_130014_f_().func_180495_p(breakPos);
                    float hardness = blockState.func_185887_b((IBlockReader)this.func_130014_f_(), breakPos);
                    Material material = blockState.func_185904_a();
                    if (hardness >= 0.0f && strength >= hardness && strength >= blockState.func_177230_c().func_149638_a() && material != Material.field_151586_h && material != Material.field_151587_i && (player == null || w != 0 || h != 0 || d != 0)) {
                        SpawnerEventListener.getInstance().onBlockBreak(this.func_130014_f_(), breakPos, blockState, player, chain);
                        this.func_130014_f_().func_175655_b(breakPos, drop);
                    }
                    ++h;
                }
                ++d;
            }
            ++w;
        }
    }

    public void destroyAreaBlock(int x, int y, int z, Class<? extends Block> blockClass, boolean drop, int range) {
        int w = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + range);
        while ((double)w <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
            int d = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + range);
            while ((double)d <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
                int h = 0;
                while ((double)h <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220316_b)) {
                    BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x + w, y + h, z + d));
                    if (blockClass.isInstance(blockState.func_177230_c())) {
                        this.func_130014_f_().func_175655_b(new BlockPos(x + w, y + h, z + d), drop);
                    }
                    ++h;
                }
                ++d;
            }
            ++w;
        }
    }

    public boolean extraAnimation01() {
        return this.extraAnimation01;
    }

    public void applyDebuffs(LivingEntity entity, int duration, int amplifier) {
        for (ElementInfo element : this.creatureInfo.elements) {
            element.debuffEntity(entity, this.getEffectDuration(duration), this.getEffectAmplifier(amplifier));
        }
    }

    public void applyBuffs(LivingEntity entity, int duration, int amplifier) {
        if (this.creatureStats.getAmplifier() >= 0.0) {
            for (ElementInfo element : this.creatureInfo.elements) {
                element.buffEntity(entity, this.getEffectDuration(duration), this.getEffectAmplifier(amplifier));
            }
        }
    }

    protected void func_213345_d(DamageSource damageSource) {
        if (this.func_130014_f_().field_72995_K || this.isMinion() || this.isBoundPet()) {
            return;
        }
        int subspeciesScale = 1;
        if (this.getSubspeciesIndex() > 2) {
            subspeciesScale = Subspecies.rareDropScale;
        } else if (this.getSubspeciesIndex() > 0) {
            subspeciesScale = Subspecies.uncommonDropScale;
        }
        for (ItemDrop itemDrop : this.drops) {
            if (itemDrop.subspeciesID >= 0 && itemDrop.subspeciesID != this.getSubspeciesIndex()) continue;
            int quantity = itemDrop.getQuantity(this.field_70146_Z, 0);
            if (itemDrop.subspeciesID < 0) {
                quantity *= subspeciesScale;
            }
            if (this.extraMobBehaviour != null && this.extraMobBehaviour.itemDropMultiplierOverride != 1.0) {
                quantity = Math.round((float)quantity * (float)this.extraMobBehaviour.itemDropMultiplierOverride);
            }
            ItemStack dropStack = null;
            if (quantity > 0) {
                dropStack = itemDrop.getEntityDropItemStack((LivingEntity)this, quantity);
            }
            if (dropStack == null) continue;
            this.dropItem(dropStack);
        }
    }

    public void dropItem(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemEquipmentPart) {
            ((ItemEquipmentPart)itemStack.func_77973_b()).initializePart(this.field_70170_p, itemStack);
        }
        this.func_70099_a(itemStack, 0.0f);
    }

    public ItemEntity func_70099_a(ItemStack itemStack, float heightOffset) {
        if (itemStack.func_190916_E() != 0) {
            EntityItemCustom entityItem = new EntityItemCustom(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)heightOffset, this.field_70161_v, itemStack);
            entityItem.func_174867_a(10);
            this.applyDropEffects(entityItem);
            this.func_130014_f_().func_217376_c((Entity)entityItem);
            return entityItem;
        }
        return null;
    }

    public void applyDropEffects(EntityItemCustom entityItem) {
    }

    public void openGUI(PlayerEntity player) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        this.addGUIViewer(player);
        this.refreshGUIViewers();
        this.openGUIToPlayer(player);
    }

    public void addGUIViewer(PlayerEntity player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.guiViewers.add(player);
        }
    }

    public void removeGUIViewer(PlayerEntity player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.guiViewers.remove(player);
        }
    }

    public void refreshGUIViewers() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.guiViewers.size() > 0) {
            for (PlayerEntity player : this.guiViewers.toArray(new PlayerEntity[this.guiViewers.size()])) {
                if (!(player.field_71070_bA instanceof ContainerCreature)) continue;
                if (((ContainerCreature)player.field_71070_bA).creature == this) {
                    this.openGUIToPlayer(player);
                    continue;
                }
                this.removeGUIViewer(player);
            }
        }
    }

    public void openGUIToPlayer(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new CreatureContainerProvider(this), buf -> buf.writeInt(this.func_145782_y()));
        }
    }

    public void scheduleGUIRefresh() {
        this.guiRefreshTick = this.guiRefreshTime + 1;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.assessInteractCommand(this.getInteractCommands(player, player.func_184586_b(hand)), player, player.func_184586_b(hand))) {
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean assessInteractCommand(HashMap<Integer, String> commands, PlayerEntity player, ItemStack itemStack) {
        if (commands.isEmpty()) {
            return false;
        }
        int priority = 100;
        for (int testPriority : commands.keySet()) {
            if (testPriority >= priority) continue;
            priority = testPriority;
        }
        if (!commands.containsKey(priority)) {
            return false;
        }
        this.performCommand(commands.get(priority), player, itemStack);
        return true;
    }

    public HashMap<Integer, String> getInteractCommands(PlayerEntity player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Items.field_151058_ca && this.func_184652_a(player)) {
                commands.put(COMMAND_PIORITIES.ITEM_USE.id, "Leash");
            }
            if (itemStack.func_77973_b() == Items.field_151057_cb) {
                if (this.canNameTag(player)) {
                    return new HashMap<Integer, String>();
                }
                commands.put(COMMAND_PIORITIES.ITEM_USE.id, "Name Tag");
            }
            if (this.canBeColored(player) && itemStack.func_77973_b() instanceof DyeItem) {
                commands.put(COMMAND_PIORITIES.ITEM_USE.id, "Color");
            }
        }
        return commands;
    }

    public void performCommand(String command, PlayerEntity player, ItemStack itemStack) {
        DyeItem dye;
        DyeColor color;
        if ("Leash".equals(command)) {
            this.func_110162_b((Entity)player, true);
            this.consumePlayersItem(player, itemStack);
        }
        if ("Color".equals(command) && itemStack.func_77973_b() instanceof DyeItem && (color = (dye = (DyeItem)itemStack.func_77973_b()).func_195962_g()) != this.getColor()) {
            this.setColor(color);
            this.consumePlayersItem(player, itemStack);
        }
    }

    public boolean canNameTag(PlayerEntity player) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        if (this.getSubspecies() != null && !this.func_145818_k_()) {
            return this.renderSubspeciesNameTag();
        }
        return super.func_94059_bO();
    }

    public boolean renderSubspeciesNameTag() {
        return CreatureManager.getInstance().config.subspeciesTags;
    }

    public void consumePlayersItem(PlayerEntity player, ItemStack itemStack) {
        this.consumePlayersItem(player, itemStack, 1);
    }

    public void consumePlayersItem(PlayerEntity player, ItemStack itemStack, int amount) {
        if (!player.field_71075_bZ.field_75102_a) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - amount));
        }
        if (itemStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        }
    }

    public void replacePlayersItem(PlayerEntity player, ItemStack itemStack, ItemStack newStack) {
        this.replacePlayersItem(player, itemStack, 1, newStack);
    }

    public void replacePlayersItem(PlayerEntity player, ItemStack itemStack, int amount, ItemStack newStack) {
        if (!player.field_71075_bZ.field_75102_a) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - amount));
        }
        if (itemStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStack);
        } else if (!player.field_71071_by.func_70441_a(newStack)) {
            player.func_71019_a(newStack, false);
        }
    }

    public void performGUICommand(PlayerEntity player, byte guiCommandID) {
        this.scheduleGUIRefresh();
    }

    public boolean canCarryItems() {
        return this.getInventorySize() > 0;
    }

    public int getInventorySize() {
        return this.inventory.func_70302_i_();
    }

    public int getInventorySizeMax() {
        return Math.max(this.getNoBagSize(), this.getBagSize());
    }

    public boolean hasBag() {
        return this.inventory.getEquipmentStack("bag") != null;
    }

    public int getNoBagSize() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.inventorySizeOverride > 0) {
            return this.extraMobBehaviour.inventorySizeOverride;
        }
        return 0;
    }

    public int getBagSize() {
        return 5;
    }

    public boolean canPickupItems() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.itemPickupOverride;
    }

    public int getSpaceForStack(ItemStack pickupStack) {
        return this.inventory.getSpaceForStack(pickupStack);
    }

    public boolean canEquip() {
        return this.creatureInfo.isTameable();
    }

    public void setCurrentItemOrArmor(int slot, ItemStack itemStack) {
        String type = "item";
        if (slot == 0) {
            type = "weapon";
        }
        if (slot == 1) {
            type = "feet";
        }
        if (slot == 2) {
            type = "legs";
        }
        if (slot == 3) {
            type = "chest";
        }
        if (slot == 4) {
            type = "head";
        }
        if (slot == 100) {
            type = "bag";
        }
        this.inventory.setEquipmentStack(type, itemStack);
    }

    public String getEquipmentName(String type) {
        if (this.inventory.getEquipmentGrade(type) != null) {
            return type + this.inventory.getEquipmentGrade(type);
        }
        return null;
    }

    public int func_70658_aO() {
        return this.inventory.getArmorValue();
    }

    public void pickupItems() {
        List list = this.func_130014_f_().func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
        for (ItemEntity entityItem : list) {
            ItemStack itemStack;
            int space;
            if (!entityItem.func_70089_S() || entityItem.func_92059_d().func_190926_b() || (space = this.getSpaceForStack(itemStack = entityItem.func_92059_d())) <= 0) continue;
            this.onPickupStack(itemStack);
            this.doItemPickup(entityItem);
        }
    }

    public void onPickupStack(ItemStack itemStack) {
    }

    public void doItemPickup(ItemEntity entityItem) {
        if (entityItem.func_70089_S() && !entityItem.func_92059_d().func_190926_b()) {
            ItemStack leftoverStack = this.inventory.autoInsertStack(entityItem.func_92059_d());
            if (leftoverStack != null) {
                entityItem.func_92058_a(leftoverStack);
            } else {
                entityItem.func_70106_y();
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.damageLimit > 0.0f && this.damageTakenThisSec >= this.damageLimit) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (("inWall".equals(type) || "cactus".equals(type)) && (this.isRareSubspecies() || this.isBoss())) {
            return false;
        }
        if ("inWall".equals(type)) {
            return !CreatureManager.getInstance().config.suffocationImmunity;
        }
        if ("drown".equals(type)) {
            return !CreatureManager.getInstance().config.drownImmunity;
        }
        return true;
    }

    public boolean isInvulnerableTo(Entity entity) {
        if (this.isBoss() || this.isRareSubspecies()) {
            if (entity == null) {
                return false;
            }
            return this.func_70032_d(entity) <= (float)this.bossRange;
        }
        return true;
    }

    protected void func_70044_A() {
        if (!this.canBurn()) {
            return;
        }
        super.func_70044_A();
    }

    public void func_70015_d(int seconds) {
        if (!this.canBurn()) {
            return;
        }
        super.func_70015_d(seconds);
    }

    protected void func_70081_e(int amount) {
        if (!this.canBurn()) {
            return;
        }
        super.func_70081_e(amount);
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        for (ElementInfo element : this.creatureInfo.elements) {
            if (element.isEffectApplicable(effectInstance)) continue;
            return false;
        }
        return true;
    }

    public boolean canBurn() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.fireImmunityOverride) {
            return false;
        }
        for (ElementInfo element : this.creatureInfo.elements) {
            if (element.canBurn()) continue;
            return false;
        }
        return true;
    }

    public boolean daylightBurns() {
        return false;
    }

    public boolean canFreeze() {
        if (this instanceof IGroupIce) {
            return false;
        }
        for (ElementInfo element : this.creatureInfo.elements) {
            if (element.canFreeze()) continue;
            return false;
        }
        return true;
    }

    public boolean waterDamage() {
        return false;
    }

    public boolean webProof() {
        return false;
    }

    public void func_213295_a(BlockState blockState, Vec3d motionMultiplier) {
        if (blockState.func_177230_c() == Blocks.field_196553_aF && this.webProof()) {
            return;
        }
        super.func_213295_a(blockState, motionMultiplier);
    }

    protected int func_207300_l(int currentAir) {
        if (this.func_70648_aU() && this.waterContact()) {
            return super.func_207300_l(currentAir);
        }
        if (this.canBreatheUnderlava() && this.lavaContact()) {
            return super.func_207300_l(currentAir);
        }
        if (this.canBreatheAir()) {
            return super.func_207300_l(currentAir);
        }
        return this.func_70682_h(currentAir);
    }

    protected int func_70682_h(int air) {
        return super.func_70682_h(air);
    }

    public boolean canBreatheAir() {
        return true;
    }

    public boolean func_70648_aU() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.waterBreathingOverride;
    }

    public boolean canBreatheUnderlava() {
        return true;
    }

    public void func_70050_g(int air) {
        super.func_70050_g(air);
    }

    public boolean func_70090_H() {
        return super.func_70090_H();
    }

    public boolean waterContact() {
        if (this.func_203008_ap()) {
            return true;
        }
        return this.func_130014_f_().func_72896_J() && !this.isBlockUnderground((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean lavaContact() {
        return this.func_180799_ab();
    }

    public boolean isSwimmable(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
        if (this.isLavaCreature && Material.field_151587_i.equals(blockState.func_185904_a())) {
            return true;
        }
        return Material.field_151586_h.equals(blockState.func_185904_a());
    }

    public float getFallResistance() {
        return 0.0f;
    }

    public int func_82143_as() {
        return super.func_82143_as() + (int)this.getFallResistance();
    }

    public byte testLightLevel() {
        return this.testLightLevel(this.func_180425_c());
    }

    public byte testLightLevel(BlockPos pos) {
        BlockState spawnBlockState = this.func_130014_f_().func_180495_p(pos);
        if (pos.func_177956_o() < 0) {
            return 0;
        }
        pos = spawnBlockState != null && spawnBlockState.func_185904_a() == Material.field_151586_h && CreatureManager.getInstance().spawnConfig.useSurfaceLightLevel ? new BlockPos(pos.func_177958_n(), this.getWaterSurfaceY(pos), pos.func_177952_p()) : new BlockPos(pos.func_177958_n(), this.getGroundY(pos), pos.func_177952_p());
        int light = this.func_130014_f_().func_201696_r(pos);
        if (light == 0) {
            return 0;
        }
        if (light <= 7) {
            return 1;
        }
        if (light <= 14) {
            return 2;
        }
        return 3;
    }

    public boolean isDaytime() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_130014_f_().func_72935_r();
        }
        long time = this.func_130014_f_().func_72820_D();
        if (time < 12500L) {
            return true;
        }
        return time < 12542L || time >= 23460L;
    }

    public int nearbyCreatureCount(Class targetClass, double range) {
        return this.getNearbyEntities(Entity.class, targetClass, range).size();
    }

    public CreatureAttribute func_70668_bt() {
        return this.attribute;
    }

    public double getMountedXOffset() {
        return 0.0;
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.5;
    }

    public double getMountedZOffset() {
        return 0.0;
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, Class filterClass, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), (Predicate)((com.google.common.base.Predicate)entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        }));
    }

    public <T extends Entity> T getNearestEntity(Class<? extends T> clazz, Class filterClass, double range, boolean canAttack) {
        List<T> aoeTargets = this.getNearbyEntities(clazz, filterClass, range);
        if (aoeTargets.size() == 0) {
            return null;
        }
        double nearestDistance = range + 10.0;
        Entity nearestEntity = null;
        for (T entityObj : aoeTargets) {
            double distance;
            Entity targetEntity = (Entity)entityObj;
            if (targetEntity == this || !(targetEntity instanceof LivingEntity) || canAttack && !this.func_213336_c((LivingEntity)targetEntity) || targetEntity == this.func_184179_bs() || !((distance = (double)this.func_70032_d(targetEntity)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestEntity = targetEntity;
        }
        return (T)nearestEntity;
    }

    public void func_70037_a(CompoundNBT nbtTagCompound) {
        this.firstSpawn = nbtTagCompound.func_74764_b("FirstSpawn") ? nbtTagCompound.func_74767_n("FirstSpawn") : true;
        if (nbtTagCompound.func_74764_b("SpawnEventType")) {
            this.spawnEventType = nbtTagCompound.func_74779_i("SpawnEventType");
        }
        if (nbtTagCompound.func_74764_b("SpawnEventCount")) {
            this.spawnEventCount = nbtTagCompound.func_74762_e("SpawnEventCount");
        }
        if (nbtTagCompound.func_74764_b("Stealth")) {
            this.setStealth(nbtTagCompound.func_74760_g("Stealth"));
        }
        if (nbtTagCompound.func_74764_b("IsMinion")) {
            this.setMinion(nbtTagCompound.func_74767_n("IsMinion"));
        }
        if (nbtTagCompound.func_74764_b("IsTemporary") && nbtTagCompound.func_74767_n("IsTemporary") && nbtTagCompound.func_74764_b("TemporaryDuration")) {
            this.setTemporary(nbtTagCompound.func_74762_e("TemporaryDuration"));
        } else {
            this.unsetTemporary();
        }
        if (nbtTagCompound.func_74764_b("IsBoundPet") && nbtTagCompound.func_74767_n("IsBoundPet") && !this.hasPetEntry()) {
            this.func_70106_y();
        }
        if (nbtTagCompound.func_74764_b("ForceNoDespawn")) {
            this.forceNoDespawn = nbtTagCompound.func_74767_n("ForceNoDespawn");
        }
        if (nbtTagCompound.func_74764_b("Color")) {
            this.setColor(DyeColor.func_196056_a((int)nbtTagCompound.func_74771_c("Color")));
        }
        if (nbtTagCompound.func_74764_b("Size")) {
            this.setSizeScale(nbtTagCompound.func_74769_h("Size"));
        }
        if (nbtTagCompound.func_74764_b("Subspecies")) {
            if (this.firstSpawn) {
                this.applySubspecies(nbtTagCompound.func_74771_c("Subspecies"));
            } else {
                this.setSubspecies(nbtTagCompound.func_74771_c("Subspecies"));
            }
        }
        if (nbtTagCompound.func_74764_b("MobLevel")) {
            if (this.firstSpawn) {
                this.applyLevel(nbtTagCompound.func_74762_e("MobLevel"));
            } else {
                this.setLevel(nbtTagCompound.func_74762_e("MobLevel"));
            }
        }
        if (nbtTagCompound.func_74764_b("SpawnedAsBoss")) {
            this.spawnedAsBoss = nbtTagCompound.func_74767_n("SpawnedAsBoss");
        }
        super.func_70037_a(nbtTagCompound);
        this.inventory.read(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Drops")) {
            ListNBT nbtDropList = nbtTagCompound.func_150295_c("Drops", 10);
            for (int i = 0; i < nbtDropList.size(); ++i) {
                CompoundNBT dropNBT = nbtDropList.func_150305_b(i);
                ItemDrop drop = new ItemDrop(dropNBT);
                this.addSavedItemDrop(drop);
            }
        }
        if (nbtTagCompound.func_74764_b("ExtraBehaviour")) {
            this.extraMobBehaviour.read(nbtTagCompound.func_74775_l("ExtraBehaviour"));
        }
        if (nbtTagCompound.func_74764_b("HomeX") && nbtTagCompound.func_74764_b("HomeY") && nbtTagCompound.func_74764_b("HomeZ") && nbtTagCompound.func_74764_b("HomeDistanceMax")) {
            this.setHome(nbtTagCompound.func_74762_e("HomeX"), nbtTagCompound.func_74762_e("HomeY"), nbtTagCompound.func_74762_e("HomeZ"), nbtTagCompound.func_74760_g("HomeDistanceMax"));
        }
        if (nbtTagCompound.func_74764_b("ArenaX") && nbtTagCompound.func_74764_b("ArenaY") && nbtTagCompound.func_74764_b("ArenaZ")) {
            this.setArenaCenter(new BlockPos(nbtTagCompound.func_74762_e("ArenaX"), nbtTagCompound.func_74762_e("ArenaY"), nbtTagCompound.func_74762_e("ArenaZ")));
        }
        if (nbtTagCompound.func_74764_b("FixateUUIDMost") && nbtTagCompound.func_74764_b("FixateUUIDLeast")) {
            this.fixateUUID = new UUID(nbtTagCompound.func_74763_f("FixateUUIDMost"), nbtTagCompound.func_74763_f("FixateUUIDLeast"));
        }
    }

    public void func_213281_b(CompoundNBT nbtTagCompound) {
        nbtTagCompound.func_74757_a("FirstSpawn", this.firstSpawn);
        nbtTagCompound.func_74778_a("SpawnEventType", this.spawnEventType);
        nbtTagCompound.func_74768_a("SpawnEventCount", this.spawnEventCount);
        nbtTagCompound.func_74776_a("Stealth", this.getStealth());
        nbtTagCompound.func_74757_a("IsMinion", this.isMinion());
        nbtTagCompound.func_74757_a("IsTemporary", this.isTemporary);
        nbtTagCompound.func_74768_a("TemporaryDuration", this.temporaryDuration);
        nbtTagCompound.func_74757_a("IsBoundPet", this.isBoundPet());
        nbtTagCompound.func_74757_a("ForceNoDespawn", this.forceNoDespawn);
        nbtTagCompound.func_74774_a("Color", (byte)this.getColor().func_196059_a());
        nbtTagCompound.func_74774_a("Subspecies", (byte)this.getSubspeciesIndex());
        nbtTagCompound.func_74780_a("Size", this.sizeScale);
        nbtTagCompound.func_74768_a("MobLevel", this.getLevel());
        nbtTagCompound.func_74757_a("SpawnedAsBoss", this.spawnedAsBoss);
        if (this.hasHome()) {
            BlockPos homePos = this.getHomePosition();
            nbtTagCompound.func_74768_a("HomeX", homePos.func_177958_n());
            nbtTagCompound.func_74768_a("HomeY", homePos.func_177956_o());
            nbtTagCompound.func_74768_a("HomeZ", homePos.func_177952_p());
            nbtTagCompound.func_74776_a("HomeDistanceMax", this.getHomeDistanceMax());
        }
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            nbtTagCompound.func_74768_a("ArenaX", arenaPos.func_177958_n());
            nbtTagCompound.func_74768_a("ArenaY", arenaPos.func_177956_o());
            nbtTagCompound.func_74768_a("ArenaZ", arenaPos.func_177952_p());
        }
        if (this.getFixateTarget() != null) {
            nbtTagCompound.func_74772_a("FixateUUIDMost", this.getFixateTarget().func_110124_au().getMostSignificantBits());
            nbtTagCompound.func_74772_a("FixateUUIDLeast", this.getFixateTarget().func_110124_au().getLeastSignificantBits());
        }
        super.func_213281_b(nbtTagCompound);
        this.inventory.write(nbtTagCompound);
        ListNBT nbtDropList = new ListNBT();
        for (ItemDrop drop : this.savedDrops) {
            CompoundNBT dropNBT;
            if (!drop.writeToNBT(dropNBT = new CompoundNBT())) continue;
            nbtDropList.add((Object)dropNBT);
        }
        nbtTagCompound.func_218657_a("Drops", (INBT)nbtDropList);
        CompoundNBT extTagCompound = new CompoundNBT();
        this.extraMobBehaviour.write(extTagCompound);
        nbtTagCompound.func_218657_a("ExtraBehaviour", (INBT)extTagCompound);
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public boolean isAttackOnCooldown() {
        return this.getAttackCooldown() > 0;
    }

    public void triggerAttackCooldown() {
        this.attackCooldown = this.getAttackCooldownMax();
    }

    public void resetAttackCooldown() {
        this.attackCooldown = 0;
        this.setAttackCooldownMax(this.getAttackCooldownMax());
    }

    public int getAttackCooldownMax() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.attackCooldownMax;
        }
        return this.getIntFromDataManager(ANIMATION_ATTACK_COOLDOWN_MAX);
    }

    public void setAttackCooldownMax(int cooldownMax) {
        this.attackCooldownMax = cooldownMax;
        if (!this.func_130014_f_().field_72995_K) {
            this.func_184212_Q().func_187227_b(ANIMATION_ATTACK_COOLDOWN_MAX, (Object)this.attackCooldownMax);
        }
    }

    public ResourceLocation getTexture() {
        return this.getTexture("");
    }

    public ResourceLocation getTexture(String suffix) {
        String textureName = this.getTextureName();
        if (this.getSubspecies() != null) {
            if (this.getSubspecies().skin != null) {
                textureName = textureName + "_" + this.getSubspecies().skin;
            }
            if (this.getSubspecies().color != null) {
                textureName = textureName + "_" + this.getSubspecies().color;
            }
        }
        if (!"".equals(suffix)) {
            textureName = textureName + "_" + suffix;
        }
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public ResourceLocation getEquipmentTexture(String equipmentName) {
        if (!this.canEquip()) {
            return this.getTexture();
        }
        return this.getSubTexture(equipmentName);
    }

    public ResourceLocation getSubTexture(String subName) {
        subName = subName.toLowerCase();
        String textureName = this.getTextureName();
        if (AssetManager.getTexture(textureName = textureName + "_" + subName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public String getTextureName() {
        return this.creatureInfo.getName();
    }

    public boolean canBeColored(PlayerEntity player) {
        return false;
    }

    public DyeColor getColor() {
        int colorId = this.getByteFromDataManager(COLOR) & 0xF;
        return DyeColor.func_196056_a((int)colorId);
    }

    public void setColor(DyeColor color) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(COLOR, (Object)((byte)(color.func_196059_a() & 0xF)));
        }
    }

    public boolean showBossInfo() {
        if (this.forceBossHealthBar || this.isBoss() && this.isBossAlways()) {
            return true;
        }
        if (this.isRareSubspecies()) {
            return Subspecies.rareHealthBars;
        }
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        if (this.getBossInfo() != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        if (this.getBossInfo() != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    protected float func_70599_aP() {
        if (this.isBoss()) {
            return 4.0f;
        }
        if (this.isRareSubspecies()) {
            return 2.0f;
        }
        return 1.0f;
    }

    public String getSoundName() {
        String soundSuffix = "";
        if (this.getSubspecies() != null && this.getSubspecies().skin != null) {
            soundSuffix = soundSuffix + "." + this.getSubspecies().skin;
        }
        return this.creatureInfo.getName() + soundSuffix;
    }

    public int func_70627_aG() {
        return CreatureManager.getInstance().config.idleSoundTicks;
    }

    protected SoundEvent func_184639_G() {
        return ObjectManager.getSound(this.getSoundName() + "_say");
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return ObjectManager.getSound(this.getSoundName() + "_hurt");
    }

    protected SoundEvent func_184615_bR() {
        return ObjectManager.getSound(this.getSoundName() + "_death");
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        if (this.isFlying()) {
            return;
        }
        if (!this.hasStepSound) {
            super.func_180429_a(pos, block);
            return;
        }
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_step"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public void playJumpSound() {
        if (!this.hasJumpSound) {
            return;
        }
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_jump"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playFlySound() {
        if (!this.isFlying()) {
            return;
        }
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_fly"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playAttackSound() {
        if (!this.hasAttackSound) {
            return;
        }
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_attack"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playPhaseSound() {
        if (ObjectManager.getSound(this.creatureInfo.getName() + "_phase") == null) {
            return;
        }
        this.func_184185_a(ObjectManager.getSound(this.getSoundName() + "_phase"), this.func_70599_aP() * 2.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        super.func_184185_a(sound, volume, pitch);
    }

    public class GroupData
    implements ILivingEntityData {
        public boolean isChild;

        public GroupData(boolean child) {
            this.isChild = child;
        }
    }

    public static enum PET_COMMAND_ID {
        ACTIVE(0),
        TELEPORT(1),
        PVP(2),
        RELEASE(3),
        PASSIVE(4),
        DEFENSIVE(5),
        ASSIST(6),
        AGGRESSIVE(7),
        FOLLOW(8),
        WANDER(9),
        SIT(10),
        FLEE(11);

        public byte id;

        private PET_COMMAND_ID(byte i) {
            this.id = i;
        }
    }

    public static enum GUI_COMMAND {
        CLOSE(0),
        SITTING(1),
        FOLLOWING(2),
        PASSIVE(3),
        STANCE(4),
        PVP(5),
        TELEPORT(6),
        SPAWNING(7),
        RELEASE(8);

        public byte id;

        private GUI_COMMAND(byte i) {
            this.id = i;
        }
    }

    public static enum COMMAND_PIORITIES {
        OVERRIDE(0),
        IMPORTANT(1),
        EQUIPPING(2),
        ITEM_USE(3),
        EMPTY_HAND(4),
        MAIN(5);

        public final int id;

        private COMMAND_PIORITIES(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum ANIMATION_STATE_BITS {
        ATTACKED(1),
        GROUNDED(2),
        IN_WATER(4),
        BLOCKING(8),
        MINION(16),
        EXTRA01(32);

        public final byte id;

        private ANIMATION_STATE_BITS(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }

    public static enum TARGET_BITS {
        ATTACK(1),
        MASTER(2),
        PARENT(4),
        AVOID(8),
        RIDER(16),
        PICKUP(32);

        public final byte id;

        private TARGET_BITS(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

