/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.instance;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.dungeon.DungeonManager;
import com.lycanitesmobs.core.dungeon.definition.DungeonSchematic;
import com.lycanitesmobs.core.dungeon.instance.DungeonLayout;
import com.lycanitesmobs.core.dungeon.instance.SectorInstance;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class DungeonInstance {
    public UUID uuid;
    public DungeonSchematic schematic;
    public boolean complete = false;
    public int chunksBuilt = 0;
    public BlockPos originPos;
    public ChunkPos chunkMin;
    public ChunkPos chunkMax;
    public World world;
    long seed = 0L;
    public Random random;
    public DungeonLayout layout;

    public void setOrigin(BlockPos blockPos) {
        this.originPos = blockPos;
    }

    public boolean init(World world) {
        ExtendedWorld extendedWorld;
        this.world = world;
        if (this.complete) {
            return true;
        }
        if (this.world == null || this.originPos == null) {
            LycanitesMobs.logWarning("Dungeon", "Tried to initialise a dungeon with a missing world or origin. " + this);
            return false;
        }
        if (this.schematic == null) {
            ArrayList<DungeonSchematic> schematics = new ArrayList<DungeonSchematic>();
            for (DungeonSchematic schematic : DungeonManager.getInstance().schematics.values()) {
                if (!schematic.canBuild(world, this.originPos)) continue;
                schematics.add(schematic);
            }
            if (schematics.isEmpty()) {
                return false;
            }
            this.schematic = schematics.size() == 1 ? (DungeonSchematic)schematics.get(0) : (DungeonSchematic)schematics.get(this.world.field_73012_v.nextInt(schematics.size()));
        }
        if (this.seed == 0L) {
            this.seed = world.field_73012_v.nextLong();
        }
        this.random = new Random(this.seed);
        LycanitesMobs.logDebug("Dungeon", "Starting Dungeon Instance Generation For " + this);
        if (this.layout == null) {
            this.layout = new DungeonLayout(this);
            this.layout.generate(this.random);
        }
        if ((extendedWorld = ExtendedWorld.getForWorld(world)) != null) {
            extendedWorld.func_76185_a();
        }
        return true;
    }

    public boolean isChunkPosWithin(ChunkPos chunkPos, int padding) {
        if (chunkPos.field_77276_a < this.chunkMin.field_77276_a - padding || chunkPos.field_77276_a > this.chunkMax.field_77276_a + padding) {
            return false;
        }
        return chunkPos.field_77275_b >= this.chunkMin.field_77275_b - padding && chunkPos.field_77275_b <= this.chunkMax.field_77275_b + padding;
    }

    public void buildChunk(World world, ChunkPos chunkPos) {
        if (this.complete || this.layout == null || !this.layout.sectorChunkMap.containsKey(chunkPos)) {
            return;
        }
        for (SectorInstance sectorInstance : this.layout.sectorChunkMap.get(chunkPos)) {
            sectorInstance.build(world, chunkPos, world.field_73012_v);
        }
        if (++this.chunksBuilt >= this.layout.sectorChunkMap.size()) {
            this.complete = true;
        }
    }

    public void readFromNBT(CompoundNBT nbtTagCompound) {
        this.uuid = nbtTagCompound.func_186857_a("Id");
        this.schematic = DungeonManager.getInstance().getSchematic(nbtTagCompound.func_74779_i("Schematic"));
        this.seed = nbtTagCompound.func_74763_f("Seed");
        this.complete = nbtTagCompound.func_74767_n("Complete");
        this.chunksBuilt = nbtTagCompound.func_74762_e("ChunksBuilt");
        if (this.schematic == null) {
            this.complete = true;
        }
        int[] originPos = nbtTagCompound.func_74759_k("OriginPos");
        this.originPos = new BlockPos(originPos[0], originPos[1], originPos[2]);
        int[] chunkMin = nbtTagCompound.func_74759_k("ChunkMin");
        this.chunkMin = new ChunkPos(chunkMin[0], chunkMin[1]);
        int[] chunkMax = nbtTagCompound.func_74759_k("ChunkMax");
        this.chunkMax = new ChunkPos(chunkMax[0], chunkMax[1]);
        LycanitesMobs.logDebug("Dungeon", "Loaded Dungeon Instance from NBT: " + this);
    }

    public CompoundNBT writeToNBT(CompoundNBT nbtTagCompound) {
        if (this.uuid == null) {
            return null;
        }
        nbtTagCompound.func_186854_a("Id", this.uuid);
        nbtTagCompound.func_74778_a("Schematic", this.schematic.name);
        nbtTagCompound.func_74772_a("Seed", this.seed);
        nbtTagCompound.func_74757_a("Complete", this.complete);
        nbtTagCompound.func_74768_a("ChunksBuilt", this.chunksBuilt);
        nbtTagCompound.func_74783_a("OriginPos", new int[]{this.originPos.func_177958_n(), this.originPos.func_177956_o(), this.originPos.func_177952_p()});
        nbtTagCompound.func_74783_a("ChunkMin", new int[]{this.chunkMin.field_77275_b, this.chunkMin.field_77275_b});
        nbtTagCompound.func_74783_a("ChunkMax", new int[]{this.chunkMax.field_77275_b, this.chunkMax.field_77275_b});
        LycanitesMobs.logDebug("Dungeon", "Saved Dungeon Instance to NBT: " + this);
        return nbtTagCompound;
    }

    public String toString() {
        String schematic = "";
        if (this.schematic != null) {
            schematic = " - Schematic: " + this.schematic.name;
        }
        return "Dungeon Instance" + schematic + " - Origin: " + this.originPos + " - Complete: " + this.complete + " - Seed: " + this.seed + " - ID: " + this.uuid;
    }
}

