/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.config;

import com.lycanitesmobs.core.config.CoreConfig;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCreatures {
    public static ConfigCreatures INSTANCE;
    public Map<String, Map<String, ForgeConfigSpec.ConfigValue<Double>>> difficultyMultipliers = new HashMap<String, Map<String, ForgeConfigSpec.ConfigValue<Double>>>();
    public Map<String, ForgeConfigSpec.ConfigValue<Double>> levelMultipliers = new HashMap<String, ForgeConfigSpec.ConfigValue<Double>>();
    public final ForgeConfigSpec.ConfigValue<Boolean> subspeciesTags;
    public final ForgeConfigSpec.ConfigValue<Integer> idleSoundTicks;
    public final ForgeConfigSpec.ConfigValue<Boolean> disableModelAlpha;
    public final ForgeConfigSpec.ConfigValue<Integer> startingLevelMin;
    public final ForgeConfigSpec.ConfigValue<Integer> startingLevelMax;
    public final ForgeConfigSpec.ConfigValue<Double> levelPerDay;
    public final ForgeConfigSpec.ConfigValue<Integer> levelPerDayMax;
    public final ForgeConfigSpec.ConfigValue<Double> levelPerLocalDifficulty;
    public final ForgeConfigSpec.ConfigValue<Boolean> ownerTags;
    public final ForgeConfigSpec.ConfigValue<Boolean> tamingEnabled;
    public final ForgeConfigSpec.ConfigValue<Boolean> mountingEnabled;
    public final ForgeConfigSpec.ConfigValue<Boolean> mountingFlightEnabled;
    public final ForgeConfigSpec.ConfigValue<Boolean> friendlyFire;
    public final ForgeConfigSpec.ConfigValue<Double> beastiaryAddOnDeathChance;
    public final ForgeConfigSpec.ConfigValue<Boolean> beastiaryKnowledgeMessages;
    public final ForgeConfigSpec.ConfigValue<Double> bossAntiFlight;
    public final ForgeConfigSpec.ConfigValue<Boolean> predatorsAttackAnimals;
    public final ForgeConfigSpec.ConfigValue<Boolean> mobsAttackVillagers;
    public final ForgeConfigSpec.ConfigValue<Boolean> animalsFightBack;
    public final ForgeConfigSpec.ConfigValue<Boolean> elementalFusion;
    public final ForgeConfigSpec.ConfigValue<String> elementalFusionLevelMix;
    public final ForgeConfigSpec.ConfigValue<Double> elementalFusionLevelMultiplier;
    public final ForgeConfigSpec.ConfigValue<Boolean> disablePickupOffsets;
    public final ForgeConfigSpec.ConfigValue<Boolean> suffocationImmunity;
    public final ForgeConfigSpec.ConfigValue<Boolean> drownImmunity;
    public final ForgeConfigSpec.ConfigValue<Boolean> subspeciesSpawn;
    public final ForgeConfigSpec.ConfigValue<Boolean> randomSizes;
    public final ForgeConfigSpec.ConfigValue<Double> randomSizeMin;
    public final ForgeConfigSpec.ConfigValue<Double> randomSizeMax;

    public ConfigCreatures(ForgeConfigSpec.Builder builder) {
        builder.push("Creatures");
        builder.comment("Global creature settings.");
        this.subspeciesTags = builder.comment("If true, all mobs that are a subspecies will always show their nametag.").translation(CoreConfig.CONFIG_PREFIX + "creatures.subspeciesTags").define("subspeciesTags", true);
        this.idleSoundTicks = builder.comment("The minimum interval in ticks between random idle sounds.").translation(CoreConfig.CONFIG_PREFIX + "creatures.idleSoundTicks").define("idleSoundTicks", (Object)100);
        this.disableModelAlpha = builder.comment("If true, alpha is disabled on mob textures, this can make them look undesirable but can increase performance on low end systems.").translation(CoreConfig.CONFIG_PREFIX + "creatures.disableModelAlpha").define("disableModelAlpha", false);
        this.startingLevelMin = builder.comment("The minimum base starting level of every mob. Cannot be less than 1.").translation(CoreConfig.CONFIG_PREFIX + "creatures.startingLevelMin").define("startingLevelMin", (Object)1);
        this.startingLevelMax = builder.comment("The maximum base starting level of every mob. Ignored when not greater than the min level.").translation(CoreConfig.CONFIG_PREFIX + "creatures.startingLevelMax").define("startingLevelMax", (Object)1);
        this.levelPerDay = builder.comment("Increases the base start level by this amount of every world day that has gone by, use this to slowly level up mobs as the world gets older. Fractions can be used such as 0.05 levels per day. The levels are rounded down so +0.9 would be +0 levels.").translation(CoreConfig.CONFIG_PREFIX + "creatures.levelPerDay").define("levelPerDay", (Object)0.0);
        this.levelPerDayMax = builder.comment("The maximum level to be able gain from levels per day.").translation(CoreConfig.CONFIG_PREFIX + "creatures.levelPerDayMax").define("levelPerDayMax", (Object)100);
        this.levelPerLocalDifficulty = builder.comment("How many levels a mob gains multiplied by the local area difficulty level. Staying in an area for a while slowly increases the difficulty of that area ranging from 0.00 to 6.75. So 1.5 means level 10 at full local area difficulty.").translation(CoreConfig.CONFIG_PREFIX + "creatures.levelPerLocalDifficulty").define("levelPerLocalDifficulty", (Object)1.5);
        this.ownerTags = builder.comment("If true, tamed mobs will display their owner's name in their name tag.").translation(CoreConfig.CONFIG_PREFIX + "creatures.ownerTags").define("ownerTags", true);
        this.tamingEnabled = builder.comment("Set to false to disable pet/mount taming.").translation(CoreConfig.CONFIG_PREFIX + "creatures.tamingEnabled").define("tamingEnabled", true);
        this.mountingEnabled = builder.comment("Set to false to disable mounts.").translation(CoreConfig.CONFIG_PREFIX + "creatures.mountingEnabled").define("mountingEnabled", true);
        this.mountingFlightEnabled = builder.comment("Set to false to disable flying mounts, if all mounts are disable this option doesn't matter.").translation(CoreConfig.CONFIG_PREFIX + "creatures.mountingFlightEnabled").define("mountingFlightEnabled", true);
        this.friendlyFire = builder.comment("If true, pets, minions, etc can't harm their owners (with ranged attacks, etc).").translation(CoreConfig.CONFIG_PREFIX + "creatures.friendlyFire").define("friendlyFire", true);
        this.beastiaryAddOnDeathChance = builder.comment("The chance that creatures are added to the player's Beastiary when killed, the Soulgazer can also be used to add creatures. Bosses are always a 100% chance.").translation(CoreConfig.CONFIG_PREFIX + "creatures.beastiaryAddOnDeathChance").define("beastiaryAddOnDeathChance", (Object)0.15);
        this.beastiaryKnowledgeMessages = builder.comment("If true, a chat message will be displayed when gaining Beastiary Knowledge.").translation(CoreConfig.CONFIG_PREFIX + "creatures.beastiaryKnowledgeMessages").define("beastiaryKnowledgeMessages", true);
        this.bossAntiFlight = builder.comment("How much higher players must be relative to a boss' y position (feet) to trigger anti flight measures.").translation(CoreConfig.CONFIG_PREFIX + "creatures.bossAntiFlight").define("bossAntiFlight", (Object)3.0);
        this.predatorsAttackAnimals = builder.comment("Set to false to prevent predator mobs from attacking animals/farmable mobs.").translation(CoreConfig.CONFIG_PREFIX + "creatures.predatorsAttackAnimals").define("predatorsAttackAnimals", true);
        this.mobsAttackVillagers = builder.comment("Set to false to prevent mobs that attack players from also attacking villagers.").translation(CoreConfig.CONFIG_PREFIX + "creatures.mobsAttackVillagers").define("mobsAttackVillagers", true);
        this.animalsFightBack = builder.comment("If true, passive mobs will fight back when hit instead of running away.").translation(CoreConfig.CONFIG_PREFIX + "creatures.animalsFightBack").define("animalsFightBack", false);
        this.elementalFusion = builder.comment("If true, some elemental mobs will fuse with each other on sight into a stronger different elemental.").translation(CoreConfig.CONFIG_PREFIX + "creatures.elementalFusion").define("elementalFusion", true);
        this.elementalFusionLevelMix = builder.comment("Controls how fused mobs combine their levels. Can be 'both' (default) where both levels are added together, 'highest' where the higher level is used and 'lowest' where the lowest level is used.").translation(CoreConfig.CONFIG_PREFIX + "creatures.elementalFusionLevelMix").define("elementalFusionLevelMix", (Object)"both");
        this.elementalFusionLevelMultiplier = builder.comment("The level of a mob created via fusion is multiplied by this value, set to 1 for no changes. Tamed fusions aren't multiplied by this value.").translation(CoreConfig.CONFIG_PREFIX + "creatures.elementalFusionLevelMultiplier").define("elementalFusionLevelMultiplier", (Object)10.0);
        this.disablePickupOffsets = builder.comment("If true, when a mob picks up a player, the player will be positioned where the mob is rather than offset to where the mob is holding the player at.").translation(CoreConfig.CONFIG_PREFIX + "creatures.disablePickupOffsets").define("disablePickupOffsets", false);
        this.suffocationImmunity = builder.comment("If true, all mobs will be immune to suffocation (inWall) damage.").translation(CoreConfig.CONFIG_PREFIX + "creatures.suffocationImmunity").define("suffocationImmunity", false);
        this.drownImmunity = builder.comment("If true, all mobs will be immune to damage from running out of air (drown damage).").translation(CoreConfig.CONFIG_PREFIX + "creatures.drownImmunity").define("drownImmunity", false);
        this.subspeciesSpawn = builder.comment("Set to false to prevent subspecies from spawning, this will not affect mobs that have already spawned as subspecies.").translation(CoreConfig.CONFIG_PREFIX + "creatures.subspeciesSpawn").define("subspeciesSpawn", true);
        this.randomSizes = builder.comment("Set to false to prevent mobs from having a random size variation when spawning, this will not affect mobs that have already spawned.").translation(CoreConfig.CONFIG_PREFIX + "creatures.randomSizes").define("randomSizes", true);
        this.randomSizeMin = builder.comment("The minimum size scale mobs can randomly spawn at.").translation(CoreConfig.CONFIG_PREFIX + "creatures.randomSizeMin").define("randomSizeMin", (Object)0.85);
        this.randomSizeMax = builder.comment("The maximum size scale mobs can randomly spawn at.").translation(CoreConfig.CONFIG_PREFIX + "creatures.randomSizeMax").define("randomSizeMax", (Object)1.15);
        int difficultyIndex = 0;
        for (String difficultyName : CreatureManager.DIFFICULTY_NAMES) {
            HashMap<String, ForgeConfigSpec.ConfigValue> statMultipliers = new HashMap<String, ForgeConfigSpec.ConfigValue>();
            for (String statName : CreatureStats.STAT_NAMES) {
                double defaultValue = CreatureManager.DIFFICULTY_DEFAULTS[difficultyIndex];
                if ("easy".equalsIgnoreCase(difficultyName) && "speed".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                if ("hard".equalsIgnoreCase(difficultyName) && ("attackSpeed".equalsIgnoreCase(statName) || "rangedSpeed".equalsIgnoreCase(statName))) {
                    defaultValue = 1.5;
                }
                if ("armor".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                if ("sight".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                statMultipliers.put(statName, builder.comment("Stat multiplier for " + statName + " on " + difficultyName + " difficulty.").translation(CoreConfig.CONFIG_PREFIX + "difficulty.multipliers." + difficultyName + "." + statName).define("difficulty.multipliers." + difficultyName + "." + statName, (Object)defaultValue));
            }
            this.difficultyMultipliers.put(difficultyName, statMultipliers);
            ++difficultyIndex;
        }
        for (String statName : CreatureStats.STAT_NAMES) {
            double levelValue = 0.01;
            if ("health".equalsIgnoreCase(statName)) {
                levelValue = 0.1;
            }
            if ("defense".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("armor".equalsIgnoreCase(statName)) {
                levelValue = 0.0;
            }
            if ("speed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("damage".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("attackSpeed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("rangedSpeed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("effect".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("pierce".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("sight".equalsIgnoreCase(statName)) {
                levelValue = 0.0;
            }
            this.levelMultipliers.put(statName, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Level multiplier for " + statName + ".").translation(CoreConfig.CONFIG_PREFIX + "level.multipliers." + statName).define("level.multipliers." + statName, (Object)levelValue));
        }
        builder.pop();
    }
}

