/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.config;

import com.lycanitesmobs.core.config.CoreConfig;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.Subspecies;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCreatureSubspecies {
    public static ConfigCreatureSubspecies INSTANCE;
    public final ForgeConfigSpec.ConfigValue<Integer> baseWeight;
    public Map<String, ForgeConfigSpec.ConfigValue<Integer>> commonWeights = new HashMap<String, ForgeConfigSpec.ConfigValue<Integer>>();
    public Map<String, Map<String, ForgeConfigSpec.ConfigValue<Double>>> subspeciesMultipliers = new HashMap<String, Map<String, ForgeConfigSpec.ConfigValue<Double>>>();
    public final ForgeConfigSpec.ConfigValue<Integer> uncommonDropScale;
    public final ForgeConfigSpec.ConfigValue<Integer> rareDropScale;
    public final ForgeConfigSpec.ConfigValue<Double> uncommonExperienceScale;
    public final ForgeConfigSpec.ConfigValue<Double> rareExperienceScale;
    public final ForgeConfigSpec.ConfigValue<Integer> uncommonSpawnDayMin;
    public final ForgeConfigSpec.ConfigValue<Integer> rareSpawnDayMin;
    public final ForgeConfigSpec.ConfigValue<Boolean> rareHealthBars;

    public ConfigCreatureSubspecies(ForgeConfigSpec.Builder builder) {
        builder.push("Creature Subspecies");
        builder.comment("Global creature subspecies settings.");
        this.baseWeight = builder.comment("The minimum base starting level of every mob. Cannot be less than 1.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.baseWeight").define("baseWeight", (Object)400);
        for (String subspeciesName : Subspecies.SUBSPECIES_NAMES) {
            this.commonWeights.put(subspeciesName, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Subspecies weight for " + subspeciesName + ".").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.weights." + subspeciesName).define("weights." + subspeciesName, (Object)Subspecies.COMMON_WEIGHTS.get(subspeciesName)));
        }
        for (String subspeciesName : Subspecies.SUBSPECIES_NAMES) {
            HashMap<String, ForgeConfigSpec.ConfigValue> statMultipliers = new HashMap<String, ForgeConfigSpec.ConfigValue>();
            for (String statName : CreatureStats.STAT_NAMES) {
                double defaultValue = 1.0;
                if ("uncommon".equals(subspeciesName) && "health".equals(statName)) {
                    defaultValue = 2.0;
                }
                if ("rare".equals(subspeciesName)) {
                    if ("health".equals(statName)) {
                        defaultValue = 20.0;
                    } else if ("attackSpeed".equals(statName)) {
                        defaultValue = 2.0;
                    } else if ("rangedSpeed".equals(statName)) {
                        defaultValue = 2.0;
                    } else if ("effect".equals(statName)) {
                        defaultValue = 2.0;
                    }
                }
                statMultipliers.put(statName, builder.comment("Stat multiplier for " + statName + " for " + subspeciesName + " subspecies.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.multipliers." + subspeciesName + "." + statName).define("multipliers." + subspeciesName + "." + statName, (Object)defaultValue));
            }
            this.subspeciesMultipliers.put(subspeciesName, statMultipliers);
        }
        this.uncommonDropScale = builder.comment("When a creature with the uncommon subspecies (Azure, Verdant, etc) dies, its item drops amount is multiplied by this value.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.uncommonDropScale").define("uncommonDropScale", (Object)2);
        this.rareDropScale = builder.comment("When a creature with the rare subspecies (Celestial, Lunar, etc) dies, its item drops amount is multiplied by this value.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.rareDropScale").define("rareDropScale", (Object)5);
        this.uncommonExperienceScale = builder.comment("When a creature with the uncommon subspecies (Azure, Verdant, etc) dies, its experience amount is multiplied by this value.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.uncommonExperienceScale").define("uncommonExperienceScale", (Object)2.0);
        this.rareExperienceScale = builder.comment("When a creature with the rare subspecies (Celestial, Lunar, etc) dies, its experience amount is multiplied by this value.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.rareExperienceScale").define("rareExperienceScale", (Object)10.0);
        this.uncommonSpawnDayMin = builder.comment("The minimum amount of days before uncommon species start to spawn.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.uncommonSpawnDayMin").define("uncommonSpawnDayMin", (Object)0);
        this.rareSpawnDayMin = builder.comment("The minimum amount of days before rare species start to spawn.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.rareSpawnDayMin").define("rareSpawnDayMin", (Object)0);
        this.rareHealthBars = builder.comment("If set to true, rare subspecies such as the Lunar Grue or Celestial Geonach will display boss health bars.").translation(CoreConfig.CONFIG_PREFIX + "creature.subspecies.rareHealthBars").define("rareHealthBars", false);
        builder.pop();
    }
}

