/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.Effects;
import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.GameEventListener;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.capabilities.ExtendedEntityStorage;
import com.lycanitesmobs.core.capabilities.ExtendedPlayerStorage;
import com.lycanitesmobs.core.capabilities.IExtendedEntity;
import com.lycanitesmobs.core.capabilities.IExtendedPlayer;
import com.lycanitesmobs.core.config.ConfigDebug;
import com.lycanitesmobs.core.config.CoreConfig;
import com.lycanitesmobs.core.info.AltarInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.consumable.ItemHalloweenTreat;
import com.lycanitesmobs.core.item.consumable.ItemWinterGift;
import com.lycanitesmobs.core.item.equipment.EquipmentPartManager;
import com.lycanitesmobs.core.mobevent.MobEventListener;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mods.DLDungeons;
import com.lycanitesmobs.core.network.PacketHandler;
import com.lycanitesmobs.core.spawner.SpawnerEventListener;
import com.lycanitesmobs.core.spawner.SpawnerManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lycanitesmobs")
public class LycanitesMobs {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "lycanitesmobs";
    public static final String name = "Lycanites Mobs";
    public static final String versionNumber = "2.1.0.0";
    public static final String versionMC = "1.14.2";
    public static final String version = "2.1.0.0 - MC 1.14.2";
    public static final String website = "http://lycanitesmobs.com";
    public static final String websiteAPI = "http://api.lycanitesmobs.com";
    public static final String websitePatreon = "https://www.patreon.com/lycanite";
    public static final PacketHandler packetHandler = new PacketHandler();
    public static ModInfo modInfo;
    public static boolean configReady;
    public static boolean earlyDebug;
    @CapabilityInject(value=IExtendedEntity.class)
    public static final Capability<IExtendedEntity> EXTENDED_ENTITY;
    @CapabilityInject(value=IExtendedPlayer.class)
    public static final Capability<IExtendedPlayer> EXTENDED_PLAYER;
    public static String texturePath;
    public static Effects EFFECTS;

    public LycanitesMobs() {
        modInfo = new ModInfo(this, name, 1000);
        FileLoader.initAll(LycanitesMobs.modInfo.modid);
        StreamLoader.initAll(LycanitesMobs.modInfo.modid);
        CoreConfig.buildSpec();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CoreConfig.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverStarting);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)ObjectManager.getInstance());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)CreatureManager.getInstance());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)ProjectileManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new GameEventListener());
        MinecraftForge.EVENT_BUS.register((Object)SpawnerEventListener.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)MobEventManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)MobEventListener.getInstance());
        packetHandler.register();
        this.loadContent();
    }

    public void loadContent() {
        ItemManager.getInstance().loadItems();
        EquipmentPartManager.getInstance().loadAllFromJSON(modInfo);
        ObjectLists.createCustomItems();
        ObjectLists.createLists();
        EFFECTS = new Effects();
        ElementManager.getInstance().loadAllFromJSON(modInfo);
        CreatureManager.getInstance().startup(modInfo);
        ProjectileManager.getInstance().startup(modInfo);
        SpawnerManager.getInstance().loadAllFromJSON();
        AltarInfo.createAltars();
        MobEventManager.getInstance().loadAllFromJSON(modInfo);
        ItemHalloweenTreat.createObjectLists();
        ItemWinterGift.createObjectLists();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        configReady = true;
        ObjectManager.setCurrentModInfo(modInfo);
        this.loadConfigs();
        CapabilityManager.INSTANCE.register(IExtendedPlayer.class, (Capability.IStorage)new ExtendedPlayerStorage(), ExtendedPlayer::new);
        CapabilityManager.INSTANCE.register(IExtendedEntity.class, (Capability.IStorage)new ExtendedEntityStorage(), ExtendedEntity::new);
        DLDungeons.init();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)ClientManager.getInstance());
        ClientManager.getInstance().initLanguageManager();
        ClientManager.getInstance().registerGUIs();
        ClientManager.getInstance().registerEvents();
        ClientManager.getInstance().registerTextures();
        ClientManager.getInstance().initRenderRegister();
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
    }

    public void loadConfigs() {
        ItemManager.getInstance().loadConfig();
        CreatureManager.getInstance().loadConfig();
        MobEventManager.getInstance().loadConfig();
        AltarInfo.loadGlobalSettings();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public static void logInfo(String key, String message) {
        if ("".equals(key) || !configReady && earlyDebug || ConfigDebug.INSTANCE.isEnabled(key.toLowerCase())) {
            LOGGER.info("[LycanitesMobs] [Info] [" + key + "] " + message);
        }
    }

    public static void logDebug(String key, String message) {
        if ("".equals(key) || !configReady && earlyDebug || ConfigDebug.INSTANCE.isEnabled(key.toLowerCase())) {
            LOGGER.debug("[LycanitesMobs] [Debug] [" + key + "] " + message);
        }
    }

    public static void logWarning(String key, String message) {
        if ("".equals(key) || !configReady && earlyDebug || ConfigDebug.INSTANCE.isEnabled(key.toLowerCase())) {
            LOGGER.warn("[LycanitesMobs] [WARNING] [" + key + "] " + message);
        }
    }

    public static void logError(String message) {
        LOGGER.error("[LycanitesMobs] " + message);
    }

    static {
        configReady = false;
        earlyDebug = false;
        EXTENDED_ENTITY = null;
        EXTENDED_PLAYER = null;
        texturePath = "mods/lycanitesmobs/";
        FluidRegistry.enableUniversalBucket();
    }
}

