/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.dungeon.instance.DungeonInstance;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerClient;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.network.MessageMobEvent;
import com.lycanitesmobs.core.network.MessageWorldEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class ExtendedWorld
extends WorldSavedData {
    public static String EXT_PROP_NAME = "LycanitesMobs";
    public static Map<World, ExtendedWorld> loadedExtWorlds = new HashMap<World, ExtendedWorld>();
    public World world;
    public boolean initialized = false;
    public long lastSpawnerTime = 0L;
    public long lastEventScheduleTime = 0L;
    public long lastEventUpdateTime = 0L;
    public boolean useTotalWorldTime = true;
    public Map<String, MobEventPlayerServer> serverMobEventPlayers = new HashMap<String, MobEventPlayerServer>();
    public Map<String, MobEventPlayerClient> clientMobEventPlayers = new HashMap<String, MobEventPlayerClient>();
    public MobEventPlayerServer serverWorldEventPlayer = null;
    public MobEventPlayerClient clientWorldEventPlayer = null;
    private long worldEventStartTargetTime = 0L;
    private long worldEventLastStartedTime = 0L;
    private String worldEventName = "";
    private int worldEventCount = -1;
    public Map<UUID, DungeonInstance> dungeons = new HashMap<UUID, DungeonInstance>();

    public static ExtendedWorld getForWorld(World world) {
        ExtendedWorld worldExt;
        if (world == null) {
            return null;
        }
        if (loadedExtWorlds.containsKey(world)) {
            ExtendedWorld worldExt2 = loadedExtWorlds.get(world);
            return worldExt2;
        }
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            world.increaseMaxEntityRadius(50.0);
            ExtendedWorld worldSavedData = (ExtendedWorld)serverWorld.func_217481_x().func_215753_b(ExtendedWorld::new, EXT_PROP_NAME);
            if (worldSavedData != null) {
                worldExt = worldSavedData;
                worldExt.world = world;
                worldExt.init();
            } else {
                worldExt = new ExtendedWorld(world);
                serverWorld.func_217481_x().func_215757_a((WorldSavedData)worldExt);
            }
        } else {
            worldExt = new ExtendedWorld(world);
            worldExt.init();
        }
        loadedExtWorlds.put(world, worldExt);
        return worldExt;
    }

    public ExtendedWorld() {
        super(EXT_PROP_NAME);
    }

    public ExtendedWorld(World world) {
        super(EXT_PROP_NAME);
        this.world = world;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.lastSpawnerTime = this.world.func_82737_E() - 1L;
        this.lastEventScheduleTime = this.world.func_82737_E() - 1L;
        this.lastEventUpdateTime = this.world.func_82737_E() - 1L;
        if (!this.world.field_72995_K && !"".equals(this.getWorldEventName()) && this.serverWorldEventPlayer == null) {
            long savedLastStartedTime = this.getWorldEventLastStartedTime();
            this.startMobEvent(this.getWorldEventName(), null, new BlockPos(0, 0, 0), 1);
            if (this.serverWorldEventPlayer != null) {
                this.serverWorldEventPlayer.changeStartedWorldTime(savedLastStartedTime);
            }
        }
    }

    public long getWorldEventStartTargetTime() {
        return this.worldEventStartTargetTime;
    }

    public long getWorldEventLastStartedTime() {
        return this.worldEventLastStartedTime;
    }

    public String getWorldEventName() {
        return this.worldEventName;
    }

    public MobEvent getWorldEvent() {
        if (this.getWorldEventName() == null || "".equals(this.getWorldEventName())) {
            return null;
        }
        return MobEventManager.getInstance().getMobEvent(this.getWorldEventName());
    }

    public int getWorldEventCount() {
        return this.worldEventCount;
    }

    public void setWorldEventStartTargetTime(long setLong) {
        if (this.worldEventStartTargetTime != setLong) {
            this.func_76185_a();
        }
        this.worldEventStartTargetTime = setLong;
        if (setLong > 0L) {
            LycanitesMobs.logDebug("MobEvents", "Next random mob will start after " + (this.worldEventStartTargetTime - this.world.func_82737_E()) / 20L + "secs.");
        }
    }

    public void setWorldEventLastStartedTime(long setLong) {
        if (this.worldEventLastStartedTime != setLong) {
            this.func_76185_a();
        }
        this.worldEventLastStartedTime = setLong;
    }

    public void setWorldEventName(String setString) {
        if (!this.worldEventName.equals(setString)) {
            this.func_76185_a();
        }
        this.worldEventName = setString;
    }

    public void increaseMobEventCount() {
        ++this.worldEventCount;
    }

    public int getRandomEventDelay(Random random) {
        int min = Math.max(200, MobEventManager.getInstance().minTicksUntilEvent);
        int max = Math.max(200, MobEventManager.getInstance().maxTicksUntilEvent);
        if (max <= min) {
            return min;
        }
        return min + random.nextInt(max - min);
    }

    public void startWorldEvent(MobEvent mobEvent) {
        boolean extended;
        if (mobEvent == null) {
            LycanitesMobs.logWarning("", "Tried to start a null world event, stopping any event instead.");
            this.stopWorldEvent();
            return;
        }
        if (!this.world.field_72995_K) {
            extended = false;
            if (this.serverWorldEventPlayer != null) {
                boolean bl = extended = this.serverWorldEventPlayer.mobEvent == mobEvent;
            }
            if (!extended) {
                this.serverWorldEventPlayer = mobEvent.getServerEventPlayer(this.world);
            }
            this.serverWorldEventPlayer.extended = extended;
            this.setWorldEventName(mobEvent.name);
            this.increaseMobEventCount();
            this.setWorldEventStartTargetTime(0L);
            this.setWorldEventLastStartedTime(this.world.func_82737_E());
            this.serverWorldEventPlayer.onStart();
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K) {
            extended = false;
            if (this.clientWorldEventPlayer != null) {
                boolean bl = extended = this.clientWorldEventPlayer.mobEvent == mobEvent;
            }
            if (!extended) {
                this.clientWorldEventPlayer = mobEvent.getClientEventPlayer(this.world);
            }
            this.clientWorldEventPlayer.extended = extended;
            if (ClientManager.getInstance().getClientPlayer() != null) {
                this.clientWorldEventPlayer.onStart(ClientManager.getInstance().getClientPlayer());
            }
        }
    }

    public void stopWorldEvent() {
        if (this.serverWorldEventPlayer != null) {
            this.serverWorldEventPlayer.onFinish();
            this.setWorldEventName("");
            this.serverWorldEventPlayer = null;
            this.updateAllClientsEvents();
        }
        if (this.clientWorldEventPlayer != null) {
            if (ClientManager.getInstance().getClientPlayer() != null) {
                this.clientWorldEventPlayer.onFinish(ClientManager.getInstance().getClientPlayer());
            }
            this.clientWorldEventPlayer = null;
        }
    }

    public void startMobEvent(MobEvent mobEvent, PlayerEntity player, BlockPos pos, int level) {
        if (mobEvent == null) {
            LycanitesMobs.logWarning("", "Tried to start a null mob event.");
            return;
        }
        if (!this.world.field_72995_K) {
            MobEventPlayerServer mobEventPlayerServer = mobEvent.getServerEventPlayer(this.world);
            this.serverMobEventPlayers.put(mobEvent.name, mobEventPlayerServer);
            mobEventPlayerServer.player = player;
            mobEventPlayerServer.origin = pos;
            mobEventPlayerServer.level = level;
            mobEventPlayerServer.onStart();
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K) {
            MobEventPlayerClient mobEventPlayerClient;
            if (this.clientMobEventPlayers.containsKey(mobEvent.name)) {
                mobEventPlayerClient = this.clientMobEventPlayers.get(mobEvent.name);
            } else {
                mobEventPlayerClient = mobEvent.getClientEventPlayer(this.world);
                this.clientMobEventPlayers.put(mobEvent.name, mobEventPlayerClient);
            }
            if (ClientManager.getInstance().getClientPlayer() != null) {
                mobEventPlayerClient.onStart(ClientManager.getInstance().getClientPlayer());
            }
        }
    }

    public MobEvent startMobEvent(String mobEventName, PlayerEntity player, BlockPos pos, int level) {
        MobEvent mobEvent;
        if (MobEventManager.getInstance().mobEvents.containsKey(mobEventName)) {
            mobEvent = MobEventManager.getInstance().mobEvents.get(mobEventName);
            if (!mobEvent.isEnabled()) {
                LycanitesMobs.logWarning("", "Tried to start a mob event that was disabled with the name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
                return null;
            }
        } else {
            LycanitesMobs.logWarning("", "Tried to start a mob event with the invalid name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
            return null;
        }
        mobEvent.trigger(this.world, player, pos, level);
        return mobEvent;
    }

    public void stopMobEvent(String mobEventName) {
        if (!this.world.field_72995_K && this.serverMobEventPlayers.containsKey(mobEventName)) {
            this.serverMobEventPlayers.get(mobEventName).onFinish();
            this.serverMobEventPlayers.remove(mobEventName);
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K && this.clientMobEventPlayers.containsKey(mobEventName)) {
            if (ClientManager.getInstance().getClientPlayer() != null) {
                this.clientMobEventPlayers.get(mobEventName).onFinish(ClientManager.getInstance().getClientPlayer());
            }
            this.clientMobEventPlayers.remove(mobEventName);
        }
    }

    public MobEventPlayerServer getMobEventPlayerServer(String mobEventName) {
        if (mobEventName == null || "".equals(mobEventName)) {
            return null;
        }
        if (mobEventName.equals(this.getWorldEventName())) {
            return this.serverWorldEventPlayer;
        }
        if (this.serverMobEventPlayers.containsKey(mobEventName)) {
            return this.serverMobEventPlayers.get(mobEventName);
        }
        return null;
    }

    public MobEventPlayerClient getMobEventPlayerClient(String mobEventName) {
        if (mobEventName == null || "".equals(mobEventName)) {
            return null;
        }
        if (mobEventName.equals(this.worldEventName)) {
            return this.clientWorldEventPlayer;
        }
        if (this.clientMobEventPlayers.containsKey(mobEventName)) {
            return this.clientMobEventPlayers.get(mobEventName);
        }
        return null;
    }

    public void updateAllClientsEvents() {
        BlockPos pos = this.serverWorldEventPlayer != null ? this.serverWorldEventPlayer.origin : new BlockPos(0, 0, 0);
        int level = this.serverWorldEventPlayer != null ? this.serverWorldEventPlayer.level : 0;
        MessageWorldEvent message = new MessageWorldEvent(this.getWorldEventName(), pos, level);
        LycanitesMobs.packetHandler.sendToWorld(message, this.world);
        for (MobEventPlayerServer mobEventPlayerServer : this.serverMobEventPlayers.values()) {
            MessageMobEvent messageMobEvent = new MessageMobEvent(mobEventPlayerServer.mobEvent != null ? mobEventPlayerServer.mobEvent.name : "", mobEventPlayerServer.origin, mobEventPlayerServer.level);
            LycanitesMobs.packetHandler.sendToWorld(messageMobEvent, this.world);
        }
    }

    public void addDungeonInstance(DungeonInstance dungeonInstance, UUID uuid) {
        dungeonInstance.uuid = uuid;
        this.dungeons.put(dungeonInstance.uuid, dungeonInstance);
        this.func_76185_a();
    }

    public List<DungeonInstance> getNearbyDungeonInstances(ChunkPos chunkPos, int range) {
        ArrayList<DungeonInstance> nearbyDungeons = new ArrayList<DungeonInstance>();
        for (DungeonInstance dungeonInstance : this.dungeons.values()) {
            if (dungeonInstance.world == null) {
                dungeonInstance.init(this.world);
            }
            if (!dungeonInstance.isChunkPosWithin(chunkPos, range)) continue;
            nearbyDungeons.add(dungeonInstance);
        }
        return nearbyDungeons;
    }

    public void func_76184_a(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("WorldEventStartTargetTime")) {
            this.worldEventStartTargetTime = nbtTagCompound.func_74762_e("WorldEventStartTargetTime");
        }
        if (nbtTagCompound.func_74764_b("WorldEventLastStartedTime")) {
            this.worldEventLastStartedTime = nbtTagCompound.func_74762_e("WorldEventLastStartedTime");
        }
        if (nbtTagCompound.func_74764_b("WorldEventName")) {
            this.worldEventName = nbtTagCompound.func_74779_i("WorldEventName");
        }
        if (nbtTagCompound.func_74764_b("WorldEventCount")) {
            this.worldEventCount = nbtTagCompound.func_74762_e("WorldEventCount");
        }
        if (nbtTagCompound.func_74764_b("Dungeons")) {
            ListNBT nbtDungeonList = nbtTagCompound.func_150295_c("Dungeons", 10);
            for (int i = 0; i < nbtDungeonList.size(); ++i) {
                try {
                    CompoundNBT dungeonNBT = nbtDungeonList.func_150305_b(i);
                    DungeonInstance dungeonInstance = new DungeonInstance();
                    dungeonInstance.readFromNBT(dungeonNBT);
                    if (dungeonInstance.uuid == null || this.dungeons.containsKey(dungeonInstance.uuid)) continue;
                    this.dungeons.put(dungeonInstance.uuid, dungeonInstance);
                    continue;
                }
                catch (Exception e) {
                    LycanitesMobs.logWarning("Dungeon", "An exception occurred when loading a dungeon from NBT.");
                }
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbtTagCompound) {
        nbtTagCompound.func_74772_a("WorldEventStartTargetTime", this.worldEventStartTargetTime);
        nbtTagCompound.func_74772_a("WorldEventLastStartedTime", this.worldEventLastStartedTime);
        nbtTagCompound.func_74778_a("WorldEventName", this.worldEventName);
        nbtTagCompound.func_74768_a("WorldEventCount", this.worldEventCount);
        ListNBT nbtDungeonList = new ListNBT();
        for (DungeonInstance dungeonInstance : this.dungeons.values()) {
            CompoundNBT dungeonNBT = new CompoundNBT();
            if ((dungeonNBT = dungeonInstance.writeToNBT(dungeonNBT)) == null) continue;
            nbtDungeonList.add((Object)dungeonNBT);
        }
        nbtTagCompound.func_218657_a("Dungeons", (INBT)nbtDungeonList);
        return nbtTagCompound;
    }
}

