/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientEventListener;
import com.lycanitesmobs.KeyHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.container.ContainerCreature;
import com.lycanitesmobs.core.container.ContainerEquipmentForge;
import com.lycanitesmobs.core.container.ContainerSummoningPedestal;
import com.lycanitesmobs.core.gui.GuiCreature;
import com.lycanitesmobs.core.gui.GuiEquipmentForge;
import com.lycanitesmobs.core.gui.GuiOverlay;
import com.lycanitesmobs.core.gui.GuiSummoningPedestal;
import com.lycanitesmobs.core.gui.beastiary.GuiBeastiarySummoning;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemColorCustomSpawnEgg;
import com.lycanitesmobs.core.localisation.LanguageLoader;
import com.lycanitesmobs.core.localisation.LanguageManager;
import com.lycanitesmobs.core.renderer.RenderRegister;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientManager {
    protected static ClientManager INSTANCE;
    protected FontRenderer fontRenderer;

    public static ClientManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientManager();
        }
        return INSTANCE;
    }

    public FontRenderer getFontRenderer() {
        if (this.fontRenderer == null) {
            ResourceLocation fontResource = new ResourceLocation("textures/font/ascii.png");
            this.fontRenderer = new FontRenderer(Minecraft.func_71410_x().func_110434_K(), new Font(Minecraft.func_71410_x().func_110434_K(), fontResource));
        }
        return this.fontRenderer;
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        for (CreatureType creatureType : CreatureManager.getInstance().creatureTypes.values()) {
            event.getItemColors().func_199877_a((IItemColor)new ItemColorCustomSpawnEgg(), new IItemProvider[]{creatureType.spawnEgg});
        }
    }

    public void registerGUIs() {
        ScreenManager.func_216911_a(ContainerCreature.TYPE, GuiCreature::new);
        ScreenManager.func_216911_a(ContainerSummoningPedestal.TYPE, GuiSummoningPedestal::new);
        ScreenManager.func_216911_a(ContainerEquipmentForge.TYPE, GuiEquipmentForge::new);
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new KeyHandler(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new GuiOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventListener());
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)LanguageLoader.getInstance());
        }
    }

    public void initLanguageManager() {
        LanguageManager.getInstance();
    }

    public void registerTextures() {
        ModInfo group = LycanitesMobs.modInfo;
        AssetManager.addTexture("GUIInventoryCreature", group, "textures/guis/inventory_creature.png");
        AssetManager.addTexture("GUIBeastiaryBackground", group, "textures/guis/beastiary/background.png");
        AssetManager.addTexture("GUIPetLevel", group, "textures/guis/beastiary/level.png");
        AssetManager.addTexture("GUIPetSpirit", group, "textures/guis/beastiary/spirit.png");
        AssetManager.addTexture("GUIPetSpiritEmpty", group, "textures/guis/beastiary/spirit_empty.png");
        AssetManager.addTexture("GUIPetSpiritUsed", group, "textures/guis/beastiary/spirit_used.png");
        AssetManager.addTexture("GUIPetSpiritFilling", group, "textures/guis/beastiary/spirit_filling.png");
        AssetManager.addTexture("GUIPetBarHealth", group, "textures/guis/beastiary/bar_health.png");
        AssetManager.addTexture("GUIPetBarRespawn", group, "textures/guis/beastiary/bar_respawn.png");
        AssetManager.addTexture("GUIPetBarEmpty", group, "textures/guis/beastiary/bar_empty.png");
        AssetManager.addTexture("GUILMMainMenu", group, "textures/guis/lmmainmenu.png");
        AssetManager.addTexture("GUIBeastiary", group, "textures/guis/beastiary.png");
        AssetManager.addTexture("GUIPet", group, "textures/guis/pet.png");
        AssetManager.addTexture("GUIMount", group, "textures/guis/mount.png");
        AssetManager.addTexture("GUIFamiliar", group, "textures/guis/familiar.png");
        AssetManager.addTexture("GUIMinion", group, "textures/guis/minion.png");
        AssetManager.addTexture("GUIMinionLg", group, "textures/guis/minion_lg.png");
        AssetManager.addTexture("GUIEquipmentForge", group, "textures/guis/equipmentforge.png");
    }

    public void initRenderRegister() {
        RenderRegister renderRegister = new RenderRegister();
        renderRegister.registerModels();
        renderRegister.registerModelLoaders();
        renderRegister.registerRenderFactories();
    }

    public void loadCreatureModel(CreatureInfo creature, String modelClassName) throws ClassNotFoundException {
        creature.modelClass = Class.forName(modelClassName);
    }

    public void loadSubspeciesModel(Subspecies subspecies, String modelClassName) throws ClassNotFoundException {
        subspecies.modelClass = Class.forName(modelClassName);
    }

    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void displayGuiScreen(String screenName, PlayerEntity player) {
        if ("beastiary".equals(screenName)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiBeastiarySummoning(player));
        }
    }
}

