/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.model.ModelCreatureBase;
import com.lycanitesmobs.core.model.ModelItemBase;
import com.lycanitesmobs.core.model.ModelProjectileBase;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class AssetManager {
    public static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    public static Map<String, ResourceLocation[]> textureGroups = new HashMap<String, ResourceLocation[]>();
    public static Map<String, ModelCreatureBase> creatureModels = new HashMap<String, ModelCreatureBase>();
    public static Map<String, ModelProjectileBase> projectileModels = new HashMap<String, ModelProjectileBase>();
    public static Map<String, Class<? extends ModelProjectileBase>> oldProjectileModelClasses = new HashMap<String, Class<? extends ModelProjectileBase>>();
    public static Map<String, ModelItemBase> itemModels = new HashMap<String, ModelItemBase>();

    public static void addTexture(String name, ModInfo modInfo, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation(modInfo.modid, path));
    }

    public static void addTextureGroup(String name, ModInfo modInfo, String[] paths) {
        name = name.toLowerCase();
        ResourceLocation[] textureGroup = new ResourceLocation[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            textureGroup[i] = new ResourceLocation(modInfo.modid, paths[i]);
        }
        textureGroups.put(name, textureGroup);
    }

    public static void addItemModel(String name, ModelItemBase model) {
        name = name.toLowerCase();
        itemModels.put(name, model);
    }

    public static ResourceLocation getTexture(String name) {
        if (!textures.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textures.get(name);
    }

    public static ResourceLocation[] getTextureGroup(String name) {
        if (!textureGroups.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textureGroups.get(name);
    }

    public static ModelCreatureBase getCreatureModel(EntityCreatureBase entityCreature) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (entityCreature.creatureInfo == null) {
            return null;
        }
        if (entityCreature.getSubspecies() != null && entityCreature.getSubspecies().modelClass != null) {
            if (creatureModels.containsKey(entityCreature.getSubspecies().modelClass.toString())) {
                return creatureModels.get(entityCreature.getSubspecies().modelClass.toString());
            }
            ModelCreatureBase creatureModel = entityCreature.getSubspecies().modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            creatureModels.put(entityCreature.getSubspecies().modelClass.toString(), creatureModel);
            return creatureModel;
        }
        return AssetManager.getCreatureModel(entityCreature.creatureInfo);
    }

    public static ModelCreatureBase getCreatureModel(CreatureInfo creatureInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (creatureInfo == null || creatureInfo.modelClass == null) {
            return null;
        }
        if (creatureModels.containsKey(creatureInfo.modelClass.toString())) {
            return creatureModels.get(creatureInfo.modelClass.toString());
        }
        ModelCreatureBase creatureModel = creatureInfo.modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        creatureModels.put(creatureInfo.modelClass.toString(), creatureModel);
        return creatureModel;
    }

    public static ModelProjectileBase getProjectileModel(ProjectileInfo projectileInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (projectileInfo == null || projectileInfo.modelClass == null) {
            return null;
        }
        if (projectileModels.containsKey(projectileInfo.modelClass.toString())) {
            return projectileModels.get(projectileInfo.modelClass.toString());
        }
        ModelProjectileBase projectileModel = projectileInfo.modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        projectileModels.put(projectileInfo.modelClass.toString(), projectileModel);
        return projectileModel;
    }

    public static void registerOldProjectileModel(String name, Class<? extends ModelProjectileBase> model) {
        name = name.toLowerCase();
        oldProjectileModelClasses.put(name, model);
    }

    public static ModelProjectileBase getOldProjectileModel(String projectileName) {
        if (!projectileModels.containsKey(projectileName)) {
            try {
                projectileModels.put("lightball", oldProjectileModelClasses.get(projectileName).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return projectileModels.get(projectileName);
    }

    public static ModelItemBase getItemModel(String name) {
        if (!itemModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return itemModels.get(name);
    }
}

