/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier6;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.MobChunkLoader;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.SpawnerItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier3.EntityTippedArrowOther;
import net.minecraft.entity.helpful.tier6.EntityWitherStormHead;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacle;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacleDevourer;
import net.minecraft.entity.helpful.tier6.EnumWitherStormPhase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitherStorm
extends EntityFriendlyCreature
implements Massive,
Armored,
Flying,
Undead {
    private static final DataParameter<Boolean> DOESNT_HAVE_COMMAND_BLOCK = EntityDataManager.func_187226_a(EntityWitherStorm.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityWitherStorm.class, (DataSerializer)DataSerializers.field_187192_b);
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;
    public EntityWitherStormHead centerHead = new EntityWitherStormHead(this.field_70170_p);
    public EntityWitherStormHead rightHead = new EntityWitherStormHead(this.field_70170_p);
    public EntityWitherStormHead leftHead = new EntityWitherStormHead(this.field_70170_p);
    public EntityWitherStormTentacle tentacle1 = new EntityWitherStormTentacle(this.field_70170_p);
    public EntityWitherStormTentacle tentacle2 = new EntityWitherStormTentacle(this.field_70170_p);
    public EntityWitherStormTentacle tentacle3 = new EntityWitherStormTentacle(this.field_70170_p);
    public EntityWitherStormTentacle tentacle4 = new EntityWitherStormTentacle(this.field_70170_p);
    public EntityWitherStormTentacle tentacle5 = new EntityWitherStormTentacle(this.field_70170_p);
    public EntityWitherStormTentacleDevourer tentacledevourer1 = new EntityWitherStormTentacleDevourer(this.field_70170_p);
    public EntityWitherStormTentacleDevourer tentacledevourer2 = new EntityWitherStormTentacleDevourer(this.field_70170_p);

    public EntityWitherStorm(World worldIn) {
        super(worldIn);
        this.func_70105_a(9.0f, 32.0f);
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.field_70145_X = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70765_h = new WitherStormMoveHelper(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 200.0f, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround());
        this.field_70728_aV = 50000;
        this.setLevel(300);
        this.field_70158_ak = true;
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            worldIn.func_184133_a(null, entityplayer.func_180425_c(), ModSoundEvents.witherStormFinish, this.func_184176_by(), Float.MAX_VALUE, 1.0f);
        }
        if (!worldIn.field_72995_K) {
            this.centerHead = null;
            this.rightHead = null;
            this.leftHead = null;
            this.tentacle1 = null;
            this.tentacle2 = null;
            this.tentacle3 = null;
            this.tentacle4 = null;
            this.tentacle5 = null;
            this.tentacledevourer1 = null;
            this.tentacledevourer2 = null;
        }
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public void updateBossBar() {
        super.updateBossBar();
        this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
        this.bossInfo.func_186741_a(true);
        this.bossInfo.func_186742_b(true);
    }

    @Override
    public int getSpawnTimer() {
        return 0;
    }

    @Override
    public boolean isABoss() {
        return true;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 64.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultFittnessStat() {
        return 1.0f;
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public boolean canWearEasterEggs() {
        return false;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER6;
    }

    @Override
    public void func_174812_G() {
        super.func_174812_G();
        this.centerHead.func_70106_y();
        this.rightHead.func_70106_y();
        this.leftHead.func_70106_y();
        this.tentacle1.func_70106_y();
        this.tentacle2.func_70106_y();
        this.tentacle3.func_70106_y();
        this.tentacle4.func_70106_y();
        this.tentacle5.func_70106_y();
        this.tentacledevourer1.func_70106_y();
        this.tentacledevourer2.func_70106_y();
        this.centerHead = null;
        this.rightHead = null;
        this.leftHead = null;
        this.tentacle1 = null;
        this.tentacle2 = null;
        this.tentacle3 = null;
        this.tentacle4 = null;
        this.tentacle5 = null;
        this.tentacledevourer1 = null;
        this.tentacledevourer2 = null;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12500.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(20.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.doesntContainACommandBlock() ? "Severed Wither Storm" : "The Wither Storm";
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
        this.field_70180_af.func_187214_a(DOESNT_HAVE_COMMAND_BLOCK, (Object)false);
    }

    public void func_70076_C() {
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Growth", this.getSize());
        tagCompound.func_74757_a("NoCommandBlock", this.doesntContainACommandBlock());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.Grow(tagCompund.func_74762_e("Growth"));
        this.setNotContainingCommandBlock(tagCompund.func_74767_n("NoCommandBlock"));
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.witherStormAmbient;
    }

    protected SoundEvent func_184601_bQ() {
        return this.doesntContainACommandBlock() ? ModSoundEvents.witherStormHurt : ModSoundEvents.witherStormHurtCommandBlock;
    }

    protected SoundEvent func_184615_bR() {
        return this.doesntContainACommandBlock() ? ModSoundEvents.witherStormHurt : ModSoundEvents.witherStormDeath;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 1.0f : 100.0f;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public boolean func_70104_M() {
        return false;
    }

    public EnumWitherStormPhase getPhase() {
        return this.getSize() <= 250000 && this.getSize() > 50000 ? EnumWitherStormPhase.Devourer : (this.getSize() > 250000 ? EnumWitherStormPhase.ThunderStorm : EnumWitherStormPhase.Destroyer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.centerHead.func_70057_ab();
        this.rightHead.func_70057_ab();
        this.leftHead.func_70057_ab();
        this.tentacle1.func_70057_ab();
        this.tentacle2.func_70057_ab();
        this.tentacle3.func_70057_ab();
        this.tentacle4.func_70057_ab();
        this.tentacle5.func_70057_ab();
        this.tentacledevourer1.func_70057_ab();
        this.tentacledevourer2.func_70057_ab();
        super.func_70057_ab();
    }

    @Override
    public void func_70636_d() {
        int i;
        if (!this.doesntContainACommandBlock() && !this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                MobChunkLoader.updateLoaded((Entity)this);
            } else {
                MobChunkLoader.stopLoading((Entity)this);
            }
        }
        this.func_70661_as().func_75499_g();
        this.field_70728_aV = this.getSize();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.doesntContainACommandBlock() ? 1000.0 : (double)this.getSize());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.doesntContainACommandBlock() ? 20.0 : 24.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(this.doesntContainACommandBlock() ? 10.0 : 20.0);
        if (!this.doesntContainACommandBlock() && this.getSize() >= 300000 && !this.field_70170_p.field_72995_K && this.field_70173_aa % 1000 == 0) {
            EntityWitherStorm entityzombie = new EntityWitherStorm(this.field_70170_p);
            entityzombie.func_82149_j((Entity)this);
            entityzombie.func_94061_f(this.func_175446_cd());
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            entityzombie.setOwnerId(this.func_184753_b());
            entityzombie.setNotContainingCommandBlock(true);
            entityzombie.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            entityzombie.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            this.Grow(this.getSize() - 12500);
        }
        if (this.field_70159_w > 1.0) {
            this.field_70159_w = 1.0;
        }
        if (this.field_70179_y < -1.0) {
            this.field_70179_y = -1.0;
        }
        if (this.field_70181_x > 1.0) {
            this.field_70181_x = 1.0;
        }
        if (this.field_70181_x < -1.0) {
            this.field_70181_x = -1.0;
        }
        if (this.field_70159_w > 1.0) {
            this.field_70159_w = 1.0;
        }
        if (this.field_70179_y < -1.0) {
            this.field_70179_y = -1.0;
        }
        if (!this.isWild()) {
            this.getOwner().func_184596_c(MobEffects.field_82731_v);
        }
        if (this.deathTicks <= 0) {
            if (!this.field_70170_p.field_72995_K && this.centerHead != null && this.centerHead.field_70128_L) {
                this.centerHead = null;
                this.func_70097_a(DamageSource.field_76377_j, 1000.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.rightHead != null && this.rightHead.field_70128_L) {
                this.rightHead = null;
                this.func_70097_a(DamageSource.field_76377_j, 1000.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.leftHead != null && this.leftHead.field_70128_L) {
                this.leftHead = null;
                this.func_70097_a(DamageSource.field_76377_j, 1000.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.centerHead == null) {
                this.centerHead = new EntityWitherStormHead(this.field_70170_p);
                this.centerHead.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.centerHead);
                this.centerHead.residentWitherStorm = this;
                this.centerHead.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.rightHead == null) {
                this.rightHead = new EntityWitherStormHead(this.field_70170_p);
                this.rightHead.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.rightHead);
                this.rightHead.residentWitherStorm = this;
                this.rightHead.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.leftHead == null) {
                this.leftHead = new EntityWitherStormHead(this.field_70170_p);
                this.leftHead.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.leftHead);
                this.leftHead.residentWitherStorm = this;
                this.leftHead.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle1 != null && this.tentacle1.field_70128_L) {
                this.tentacle1 = null;
                this.func_70097_a(DamageSource.field_76377_j, 100.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle2 != null && this.tentacle2.field_70128_L) {
                this.tentacle2 = null;
                this.func_70097_a(DamageSource.field_76377_j, 100.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle3 != null && this.tentacle3.field_70128_L) {
                this.tentacle3 = null;
                this.func_70097_a(DamageSource.field_76377_j, 100.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle4 != null && this.tentacle4.field_70128_L) {
                this.tentacle4 = null;
                this.func_70097_a(DamageSource.field_76377_j, 100.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle5 != null && this.tentacle5.field_70128_L) {
                this.tentacle5 = null;
                this.func_70097_a(DamageSource.field_76377_j, 100.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle1 == null) {
                this.tentacle1 = new EntityWitherStormTentacle(this.field_70170_p);
                this.tentacle1.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacle1);
                this.tentacle1.residentWitherStorm = this;
                this.tentacle1.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle2 == null) {
                this.tentacle2 = new EntityWitherStormTentacle(this.field_70170_p);
                this.tentacle2.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacle2);
                this.tentacle2.residentWitherStorm = this;
                this.tentacle2.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle3 == null) {
                this.tentacle3 = new EntityWitherStormTentacle(this.field_70170_p);
                this.tentacle3.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacle3);
                this.tentacle3.residentWitherStorm = this;
                this.tentacle3.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle4 == null) {
                this.tentacle4 = new EntityWitherStormTentacle(this.field_70170_p);
                this.tentacle4.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacle4);
                this.tentacle4.residentWitherStorm = this;
                this.tentacle4.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacle5 == null) {
                this.tentacle5 = new EntityWitherStormTentacle(this.field_70170_p);
                this.tentacle5.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacle5);
                this.tentacle5.residentWitherStorm = this;
                this.tentacle5.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacledevourer1 != null && this.tentacledevourer1.field_70128_L) {
                this.tentacledevourer1 = null;
                this.func_70097_a(DamageSource.field_76377_j, 200.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacledevourer2 != null && this.tentacledevourer2.field_70128_L) {
                this.tentacledevourer2 = null;
                this.func_70097_a(DamageSource.field_76377_j, 200.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.tentacledevourer1 == null) {
                this.tentacledevourer1 = new EntityWitherStormTentacleDevourer(this.field_70170_p);
                this.tentacledevourer1.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacledevourer1);
                this.tentacledevourer1.residentWitherStorm = this;
                this.tentacledevourer1.func_70071_h_();
            }
            if (!this.field_70170_p.field_72995_K && this.tentacledevourer2 == null) {
                this.tentacledevourer2 = new EntityWitherStormTentacleDevourer(this.field_70170_p);
                this.tentacledevourer2.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)this.tentacledevourer2);
                this.tentacledevourer2.residentWitherStorm = this;
                this.tentacledevourer2.func_70071_h_();
            }
        }
        if ((this.field_70173_aa + this.func_145782_y()) % 100 == 0) {
            this.func_184185_a(ModSoundEvents.commandBlockWitherHum, 0.25f, 1.0f);
        }
        float rot = this.field_70759_as * ((float)Math.PI / 180);
        float oned = MathHelper.func_76126_a((float)rot);
        float twod = MathHelper.func_76134_b((float)rot);
        if (this.getJukeboxToDanceTo() != null) {
            if (this.centerHead != null) {
                this.centerHead.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.rightHead != null) {
                this.rightHead.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.leftHead != null) {
                this.leftHead.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacle1 != null) {
                this.tentacle1.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacle2 != null) {
                this.tentacle2.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacle3 != null) {
                this.tentacle3.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacle4 != null) {
                this.tentacle4.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacle5 != null) {
                this.tentacle5.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacledevourer1 != null) {
                this.tentacledevourer1.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
            if (this.tentacledevourer2 != null) {
                this.tentacledevourer2.setJukeboxToDanceTo(this.getJukeboxToDanceTo());
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            float f13 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            float f15 = (this.field_70146_Z.nextFloat() - 0.5f) * 36.0f;
            float f17 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f13, this.field_70163_u - 4.0 + (double)f15, this.field_70161_v + (double)f17, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K && this.getOwner() != null && this.field_70163_u <= this.getOwner().field_70163_u && this.field_70163_u >= this.getOwner().field_70163_u - 0.5 && !this.func_70093_af()) {
            EntityWitherStorm.createEngenderModExplosion((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
        }
        this.field_70122_E = false;
        this.field_70160_al = true;
        this.field_70145_X = true;
        if (this.getSize() < 12500) {
            this.Grow(12500);
        }
        if (this.getSize() >= 250000) {
            WorldInfo worldinfo = this.field_70170_p.func_72912_H();
            worldinfo.func_176142_i(0);
            worldinfo.func_76080_g(200);
            worldinfo.func_76090_f(200);
            worldinfo.func_76084_b(true);
            worldinfo.func_76069_a(true);
        }
        if (this.field_70181_x > 1.0) {
            this.field_70181_x = 0.0;
        }
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (this.deathTicks <= 0) {
            List list11111;
            List list1111;
            List list111;
            List list11;
            List list1;
            float f2;
            double d21;
            List list;
            if (this.field_70718_bc <= 50 && this.func_110143_aJ() <= 0.0f) {
                this.func_70606_j(1.0f);
            } else if (this.field_70718_bc > 50 && this.func_110143_aJ() <= 0.0f) {
                this.func_70606_j(0.0f);
            }
            this.centerHead.field_70159_w = this.field_70159_w;
            this.centerHead.field_70181_x = this.field_70181_x;
            this.centerHead.field_70179_y = this.field_70179_y;
            this.rightHead.field_70159_w = this.field_70159_w;
            this.rightHead.field_70181_x = this.field_70181_x;
            this.rightHead.field_70179_y = this.field_70179_y;
            this.leftHead.field_70159_w = this.field_70159_w;
            this.leftHead.field_70181_x = this.field_70181_x;
            this.leftHead.field_70179_y = this.field_70179_y;
            if (this.centerHead.getOwner() == null) {
                this.centerHead.setOwnerId(this.func_184753_b());
            }
            if (this.rightHead.getOwner() == null) {
                this.rightHead.setOwnerId(this.func_184753_b());
            }
            if (this.leftHead.getOwner() == null) {
                this.leftHead.setOwnerId(this.func_184753_b());
            }
            if (this.tentacle1.getOwner() == null) {
                this.tentacle1.setOwnerId(this.func_184753_b());
            }
            if (this.tentacle2.getOwner() == null) {
                this.tentacle2.setOwnerId(this.func_184753_b());
            }
            if (this.tentacle3.getOwner() == null) {
                this.tentacle3.setOwnerId(this.func_184753_b());
            }
            if (this.tentacle4.getOwner() == null) {
                this.tentacle4.setOwnerId(this.func_184753_b());
            }
            if (this.tentacle5.getOwner() == null) {
                this.tentacle5.setOwnerId(this.func_184753_b());
            }
            if (this.tentacledevourer1.getOwner() == null) {
                this.tentacledevourer1.setOwnerId(this.func_184753_b());
            }
            if (this.tentacledevourer2.getOwner() == null) {
                this.tentacledevourer2.setOwnerId(this.func_184753_b());
            }
            if (this.doesntContainACommandBlock()) {
                this.tentacle1.field_70759_as = this.field_70759_as - 30.0f;
                this.tentacle2.field_70759_as = this.field_70759_as + 90.0f;
                this.tentacle3.field_70759_as = this.field_70759_as - 130.0f;
                this.tentacle4.field_70759_as = this.field_70759_as + 120.0f;
                this.tentacle5.field_70759_as = this.field_70759_as - 100.0f;
                this.tentacledevourer1.field_70759_as = this.field_70759_as - 180.0f;
                this.tentacledevourer2.field_70759_as = this.field_70759_as + 180.0f;
                this.centerHead.field_70761_aq = this.centerHead.field_70177_z = this.field_70759_as;
                this.rightHead.field_70761_aq = this.rightHead.field_70177_z = this.field_70759_as + 10.0f;
                this.leftHead.field_70761_aq = this.leftHead.field_70177_z = this.field_70759_as - 10.0f;
            } else {
                this.tentacle1.field_70759_as = this.field_70759_as - 60.0f;
                this.tentacle2.field_70759_as = this.field_70759_as + 60.0f;
                this.tentacle3.field_70759_as = this.field_70759_as - 120.0f;
                this.tentacle4.field_70759_as = this.field_70759_as + 105.0f;
                this.tentacle5.field_70759_as = this.field_70759_as - 180.0f;
                this.tentacledevourer1.field_70759_as = this.field_70759_as - 120.0f;
                this.tentacledevourer2.field_70759_as = this.field_70759_as + 120.0f;
                this.centerHead.field_70761_aq = this.centerHead.field_70177_z = this.field_70759_as;
                this.rightHead.field_70761_aq = this.rightHead.field_70177_z = this.field_70759_as + 30.0f;
                this.leftHead.field_70761_aq = this.leftHead.field_70177_z = this.field_70759_as - 30.0f;
            }
            this.tentacle1.field_70159_w = this.field_70159_w;
            this.tentacle1.field_70181_x = this.field_70181_x;
            this.tentacle1.field_70179_y = this.field_70179_y;
            this.tentacle2.field_70159_w = this.field_70159_w;
            this.tentacle2.field_70181_x = this.field_70181_x;
            this.tentacle2.field_70179_y = this.field_70179_y;
            this.tentacle3.field_70159_w = this.field_70159_w;
            this.tentacle3.field_70181_x = this.field_70181_x;
            this.tentacle3.field_70179_y = this.field_70179_y;
            this.tentacle4.field_70159_w = this.field_70159_w;
            this.tentacle4.field_70181_x = this.field_70181_x;
            this.tentacle4.field_70179_y = this.field_70179_y;
            this.tentacle5.field_70159_w = this.field_70159_w;
            this.tentacle5.field_70181_x = this.field_70181_x;
            this.tentacle5.field_70179_y = this.field_70179_y;
            this.tentacledevourer1.field_70159_w = this.field_70159_w;
            this.tentacledevourer1.field_70181_x = this.field_70181_x;
            this.tentacledevourer1.field_70179_y = this.field_70179_y;
            this.tentacledevourer2.field_70159_w = this.field_70159_w;
            this.tentacledevourer2.field_70181_x = this.field_70181_x;
            this.tentacledevourer2.field_70179_y = this.field_70179_y;
            this.centerHead.field_70173_aa = this.field_70173_aa;
            this.rightHead.field_70173_aa = this.field_70173_aa;
            this.leftHead.field_70173_aa = this.field_70173_aa;
            this.tentacle1.field_70173_aa = this.field_70173_aa;
            this.tentacle2.field_70173_aa = this.field_70173_aa;
            this.tentacle3.field_70173_aa = this.field_70173_aa;
            this.tentacle4.field_70173_aa = this.field_70173_aa;
            this.tentacle5.field_70173_aa = this.field_70173_aa;
            this.tentacledevourer1.field_70173_aa = this.field_70173_aa;
            this.tentacledevourer2.field_70173_aa = this.field_70173_aa;
            if (!this.func_175446_cd() && this.func_70089_S() && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < this.getSize() / 100; ++i1) {
                    if (this.field_70146_Z.nextInt(40) != 0) continue;
                    int i11 = MathHelper.func_76128_c((double)(this.field_70163_u - 24.0)) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)2, (int)128) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)2, (int)128) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)2, (int)128) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    BlockPos blockpos = new BlockPos(l1, i11, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (!this.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_177230_c().isAir(this.field_70170_p.func_180495_p(blockpos.func_177984_a()), (IBlockAccess)this.field_70170_p, blockpos.func_177984_a()) || block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_175707_a(blockpos, blockpos) || block.func_176195_g(iblockstate, this.field_70170_p, new BlockPos(l1, i11, i2)) == -1.0f) continue;
                    if (block.func_149688_o(iblockstate).func_76224_d()) {
                        this.field_70170_p.func_175698_g(new BlockPos(l1, i11, i2));
                        continue;
                    }
                    this.field_70170_p.func_72838_d((Entity)new EntityFallingBlock(this.field_70170_p, (double)l1, (double)i11, (double)i2, block.func_176221_a(iblockstate, (IBlockAccess)this.field_70170_p, blockpos)));
                }
            }
            if (this.field_70173_aa > 20 && !this.doesntContainACommandBlock() && (list = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list.isEmpty() && this.func_70089_S()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity instanceof EntityFallingBlock || entity == null || entity.func_70047_e() != 0.0f || entity.field_70131_O != 0.98f || entity.field_70130_N != 0.98f) continue;
                    entity.field_70145_X = entity.field_70123_F || entity.field_70124_G;
                    double d01 = this.field_70165_t - entity.field_70165_t;
                    double d11 = this.field_70163_u + (double)this.func_70047_e() - entity.field_70163_u;
                    d21 = this.field_70161_v - entity.field_70161_v;
                    f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                    entity.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + entity.field_70159_w * 0.5;
                    entity.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + entity.field_70181_x * 0.5;
                    entity.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + entity.field_70179_y * 0.5;
                }
            }
            if ((list = this.field_70170_p.func_175647_a(EntityFallingBlock.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list.isEmpty() && this.func_70089_S() && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityFallingBlock entity = (EntityFallingBlock)list.get(i1);
                    if (entity == null) continue;
                    double d01 = this.field_70165_t - entity.field_70165_t;
                    double d11 = this.field_70163_u + (double)this.func_70047_e() - entity.field_70163_u;
                    d21 = this.field_70161_v - entity.field_70161_v;
                    f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                    entity.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + entity.field_70159_w * 0.5;
                    entity.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + entity.field_70181_x * 0.5;
                    entity.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + entity.field_70179_y * 0.5;
                    List sublist = this.field_70170_p.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ(), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                    if (!this.func_70089_S() || sublist == null || sublist.isEmpty()) continue;
                    for (int i11 = 0; i11 < sublist.size(); ++i11) {
                        EntityLivingBase subentity = (EntityLivingBase)sublist.get(i11);
                        if (subentity == null || this.isOnSameTeam(subentity)) continue;
                        subentity.func_70097_a(DamageSource.field_76368_d, 5.0f);
                    }
                }
            }
            if ((list1 = this.field_70170_p.func_175647_a(EntityFallingBlock.class, this.func_174813_aQ(), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list1.isEmpty() && this.func_70089_S() && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < list1.size(); ++i1) {
                    EntityFallingBlock entity = (EntityFallingBlock)list1.get(i1);
                    if (entity == null) continue;
                    entity.func_70106_y();
                    this.Grow(this.getSize() + 3);
                    this.func_70691_i(2.0f);
                }
            }
            if ((list11 = this.field_70170_p.func_175647_a(EntityItem.class, this.func_174813_aQ().func_72314_b(256.0, 256.0, 256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list11.isEmpty() && this.func_70089_S() && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    EntityItem entity = (EntityItem)list11.get(i1);
                    if (entity == null || entity.func_92059_d().func_77973_b() == SpawnerItems.witheredNetherStar) continue;
                    double d01 = this.field_70165_t - entity.field_70165_t;
                    double d11 = this.field_70163_u + 2.0 - entity.field_70163_u;
                    double d212 = this.field_70161_v - entity.field_70161_v;
                    float f22 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d212 * d212));
                    entity.field_70159_w = d01 / (double)f22 * 0.6 * 0.6 + entity.field_70159_w * 0.6;
                    entity.field_70181_x = d11 / (double)f22 * 0.6 * 0.6 + entity.field_70181_x * 0.6;
                    entity.field_70179_y = d212 / (double)f22 * 0.6 * 0.6 + entity.field_70179_y * 0.6;
                }
            }
            if ((list111 = this.field_70170_p.func_175647_a(EntityItem.class, this.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list111.isEmpty() && this.func_70089_S() && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < list111.size(); ++i1) {
                    EntityItem entity = (EntityItem)list111.get(i1);
                    if (entity == null || entity.func_92059_d().func_77973_b() == SpawnerItems.witheredNetherStar) continue;
                    entity.func_70106_y();
                    this.Grow(this.getSize() + 1 + entity.func_92059_d().func_190916_E());
                    this.func_70691_i(1 + entity.func_92059_d().func_190916_E());
                }
            }
            if ((list1111 = this.field_70170_p.func_175647_a(EntityArrow.class, this.func_174813_aQ().func_72314_b(256.0, 256.0, 256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list1111.isEmpty() && this.func_70089_S() && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < list1111.size(); ++i1) {
                    EntityArrow entity = (EntityArrow)list1111.get(i1);
                    if (entity == null || entity instanceof EntityTippedArrowOther) continue;
                    double d01 = this.field_70165_t - entity.field_70165_t;
                    double d11 = this.field_70163_u + 2.0 - entity.field_70163_u;
                    double d213 = this.field_70161_v - entity.field_70161_v;
                    float f23 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d213 * d213));
                    entity.field_70159_w = d01 / (double)f23 * 0.6 * 0.6 + entity.field_70159_w * 0.6;
                    entity.field_70181_x = d11 / (double)f23 * 0.6 * 0.6 + entity.field_70181_x * 0.6;
                    entity.field_70179_y = d213 / (double)f23 * 0.6 * 0.6 + entity.field_70179_y * 0.6;
                }
            }
            if ((list11111 = this.field_70170_p.func_175647_a(EntityArrow.class, this.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list11111.isEmpty() && this.func_70089_S() && !this.doesntContainACommandBlock()) {
                for (int i1 = 0; i1 < list11111.size(); ++i1) {
                    EntityArrow entity = (EntityArrow)list11111.get(i1);
                    if (entity == null || entity instanceof EntityTippedArrowOther) continue;
                    entity.func_70106_y();
                    this.Grow(this.getSize() + 1);
                    this.func_70691_i(1.0f);
                }
            }
        }
        this.field_70158_ak = true;
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        if (this.field_70170_p.field_72995_K) {
            for (i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 12.0, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 48.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 12.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.doesntContainACommandBlock()) {
            if (this.centerHead != null) {
                this.centerHead.func_70012_b(this.field_70165_t + (double)(oned * -7.0f), this.field_70163_u, this.field_70161_v - (double)(twod * -7.0f), 0.0f, 0.0f);
            }
            if (this.rightHead != null) {
                this.rightHead.func_70012_b(this.field_70165_t + (double)(twod * -7.0f) + (double)(oned * -7.0f), this.field_70163_u, this.field_70161_v + (double)(oned * -7.0f) - (double)(twod * -7.0f), 0.0f, 0.0f);
            }
            if (this.leftHead != null) {
                this.leftHead.func_70012_b(this.field_70165_t - (double)(twod * -7.0f) + (double)(oned * -7.0f), this.field_70163_u, this.field_70161_v - (double)(oned * -7.0f) - (double)(twod * -7.0f), 0.0f, 0.0f);
            }
            if (this.tentacle1 != null) {
                this.tentacle1.func_70012_b(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, 0.0f, 0.0f);
            }
            if (this.tentacle2 != null) {
                this.tentacle2.func_70012_b(this.field_70165_t + (double)(twod * 4.0f), this.field_70163_u - 1.0, this.field_70161_v + (double)(oned * 4.0f), 0.0f, 0.0f);
            }
            if (this.tentacle3 != null) {
                this.tentacle3.func_70012_b(this.field_70165_t - (double)(twod * -2.0f), this.field_70163_u + 4.0, this.field_70161_v - (double)(oned * -2.0f), 0.0f, 0.0f);
            }
            if (this.tentacle4 != null) {
                this.tentacle4.func_70012_b(this.field_70165_t + (double)(twod * -5.0f), this.field_70163_u + 3.0, this.field_70161_v + (double)(oned * -5.0f), 0.0f, 0.0f);
            }
            if (this.tentacle5 != null) {
                this.tentacle5.func_70012_b(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 0.0f, 0.0f);
            }
            if (this.tentacledevourer1 != null) {
                this.tentacledevourer1.func_70012_b(this.field_70165_t, this.field_70163_u + 10.0, this.field_70161_v - (double)oned, 0.0f, 0.0f);
            }
            if (this.tentacledevourer2 != null) {
                this.tentacledevourer2.func_70012_b(this.field_70165_t, this.field_70163_u + 10.0, this.field_70161_v + (double)oned, 0.0f, 0.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(1.0f);
            }
            this.func_70105_a(12.0f, 12.0f);
        } else {
            if (this.centerHead != null) {
                this.centerHead.func_70012_b(this.field_70165_t + (double)(oned * -7.0f), this.field_70163_u, this.field_70161_v - (double)(twod * -7.0f), 0.0f, 0.0f);
            }
            if (this.rightHead != null) {
                this.rightHead.func_70012_b(this.field_70165_t + (double)(twod * -20.0f) + (double)(oned * -4.0f), this.field_70163_u + 10.0, this.field_70161_v + (double)(oned * -20.0f) - (double)(twod * -4.0f), 0.0f, 0.0f);
                this.rightHead.func_82142_c(this.func_110143_aJ() <= 1000.0f);
            }
            if (this.leftHead != null) {
                this.leftHead.func_70012_b(this.field_70165_t - (double)(twod * -20.0f) + (double)(oned * -4.0f), this.field_70163_u + 10.0, this.field_70161_v - (double)(oned * -20.0f) - (double)(twod * -4.0f), 0.0f, 0.0f);
                this.leftHead.func_82142_c(this.func_110143_aJ() <= 2000.0f);
            }
            if (this.tentacle1 != null) {
                this.tentacle1.func_70012_b(this.field_70165_t, this.field_70163_u - 12.0, this.field_70161_v, 0.0f, 0.0f);
                this.tentacle1.func_82142_c(this.func_110143_aJ() <= 9000.0f);
            }
            if (this.tentacle2 != null) {
                this.tentacle2.func_70012_b(this.field_70165_t + (double)(twod * 2.0f), this.field_70163_u - 8.0, this.field_70161_v + (double)(oned * 2.0f), 0.0f, 0.0f);
                this.tentacle2.func_82142_c(this.func_110143_aJ() <= 7500.0f);
            }
            if (this.tentacle3 != null) {
                this.tentacle3.func_70012_b(this.field_70165_t - (double)(twod * -8.0f), this.field_70163_u + 8.0, this.field_70161_v - (double)(oned * -8.0f), 0.0f, 0.0f);
                this.tentacle3.func_82142_c(this.func_110143_aJ() <= 5000.0f);
            }
            if (this.tentacle4 != null) {
                this.tentacle4.func_70012_b(this.field_70165_t + (double)(twod * -5.0f), this.field_70163_u + 4.0, this.field_70161_v + (double)(oned * -5.0f), 0.0f, 0.0f);
                this.tentacle4.func_82142_c(this.func_110143_aJ() <= 4000.0f);
            }
            if (this.tentacle5 != null) {
                this.tentacle5.func_70012_b(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, 0.0f, 0.0f);
                this.tentacle5.func_82142_c(this.func_110143_aJ() <= 3000.0f);
            }
            if (this.tentacledevourer1 != null) {
                this.tentacledevourer1.func_70012_b(this.field_70165_t - (double)(twod * -12.0f), this.field_70163_u + 10.0, this.field_70161_v - (double)(oned * -12.0f), 0.0f, 0.0f);
                this.tentacledevourer1.func_82142_c(this.func_110143_aJ() <= 11500.0f || this.getSize() < 50000 || this.doesntContainACommandBlock());
            }
            if (this.tentacledevourer2 != null) {
                this.tentacledevourer2.func_70012_b(this.field_70165_t + (double)(twod * -12.0f), this.field_70163_u + 10.0, this.field_70161_v + (double)(oned * -12.0f), 0.0f, 0.0f);
                this.tentacledevourer2.func_82142_c(this.func_110143_aJ() <= 10000.0f || this.getSize() < 50000 || this.doesntContainACommandBlock());
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(2.0f);
            }
            this.func_70105_a(9.0f, 32.0f);
        }
    }

    public void func_70110_aj() {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_70612_e(float strafe, float forward) {
        float f = this.doesntContainACommandBlock() ? 0.99f : (this.getSize() > 250000 ? 0.85f : (this.getSize() > 250000 ? 0.88f : 0.91f));
        float f1 = 0.16277136f / (f * f * f);
        this.func_70060_a(strafe, forward, 0.02f);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)f;
        this.field_70179_y *= (double)f;
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.25;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 2.25 : this.field_70163_u + 2.25;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.25;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    public void setPartAttackTarget(@Nullable EntityFriendlyCreature part, @Nullable EntityLivingBase entitylivingbaseIn) {
        if (part != null) {
            part.func_70624_b(entitylivingbaseIn);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getSize() > 250000 && amount < 20.0f) {
            return false;
        }
        if (source.func_76355_l() == "chaosImplosion") {
            amount *= 0.2f;
        }
        if (source.func_94541_c()) {
            amount *= 5.0f;
        }
        if (amount > 5000.0f && source.func_94541_c() && !this.doesntContainACommandBlock() && this.getSize() >= 50000 && !this.field_70170_p.field_72995_K) {
            EntityWitherStorm entityzombie = new EntityWitherStorm(this.field_70170_p);
            entityzombie.func_82149_j((Entity)this);
            entityzombie.func_94061_f(this.func_175446_cd());
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            entityzombie.setOwnerId(this.func_184753_b());
            entityzombie.setNotContainingCommandBlock(true);
            entityzombie.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            entityzombie.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            this.Grow(this.getSize() - 12500);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_76352_a() && !source.func_82725_o() && source != DamageSource.field_76371_c && source != DamageSource.field_76370_b && source != DamageSource.field_76372_a && source != DamageSource.field_76368_d && source != DamageSource.field_76379_h && source != DamageSource.field_76369_e) {
            if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
                if (this.centerHead != null) {
                    this.centerHead.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.leftHead != null) {
                    this.leftHead.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.rightHead != null) {
                    this.rightHead.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacle1 != null) {
                    this.tentacle1.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacle2 != null) {
                    this.tentacle2.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacle3 != null) {
                    this.tentacle3.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacle4 != null) {
                    this.tentacle4.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacle5 != null) {
                    this.tentacle5.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacledevourer1 != null) {
                    this.tentacledevourer1.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                if (this.tentacledevourer2 != null) {
                    this.tentacledevourer2.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    @Override
    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    public boolean func_70662_br() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        if (!potioneffectIn.func_188419_a().func_76398_f()) {
            super.func_70690_d(potioneffectIn);
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDarkness() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void Grow(int p_82215_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(SIZE, (Object)(this.doesntContainACommandBlock() ? 12500 : p_82215_1_));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.doesntContainACommandBlock() ? 1000.0 : (double)p_82215_1_);
            if (p_82215_1_ == 12500 && !this.isWild()) {
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation(this.doesntContainACommandBlock() ? "\u00a75 A Wither Storm has fissioned!" : "\u00a75" + this.getOwner().func_70005_c_() + "'s Wither Storm has grown to Destroyer form!!", new Object[0]), true);
                }
            }
        }
    }

    public boolean doesntContainACommandBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(DOESNT_HAVE_COMMAND_BLOCK);
    }

    public void setNotContainingCommandBlock(boolean p_82215_1_) {
        if (p_82215_1_) {
            this.field_110153_bc = Float.MAX_VALUE;
        }
        this.field_70180_af.func_187227_b(DOESNT_HAVE_COMMAND_BLOCK, (Object)p_82215_1_);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.doesntContainACommandBlock() ? LootTableListEngender.ENTITIES_WITHER_STORM_MULAGEN : LootTableListEngender.ENTITIES_WITHER_STORM;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrushHeavy;
    }

    @Override
    protected void func_70609_aI() {
        BlockPos blockpos = this.func_180425_c();
        if (this.getSize() > 12500 && !this.field_70170_p.field_72995_K && this.field_70170_p.func_175707_a(blockpos, blockpos)) {
            for (int j = 0; j < 2; ++j) {
                this.field_70170_p.func_175656_a(this.func_180425_c().func_177981_b(j), Blocks.field_150343_Z.func_176223_P());
                EntityFallingBlock deathBlocks = new EntityFallingBlock(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5 + (double)j, this.field_70161_v, this.field_70170_p.func_180495_p(this.func_180425_c().func_177981_b(j)));
                deathBlocks.field_70159_w += this.field_70146_Z.nextDouble() * 4.0 - 2.0;
                deathBlocks.field_70181_x -= this.field_70146_Z.nextDouble();
                deathBlocks.field_70179_y += this.field_70146_Z.nextDouble() * 4.0 - 2.0;
                deathBlocks.func_145806_a(true);
                this.field_70170_p.func_72838_d((Entity)deathBlocks);
                this.Grow(this.getSize() - 3);
            }
        }
        if (this.getGrowingAge() < 50000) {
            if (this.tentacledevourer1 != null) {
                this.tentacledevourer1.func_70106_y();
            }
            if (this.tentacledevourer2 != null) {
                this.tentacledevourer2.func_70106_y();
            }
        }
        if (this.doesntContainACommandBlock()) {
            ++this.deathTicks;
            super.func_70609_aI();
        } else {
            ++this.deathTicks;
            if (this.deathTicks % 20 == 0) {
                ++this.field_70725_aQ;
            }
            if (this.func_110143_aJ() <= 0.0f) {
                this.func_70624_b(null);
                float f13 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
                float f15 = (this.field_70146_Z.nextFloat() - 0.5f) * 36.0f;
                float f17 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f13, this.field_70163_u - 4.0 + (double)f15, this.field_70161_v + (double)f17, 0.0, 0.0, 0.0, new int[0]);
            }
            if (!this.field_70170_p.field_72995_K && this.deathTicks == 1 && this.getOwner() != null) {
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.0f);
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s Wither Storm has been killed!!!", new Object[0]), true);
                }
                ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Wither Storm has been destroyed!", new Object[0]));
            }
            if (this.deathTicks == 80 && this.tentacle1 != null && this.tentacle1.residentWitherStorm != null) {
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                if (!this.field_70170_p.field_72995_K) {
                    EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacle1.field_70165_t, this.tentacle1.field_70163_u, this.tentacle1.field_70161_v, 6.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                this.tentacle1.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                this.tentacle1.field_70181_x = 0.8f;
                this.tentacle1.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            }
            if (this.deathTicks == 100 && this.tentacle2 != null && this.tentacle2.residentWitherStorm != null) {
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                if (!this.field_70170_p.field_72995_K) {
                    EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacle2.field_70165_t, this.tentacle2.field_70163_u, this.tentacle2.field_70161_v, 6.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                this.tentacle2.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                this.tentacle2.field_70181_x = 0.8f;
                this.tentacle2.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            }
            if (this.deathTicks == 110 && this.tentacledevourer1 != null && this.tentacledevourer1.residentWitherStorm != null) {
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                if (!this.field_70170_p.field_72995_K) {
                    EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacledevourer1.field_70165_t, this.tentacledevourer1.field_70163_u, this.tentacledevourer1.field_70161_v, 15.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                this.tentacledevourer1.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                this.tentacledevourer1.field_70181_x = 0.8f;
                this.tentacledevourer1.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            }
            if (this.deathTicks == 150) {
                if (this.tentacle4 != null && this.tentacle4.residentWitherStorm != null) {
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacle4.field_70165_t, this.tentacle4.field_70163_u, this.tentacle4.field_70161_v, 6.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    }
                    this.tentacle4.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                    this.tentacle4.field_70181_x = 0.8f;
                    this.tentacle4.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                }
                if (this.tentacle3 != null && this.tentacle3.residentWitherStorm != null) {
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacle3.field_70165_t, this.tentacle3.field_70163_u, this.tentacle3.field_70161_v, 6.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    }
                    this.tentacle3.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                    this.tentacle3.field_70181_x = 0.8f;
                    this.tentacle3.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                }
            }
            if (this.deathTicks == 180) {
                if (this.tentacle5 != null && this.tentacle5.residentWitherStorm != null) {
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacle5.field_70165_t, this.tentacle5.field_70163_u, this.tentacle5.field_70161_v, 6.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    }
                    this.tentacle5.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                    this.tentacle5.field_70181_x = 0.8f;
                    this.tentacle5.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                }
                if (this.tentacledevourer2 != null && this.tentacledevourer2.residentWitherStorm != null) {
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.tentacledevourer2.field_70165_t, this.tentacledevourer2.field_70163_u, this.tentacledevourer2.field_70161_v, 15.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    }
                    this.tentacledevourer2.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                    this.tentacledevourer2.field_70181_x = 0.8f;
                    this.tentacledevourer2.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                }
            }
            if (this.deathTicks == 180 && this.leftHead != null && this.leftHead.residentWitherStorm != null) {
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                if (!this.field_70170_p.field_72995_K) {
                    EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.leftHead.field_70165_t, this.leftHead.field_70163_u, this.leftHead.field_70161_v, 9.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                this.leftHead.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                this.leftHead.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            }
            if (this.deathTicks == 200 && this.rightHead != null && this.rightHead.residentWitherStorm != null) {
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                if (!this.field_70170_p.field_72995_K) {
                    EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.rightHead.field_70165_t, this.rightHead.field_70163_u, this.rightHead.field_70161_v, 9.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                this.rightHead.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
                this.rightHead.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 3.0f;
            }
            if (this.deathTicks == 300 && !this.field_70170_p.field_72995_K) {
                int j;
                List list;
                if (this.centerHead != null && this.centerHead.residentWitherStorm != null) {
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), 2.0f);
                    EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, this.centerHead.field_70165_t, this.centerHead.field_70163_u, this.centerHead.field_70161_v, 9.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    double d01 = this.centerHead.field_70165_t - this.field_70165_t;
                    double d21 = this.centerHead.field_70161_v - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d21 * d21));
                    this.centerHead.field_70159_w = d01 / (double)f2 * 0.6 * 0.6 + this.centerHead.field_70159_w;
                    this.centerHead.field_70179_y = d21 / (double)f2 * 0.6 * 0.6 + this.centerHead.field_70179_y;
                }
                if ((list = this.field_70170_p.func_175647_a(EntityFallingBlock.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list.isEmpty() && this.field_70170_p.field_72995_K) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntityFallingBlock entity = (EntityFallingBlock)list.get(i1);
                        if (entity == null) continue;
                        EntityWitherStorm.createEngenderModExplosionFireless((Entity)this, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 2.0f, false);
                        entity.func_70106_y();
                    }
                }
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.0f);
                }
                for (int i = this.getSize(); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
                }
                EntityItem entityitem = this.func_70099_a(new ItemStack(SpawnerItems.witheredNetherStar), 0.0f);
                if (entityitem != null) {
                    entityitem.func_174873_u();
                }
                if (!this.field_70170_p.field_72995_K) {
                    for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                        entityplayer.func_71029_a((StatBase)AchievementList.field_187977_J);
                    }
                    for (EntityWitherStorm allmulegans : this.field_70170_p.func_72872_a(EntityWitherStorm.class, this.func_174813_aQ().func_186662_g(256.0))) {
                        if (!allmulegans.doesntContainACommandBlock()) continue;
                        allmulegans.func_70606_j(0.0f);
                    }
                }
                this.func_70106_y();
            }
        }
    }

    public boolean func_184222_aU() {
        return EngenderMod.sensorsShowJzahars(this.field_70170_p);
    }

    static class WitherStormMoveHelper
    extends EntityMoveHelper {
        private EntityWitherStorm witherStorm;
        private int courseChangeCooldown;

        public WitherStormMoveHelper(EntityWitherStorm ghast) {
            super((EntityLiving)ghast);
            this.witherStorm = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.witherStorm.field_70165_t;
                double d1 = this.field_75647_c - this.witherStorm.field_70163_u;
                double d2 = this.field_75644_d - this.witherStorm.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.witherStorm.func_70681_au().nextInt(5) + 2;
                    d3 = MathHelper.func_76133_a((double)d3);
                    if (this.witherStorm.getOwner() != null && this.witherStorm.func_70068_e((Entity)this.witherStorm.getOwner()) > 5184.0 && this.witherStorm.getGuardBlock() == null) {
                        this.witherStorm.field_70159_w += d0 / d3 * 0.2;
                        this.witherStorm.field_70181_x += d1 / d3 * 0.2;
                        this.witherStorm.field_70179_y += d2 / d3 * 0.2;
                    } else if (this.witherStorm.moralRaisedTimer > 200) {
                        this.witherStorm.field_70159_w += d0 / d3 * 0.2;
                        this.witherStorm.field_70181_x += d1 / d3 * 0.2;
                        this.witherStorm.field_70179_y += d2 / d3 * 0.2;
                    } else {
                        this.witherStorm.field_70159_w += d0 / d3 * 0.1;
                        this.witherStorm.field_70181_x += d1 / d3 * 0.1;
                        this.witherStorm.field_70179_y += d2 / d3 * 0.1;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityWitherStorm witherStorm;

        public AIRandomFly(EntityWitherStorm ghast) {
            this.witherStorm = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.witherStorm.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.witherStorm.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.witherStorm.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.witherStorm.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.witherStorm.func_70681_au();
            if (this.witherStorm.getOwner() != null) {
                double d0 = this.witherStorm.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f);
                double d1 = this.witherStorm.getOwner().field_70163_u + 40.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.witherStorm.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f);
                if (this.witherStorm.func_70093_af()) {
                    d0 = this.witherStorm.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f);
                    d1 = this.witherStorm.getOwner().field_70163_u - 60.0 - (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    d2 = this.witherStorm.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f);
                }
                if (this.witherStorm.centerHead.func_184207_aI()) {
                    Vec3d vec3 = this.witherStorm.getOwner().func_70676_i(1.0f);
                    d0 = this.witherStorm.field_70165_t + vec3.field_72450_a * 8.0;
                    d1 = this.witherStorm.field_70163_u + vec3.field_72448_b * 8.0;
                    d2 = this.witherStorm.field_70161_v + vec3.field_72449_c * 8.0;
                }
                this.witherStorm.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            } else {
                EntityPlayer player = this.witherStorm.field_70170_p.func_72890_a((Entity)this.witherStorm, 256.0);
                if (this.witherStorm.func_70638_az() != null) {
                    double d0 = this.witherStorm.func_70638_az().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d1 = (double)this.witherStorm.field_70170_p.func_175672_r(this.witherStorm.func_180425_c()).func_177956_o() + 48.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.witherStorm.func_70638_az().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.witherStorm.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else if (player != null && this.witherStorm.func_70068_e((Entity)player) > 2304.0) {
                    double d0 = player.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d1 = player.field_70163_u + 48.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d2 = player.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.witherStorm.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else {
                    double d0 = this.witherStorm.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d1 = this.witherStorm.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.witherStorm.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    if (d1 < 32.0) {
                        d1 = 32.0;
                    }
                    this.witherStorm.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                }
            }
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityWitherStorm witherStorm;

        public AILookAround() {
            this.witherStorm = EntityWitherStorm.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.witherStorm.func_70638_az() != null) {
                this.witherStorm.func_70671_ap().func_75651_a((Entity)this.witherStorm.func_70638_az(), 3.0f, 0.0f);
            } else if (this.witherStorm.centerHead.func_184207_aI()) {
                Vec3d vec3 = this.witherStorm.centerHead.func_184179_bs().func_70676_i(1.0f);
                this.witherStorm.func_70671_ap().func_75650_a(this.witherStorm.centerHead.func_184179_bs().field_70165_t + vec3.field_72450_a * 8.0, this.witherStorm.centerHead.func_184179_bs().field_70163_u + vec3.field_72448_b * 8.0, this.witherStorm.centerHead.func_184179_bs().field_70161_v + vec3.field_72449_c * 8.0, 180.0f, 0.0f);
            } else {
                this.witherStorm.func_70671_ap().func_75650_a(this.witherStorm.func_70605_aq().func_179917_d(), this.witherStorm.field_70163_u, this.witherStorm.func_70605_aq().func_179918_f(), 3.0f, 0.0f);
            }
        }
    }
}

