/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier6;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIAttackRangedAlly;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.helpful.tier6.EntityWitherStorm;
import net.minecraft.entity.helpful.tier6.EntityWitherStormHead;
import net.minecraft.entity.helpful.tier6.EntityWitherStormSkull;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacle;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacleDevourer;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCommandBlockWither
extends EntityFriendlyCreature
implements IRangedAttackMob,
Massive,
Armored,
Flying,
Undead {
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityCommandBlockWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityCommandBlockWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private float[] field_82220_d = new float[2];
    private float[] field_82221_e = new float[2];
    private float[] field_82217_f = new float[2];
    private float[] field_82218_g = new float[2];
    private int[] field_82223_h = new int[2];
    private int[] field_82224_i = new int[2];
    private int blockBreakCounter;

    public EntityCommandBlockWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(1.0f, 3.3f);
        this.isOffensive = true;
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 3.0, 64.0f, 12.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRangedAlly(this, 1.0, 60, 32.0f));
        this.field_70728_aV = 500;
        this.setLevel(300);
    }

    @Override
    public void updateBossBar() {
        super.updateBossBar();
        if (this.getSize() >= 12250 && this.field_70173_aa % 2 == 0) {
            this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
        } else {
            this.bossInfo.func_186745_a(BossInfo.Color.RED);
        }
        this.bossInfo.func_186741_a(true);
    }

    @Override
    public boolean isABoss() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public boolean canWearEasterEggs() {
        return false;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER6;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return "Wither (Wither Storm)";
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultFittnessStat() {
        return 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
        tagCompound.func_74768_a("Growth", this.getSize());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
        this.Grow(tagCompund.func_74762_e("Growth"));
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void Grow(int p_82215_1_) {
        this.field_70180_af.func_187227_b(SIZE, (Object)p_82215_1_);
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.getSize() >= 5000 ? ModSoundEvents.commandBlockWitherIdle : SoundEvents.field_187925_gy;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    public float func_70047_e() {
        return 2.75f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.945;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.field_70170_p.field_72995_K && this.field_70725_aQ == 1 && this.getOwner() != null) {
            if (!this.field_70170_p.field_72995_K) {
                for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                    entityplayer.func_71029_a((StatBase)AchievementList.field_187977_J);
                }
            }
            for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.1f);
                this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.0f);
                this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 0.9f);
                entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s Wither Storm has been killed!!!", new Object[0]), true);
            }
            ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Wither Storm has been destroyed!", new Object[0]));
        }
    }

    @Override
    public void func_70636_d() {
        int j;
        int i;
        EntityLivingBase entity;
        double d11;
        Block block;
        IBlockState iblockstate;
        BlockPos blockpos;
        this.field_70728_aV = this.getSize();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getSize() < 300 ? 300.0 : (double)this.getSize());
        if (this.field_70163_u < 0.0) {
            this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
        }
        if (this.field_70159_w > 1.0) {
            this.field_70159_w = 1.0;
        }
        if (this.field_70179_y < -1.0) {
            this.field_70179_y = -1.0;
        }
        if (this.field_70181_x > 1.0) {
            this.field_70181_x = 1.0;
        }
        if (this.field_70181_x < -1.0) {
            this.field_70181_x = -1.0;
        }
        if (this.field_70159_w > 1.0) {
            this.field_70159_w = 1.0;
        }
        if (this.field_70179_y < -1.0) {
            this.field_70179_y = -1.0;
        }
        if ((this.field_70173_aa + this.func_145782_y()) % 100 == 0) {
            this.func_184185_a(ModSoundEvents.commandBlockWitherHum, this.getSize() >= 5250 ? 0.25f : 5.0f, 1.0f);
        }
        if (this.getSize() >= 12500 && !this.field_70170_p.field_72995_K) {
            EntityWitherStorm entityzombie = new EntityWitherStorm(this.field_70170_p);
            entityzombie.func_82149_j((Entity)this);
            entityzombie.func_94061_f(this.func_175446_cd());
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            entityzombie.setOwnerId(this.func_184753_b());
            entityzombie.Grow(12500);
            this.Grow(0);
            this.field_70170_p.func_72900_e((Entity)this);
        }
        if (this.field_70173_aa % 160 == 0) {
            this.func_184185_a(ModSoundEvents.commandBlockWitherGrow, 2.0f, 1.0f);
        }
        if (this.field_70173_aa % 30 == 0 && this.getSize() > 5000) {
            this.func_70642_aH();
        }
        if (this.field_70173_aa % 60 == 0 && this.getSize() > 12000) {
            this.func_184185_a(ModSoundEvents.witherStormFirstRoar, 100.0f, 1.0f);
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            int in = MathHelper.func_76128_c((double)(this.field_70165_t - 1.5 + this.field_70146_Z.nextDouble() * 3.0));
            int j2 = MathHelper.func_76128_c((double)(this.field_70163_u + 3.0 - this.field_70146_Z.nextDouble() * 9.0));
            int k = MathHelper.func_76128_c((double)(this.field_70161_v - 1.5 + this.field_70146_Z.nextDouble() * 3.0));
            blockpos = new BlockPos(in, j2, k);
            iblockstate = this.field_70170_p.func_180495_p(blockpos);
            block = iblockstate.func_177230_c();
            if (this.field_70170_p.field_72995_K || block == Blocks.field_150350_a && j2 >= 0) continue;
            this.field_70181_x = 0.05f;
        }
        for (int i1 = 0; i1 < 1 + this.getSize() && i1 <= 1500; ++i1) {
            if (!this.func_70089_S() || this.field_70146_Z.nextInt(50) != 0) continue;
            int i11 = MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)2, (int)24) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            int l1 = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)2, (int)24) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            int i2 = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)2, (int)24) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            blockpos = new BlockPos(l1, i11, i2);
            iblockstate = this.field_70170_p.func_180495_p(blockpos);
            block = iblockstate.func_177230_c();
            if (!this.field_70170_p.func_175710_j(blockpos) || block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_175707_a(blockpos, blockpos) || block.func_176195_g(iblockstate, this.field_70170_p, new BlockPos(l1, i11, i2)) == -1.0f || !this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) continue;
            this.Grow(this.getSize() + 3);
            this.func_70691_i(3.0f);
            if (block.func_149688_o(iblockstate).func_76224_d()) {
                this.field_70170_p.func_175698_g(new BlockPos(l1, i11, i2));
                continue;
            }
            this.field_70170_p.func_72838_d((Entity)new EntityFallingBlock(this.field_70170_p, (double)l1, (double)i11, (double)i2, block.func_176221_a(iblockstate, (IBlockAccess)this.field_70170_p, blockpos)));
        }
        List list = this.field_70170_p.func_175647_a(EntityFallingBlock.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
        if (this.func_70089_S() && list != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityFallingBlock entity2 = (EntityFallingBlock)list.get(i1);
                if (entity2 == null) continue;
                entity2.field_70145_X = entity2.field_70123_F || entity2.field_70124_G;
                double d01 = this.field_70165_t - entity2.field_70165_t;
                double d112 = this.field_70163_u + 1.5 - entity2.field_70163_u;
                double d21 = this.field_70161_v - entity2.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d112 * d112 + d21 * d21));
                entity2.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + entity2.field_70159_w * 0.5;
                entity2.field_70181_x = d112 / (double)f2 * 0.5 * 0.5 + entity2.field_70181_x * 0.5;
                entity2.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + entity2.field_70179_y * 0.5;
                List sublist = this.field_70170_p.func_175647_a(EntityLivingBase.class, entity2.func_174813_aQ(), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                if (!this.func_70089_S() || sublist == null || sublist.isEmpty()) continue;
                for (int i11 = 0; i11 < sublist.size(); ++i11) {
                    EntityLivingBase subentity = (EntityLivingBase)sublist.get(i11);
                    if (subentity == null || this.isOnSameTeam(subentity)) continue;
                    subentity.func_70097_a(DamageSource.field_76368_d, 1.0f);
                }
            }
        }
        List list1 = this.field_70170_p.func_175647_a(EntityFallingBlock.class, this.func_174813_aQ(), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
        if (this.func_70089_S() && list1 != null && !list1.isEmpty()) {
            for (int i1 = 0; i1 < list1.size(); ++i1) {
                EntityFallingBlock entity3 = (EntityFallingBlock)list1.get(i1);
                if (entity3 == null) continue;
                entity3.func_70106_y();
                this.Grow(this.getSize() + 3);
                this.func_70691_i(3.0f);
            }
        }
        List list11 = this.field_70170_p.func_175647_a(EntityItem.class, this.func_174813_aQ().func_72314_b(256.0, 256.0, 256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
        if (this.func_70089_S() && list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                EntityItem entity4 = (EntityItem)list11.get(i1);
                if (entity4 == null) continue;
                double d01 = this.field_70165_t - entity4.field_70165_t;
                d11 = this.field_70163_u + 1.5 - entity4.field_70163_u;
                double d21 = this.field_70161_v - entity4.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                entity4.field_70159_w = d01 / (double)f2 * 0.6 * 0.6 + entity4.field_70159_w * 0.6;
                entity4.field_70181_x = d11 / (double)f2 * 0.6 * 0.6 + entity4.field_70181_x * 0.6;
                entity4.field_70179_y = d21 / (double)f2 * 0.6 * 0.6 + entity4.field_70179_y * 0.6;
            }
        }
        List list111 = this.field_70170_p.func_175647_a(EntityItem.class, this.func_174813_aQ(), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
        if (this.func_70089_S() && list111 != null && !list111.isEmpty()) {
            for (int i1 = 0; i1 < list111.size(); ++i1) {
                EntityItem entity5 = (EntityItem)list111.get(i1);
                if (entity5 == null) continue;
                entity5.func_70106_y();
                this.Grow(this.getSize() + 1 + entity5.func_92059_d().func_190916_E());
                this.func_70691_i(1.0f + (float)entity5.func_92059_d().func_190916_E());
            }
        }
        if (!((entity = this.func_70638_az()) == null || this.getSize() < 6000 || this.isOnSameTeam(entity) || !(entity.func_110143_aJ() > 0.0f) || entity instanceof EntityWitherStorm || entity instanceof EntityWitherStormHead || entity instanceof EntityWitherStormTentacle || entity instanceof EntityWitherStormTentacleDevourer)) {
            List list11111;
            if (!this.field_70170_p.field_72995_K) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, Integer.MAX_VALUE, 1));
            }
            double d01 = this.field_70165_t - entity.field_70165_t;
            d11 = this.field_70163_u + (double)this.func_70047_e() - entity.field_70163_u;
            double d21 = this.field_70161_v - entity.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
            if (entity instanceof EntityPlayer) {
                if (!((EntityPlayer)entity).field_71075_bZ.field_75102_a) {
                    entity.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + entity.field_70159_w * 0.5;
                    entity.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + entity.field_70181_x * 0.5;
                    entity.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + entity.field_70179_y * 0.5;
                }
            } else if (entity instanceof net.minecraft.entity.helpful.tier4.EntityEnderman || entity instanceof EntityEnderman) {
                ((EntityLiving)entity).func_70624_b((EntityLivingBase)this);
            } else if (entity instanceof EntityDragon && entity.func_110143_aJ() <= 1.0f) {
                ((EntityLiving)entity).func_70656_aK();
            } else if (entity instanceof EntityFriendlyCreature && (entity instanceof EntityWitherStorm || entity instanceof EntityWither || entity instanceof EntityEnderDragon || !((EntityFriendlyCreature)entity).func_184222_aU() || ((EntityFriendlyCreature)entity).isHero())) {
                ((EntityLiving)entity).func_70624_b((EntityLivingBase)this);
            } else {
                if (entity instanceof EntityLiving && !entity.func_184222_aU()) {
                    ((EntityLiving)entity).func_70624_b((EntityLivingBase)this);
                }
                entity.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + entity.field_70159_w * 0.5;
                entity.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + entity.field_70181_x * 0.5;
                entity.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + entity.field_70179_y * 0.5;
            }
            if ((list11111 = this.field_70170_p.func_175647_a(EntityLiving.class, this.func_174813_aQ().func_186662_g(1.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}))) != null && !list11111.isEmpty() && this.getSize() >= 6000) {
                for (int i1 = 0; i1 < list11111.size(); ++i1) {
                    EntityLiving entity1 = (EntityLiving)list11111.get(i1);
                    if (entity1 == null || !entity1.func_70089_S() || this.isOnSameTeam((EntityLivingBase)entity1) && !(entity1 instanceof EntityAnimal) || entity instanceof net.minecraft.entity.helpful.tier4.EntityEnderman || entity instanceof EntityEnderman || entity1 instanceof EntityFriendlyCreature || entity1 instanceof EntityDragon || entity1 instanceof EntityWitherStorm || entity1 instanceof EntityWitherStormHead || entity1 instanceof EntityWitherStormTentacle || entity1 instanceof EntityWitherStormTentacleDevourer) continue;
                    if (!this.isWild() && EngenderMod.enableMessages) {
                        this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity1.func_70005_c_() + " was eaten by The Wither Storm (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                    }
                    this.field_70170_p.func_72960_a((Entity)entity1, (byte)3);
                    if (!entity1.func_184222_aU()) {
                        entity1.func_70606_j(0.0f);
                    } else {
                        entity1.func_70106_y();
                    }
                    this.Grow(this.getSize() + 1 + (int)entity1.field_70131_O * (int)entity1.field_70131_O + (int)entity1.field_70130_N * (int)entity1.field_70130_N);
                    this.func_70691_i(1 + (int)entity1.field_70131_O * (int)entity1.field_70131_O + (int)entity1.field_70130_N * (int)entity1.field_70130_N);
                }
            }
        }
        if (this.getSize() >= 1000) {
            this.func_70105_a(2.0f, 4.0f);
        } else {
            this.func_70105_a(1.0f, 3.3f);
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && entity != null) {
            double d1;
            double d0;
            double d3;
            if (this.field_70163_u < entity.field_70163_u || !this.isArmored() && this.field_70163_u < entity.field_70163_u + 4.0 + (double)entity.func_70047_e()) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.35 - this.field_70181_x) * 0.6;
            }
            if ((d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 64.0) {
                if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
                    this.field_70761_aq = this.field_70177_z = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f;
                }
                double d5 = MathHelper.func_76133_a((double)d3);
                if (this.moralRaisedTimer > 200) {
                    this.field_70159_w += (d0 / d5 * 0.35 - this.field_70159_w) * 0.5;
                    this.field_70179_y += (d1 / d5 * 0.35 - this.field_70179_y) * 0.5;
                } else {
                    this.field_70159_w += (d0 / d5 * 0.35 - this.field_70159_w) * 0.6;
                    this.field_70179_y += (d1 / d5 * 0.35 - this.field_70179_y) * 0.6;
                }
            }
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (i = 0; i < 2; ++i) {
            this.field_82220_d[i] = this.func_82204_b(this.field_82220_d[i], this.field_70125_A, 40.0f);
            this.field_82221_e[i] = this.func_82204_b(this.field_82221_e[i], this.field_70761_aq, 10.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            for (i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 1.0, (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                EntityCommandBlockWither.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false);
                this.func_184185_a(ModSoundEvents.commandBlockWitherSpawn, Float.MAX_VALUE, 1.0f);
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), ModSoundEvents.commandBlockWitherSpawn, this.func_184176_by(), Float.MAX_VALUE, 1.0f);
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a75A Wither Storm has been summoned in " + this.field_70170_p.field_73011_w.func_186058_p().func_186065_b() + "!", new Object[0]), true);
                }
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(1.0f);
            }
        } else {
            super.func_70619_bc();
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i11 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                Block block = iblockstate.func_177230_c();
                                if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this)) continue;
                                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public static boolean canDestroyBlock(Block p_181033_0_) {
        return p_181033_0_ != Blocks.field_150357_h && p_181033_0_ != Blocks.field_150384_bq && p_181033_0_ != Blocks.field_150378_br && p_181033_0_ != Blocks.field_150483_bI && p_181033_0_ != Blocks.field_185776_dc && p_181033_0_ != Blocks.field_185777_dd && p_181033_0_ != Blocks.field_180401_cv;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.25;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 1.75 : this.field_70163_u + 2.25;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.25;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.field_70131_O * 0.75, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        float f;
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1024, new BlockPos((Entity)this), 0);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityWitherStormSkull entitywitherskull = new EntityWitherStormSkull(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        if (p_82209_8_) {
            entitywitherskull.setInvulnerable(true);
        }
        entitywitherskull.damage = f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        this.field_70170_p.func_72838_d((Entity)entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        if (!this.isOnSameTeam(p_82196_1_)) {
            this.launchWitherSkullToEntity(0, p_82196_1_);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_94541_c() && source != DamageSource.field_76369_e) {
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.getSize() >= 1000 && (source.func_76352_a() || source.func_76346_g() instanceof EntitySkeleton)) {
                this.func_85034_r(0);
                return false;
            }
            if (this.getSize() >= 5250 && source.func_82725_o()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 10;
            }
            if (source.func_82725_o() && this.getSize() < 5000) {
                amount *= 100.0f;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        EntityItem entityitem = this.func_70099_a(new ItemStack(Blocks.field_150483_bI, 1, 0), 0.0f);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187977_J);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_COMMAND_BLOCK_WITHER;
    }

    @Override
    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        if (!potioneffectIn.func_188419_a().func_76398_f()) {
            super.func_70690_d(potioneffectIn);
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDarkness() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)p_82215_1_);
    }

    public boolean isArmored() {
        return this.getSize() >= 3000;
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }

    public boolean func_184222_aU() {
        return EngenderMod.sensorsShowJzahars(this.field_70170_p);
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return false;
        }
    }
}

