/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5.dragonphases;

import javax.annotation.Nullable;
import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseBaseFriendly;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseList;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.feature.WorldGenEndPodium;

public class PhaseTakeoff
extends PhaseBaseFriendly {
    private boolean firstTick;
    private Path currentPath;
    private Vec3d targetLocation;

    public PhaseTakeoff(EntityEnderDragon dragonIn) {
        super(dragonIn);
    }

    @Override
    public void doLocalUpdate() {
        if (!this.firstTick && this.currentPath != null) {
            BlockPos blockpos = this.dragon.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a);
            double d0 = this.dragon.func_174831_c(blockpos);
            if (d0 > 100.0) {
                this.dragon.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
            }
        } else {
            this.firstTick = false;
            this.dragon.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
        }
    }

    @Override
    public void initPhase() {
        this.firstTick = true;
        this.currentPath = null;
        this.targetLocation = null;
    }

    private void findNewTarget() {
        int i = this.dragon.initPathPoints();
        Vec3d vec3d = this.dragon.getHeadLookVec(1.0f);
        int j = this.dragon.getNearestPpIdx(-vec3d.field_72450_a * 40.0, 105.0, -vec3d.field_72449_c * 40.0);
        j -= 12;
        j &= 7;
        this.currentPath = this.dragon.findPath(i, j += 12, null);
        if (this.currentPath != null) {
            this.currentPath.func_75875_a();
            this.navigateToNextPathNode();
        }
    }

    private void navigateToNextPathNode() {
        double d0;
        Vec3d vec3d = this.currentPath.func_186310_f();
        this.currentPath.func_75875_a();
        while (!((d0 = vec3d.field_72448_b + (double)(this.dragon.func_70681_au().nextFloat() * 20.0f)) >= vec3d.field_72448_b)) {
        }
        this.targetLocation = new Vec3d(vec3d.field_72450_a, d0, vec3d.field_72449_c);
    }

    @Override
    @Nullable
    public Vec3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseList<PhaseTakeoff> getPhaseList() {
        return PhaseList.TAKEOFF;
    }
}

