/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5.dragonphases;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.dragonphases.IPhase;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseApproachOwner;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseBreathing;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseCircle;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseDeath;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseFaceNearestEnemy;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseFireballAndStrafe;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseHoveringOverOwner;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseIdleHover;
import net.minecraft.entity.helpful.tier5.dragonphases.PhasePreBreathing;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseRamAttack;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseTakeoff;

public class PhaseList<T extends IPhase> {
    private static PhaseList<?>[] phases = new PhaseList[0];
    public static final PhaseList<PhaseCircle> HOLDING_PATTERN = PhaseList.create(PhaseCircle.class, "Circle");
    public static final PhaseList<PhaseFireballAndStrafe> STRAFE_PLAYER = PhaseList.create(PhaseFireballAndStrafe.class, "FireballAndStrafe");
    public static final PhaseList<PhaseApproachOwner> LANDING_APPROACH = PhaseList.create(PhaseApproachOwner.class, "ApproachOwner");
    public static final PhaseList<PhaseHoveringOverOwner> LANDING = PhaseList.create(PhaseHoveringOverOwner.class, "HoverOverOwner");
    public static final PhaseList<PhaseTakeoff> TAKEOFF = PhaseList.create(PhaseTakeoff.class, "Takeoff");
    public static final PhaseList<PhaseBreathing> SITTING_FLAMING = PhaseList.create(PhaseBreathing.class, "Breathe");
    public static final PhaseList<PhaseFaceNearestEnemy> SITTING_SCANNING = PhaseList.create(PhaseFaceNearestEnemy.class, "Search");
    public static final PhaseList<PhasePreBreathing> SITTING_ATTACKING = PhaseList.create(PhasePreBreathing.class, "Roar");
    public static final PhaseList<PhaseRamAttack> CHARGING_PLAYER = PhaseList.create(PhaseRamAttack.class, "MeleeAttack");
    public static final PhaseList<PhaseDeath> DYING = PhaseList.create(PhaseDeath.class, "Dying");
    public static final PhaseList<PhaseIdleHover> HOVER = PhaseList.create(PhaseIdleHover.class, "Hover");
    private final Class<? extends IPhase> clazz;
    private final int id;
    private final String name;

    private PhaseList(int idIn, Class<? extends IPhase> clazzIn, String nameIn) {
        this.id = idIn;
        this.clazz = clazzIn;
        this.name = nameIn;
    }

    public IPhase createPhase(EntityEnderDragon dragon) {
        try {
            Constructor<IPhase> constructor = this.getConstructor();
            return constructor.newInstance(dragon);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    protected Constructor<? extends IPhase> getConstructor() throws NoSuchMethodException {
        return this.clazz.getConstructor(EntityEnderDragon.class);
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name + " (#" + this.id + ")";
    }

    public static PhaseList<?> getById(int p_188738_0_) {
        return p_188738_0_ >= 0 && p_188738_0_ < phases.length ? phases[p_188738_0_] : HOLDING_PATTERN;
    }

    public static int getTotalPhases() {
        return phases.length;
    }

    private static <T extends IPhase> PhaseList<T> create(Class<T> phaseIn, String nameIn) {
        PhaseList<T> phaselist = new PhaseList<T>(phases.length, phaseIn, nameIn);
        phases = Arrays.copyOf(phases, phases.length + 1);
        PhaseList.phases[phaselist.getId()] = phaselist;
        return phaselist;
    }
}

