/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5.dragonphases;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAreaEffectCloudOther
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityAreaEffectCloudOther.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityAreaEffectCloudOther.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.func_187226_a(EntityAreaEffectCloudOther.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PARTICLE = EntityDataManager.func_187226_a(EntityAreaEffectCloudOther.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PARTICLE_PARAM_1 = EntityDataManager.func_187226_a(EntityAreaEffectCloudOther.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PARTICLE_PARAM_2 = EntityDataManager.func_187226_a(EntityAreaEffectCloudOther.class, (DataSerializer)DataSerializers.field_187192_b);
    private PotionType potion = PotionTypes.field_185229_a;
    private final List<PotionEffect> effects = Lists.newArrayList();
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 0;
    private int reapplicationDelay = 5;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private EntityFriendlyCreature owner;
    private UUID ownerUniqueId;

    public EntityAreaEffectCloudOther(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.setRadius(3.0f);
    }

    public EntityAreaEffectCloudOther(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(IGNORE_RADIUS, (Object)false);
        this.func_184212_Q().func_187214_a(PARTICLE, (Object)EnumParticleTypes.SPELL_MOB.func_179348_c());
        this.func_184212_Q().func_187214_a(PARTICLE_PARAM_1, (Object)0);
        this.func_184212_Q().func_187214_a(PARTICLE_PARAM_2, (Object)0);
    }

    public void setRadius(float radiusIn) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.func_70105_a(radiusIn * 2.0f, 0.5f);
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setPotion(PotionType potionIn) {
        this.potion = potionIn;
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    private void updateFixedColor() {
        if (this.potion == PotionTypes.field_185229_a && this.effects.isEmpty()) {
            this.func_184212_Q().func_187227_b(COLOR, (Object)0);
        } else {
            this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.effects)));
        }
    }

    public void addEffect(PotionEffect effect) {
        this.effects.add(effect);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int colorIn) {
        this.colorSet = true;
        this.func_184212_Q().func_187227_b(COLOR, (Object)colorIn);
    }

    public EnumParticleTypes getParticle() {
        return EnumParticleTypes.func_179342_a((int)((Integer)this.func_184212_Q().func_187225_a(PARTICLE)));
    }

    public void setParticle(EnumParticleTypes particleIn) {
        this.func_184212_Q().func_187227_b(PARTICLE, (Object)particleIn.func_179348_c());
    }

    public int getParticleParam1() {
        return (Integer)this.func_184212_Q().func_187225_a(PARTICLE_PARAM_1);
    }

    public void setParticleParam1(int particleParam) {
        this.func_184212_Q().func_187227_b(PARTICLE_PARAM_1, (Object)particleParam);
    }

    public int getParticleParam2() {
        return (Integer)this.func_184212_Q().func_187225_a(PARTICLE_PARAM_2);
    }

    public void setParticleParam2(int particleParam) {
        this.func_184212_Q().func_187227_b(PARTICLE_PARAM_2, (Object)particleParam);
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.func_184212_Q().func_187227_b(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.func_184212_Q().func_187225_a(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void func_70071_h_() {
        block31: {
            boolean flag1;
            float f;
            boolean flag;
            block29: {
                int[] aint;
                EnumParticleTypes enumparticletypes;
                block30: {
                    super.func_70071_h_();
                    if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.1, this.field_70161_v)).func_177230_c().func_149662_c(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.1, this.field_70161_v)))) {
                        this.field_70163_u -= 0.2;
                    }
                    if (this.getRadius() <= 0.0f) {
                        this.func_70106_y();
                    }
                    flag = this.shouldIgnoreRadius();
                    f = this.getRadius();
                    if (!this.field_70170_p.field_72995_K) break block29;
                    enumparticletypes = this.getParticle();
                    aint = new int[enumparticletypes.func_179345_d()];
                    if (aint.length > 0) {
                        aint[0] = this.getParticleParam1();
                    }
                    if (aint.length > 1) {
                        aint[1] = this.getParticleParam2();
                    }
                    if (!flag) break block30;
                    if (!this.field_70146_Z.nextBoolean()) break block31;
                    for (int i = 0; i < 2; ++i) {
                        float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                        float f3 = MathHelper.func_76134_b((float)f1) * f2;
                        float f4 = MathHelper.func_76126_a((float)f1) * f2;
                        if (enumparticletypes == EnumParticleTypes.SPELL_MOB) {
                            int j = this.field_70146_Z.nextBoolean() ? 0xFFFFFF : this.getColor();
                            int k = j >> 16 & 0xFF;
                            int l = j >> 8 & 0xFF;
                            int i1 = j & 0xFF;
                            this.field_70170_p.func_190523_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)f4, (double)((float)k / 255.0f), (double)((float)l / 255.0f), (double)((float)i1 / 255.0f), new int[0]);
                            continue;
                        }
                        this.field_70170_p.func_190523_a(enumparticletypes.func_179348_c(), this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)f4, 0.0, 0.0, 0.0, aint);
                    }
                    break block31;
                }
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                    float f8 = MathHelper.func_76134_b((float)f6) * f7;
                    float f9 = MathHelper.func_76126_a((float)f6) * f7;
                    if (enumparticletypes == EnumParticleTypes.SPELL_MOB) {
                        int l1 = this.getColor();
                        int i2 = l1 >> 16 & 0xFF;
                        int j2 = l1 >> 8 & 0xFF;
                        int j1 = l1 & 0xFF;
                        this.field_70170_p.func_190523_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), this.field_70165_t + (double)f8, this.field_70163_u, this.field_70161_v + (double)f9, (double)((float)i2 / 255.0f), (double)((float)j2 / 255.0f), (double)((float)j1 / 255.0f), new int[0]);
                    } else {
                        this.field_70170_p.func_190523_a(enumparticletypes.func_179348_c(), this.field_70165_t + (double)f8, this.field_70163_u, this.field_70161_v + (double)f9, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, aint);
                    }
                    ++k1;
                }
                break block31;
            }
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            boolean bl = flag1 = this.field_70173_aa < this.waitTime;
            if (flag != flag1) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(f);
            }
            if (this.field_70173_aa % 20 == 0) {
                Iterator<Map.Entry<Entity, Integer>> iterator = this.reapplicationDelayMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Entity, Integer> entry = iterator.next();
                    if (this.field_70173_aa < entry.getValue()) continue;
                    iterator.remove();
                }
                ArrayList potions = Lists.newArrayList();
                for (PotionEffect potioneffect1 : this.potion.func_185170_a()) {
                    potions.add(new PotionEffect(potioneffect1.func_188419_a(), potioneffect1.func_76459_b() / 4, potioneffect1.func_76458_c(), potioneffect1.func_82720_e(), potioneffect1.func_188418_e()));
                }
                potions.addAll(this.effects);
                if (potions.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(1.0));
                    if (!list.isEmpty() && this.getOwner() != null) {
                        for (EntityLivingBase entitylivingbase : list) {
                            double d1;
                            double d0;
                            double d2;
                            if (this.reapplicationDelayMap.containsKey(entitylivingbase) || !entitylivingbase.func_184603_cC() || !((d2 = (d0 = entitylivingbase.field_70165_t - this.field_70165_t) * d0 + (d1 = entitylivingbase.field_70161_v - this.field_70161_v) * d1) <= (double)(f * f))) continue;
                            this.reapplicationDelayMap.put((Entity)entitylivingbase, this.field_70173_aa + 5);
                            if (this.getOwner().isOnSameTeam(entitylivingbase)) {
                                for (PotionEffect potioneffect : potions) {
                                    if (potioneffect.func_188419_a().func_76403_b()) {
                                        potioneffect.func_188419_a().func_180793_a((Entity)this, (Entity)this.getOwner(), entitylivingbase, potioneffect.func_76458_c(), 0.5);
                                        continue;
                                    }
                                    if (potioneffect.func_188419_a().func_76398_f()) continue;
                                    entitylivingbase.func_70690_d(new PotionEffect(potioneffect));
                                }
                            } else {
                                for (PotionEffect potioneffect : potions) {
                                    if (potioneffect.func_188419_a().func_76403_b()) {
                                        this.getOwner().inflictEngenderMobDamage(entitylivingbase, " found a pool of death created by ", new EntityDamageSource("indirectMagic", (Entity)this.getOwner()).func_82726_p().func_76348_h().func_151518_m(), 6.0f);
                                        continue;
                                    }
                                    if (!potioneffect.func_188419_a().func_76398_f()) continue;
                                    entitylivingbase.func_70690_d(new PotionEffect(potioneffect));
                                }
                                this.getOwner().inflictEngenderMobDamage(entitylivingbase, " found a pool of death created by ", new EntityDamageSource("indirectMagic", (Entity)this.getOwner()).func_82726_p().func_76348_h().func_151518_m(), 6.0f);
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.func_70106_y();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.func_70106_y();
                            return;
                        }
                    }
                }
            }
        }
    }

    public void setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    public void setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
    }

    public void setOwner(@Nullable EntityFriendlyCreature ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    @Nullable
    public EntityFriendlyCreature getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUniqueId)) instanceof EntityFriendlyCreature) {
            this.owner = (EntityFriendlyCreature)entity;
        }
        return this.owner;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151069_bo) {
            this.setRadius(this.getRadius() - 0.5f);
            this.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187618_I, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            this.turnBottleIntoItem(stack, player, new ItemStack(Items.field_185157_bK));
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    protected ItemStack turnBottleIntoItem(ItemStack p_185061_1_, EntityPlayer player, ItemStack stack) {
        p_185061_1_.func_190918_g(1);
        player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
        if (p_185061_1_.func_190926_b()) {
            return stack;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
        return p_185061_1_;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        EnumParticleTypes enumparticletypes;
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.durationOnUse = compound.func_74762_e("DurationOnUse");
        this.radiusOnUse = compound.func_74760_g("RadiusOnUse");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
        if (compound.func_150297_b("Particle", 8) && (enumparticletypes = EnumParticleTypes.func_186831_a((String)compound.func_74779_i("Particle"))) != null) {
            this.setParticle(enumparticletypes);
            this.setParticleParam1(compound.func_74762_e("ParticleParam1"));
            this.setParticleParam2(compound.func_74762_e("ParticleParam2"));
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_150297_b("Potion", 8)) {
            this.setPotion(PotionUtils.func_185187_c((NBTTagCompound)compound));
        }
        if (compound.func_150297_b("Effects", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttaglist.func_150305_b(i));
                if (potioneffect == null) continue;
                this.addEffect(potioneffect);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74768_a("DurationOnUse", this.durationOnUse);
        compound.func_74776_a("RadiusOnUse", this.radiusOnUse);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        compound.func_74778_a("Particle", this.getParticle().func_179346_b());
        compound.func_74768_a("ParticleParam1", this.getParticleParam1());
        compound.func_74768_a("ParticleParam2", this.getParticleParam2());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
        if (this.colorSet) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (this.potion != PotionTypes.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)this.potion)).toString());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.effects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("Effects", (NBTBase)nbttaglist);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.func_184206_a(key);
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public boolean func_70067_L() {
        return true;
    }
}

