/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.MobChunkLoader;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIAttackRangedAlly;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier5.EntityWitherSkullOther;
import net.minecraft.entity.helpful.tier6.EntityCommandBlockWither;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWither
extends EntityFriendlyCreature
implements IEntityMultiPart,
IRangedAttackMob,
IJumpingMount,
Flying,
Armored,
Undead {
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private float[] xRotationHeads = new float[2];
    private float[] yRotationHeads = new float[2];
    private float[] xRotOHeads = new float[2];
    private float[] yRotOHeads = new float[2];
    private int[] nextHeadUpdate = new int[2];
    private int[] idleHeadUpdates = new int[2];
    private float[] headRandomTurn = new float[2];
    private static final DataParameter<Integer> HOVERTIMER = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RAMTIMER = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SPAWNEDSKELETONS = EntityDataManager.func_187226_a(EntityWither.class, (DataSerializer)DataSerializers.field_187198_h);
    private double hoverX;
    private double hoverZ;
    public EntityDragonPart[] partArray;
    public EntityDragonPart mainHead = new EntityDragonPart((IEntityMultiPart)this, "mainHead", 1.0f, 1.0f);
    public EntityDragonPart rightHead = new EntityDragonPart((IEntityMultiPart)this, "rightHead", 0.75f, 0.75f);
    public EntityDragonPart leftHead = new EntityDragonPart((IEntityMultiPart)this, "leftHead", 0.75f, 0.75f);
    public EntityDragonPart spine = new EntityDragonPart((IEntityMultiPart)this, "spine", 0.4f, 1.6f);
    public EntityDragonPart lowerspine = new EntityDragonPart((IEntityMultiPart)this, "lowerspine", 0.4f, 0.6f);
    public EntityDragonPart rightRibs = new EntityDragonPart((IEntityMultiPart)this, "rightRibs", 0.5f, 0.8f);
    public EntityDragonPart leftRibs = new EntityDragonPart((IEntityMultiPart)this, "leftRibs", 0.5f, 0.8f);
    public EntityDragonPart rightsupport = new EntityDragonPart((IEntityMultiPart)this, "rightsupport", 0.4f, 0.4f);
    public EntityDragonPart leftsupport = new EntityDragonPart((IEntityMultiPart)this, "leftsupport", 0.4f, 0.4f);
    private int blockBreakCounter;
    private int lastActiveTime;
    private int timeSinceIgnited;
    protected float jumpPower;

    public EntityWither(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.mainHead, this.rightHead, this.leftHead, this.spine, this.lowerspine, this.rightRibs, this.leftRibs, this.rightsupport, this.leftsupport};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.3f);
        this.isOffensive = true;
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 4.0, 100.0f, 16.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRangedAlly(this, 4.0, 50, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70158_ak = true;
        this.field_70728_aV = 500;
    }

    @Override
    public int getNextLevelRequirement() {
        return 2500;
    }

    public boolean hasSpawnedSkeletons() {
        return (Boolean)this.func_184212_Q().func_187225_a(SPAWNEDSKELETONS);
    }

    public void setCanSpawnSkeletons(boolean childZombie) {
        this.func_184212_Q().func_187227_b(SPAWNEDSKELETONS, (Object)childZombie);
    }

    @Override
    public void updateBossBar() {
        super.updateBossBar();
        this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
        this.bossInfo.func_186741_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / 30.0f;
    }

    @Override
    public boolean isABoss() {
        return true;
    }

    @Override
    public boolean affectedByCommandingStaff() {
        return false;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    @Override
    public int getSpawnTimer() {
        return 1;
    }

    @Override
    public float getBonusVSLight() {
        return 1.5f;
    }

    @Override
    public float getBonusVSArmored() {
        return 2.0f;
    }

    @Override
    public float getBonusVSFlying() {
        return 4.0f;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(HOVERTIMER, (Object)0);
        this.field_70180_af.func_187214_a(RAMTIMER, (Object)0);
        this.func_184212_Q().func_187214_a(SPAWNEDSKELETONS, (Object)false);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("SpawnSkeletons", this.hasSpawnedSkeletons());
        tagCompound.func_74768_a("Invul", this.getInvulTime());
        tagCompound.func_74768_a("Hover", this.getHoverTime());
        tagCompound.func_74768_a("Ram", this.getRamTime());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setCanSpawnSkeletons(tagCompund.func_74767_n("SpawnSkeletons"));
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
        this.setHoverTime(tagCompund.func_74762_e("Hover"));
        this.setRamTime(tagCompund.func_74762_e("Ram"));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187925_gy;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return this.func_70093_af() ? this.field_70131_O * 0.83f - 0.1f : this.field_70131_O * 0.83f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.945;
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            int i;
            if (this.getInvulTime() > 0) {
                int i2 = this.getInvulTime() - 1;
                if (i2 <= 0) {
                    EntityWither.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.isHero() ? 35.0f : 7.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
                }
                this.setInvulTime(i2);
                if (this.field_70173_aa % 1 == 0) {
                    this.func_70691_i(1.0f);
                }
            }
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            entitylivingbase.field_70143_R *= 0.0f;
            entitylivingbase.field_70172_ad = 40;
            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 40, 4));
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.2f;
            if (((EntityLivingBase)this.func_184179_bs()).field_70702_br != 0.0f && this.field_70173_aa % 10 == 0 && !this.field_70170_p.field_72995_K) {
                Vec3d vec3 = entitylivingbase.func_70676_i(1.0f);
                double d0 = entitylivingbase.field_70165_t + vec3.field_72450_a * 50.0;
                double d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() + vec3.field_72448_b * 50.0;
                double d2 = entitylivingbase.field_70161_v + vec3.field_72449_c * 50.0;
                this.launchWitherSkullToCoords(0, d0, d1, d2, this.field_70146_Z.nextFloat() < 0.001f);
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            for (i = 0; i < 256; ++i) {
                int k;
                int j;
                int in = MathHelper.func_76128_c((double)(this.field_70165_t - 1.5 + this.field_70146_Z.nextDouble() * 3.0));
                BlockPos blockpos = new BlockPos(in, j = MathHelper.func_76128_c((double)(this.field_70163_u + 3.0 - this.field_70146_Z.nextDouble() * 8.0)), k = MathHelper.func_76128_c((double)(this.field_70161_v - 1.5 + this.field_70146_Z.nextDouble() * 3.0)));
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (block == Blocks.field_150350_a) continue;
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.01, this.field_70161_v);
            }
            if (this.jumpPower > 0.0f) {
                this.field_70181_x += (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.jumpPower = 0.0f;
            }
            for (i = 1; i < 3; ++i) {
                int i1;
                if (this.field_70170_p.field_72995_K || this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[k2] = this.idleHeadUpdates[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (!this.func_70093_af() && entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.idleHeadUpdates[i - 1] = 0;
                        if (this.moralRaisedTimer > 200) {
                            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 20 + this.field_70146_Z.nextInt(10);
                            continue;
                        }
                        this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase1 = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase1 != this && entitylivingbase1.func_70089_S() && this.func_70685_l((Entity)entitylivingbase1) && (!this.isOnSameTeam(entitylivingbase1) || entitylivingbase1 instanceof EntityFriendlyCreature && this.isOnSameTeam(entitylivingbase1) && entitylivingbase1 != this && ((EntityFriendlyCreature)entitylivingbase1).getFakeHealth() > 0.0f && this.getFakeHealth() > 0.0f) && entitylivingbase1 != this.getOwner()) {
                        if (entitylivingbase1 instanceof EntityPlayer) {
                            if (!((EntityPlayer)entitylivingbase1).field_71075_bZ.field_75102_a) {
                                this.updateWatchedTargetId(i, entitylivingbase1.func_145782_y());
                            }
                        } else {
                            this.updateWatchedTargetId(i, entitylivingbase1.func_145782_y());
                        }
                    }
                    if (entitylivingbase1 != this && entitylivingbase1.func_70089_S() && this.func_70685_l((Entity)entitylivingbase1) && !this.isOnSameTeam(entitylivingbase1) && entitylivingbase1 != this.getOwner()) continue;
                    list.remove(entitylivingbase1);
                }
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else if (this.func_70638_az() != null) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_180799_ab()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float f = 0.95f;
                float f1 = 0.16277136f / (f * f * f);
                this.func_70060_a(strafe, forward, 0.02f);
                f = 0.95f;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void performSpecialAttack() {
        this.func_70642_aH();
        this.func_184185_a(ModSoundEvents.witherSpecial, 10.0f, 1.0f);
        this.setSpecialAttackTimer(1600);
    }

    @Override
    public boolean func_180427_aV() {
        return this.getInvulTime() > 1 || super.func_180427_aV();
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public void becomeAHero() {
        super.becomeAHero();
        this.func_82206_m();
    }

    @Override
    public void func_70636_d() {
        int j;
        int i;
        if (!this.func_175446_cd() && !this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                float f = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                if (d < (double)(this.reachWidth * this.reachWidth + f * f2) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 10 == 0) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            }
            if (this.func_70089_S()) {
                MobChunkLoader.updateLoaded((Entity)this);
            } else {
                MobChunkLoader.stopLoading((Entity)this);
            }
        }
        this.setRamTime(this.getRamTime() - 1);
        this.setHoverTime(this.getHoverTime() - 1);
        if (this.hoverX == 0.0) {
            this.hoverX = this.field_70165_t;
        }
        if (this.hoverZ == 0.0) {
            this.hoverZ = this.field_70161_v;
        }
        for (int i2 = 0; i2 < this.nextHeadUpdate.length; ++i2) {
            if (this.nextHeadUpdate[i2] <= 90) continue;
            this.xRotationHeads[i2] = this.func_82204_b(this.xRotationHeads[i2], 90.0f, 15.0f);
        }
        float f2 = this.field_70761_aq * ((float)Math.PI / 180);
        float f19 = MathHelper.func_76126_a((float)f2);
        float f3 = MathHelper.func_76134_b((float)f2);
        double ex = !this.field_70122_E && !this.func_184207_aI() && !this.func_82150_aj() ? (double)(MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.2f)) * 0.2f) : 0.0;
        this.mainHead.func_70071_h_();
        this.mainHead.func_70012_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() - 0.4 + ex, this.field_70161_v, 0.0f, 0.0f);
        this.rightHead.func_70071_h_();
        this.rightHead.func_70012_b(this.field_70165_t - (double)(f3 * 1.15f), this.field_70163_u + (double)this.func_70047_e() - 0.7 + ex, this.field_70161_v - (double)(f19 * 1.15f), 0.0f, 0.0f);
        this.leftHead.func_70071_h_();
        this.leftHead.func_70012_b(this.field_70165_t + (double)(f3 * 1.15f), this.field_70163_u + (double)this.func_70047_e() - 0.7 + ex, this.field_70161_v + (double)(f19 * 1.15f), 0.0f, 0.0f);
        this.rightsupport.func_70071_h_();
        this.rightsupport.func_70012_b(this.field_70165_t - (double)(f3 * 0.5f), this.field_70163_u + (double)this.func_70047_e() - 0.8 + ex, this.field_70161_v - (double)(f19 * 0.5f), 0.0f, 0.0f);
        this.leftsupport.func_70071_h_();
        this.leftsupport.func_70012_b(this.field_70165_t + (double)(f3 * 0.5f), this.field_70163_u + (double)this.func_70047_e() - 0.8 + ex, this.field_70161_v + (double)(f19 * 0.5f), 0.0f, 0.0f);
        this.spine.func_70071_h_();
        this.spine.func_70012_b(this.field_70165_t - (double)(f19 * (-0.25f + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f + (float)Math.PI)) * 0.1f)), this.field_70163_u + 0.75 + ex, this.field_70161_v - (double)(f3 * (0.25f - MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f + (float)Math.PI)) * 0.1f)), 0.0f, 0.0f);
        this.lowerspine.func_70071_h_();
        this.lowerspine.func_70012_b(this.field_70165_t - (double)(f19 * (-0.75f + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f - 1.0f + (float)Math.PI)) * 0.2f)), this.field_70163_u + 0.25 + ex, this.field_70161_v - (double)(f3 * (0.75f - MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f - 1.0f + (float)Math.PI)) * 0.2f)), 0.0f, 0.0f);
        this.rightRibs.func_70071_h_();
        this.rightRibs.func_70012_b(this.spine.field_70165_t + (double)(f3 * 0.375f), this.field_70163_u + 0.95 + ex, this.spine.field_70161_v + (double)(f19 * 0.375f), 0.0f, 0.0f);
        this.leftRibs.func_70071_h_();
        this.leftRibs.func_70012_b(this.spine.field_70165_t - (double)(f3 * 0.375f), this.field_70163_u + 0.95 + ex, this.spine.field_70161_v - (double)(f19 * 0.375f), 0.0f, 0.0f);
        if (!this.field_70170_p.field_72995_K && this.getInvulTime() <= 1) {
            Entity entity;
            if (this.isArmored() && !this.hasSpawnedSkeletons()) {
                this.field_70181_x = -(0.9 + this.field_70181_x);
            } else if (this.getWatchedTargetId(0) > 0 && this.func_184179_bs() == null && !(this.func_184179_bs() instanceof EntityPlayer) && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
                double d1;
                double d0;
                double d3;
                if (entity instanceof EntityWither || entity instanceof EntityCommandBlockWither) {
                    for (int i3 = 0; i3 < 256; ++i3) {
                        int k;
                        int j2;
                        int in = MathHelper.func_76128_c((double)(this.field_70165_t - 1.5 + this.field_70146_Z.nextDouble() * 3.0));
                        BlockPos blockpos = new BlockPos(in, j2 = MathHelper.func_76128_c((double)(this.field_70163_u + 3.0 - this.field_70146_Z.nextDouble() * 8.0)), k = MathHelper.func_76128_c((double)(this.field_70161_v - 1.5 + this.field_70146_Z.nextDouble() * 3.0)));
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = iblockstate.func_177230_c();
                        if (block == Blocks.field_150350_a) continue;
                        this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.01, this.field_70161_v);
                    }
                    if ((double)this.func_70032_d(entity) > 4.0 && this.getRamTime() <= 0) {
                        this.hoverX = entity.field_70165_t;
                        this.hoverZ = entity.field_70161_v;
                        if (!(entity instanceof EntityWither) && !(entity instanceof EntityCommandBlockWither) && this.field_70163_u < entity.field_70163_u) {
                            this.field_70122_E = false;
                            this.field_70160_al = true;
                            this.field_70181_x += 0.5 - this.field_70181_x;
                        }
                        if (!(entity instanceof EntityWither) && !(entity instanceof EntityCommandBlockWither) && this.field_70163_u > entity.field_70163_u) {
                            this.field_70122_E = false;
                            this.field_70160_al = true;
                            this.field_70181_x -= 0.5 + this.field_70181_x;
                        }
                    }
                }
                if (!(entity instanceof EntityWither) && !(entity instanceof EntityCommandBlockWither)) {
                    double d = this.isArmored() ? entity.field_70163_u - (this.hasSpawnedSkeletons() ? 8.0 : 1.0) : entity.field_70163_u + 4.0 + (double)entity.func_70047_e();
                    if (this.field_70163_u < d) {
                        this.field_70122_E = false;
                        this.field_70160_al = true;
                        this.field_70181_x += 0.5 - this.field_70181_x;
                    }
                }
                if (!(entity instanceof EntityWither) && !(entity instanceof EntityCommandBlockWither)) {
                    double d = entity.field_70163_u;
                    double d2 = this.isArmored() ? entity.field_70163_u - (this.hasSpawnedSkeletons() ? 8.0 : 1.0) : entity.field_70163_u + 5.0 + (double)entity.func_70047_e();
                    if (this.field_70163_u > d + d2) {
                        this.field_70122_E = false;
                        this.field_70160_al = true;
                        this.field_70181_x -= 0.5 + this.field_70181_x;
                    }
                }
                this.func_70625_a(entity, 180.0f, 40.0f);
                if ((this.getHoverTime() > 40 && !this.isArmored() || this.isArmored() && this.getRamTime() < 140 && this.getRamTime() > 100) && (d3 = (d0 = this.hoverX - this.field_70165_t) * d0 + (d1 = this.hoverZ - this.field_70161_v) * d1) > 36.0) {
                    double d5 = MathHelper.func_76133_a((double)d3);
                    if (this.moralRaisedTimer > 200 || this.isArmored() || this.getRamTime() < 140 && this.getRamTime() > 100) {
                        this.field_70159_w += d0 / d5 * 1.8 - this.field_70159_w;
                        this.field_70179_y += d1 / d5 * 1.8 - this.field_70179_y;
                    } else {
                        this.field_70159_w += d0 / d5 * 0.6 - this.field_70159_w;
                        this.field_70179_y += d1 / d5 * 0.6 - this.field_70179_y;
                    }
                }
            }
            if (this.isArmored()) {
                if (!this.hasSpawnedSkeletons() && this.isArmored() && this.field_70122_E) {
                    EntityWither.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.isHero() ? 35.0f : 7.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
                    for (int a = 0; a < 4; ++a) {
                        EntitySkeleton entityliving = new EntitySkeleton(this.field_70170_p);
                        entityliving.func_82149_j((Entity)this);
                        entityliving.field_70759_as = entityliving.field_70177_z;
                        entityliving.field_70761_aq = entityliving.field_70177_z;
                        entityliving.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityliving)), null);
                        entityliving.setSkeletonType(1);
                        entityliving.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                        if (entityliving.func_70681_au().nextInt(2) > 0) {
                            entityliving.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151052_q));
                        }
                        this.field_70170_p.func_72838_d((Entity)entityliving);
                        entityliving.setOwnerId(this.func_184753_b());
                    }
                    this.setCanSpawnSkeletons(true);
                }
                if (this.getRamTime() <= 0 && this.func_70638_az() != null) {
                    this.setRamTime(200);
                    this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 0.0f);
                }
                if (this.getRamTime() == 120) {
                    double d1 = this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) > 24.0 ? (double)this.func_70032_d((Entity)this.func_70638_az()) : 24.0;
                    Vec3d vec3d = this.func_70676_i(1.0f);
                    this.hoverX = this.field_70165_t + vec3d.field_72450_a * d1;
                    this.hoverZ = this.field_70161_v + vec3d.field_72449_c * d1;
                }
                if (this.getRamTime() < 140 && this.getRamTime() > 100) {
                    this.field_70181_x = -0.1;
                    double d0 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) * 5.0;
                    double d1 = (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) * 2.0;
                    double d2 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) * 5.0;
                    List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(5.0));
                    if (!list.isEmpty()) {
                        for (int i1 = 0; i1 < list.size(); ++i1) {
                            EntityLivingBase entity2;
                            Entity e = (Entity)list.get(i1);
                            if (!e.func_70089_S() || !(e instanceof EntityLivingBase) || this.isOnSameTeam(entity2 = (EntityLivingBase)e)) continue;
                            double d3 = entity2.field_70165_t - d0;
                            double d4 = entity2.field_70161_v - d1;
                            double d5 = entity2.field_70161_v - d2;
                            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
                            this.inflictEngenderMobDamage(entity2, " was rammed into by ", DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 2.0f);
                            entity2.field_70177_z = entity2.field_70759_as = (float)MathHelper.func_181159_b((double)entity2.field_70179_y, (double)entity2.field_70159_w) * 57.295776f - 90.0f;
                            entity2.field_70761_aq = entity2.field_70759_as;
                            entity2.func_70604_c(null);
                            if (entity2 instanceof EntityLiving) {
                                ((EntityLiving)entity2).func_70624_b(null);
                            }
                            entity2.func_70024_g(d3 / d6 * 5.0, d4 / d6 * 1.0, d5 / d6 * 5.0);
                        }
                    }
                    if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
                        int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                        int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                        boolean flag = false;
                        for (int k2 = -2; k2 <= 2; ++k2) {
                            for (int l2 = -2; l2 <= 2; ++l2) {
                                for (int j3 = -1; j3 <= 3; ++j3) {
                                    int i3 = l1 + k2;
                                    int k = i11 + j3;
                                    int l = i2 + l2;
                                    BlockPos blockpos = new BlockPos(i3, k, l);
                                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                    Block block = iblockstate.func_177230_c();
                                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos)) continue;
                                    if (!EntityWither.canDestroyBlock(block)) continue;
                                    flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                                }
                            }
                        }
                        if (flag) {
                            this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
                        }
                    }
                }
            } else {
                if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.getHoverTime() <= 120 && this.getHoverTime() >= 60 && this.field_70173_aa % 20 == 0) {
                    this.func_82196_d(this.func_70638_az(), 1.0f);
                }
                if (this.func_70638_az() != null && this.getHoverTime() <= 0) {
                    this.setHoverTime(120);
                    this.hoverX = this.func_70638_az().field_70165_t + this.field_70146_Z.nextGaussian() * 10.0;
                    this.hoverZ = this.func_70638_az().field_70161_v + this.field_70146_Z.nextGaussian() * 10.0;
                }
            }
        }
        if (this.func_70093_af() || this.getRamTime() < 180 && this.getRamTime() > 100) {
            this.func_70105_a(0.9f, 2.3f);
        } else {
            this.func_70105_a(0.9f, 3.3f);
        }
        if (this.field_70181_x < 0.0 || this.func_70638_az() != null && !this.func_184207_aI()) {
            this.field_70181_x *= 0.6;
        }
        if (this.func_70093_af() || this.getInvulTime() > 0) {
            this.func_70624_b(null);
        }
        if (this.field_70163_u < 0.0) {
            this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (i = 0; i < 2; ++i) {
            if (this.func_70638_az() != null) {
                this.headRandomTurn[i] = 0.0f;
            }
            int j4 = this.getWatchedTargetId(i + 1);
            Entity entity1 = null;
            if (j4 > 0) {
                entity1 = this.field_70170_p.func_73045_a(j4);
            }
            if (entity1 != null) {
                double d1 = this.func_82214_u(i + 1);
                double d3 = this.func_82208_v(i + 1);
                double d5 = this.func_82213_w(i + 1);
                double d6 = entity1.field_70165_t - d1;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d3;
                double d8 = entity1.field_70161_v - d5;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
                float f1 = (float)(-(Math.atan2(d7, d9) * 180.0 / Math.PI));
                this.xRotationHeads[i] = this.func_82204_b(this.xRotationHeads[i], f1, 40.0f);
                this.yRotationHeads[i] = this.func_82204_b(this.yRotationHeads[i], f, 10.0f);
                continue;
            }
            if ((this.field_70173_aa + this.func_145782_y()) % 400 == 0) {
                this.headRandomTurn[0] = this.field_70146_Z.nextFloat() * 360.0f - 180.0f;
            }
            if ((this.field_70173_aa + this.func_145782_y()) % 400 == 0) {
                this.headRandomTurn[1] = this.field_70146_Z.nextFloat() * 360.0f - 180.0f;
            }
            this.yRotationHeads[i] = this.func_82204_b(this.yRotationHeads[i], this.field_70760_ar + (this.field_70761_aq - this.field_70760_ar) + this.headRandomTurn[i], 2.0f);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.isHero() && this.getSpecialAttackTimer() == 1400) {
            EntityWither.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false);
            this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity) && entity.func_184222_aU() && !(entity instanceof EntityFriendlyCreature)) {
                        entity.field_70172_ad = 0;
                        entity.func_70097_a(DamageSource.field_76377_j, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_82728_o, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76367_g, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_188407_q, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76369_e, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76379_h, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_82729_p, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_188406_j, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76372_a, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76368_d, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76371_c, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_180137_b, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76370_b, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_76366_f, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_82727_n, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_190095_e, Float.MAX_VALUE);
                        entity.func_70097_a(DamageSource.field_191552_t, Float.MAX_VALUE);
                        entity.func_70097_a(new DamageSource("generic").func_76348_h().func_151518_m(), Float.MAX_VALUE);
                        if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                        entity.func_70106_y();
                        this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " doesn't exist anymore...", new Object[0]));
                        continue;
                    }
                    list.remove(entity);
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.isHero() && this.getSpecialAttackTimer() >= 1400) {
                for (int i1 = 0; i1 < 128; ++i1) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 1.75, this.field_70161_v, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                }
            }
        }
        boolean flag = this.isArmored();
        for (j = 0; j < 3; ++j) {
            double d10 = this.func_82214_u(j);
            double d2 = this.func_82208_v(j);
            double d4 = this.func_82213_w(j);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5, new int[0]);
        }
        if (this.func_70090_H()) {
            for (j = 0; j < this.partArray.length; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.partArray[j].field_70165_t + this.field_70146_Z.nextGaussian() * (double)(this.partArray[j].field_70130_N / 2.0f), this.partArray[j].field_70163_u + this.field_70146_Z.nextDouble() * (double)(this.partArray[j].field_70130_N / 2.0f), this.partArray[j].field_70161_v + this.field_70146_Z.nextGaussian() * (double)(this.partArray[j].field_70130_N / 2.0f), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.getInvulTime() > 0) {
            for (j = 0; j < 3; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian() * 1.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian() * 1.0, (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                EntityWither.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.isHero() ? 35.0f : 7.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(1.0f);
            }
        } else {
            super.func_70619_bc();
            if (this.func_70638_az() == null && this.isArmored() && this.field_70146_Z.nextInt(400) == 0) {
                this.setInvulTime(220);
                this.field_70173_aa = 0;
                this.func_70642_aH();
                this.func_184185_a(ModSoundEvents.createMob, 10.0f, 0.75f);
                this.func_184185_a(ModSoundEvents.createBossMob, 1.0E7f, 1.0f);
            }
            for (int i = 1; i < 3; ++i) {
                int i1;
                if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.field_70173_aa + 20 + this.field_70146_Z.nextInt(20);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int k2 = i - 1;
                    int l2 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[k2] = this.idleHeadUpdates[i - 1] + 1;
                    if (l2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                        this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((i1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(i1);
                    if (!this.func_70093_af() && entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 2000.0 && this.func_70685_l(entity)) {
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.idleHeadUpdates[i - 1] = 0;
                        if (this.moralRaisedTimer > 200) {
                            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 20 + this.field_70146_Z.nextInt(10) - (int)(this.func_110148_a(DEXTERITY).func_111125_b() * 0.1);
                            continue;
                        }
                        this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20) - (int)(this.func_110148_a(DEXTERITY).func_111125_b() * 0.2);
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                for (int k1 = 0; k1 < 10 && !list.isEmpty(); ++k1) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase) && (!this.isOnSameTeam(entitylivingbase) || this.func_70638_az() != null && this.field_70146_Z.nextInt(120) == 0)) {
                        this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                        continue;
                    }
                    if (entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase) && (!this.isOnSameTeam(entitylivingbase) || this.field_70146_Z.nextInt(80) != 0)) continue;
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.updateWatchedTargetId(0, this.func_70638_az().func_145782_y());
            } else {
                this.updateWatchedTargetId(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i11 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                Block block = iblockstate.func_177230_c();
                                if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !EntityWither.canDestroyBlock(block)) continue;
                                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    public static boolean canDestroyBlock(Block p_181033_0_) {
        return p_181033_0_ != Blocks.field_150357_h && p_181033_0_ != Blocks.field_150384_bq && p_181033_0_ != Blocks.field_150378_br && p_181033_0_ != Blocks.field_150483_bI && p_181033_0_ != Blocks.field_185776_dc && p_181033_0_ != Blocks.field_185777_dd && p_181033_0_ != Blocks.field_180401_cv;
    }

    public void func_82206_m() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            if (p_70652_1_ instanceof EntityLivingBase) {
                this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa(), (EntityLivingBase)p_70652_1_, MobEffects.field_82731_v, 10, 1);
            }
            if (!p_70652_1_.func_70089_S()) {
                this.func_70691_i(10.0f);
            } else {
                this.func_174815_a((EntityLivingBase)this, p_70652_1_);
            }
            return true;
        }
        return false;
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * (1.25 * this.func_110148_a(FITTNESS).func_111126_e());
    }

    private double func_82208_v(int p_82208_1_) {
        return this.func_70093_af() ? this.field_70163_u + 1.25 * this.func_110148_a(FITTNESS).func_111126_e() : this.field_70163_u + 2.25 * this.func_110148_a(FITTNESS).func_111126_e();
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70110_aj() {
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * (1.25 * this.func_110148_a(FITTNESS).func_111126_e());
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f3 > p_82204_3_) {
            f3 = p_82204_3_;
        }
        if (f3 < -p_82204_3_) {
            f3 = -p_82204_3_;
        }
        return p_82204_1_ + f3;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        if (!this.isOnSameTeam(p_82216_2_)) {
            this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t + p_82216_2_.field_70159_w * p_82216_2_.field_70159_w, p_82216_2_.field_70163_u + (p_82216_2_.field_70131_O > 8.0f ? 7.0 : (double)p_82216_2_.field_70131_O * 0.5), p_82216_2_.field_70161_v + p_82216_2_.field_70179_y * p_82216_2_.field_70179_y, p_82216_1_ == 0 && !p_82216_2_.func_70685_l((Entity)this));
        }
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_, boolean p_82209_8_) {
        float f;
        this.func_184185_a(SoundEvents.field_187853_gC, this.func_70599_aP(), 1.0f);
        double d3 = this.func_82214_u(p_82209_1_);
        double d4 = this.func_82208_v(p_82209_1_);
        double d5 = this.func_82213_w(p_82209_1_);
        double d6 = p_82209_2_ - d3;
        double d7 = p_82209_4_ - d4;
        double d8 = p_82209_6_ - d5;
        EntityWitherSkullOther entitywitherskull = new EntityWitherSkullOther(this.field_70170_p, (EntityLivingBase)this, d6, d7, d8);
        if (p_82209_8_) {
            entitywitherskull.func_82343_e(true);
        }
        entitywitherskull.damage = f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        entitywitherskull.field_70163_u = d4;
        entitywitherskull.field_70165_t = d3;
        entitywitherskull.field_70161_v = d5;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)entitywitherskull);
        }
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.launchWitherSkullToEntity(0, p_82196_1_);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_WITHER;
    }

    @Override
    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        if (!potioneffectIn.func_188419_a().func_76398_f()) {
            super.func_70690_d(potioneffectIn);
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187977_J);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadYRotation(int p_82207_1_) {
        return this.yRotationHeads[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadXRotation(int p_82210_1_) {
        return this.xRotationHeads[p_82210_1_];
    }

    public int getHoverTime() {
        return (Integer)this.field_70180_af.func_187225_a(HOVERTIMER);
    }

    public void setHoverTime(int p_82215_1_) {
        this.field_70180_af.func_187227_b(HOVERTIMER, (Object)p_82215_1_);
    }

    public int getRamTime() {
        return (Integer)this.field_70180_af.func_187225_a(RAMTIMER);
    }

    public void setRamTime(int p_82215_1_) {
        this.field_70180_af.func_187227_b(RAMTIMER, (Object)p_82215_1_);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)p_82215_1_);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[p_82203_1_]);
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[targetOffset], (Object)newId);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }

    @Override
    protected void func_70609_aI() {
        this.lastActiveTime = this.timeSinceIgnited;
        ++this.deathTicks;
        this.timeSinceIgnited = this.deathTicks;
        if (this.deathTicks == 120) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
            if (!this.field_70170_p.field_72995_K) {
                EntityWither.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 35.0f, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            }
            if (!this.field_70170_p.field_72995_K && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
                }
            }
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 1) {
            if (!this.field_70170_p.field_72995_K) {
                for (EntityPlayer entityplayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 100.0, 50.0))) {
                    entityplayer.func_71029_a((StatBase)AchievementList.field_187977_J);
                }
            }
            if (this.getOwner() != null) {
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.0f);
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s " + this.func_70005_c_() + " has been killed!!!", new Object[0]), true);
                }
                ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Wither has been destroyed!", new Object[0]));
            }
        }
    }

    public boolean func_184222_aU() {
        return EngenderMod.sensorsShowJzahars(this.field_70170_p);
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    @Override
    public int getDamageCap() {
        return 50;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_70965_a(this.mainHead, source, amount);
    }

    public boolean func_70965_a(EntityDragonPart witherPart, DamageSource source, float damage) {
        if (this.isArmored()) {
            damage = damage / 2.0f + Math.min(damage, 1.0f);
        }
        if (witherPart == this.spine || witherPart == this.rightRibs || witherPart == this.leftRibs) {
            damage = damage / 10.0f + Math.min(damage, 1.0f);
        }
        if (witherPart == this.lowerspine || witherPart == this.rightsupport || witherPart == this.leftsupport) {
            damage = damage / 2.0f + Math.min(damage, 1.0f);
        }
        if (witherPart == this.rightHead && !source.func_94541_c()) {
            this.nextHeadUpdate[0] = this.nextHeadUpdate[0] + 200;
        }
        if (witherPart == this.leftHead && !source.func_94541_c()) {
            this.nextHeadUpdate[1] = this.nextHeadUpdate[1] + 200;
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && !this.isWild() && source.func_76346_g() == this.getOwner()) {
            this.updateWatchedTargetId(1, 0);
            this.updateWatchedTargetId(2, 0);
        }
        if (this.func_180431_b(source) || this.getInvulTime() > 0 || damage < 0.01f || source == DamageSource.field_82727_n || source == DamageSource.field_76368_d || source == DamageSource.field_76369_e || source == DamageSource.field_191291_g || source == DamageSource.field_76367_g) {
            return false;
        }
        if (this.isArmored() && source.func_76352_a()) {
            return false;
        }
        super.func_70097_a(source, damage);
        if (this.blockBreakCounter <= 0) {
            this.blockBreakCounter = 20;
        }
        int i = 0;
        while (i < this.idleHeadUpdates.length) {
            int n = i++;
            this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
        }
        if (!source.func_82725_o()) {
            for (i = 0; i < this.nextHeadUpdate.length; ++i) {
                if (this.nextHeadUpdate[i] > 80) continue;
                int n = i;
                this.nextHeadUpdate[n] = this.nextHeadUpdate[n] - 20;
            }
        }
        return true;
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityWither.this.getInvulTime() > 0;
        }
    }
}

