/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.Elemental;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMagmaGolem
extends EntityFriendlyCreature
implements Armored,
Elemental {
    public EntityMagmaGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.25f, 2.68f);
        this.isOffensive = true;
        this.field_70728_aV = 20;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 48.0f, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.67, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public int getNextLevelRequirement() {
        return 500;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityMagmaGolem(this.field_70170_p);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.CONSTRUCT;
    }

    @Override
    public float getBonusVSLight() {
        return 4.0f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.25f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public void performSpecialAttack() {
        this.field_70181_x = 1.0;
        this.func_184185_a(ModSoundEvents.golemSpecial, 10.0f, 1.0f);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && !this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !player.func_70093_af() && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f3 = this.field_70761_aq * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f3);
            float f4 = MathHelper.func_76134_b((float)f3);
            float sho = this.field_184619_aG - this.field_70721_aZ * (1.0f - (float)this.field_70173_aa * 0.001f) + 6.0f;
            float sho1 = (Math.abs(sho % 13.0f - 6.5f) - 3.25f) / 3.25f;
            if (EngenderMod.useMobTalkerModels) {
                if (i == 1) {
                    passenger.func_70107_b(this.field_70165_t - (double)f4 * (0.5 + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * -0.2 : 0.0)), this.field_70163_u + 1.1, this.field_70161_v - (double)f11 * (0.5 + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * -0.2 : 0.0)));
                }
                if (i == 0) {
                    passenger.func_70107_b(this.field_70165_t + (double)f4 * (0.5 + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.2 : 0.0)), this.field_70163_u + 1.1, this.field_70161_v + (double)f11 * (0.5 + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.2 : 0.0)));
                }
            } else {
                if (i == 1) {
                    passenger.func_70107_b(this.field_70165_t - (double)f4 * ((double)0.65f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * -0.2 : 0.0)), this.field_70163_u + 1.375, this.field_70161_v - (double)f11 * ((double)0.65f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * -0.2 : 0.0)));
                }
                if (i == 0) {
                    passenger.func_70107_b(this.field_70165_t + (double)f4 * ((double)0.65f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.2 : 0.0)), this.field_70163_u + 1.375, this.field_70161_v + (double)f11 * ((double)0.65f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.2 : 0.0)));
                }
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br / 3.0f;
            forward = entitylivingbase.field_70701_bs / 3.0f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(1.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity) || this.field_70170_p.field_72995_K || this.field_70173_aa % 10 != 0) continue;
                this.func_70652_k(entity);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        this.func_70105_a(1.25f, 2.68f);
        if (this.func_70026_G()) {
            this.func_184185_a(SoundEvents.field_187658_bx, 1.0f, 1.0f);
            this.func_70097_a(new DamageSource("cooler").func_76348_h().func_151518_m().func_76351_m(), 8.0f);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 64.0 && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        AttributeModifier irongolemrandomizer = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D839"), "Iron Golem randomizer", this.field_70146_Z.nextDouble() * 0.5, 1).func_111168_a(false);
        IAttributeInstance iattributeinstanceattack = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (!iattributeinstanceattack.func_180374_a(irongolemrandomizer)) {
            iattributeinstanceattack.func_111121_a(irongolemrandomizer);
        }
        if (super.func_70652_k(entityIn)) {
            if (iattributeinstanceattack.func_180374_a(irongolemrandomizer)) {
                iattributeinstanceattack.func_111124_b(irongolemrandomizer);
            }
            return true;
        }
        return false;
    }

    @Override
    public void attackWithAdditionalEffects(Entity entity) {
        double amount = 0.5;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
            amount *= 0.75;
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            amount *= 1.5;
        }
        if (!entity.func_70089_S() && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70758_at = ((EntityLivingBase)entity).field_70759_as = this.field_70759_as;
            ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70126_B = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70760_ar = ((EntityLivingBase)entity).field_70759_as;
            float xRatio = MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180)));
            float zRatio = -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)));
            entity.field_70160_al = true;
            float f = MathHelper.func_76129_c((float)(xRatio * xRatio + zRatio * zRatio));
            entity.field_70159_w /= 2.0;
            entity.field_70179_y /= 2.0;
            entity.field_70159_w -= (double)xRatio / (double)f * 2.0;
            entity.field_70179_y -= (double)zRatio / (double)f * 2.0;
            entity.field_70181_x /= 2.0;
            entity.field_70181_x += amount;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
            }
        }
        entity.field_70181_x += amount;
        entity.func_70015_d(15);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            EntityLivingBase entitylivingbase;
            if (!(source.func_82725_o() || !(source.func_76364_f() instanceof EntityLivingBase) || (entitylivingbase = (EntityLivingBase)source.func_76364_f()).func_70045_F() || source.func_94541_c() || entitylivingbase.func_184191_r((Entity)this) && (this.getOwner() == null || entitylivingbase != this.getOwner()))) {
                entitylivingbase.func_70097_a(new EntityDamageSource("litOnFire", (Entity)this).func_180138_v().func_76348_h().func_76361_j(), 2.0f);
                this.func_184185_a(SoundEvents.field_187658_bx, this.func_70599_aP(), this.func_70647_i());
                if (this.field_70146_Z.nextInt(3) == 0) {
                    entitylivingbase.func_70015_d(5 + this.field_70146_Z.nextInt(5));
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (id == 11) {
            this.holdRoseTick = 100;
        } else if (id == 12) {
            this.holdRoseTick = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setHoldingRose(boolean p_70851_1_) {
        this.holdRoseTick = p_70851_1_ ? 100 : 0;
        this.field_70170_p.func_72960_a((Entity)this, p_70851_1_ ? (byte)11 : 12);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.setSpecialAttackTimer(300);
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 1.0f);
            EntityMagmaGolem.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, 3.0f, false);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(24.0, 3.0, 24.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity)) {
                        entity.field_70181_x += 1.5;
                        if (entity instanceof IMob) {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 24.0f);
                        } else {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 12.0f);
                        }
                        entity.field_70160_al = true;
                        float f = MathHelper.func_76129_c((float)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) + -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        entity.field_70159_w /= 2.0;
                        entity.field_70179_y /= 2.0;
                        entity.field_70159_w -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                        entity.field_70179_y -= (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                    }
                    if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was blown up by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, (this.func_70631_g_() ? 1.5f : 1.0f) / this.getFittness());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_MAGMA_GOLEM;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }
}

