/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGiant
extends EntityFriendlyCreature
implements Massive,
Armored {
    public EntityGiant(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 12.0f);
        this.field_70138_W = 3.0f;
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 48.0f, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.2, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 250;
        this.field_70158_ak = true;
        this.field_70728_aV = 50;
    }

    @Override
    public int getNextLevelRequirement() {
        return 1000;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityGiant(this.field_70170_p);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public float getBonusVSLight() {
        return 2.0f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.25f;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 12.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 3;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f3 = this.field_70761_aq * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f3);
            float f4 = MathHelper.func_76134_b((float)f3);
            if (EngenderMod.useMobTalkerModels) {
                if (i == 2) {
                    passenger.func_70107_b(this.field_70165_t - (double)(f4 * (2.1f * this.getFittness())), this.field_70163_u + (this.isHero() ? 8.0 * (double)this.getFittness() : 7.5 * (double)this.getFittness()), this.field_70161_v - (double)(f11 * (2.1f * this.getFittness())));
                }
                if (i == 1) {
                    passenger.func_70107_b(this.field_70165_t + (double)(f4 * (2.1f * this.getFittness())), this.field_70163_u + (this.isHero() ? 8.0 * (double)this.getFittness() : 7.5 * (double)this.getFittness()), this.field_70161_v + (double)(f11 * (2.1f * this.getFittness())));
                }
                if (i == 0) {
                    passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (this.isHero() ? 12.0 * (double)this.getFittness() : 11.35 * (double)this.getFittness()), this.field_70161_v);
                }
            } else {
                if (i == 2) {
                    passenger.func_70107_b(this.field_70165_t - (double)(f4 * 2.25f), this.field_70163_u + (this.isHero() ? 9.0 : 8.5), this.field_70161_v - (double)(f11 * 2.25f));
                }
                if (i == 1) {
                    passenger.func_70107_b(this.field_70165_t + (double)(f4 * 2.25f), this.field_70163_u + (this.isHero() ? 9.0 : 8.5), this.field_70161_v + (double)(f11 * 2.25f));
                }
                if (i == 0) {
                    passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (this.isHero() ? 12.0 * (double)this.getFittness() : 11.35 * (double)this.getFittness()), this.field_70161_v);
                }
            }
        }
    }

    @Override
    public void attackWithAdditionalEffects(Entity entity) {
        double amount = 0.6;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
            amount *= 0.75;
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            amount *= 1.5;
        }
        ((EntityLivingBase)entity).func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
        if (!entity.func_70089_S() && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70758_at = ((EntityLivingBase)entity).field_70759_as = this.field_70759_as;
            ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70126_B = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70760_ar = ((EntityLivingBase)entity).field_70759_as;
            float xRatio = MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180)));
            float zRatio = -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)));
            entity.field_70160_al = true;
            float f = MathHelper.func_76129_c((float)(xRatio * xRatio + zRatio * zRatio));
            entity.field_70159_w /= 2.0;
            entity.field_70179_y /= 2.0;
            entity.field_70159_w -= (double)xRatio / (double)f * 3.0;
            entity.field_70179_y -= (double)zRatio / (double)f * 3.0;
            entity.field_70181_x /= 2.0;
            entity.field_70181_x += amount;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
            }
        }
        entity.field_70181_x += amount;
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O * 0.87f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = 10.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity) || this.field_70170_p.field_72995_K || this.field_70173_aa % 10 != 0) continue;
                this.func_70652_k(entity);
                double d01 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
                double d11 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
                double d2 = entity.field_70165_t - d01;
                double d3 = entity.field_70161_v - d11;
                double d4 = d2 * d2 + d3 * d3;
                entity.func_70024_g(d2 / d4 * 6.0, 0.25, d3 / d4 * 6.0);
                if (!(entity.field_70131_O >= 1.0f)) continue;
                this.func_70024_g(-(d2 / d4 * 1.25), 0.25, -(d3 / d4 * 1.25));
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.func_70105_a(3.0f, 12.0f);
        } else {
            this.func_70105_a(1.5f, 12.0f);
        }
        this.reachWidth = 6.0f;
        if (this.isHero() && !this.isWild() && this.field_70170_p.field_72995_K) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 3.0f * 2.0f) - 3.0 - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 12.0f) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 3.0f * 2.0f) - 3.0 - d2 * d3, d0, (double)0.1f, d2, new int[0]);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.performSpecialAttack();
        }
        this.field_70138_W = 4.0f;
        super.func_70636_d();
        for (int t = 0; t < 8; ++t) {
            int k;
            int j;
            int i;
            IBlockState iblockstate;
            if (this.field_70159_w == 0.0 || this.field_70179_y == 0.0 || (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.25)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() == Material.field_151579_a) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    @Override
    public void performSpecialAttack() {
        this.field_70181_x = 2.0;
        this.func_184185_a(ModSoundEvents.golemSpecial, 10.0f, 0.75f);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.setSpecialAttackTimer(500);
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 0.9f);
            EntityGiant.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u - 3.0, this.field_70161_v, 6.0f, false);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 3.0, 48.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity)) {
                        entity.field_70181_x = entity.field_70181_x + (this.field_70146_Z.nextInt(30) == 0 ? 30.0 : 3.0);
                        if (entity instanceof IMob) {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 50.0f);
                        } else {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 25.0f);
                        }
                        entity.field_70160_al = true;
                        float f = MathHelper.func_76129_c((float)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) + -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        entity.field_70159_w /= 2.0;
                        entity.field_70179_y /= 2.0;
                        entity.field_70159_w -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                        entity.field_70179_y -= (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                    }
                    if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was blown up by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.guyHurt, this.func_70599_aP(), this.func_70647_i() + 0.4f);
        }
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.guyDeath, this.func_70599_aP(), this.func_70647_i() + 0.4f);
        }
        return SoundEvents.field_187930_hd;
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187605_cG, 3.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.8f) / this.getFittness());
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 5.0f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_GIANT;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.5f;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrushHeavy;
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public World getWorld() {
        return this.field_70170_p;
    }

    public boolean attackEntityFromPart(EntityDragonPart dragonPart, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }
}

