/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.MobChunkLoader;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.ai.EntityAIAvoidEntitySPC;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier4.EntityGhast;
import net.minecraft.entity.helpful.tier4.EntityLargeFireballOther;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGhasther
extends EntityFriendlyCreature
implements Massive,
Flying,
Armored {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityGhasther.class, (DataSerializer)DataSerializers.field_187198_h);
    private int explosionStrength = 5;
    public EnumBehaviour behaviour = EnumBehaviour.REGULAR;
    private int damageTillNextScream;

    public EntityGhasther(World worldIn) {
        super(worldIn);
        this.func_70105_a(9.0f, 9.0f);
        this.field_70728_aV = 100;
        this.field_70178_ae = true;
        this.isOffensive = true;
        this.field_70765_h = new GhastMoveHelper(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, EngenderMod.useMobTalkerModels ? 64.0f : 100.0f, EngenderMod.useMobTalkerModels ? 9.0f : 16.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILookAround());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public int getNextLevelRequirement() {
        return 1500;
    }

    @Override
    public void updateBossBar() {
        super.updateBossBar();
        this.bossInfo.func_186745_a(BossInfo.Color.YELLOW);
    }

    @Override
    public boolean isABoss() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityGhasther(this.field_70170_p);
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public float getBonusVSLight() {
        return 0.5f;
    }

    @Override
    public float getBonusVSArmored() {
        return 3.0f;
    }

    @Override
    public float getBonusVSFlying() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 2.0f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    @Override
    public void performSpecialAttack() {
        this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i());
        this.setSpecialAttackTimer(1200);
    }

    protected float func_70647_i() {
        return super.func_70647_i() - 0.25f;
    }

    public void func_70110_aj() {
    }

    @Override
    public int getSpawnTimer() {
        return 80;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                float f = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                if (d < (double)(this.reachWidth * this.reachWidth + f * f2) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 10 == 0) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            }
            if (this.func_70089_S()) {
                MobChunkLoader.updateLoaded((Entity)this);
            } else {
                MobChunkLoader.stopLoading((Entity)this);
            }
        }
        this.func_70105_a(9.0f, 9.0f);
        this.field_70122_E = false;
        this.field_70160_al = true;
        if (this.isHero() && this.getSpecialAttackTimer() > 1100) {
            this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i());
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    if (this.getSpecialAttackTimer() > 1190 && entity instanceof EntityCreature && !(entity instanceof EntityFriendlyCreature)) {
                        ((EntityCreature)entity).field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<EntityGhasther>((EntityCreature)entity, EntityGhasther.class, 128.0f, 1.5, 1.5));
                    }
                    entity.field_70172_ad = 0;
                    this.inflictEngenderMobDamage(entity, "'s ears exploded thanks to ", DamageSource.field_82727_n, 0.25f);
                    entity.func_70024_g(this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05);
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 2048.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.func_70638_az() != null && this.getOwner() != null && !this.func_70685_l((Entity)this.func_70638_az()) && this.field_70146_Z.nextInt(80) == 0) {
            this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i() + 0.25f);
        }
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
            this.field_70177_z = this.field_70759_as = passenger.field_70177_z;
            this.field_70761_aq = this.field_70759_as;
            this.field_70125_A = EngenderMod.useMobTalkerModels ? passenger.field_70125_A : 0.0f;
            double d1 = 0.4;
            if (this.moralRaisedTimer > 200) {
                d1 *= 2.0;
            }
            Vec3d vec3 = passenger.func_70676_i(1.0f);
            if (passenger.field_70701_bs > 0.0f) {
                this.func_70091_d(MoverType.SELF, vec3.field_72450_a * d1, vec3.field_72448_b * d1, vec3.field_72449_c * d1);
            }
            if (passenger.field_70701_bs < 0.0f) {
                this.func_70091_d(MoverType.SELF, -(vec3.field_72450_a * d1), -(vec3.field_72448_b * d1), -(vec3.field_72449_c * d1));
            }
        }
        if (this.getOwner() != null && this.func_70638_az() == null && this.field_70173_aa % 10 == 0) {
            double d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d0, d0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70685_l(entity) && !this.isOnSameTeam((EntityLivingBase)entity) && entity.func_70068_e((Entity)this.getOwner()) <= 256.0) {
                        this.func_70624_b((EntityLivingBase)entity);
                        continue;
                    }
                    list.remove(entity);
                }
            }
        }
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.deathTicks >= 300) {
            super.func_70612_e(strafe, forward);
        }
        if (!this.func_175446_cd() || this.func_184207_aI() || this.deathTicks < 300) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_180799_ab()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float f = 0.95f;
                float f1 = 0.16277136f / (f * f * f);
                this.func_70060_a(strafe, forward, 0.02f);
                f = 0.95f;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (amount > 50.0f) {
            amount = 50.0f;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if ("fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(source, 50.0f);
            ((EntityPlayer)source.func_76346_g()).func_71029_a((StatBase)AchievementList.field_76028_y);
            return true;
        }
        float f = this.func_110143_aJ();
        super.func_70097_a(source, amount);
        this.damageTillNextScream = (int)((float)this.damageTillNextScream + (f - this.func_110143_aJ()));
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_GHASTHER;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 10.0f;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = tagCompund.func_74762_e("ExplosionPower");
        }
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O * 0.66f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * (EngenderMod.useMobTalkerModels ? 0.75 : 0.95);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getCrushHurtSound() : ModSoundEvents.fleshHitCrushHeavy;
    }

    public boolean func_184222_aU() {
        return EngenderMod.sensorsShowJzahars(this.field_70170_p);
    }

    public void launchFireball(EntityGhasther ghast, double d2, double d3, double d4, double d5, double d6, double d7) {
        float dm;
        EntityLargeFireballOther entitylargefireball = new EntityLargeFireballOther(this.field_70170_p, (EntityLivingBase)ghast, d2, d3, d4);
        entitylargefireball.field_92057_e = ghast.getFireballStrength();
        entitylargefireball.field_70165_t = d5;
        entitylargefireball.field_70163_u = d6;
        entitylargefireball.field_70161_v = d7;
        entitylargefireball.damage = dm = (float)ghast.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        ghast.func_184185_a(SoundEvents.field_187557_bK, 10.0f, 0.875f);
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
    }

    public void chooseNewAttack() {
        if ((float)this.damageTillNextScream > 20.0f) {
            this.behaviour = this.func_110143_aJ() <= this.func_110138_aP() / 3.0f ? EnumBehaviour.RANDOM : EnumBehaviour.GHASTCALL;
        } else {
            switch (this.field_70146_Z.nextInt(15)) {
                case 1: 
                case 2: 
                case 3: {
                    this.behaviour = EnumBehaviour.SPREAD;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.behaviour = EnumBehaviour.PEPPER;
                    break;
                }
                case 7: 
                case 8: {
                    this.behaviour = EnumBehaviour.TRISHOT;
                    break;
                }
                case 9: {
                    this.behaviour = EnumBehaviour.BOMBARD;
                    break;
                }
                case 10: {
                    this.behaviour = EnumBehaviour.MACHINEGUN;
                    break;
                }
                default: {
                    this.behaviour = EnumBehaviour.REGULAR;
                }
            }
        }
    }

    @Override
    protected void func_70609_aI() {
        if (this.deathTicks < 300 || this.field_70163_u < 0.0 || this.deathTicks >= 300 && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a() != Material.field_151579_a) {
            ++this.deathTicks;
        }
        this.field_70170_p.func_175688_a(this.field_70146_Z.nextFloat() <= 0.2f ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 9.0f - 4.5f), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 9.0f - 4.5f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 9.0f - 4.5f), 0.0, 0.0, 0.0, new int[0]);
        if (this.deathTicks >= 300) {
            this.field_70125_A -= 1.0f;
            ++this.field_70725_aQ;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 9.0f - 4.5f), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 9.0f - 4.5f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 9.0f - 4.5f), 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks == 340) {
                if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    int j;
                    int i = this.func_70693_a(this.field_70717_bb);
                    for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                    }
                }
                this.func_70106_y();
                for (int k = 0; k < 10; ++k) {
                    this.func_70656_aK();
                }
            }
            if (this.deathTicks % 60 == 0) {
                this.func_184581_c(null);
            }
            if (this.deathTicks == 1) {
                this.field_70181_x += 1.0;
                this.field_70181_x += 1.0;
                if (this.getOwner() != null) {
                    for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                        this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.0f);
                        entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s " + this.func_70005_c_() + " has been killed!!!", new Object[0]), true);
                    }
                    ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Ghasther has been destroyed!", new Object[0]));
                }
            }
            if (this.deathTicks > 80) {
                this.func_70612_e(1.0f, this.field_70146_Z.nextBoolean() ? -1.0f : 1.0f);
                this.func_70091_d(MoverType.SELF, 0.0, -0.2, 0.0);
            }
            this.field_70759_as = this.field_70177_z += 5.0f;
            this.field_70761_aq = this.field_70177_z;
        }
    }

    private static enum EnumBehaviour {
        REGULAR,
        SPREAD,
        BOMBARD,
        CATCH,
        MACHINEGUN,
        PEPPER,
        TRISHOT,
        GHASTCALL,
        ENRAGED,
        RANDOM,
        FINALE;

    }

    static class GhastMoveHelper
    extends EntityMoveHelper {
        private EntityGhasther parentEntity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityGhasther ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && this.parentEntity.getJukeboxToDanceTo() == null) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w = this.parentEntity.field_70159_w + d0 / d3 * (this.parentEntity.moralRaisedTimer > 200 ? 0.15 : 0.075);
                        this.parentEntity.field_70181_x = this.parentEntity.field_70181_x + d1 / d3 * (this.parentEntity.moralRaisedTimer > 200 ? 0.15 : 0.075);
                        this.parentEntity.field_70179_y = this.parentEntity.field_70179_y + d2 / d3 * (this.parentEntity.moralRaisedTimer > 200 ? 0.15 : 0.075);
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityGhasther ghast;

        public AIRandomFly(EntityGhasther ghast) {
            this.ghast = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.ghast.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.ghast.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.ghast.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.ghast.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 6400.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.ghast.func_70681_au();
            if (this.ghast.getOwner() != null) {
                if (this.ghast.getOwner().func_70093_af()) {
                    double d0 = this.ghast.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    double d1 = this.ghast.getOwner().field_70163_u + 8.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    double d2 = this.ghast.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else if (!this.ghast.getCurrentBook().func_190926_b()) {
                    double d0 = this.ghast.getOwner().field_70165_t;
                    double d1 = this.ghast.getOwner().field_70163_u + 8.0;
                    double d2 = this.ghast.getOwner().field_70161_v;
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else {
                    double d0 = this.ghast.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d1 = this.ghast.getOwner().field_70163_u + (EngenderMod.useMobTalkerModels || this.ghast.func_70631_g_() ? 16.0 : 32.0) + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.ghast.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                }
            } else {
                double d0 = this.ghast.field_70165_t + random.nextGaussian() * 32.0;
                double d1 = this.ghast.field_70163_u + random.nextGaussian() * 32.0;
                double d2 = this.ghast.field_70161_v + random.nextGaussian() * 32.0;
                this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityGhasther parentEntity;

        public AILookAround() {
            this.parentEntity = EntityGhasther.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_184179_bs() != null) {
                this.parentEntity.field_70126_B = this.parentEntity.field_70177_z = this.parentEntity.func_184179_bs().field_70177_z;
                this.parentEntity.field_70125_A = 0.0f;
                this.parentEntity.func_70101_b(this.parentEntity.field_70177_z, this.parentEntity.field_70125_A);
                this.parentEntity.field_70759_as = this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z;
            } else if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70177_z = this.parentEntity.field_70759_as = -((float)Math.atan2(this.parentEntity.field_70159_w, this.parentEntity.field_70179_y)) * 180.0f / (float)Math.PI;
                this.parentEntity.field_70761_aq = this.parentEntity.field_70759_as;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = this.parentEntity.field_70759_as;
                this.parentEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, EngenderMod.useMobTalkerModels ? 40.0f : 180.0f);
            }
        }
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityGhasther ghast;
        public int attackTimer;

        public AIFireballAttack(EntityGhasther ghast) {
            this.ghast = ghast;
        }

        public boolean func_75250_a() {
            return this.ghast.func_70638_az() != null && !this.ghast.func_70093_af();
        }

        public void func_75249_e() {
            this.attackTimer = 0;
            this.ghast.setArmsRaised(true);
            this.ghast.chooseNewAttack();
        }

        public void func_75251_c() {
            this.ghast.setAttacking(false);
            this.ghast.setArmsRaised(false);
        }

        public void func_75246_d() {
            block45: {
                block44: {
                    double d1 = this.ghast.func_70631_g_() ? 1.5 : 3.0;
                    Vec3d vec3 = this.ghast.func_70676_i(1.0f);
                    double mark1 = this.ghast.field_70165_t + vec3.field_72450_a * d1;
                    double mark2 = this.ghast.field_70163_u + 1.0 + vec3.field_72448_b * d1;
                    double mark3 = this.ghast.field_70161_v + vec3.field_72449_c * d1;
                    EntityLivingBase entitylivingbase = this.ghast.func_70638_az();
                    double d0 = 100.0;
                    if (entitylivingbase == null || !(entitylivingbase.func_70068_e((Entity)this.ghast) < d0 * d0)) break block44;
                    World world = this.ghast.field_70170_p;
                    ++this.attackTimer;
                    if (this.ghast.moralRaisedTimer > 200) {
                        ++this.attackTimer;
                    }
                    switch (this.ghast.behaviour) {
                        case PEPPER: {
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.6f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer > 30 && this.attackTimer % 10 == 0) {
                                double d2 = entitylivingbase.field_70165_t - mark1;
                                double d3 = entitylivingbase.field_70163_u + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                double d4 = entitylivingbase.field_70161_v - mark3;
                                this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                            }
                            if (this.attackTimer == 80) {
                                this.attackTimer = -40;
                                this.ghast.chooseNewAttack();
                                break;
                            }
                            break block45;
                        }
                        case TRISHOT: {
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.6f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer >= 20 && this.attackTimer % 20 == 0) {
                                double d2 = entitylivingbase.field_70165_t - mark1;
                                double d3 = entitylivingbase.field_70163_u + (entitylivingbase.field_70131_O > 6.0f ? 6.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                double d4 = entitylivingbase.field_70161_v - mark3;
                                this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                            }
                            if (this.attackTimer == 60) {
                                this.attackTimer = -40;
                                this.ghast.chooseNewAttack();
                                break;
                            }
                            break block45;
                        }
                        case CATCH: {
                            double d4;
                            double d3;
                            double d2;
                            int i;
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.5f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer == 40) {
                                for (i = 0; i <= 6; ++i) {
                                    d2 = entitylivingbase.field_70165_t + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) - mark1;
                                    d3 = entitylivingbase.field_70163_u + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                    d4 = entitylivingbase.field_70161_v + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) - mark3;
                                    this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                                }
                            }
                            if (this.attackTimer == 50) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.5f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer == 80) {
                                for (i = 0; i <= 6; ++i) {
                                    d2 = entitylivingbase.field_70165_t + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) - mark1;
                                    d3 = entitylivingbase.field_70163_u + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                    d4 = entitylivingbase.field_70161_v + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) - mark3;
                                    this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                                }
                                this.attackTimer = -40;
                                this.ghast.chooseNewAttack();
                                break;
                            }
                            break block45;
                        }
                        case SPREAD: {
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.5f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer == 40) {
                                for (int i = 0; i <= 6 + this.ghast.func_70681_au().nextInt(3); ++i) {
                                    double d2 = entitylivingbase.field_70165_t + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) - mark1;
                                    double d3 = entitylivingbase.field_70163_u + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                    double d4 = entitylivingbase.field_70161_v + (i == 1 ? 0.0 : this.ghast.func_70681_au().nextDouble() * 8.0 - 4.0) - mark3;
                                    this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                                }
                                this.attackTimer = -40;
                                this.ghast.chooseNewAttack();
                                break;
                            }
                            break block45;
                        }
                        case BOMBARD: {
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.4f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer > 20 && this.attackTimer % 3 == 0) {
                                double d2 = entitylivingbase.field_70165_t + (this.ghast.func_70681_au().nextDouble() * 2.0 - 1.0) - mark1;
                                double d3 = entitylivingbase.field_70163_u + (this.ghast.func_70681_au().nextDouble() * 2.0 - 1.0) + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                double d4 = entitylivingbase.field_70161_v + (this.ghast.func_70681_au().nextDouble() * 2.0 - 1.0) - mark3;
                                this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                            }
                            if (this.attackTimer == 140) {
                                this.attackTimer = -60;
                                this.ghast.chooseNewAttack();
                                break;
                            }
                            break block45;
                        }
                        case MACHINEGUN: {
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.4f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer > 20) {
                                double d2 = entitylivingbase.field_70165_t - mark1;
                                double d3 = entitylivingbase.field_70163_u + (entitylivingbase.field_70131_O > 6.0f ? 6.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                double d4 = entitylivingbase.field_70161_v - mark3;
                                this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                            }
                            if (this.attackTimer == 80) {
                                this.attackTimer = -80;
                                this.ghast.chooseNewAttack();
                                break;
                            }
                            break block45;
                        }
                        case GHASTCALL: {
                            if (this.attackTimer == 40) {
                                this.ghast.func_184581_c(null);
                                this.ghast.func_184581_c(null);
                                this.ghast.func_184581_c(null);
                                this.ghast.func_184581_c(null);
                                this.ghast.func_184581_c(null);
                            }
                            if (this.attackTimer >= 80) {
                                int i = MathHelper.func_76128_c((double)this.ghast.field_70165_t);
                                int k = MathHelper.func_76128_c((double)this.ghast.field_70161_v);
                                int h = (int)this.ghast.func_110143_aJ();
                                while ((float)h <= this.ghast.func_110138_aP()) {
                                    for (int l = 0; l < 10; ++l) {
                                        int i1 = i + MathHelper.func_76136_a((Random)this.ghast.field_70146_Z, (int)16, (int)64) * MathHelper.func_76136_a((Random)this.ghast.field_70146_Z, (int)-1, (int)1);
                                        int k1 = k + MathHelper.func_76136_a((Random)this.ghast.field_70146_Z, (int)16, (int)64) * MathHelper.func_76136_a((Random)this.ghast.field_70146_Z, (int)-1, (int)1);
                                        int j1 = this.ghast.field_70170_p.func_175672_r(new BlockPos((double)i1, (double)MathHelper.func_76128_c((double)this.ghast.field_70163_u), (double)k1)).func_177956_o();
                                        if (!this.ghast.field_70170_p.func_180495_p(new BlockPos(i1, j1 - 1, k1)).isSideSolid((IBlockAccess)this.ghast.field_70170_p, new BlockPos(i1, j1 - 1, k1), EnumFacing.UP)) continue;
                                        EntityGhast entityzombie = new EntityGhast(this.ghast.field_70170_p);
                                        entityzombie.func_70107_b(i1, j1, k1);
                                        if (this.ghast.field_70146_Z.nextInt(100) != 0 || this.ghast.field_70170_p.func_175636_b((double)i1, (double)j1, (double)k1, 7.0) || !this.ghast.field_70170_p.func_72917_a(entityzombie.func_174813_aQ(), (Entity)entityzombie) || !this.ghast.field_70170_p.func_184144_a((Entity)entityzombie, entityzombie.func_174813_aQ()).isEmpty() || this.ghast.field_70170_p.func_72953_d(entityzombie.func_174813_aQ())) continue;
                                        this.ghast.field_70170_p.func_72838_d((Entity)entityzombie);
                                        entityzombie.func_180482_a(this.ghast.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                                        entityzombie.setOwnerId(this.ghast.func_184753_b());
                                        entityzombie.setIsAntiMob(this.ghast.isAntiMob());
                                        entityzombie.setGrowingAge(this.ghast.func_70654_ax());
                                        break;
                                    }
                                    ++h;
                                }
                                this.attackTimer = -80;
                                this.ghast.chooseNewAttack();
                                this.ghast.damageTillNextScream = 0;
                                break;
                            }
                            break block45;
                        }
                        case RANDOM: {
                            if (this.attackTimer == 10) {
                                this.ghast.func_184581_c(null);
                            }
                            if (this.attackTimer > 20 && this.attackTimer % 10 == 0) {
                                double d2 = this.ghast.func_70681_au().nextDouble() * 64.0 - 32.0;
                                double d3 = this.ghast.func_70681_au().nextDouble() * 64.0 - 32.0;
                                double d4 = this.ghast.func_70681_au().nextDouble() * 64.0 - 32.0;
                                this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                            }
                            if (this.attackTimer == 140) {
                                this.attackTimer = -60;
                                this.ghast.chooseNewAttack();
                                this.ghast.damageTillNextScream = 0;
                                break;
                            }
                            break block45;
                        }
                        default: {
                            if (this.ghast.behaviour == EnumBehaviour.GHASTCALL || this.ghast.behaviour == EnumBehaviour.RANDOM) {
                                this.attackTimer = 0;
                            }
                            if (this.attackTimer == 10) {
                                this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.6f + this.ghast.func_70681_au().nextFloat() * 0.4f);
                            }
                            if (this.attackTimer == 20) {
                                double d2 = entitylivingbase.field_70165_t - mark1;
                                double d3 = entitylivingbase.field_70163_u + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) - mark2;
                                double d4 = entitylivingbase.field_70161_v - mark3;
                                this.ghast.launchFireball(this.ghast, d2, d3, d4, mark1, mark2, mark3);
                                this.attackTimer = -40;
                                this.ghast.chooseNewAttack();
                                if ((double)this.ghast.func_70032_d((Entity)entitylivingbase) <= 10.0) {
                                    this.ghast.func_70652_k((Entity)entitylivingbase);
                                    break;
                                }
                            }
                            break block45;
                        }
                    }
                    break block45;
                }
                if (this.attackTimer > 0) {
                    --this.attackTimer;
                }
            }
            this.ghast.setAttacking(this.attackTimer > 10 || this.ghast.getSpecialAttackTimer() > 1100);
        }
    }
}

