/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier1.EntityPig;
import net.minecraft.entity.helpful.tier1.EntityRabbit;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier3.EntitySlime;
import net.minecraft.entity.helpful.tier3.EntityVex;
import net.minecraft.entity.helpful.tier4.EntityLargeFireballOther;
import net.minecraft.entity.helpful.tier4.EntitySmallFireballOther;
import net.minecraft.entity.helpful.tier5.EntityDisintigrationRay;
import net.minecraft.entity.helpful.tier5.EntityEvokerFangOther;
import net.minecraft.entity.helpful.tier5.EntityFrostRay;
import net.minecraft.entity.helpful.tier5.EntityInvisibleFangsProjectile;
import net.minecraft.entity.helpful.tier5.EntityMagicMissile;
import net.minecraft.entity.helpful.tier5.EntityPoisonSpray;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityEvoker
extends EntityFriendlyCreature
implements IRangedAttackMob,
Light {
    protected static final DataParameter<Byte> DATA_SPELL_CASTING_ID = EntityDataManager.func_187226_a(EntityEvoker.class, (DataSerializer)DataSerializers.field_187191_a);
    private int spellCastingTickCount;
    private int spellCastId;
    private EntitySheep wololoTarget;
    private EntityFriendlyCreature convertTarget;
    private EntityFriendlyCreature allyTarget;

    public EntityEvoker(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.func_70105_a(0.5f, 1.9f);
        this.field_70728_aV = 20;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIConvertingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIReinforcingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIWololoSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISummonSpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISummonMeteorStormSpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIDisintigrationRaySpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILightningBoltSpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIPoisonSpraySpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISmallFireballSpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFireballSpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFrostRaySpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIMagicMissileSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIAttackSpell());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public int getNextLevelRequirement() {
        return 500;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityEvoker(this.field_70170_p);
    }

    @Override
    public float getBonusVSLight() {
        return 1.5f;
    }

    @Override
    public float getBonusVSFlying() {
        return 3.0f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 44.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 64.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_SPELL_CASTING_ID, (Object)0);
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                EntityEvoker baby = new EntityEvoker(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-100000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.4f : super.func_70647_i();
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spellCastingTickCount = compound.func_74762_e("SpellTicks");
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SpellTicks", this.spellCastingTickCount);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ILLAGER;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_EVOCATION_ILLAGER;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        double d1 = 1.25;
        Vec3d vec3d = this.func_70676_i(1.0f);
        double d2 = target.field_70165_t - (this.field_70165_t + vec3d.field_72450_a * d1);
        double d3 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d4 = target.field_70161_v - (this.field_70161_v + vec3d.field_72449_c * d1);
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
        EntityLargeFireballOther entitylargefireball = new EntityLargeFireballOther(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
        entitylargefireball.field_92057_e = 4;
        entitylargefireball.field_70165_t = this.field_70165_t + vec3d.field_72450_a * d1;
        entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        entitylargefireball.field_70161_v = this.field_70161_v + vec3d.field_72449_c * d1;
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
        this.func_184609_a(EnumHand.MAIN_HAND);
        this.setIsCastingSpell(8);
    }

    public void attackEntityWithRangedAttack2(EntityLivingBase target, float p_82196_2_) {
        double d1 = 1.25;
        Vec3d vec3d = this.func_70676_i(1.0f);
        double d2 = target.field_70165_t - (this.field_70165_t + vec3d.field_72450_a * d1);
        double d3 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d4 = target.field_70161_v - (this.field_70161_v + vec3d.field_72449_c * d1);
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
        EntitySmallFireballOther entitylargefireball = new EntitySmallFireballOther(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
        entitylargefireball.field_70165_t = this.field_70165_t + vec3d.field_72450_a * d1;
        entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        entitylargefireball.field_70161_v = this.field_70161_v + vec3d.field_72449_c * d1;
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
        this.func_184609_a(EnumHand.MAIN_HAND);
        this.setIsCastingSpell(10);
    }

    public void attackEntityWithSpray(EntityLivingBase target, float p_82196_2_) {
        double d = 1.25;
        Vec3d vec3d = this.func_70676_i(1.0f);
        EntityPoisonSpray entitysnowball = new EntityPoisonSpray(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t - (this.field_70165_t + vec3d.field_72450_a * d);
        double d2 = d0 - entitysnowball.field_70163_u;
        double d3 = target.field_70161_v - (this.field_70161_v + vec3d.field_72449_c * d);
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.1f;
        entitysnowball.func_70186_c(d1, d2 + (double)f, d3, 1.2f, 1.0f);
        this.func_184185_a(SoundEvents.field_187888_ft, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitysnowball);
        this.func_184609_a(EnumHand.MAIN_HAND);
        this.setIsCastingSpell(8);
    }

    public void fireRay(Entity entity, double x, double y, double z) {
        if (entity != null && entity.func_70089_S()) {
            double d3 = x;
            double d4 = y;
            double d5 = z;
            double d6 = entity.field_70165_t - d3;
            double d7 = entity.field_70163_u - d4;
            double d8 = entity.field_70161_v - d5;
            EntityDisintigrationRay entitywitherskull = new EntityDisintigrationRay(this.field_70170_p, entity, (EntityLivingBase)this, d6, d7, d8);
            entitywitherskull.field_70163_u = d4;
            entitywitherskull.field_70165_t = d3;
            entitywitherskull.field_70161_v = d5;
            entitywitherskull.field_70233_c = d4;
            entitywitherskull.field_70232_b = d3;
            entitywitherskull.field_70230_d = d5;
            entitywitherskull.targetEntity = entity;
            this.field_70170_p.func_72838_d((Entity)entitywitherskull);
        }
    }

    public void fireCone(Entity entity, double x, double y, double z) {
        if (entity != null && entity.func_70089_S()) {
            double d3 = x;
            double d4 = y;
            double d5 = z;
            double d6 = entity.field_70165_t - d3;
            double d7 = entity.field_70163_u - d4;
            double d8 = entity.field_70161_v - d5;
            EntityFrostRay entitywitherskull = new EntityFrostRay(this.field_70170_p, entity, (EntityLivingBase)this, d6, d7, d8);
            entitywitherskull.field_70163_u = d4;
            entitywitherskull.field_70165_t = d3;
            entitywitherskull.field_70161_v = d5;
            entitywitherskull.field_70233_c = d4;
            entitywitherskull.field_70232_b = d3;
            entitywitherskull.field_70230_d = d5;
            entitywitherskull.targetEntity = entity;
            this.field_70170_p.func_72838_d((Entity)entitywitherskull);
        }
    }

    private void setAllyTarget(@Nullable EntityFriendlyCreature p_190748_1_) {
        this.allyTarget = p_190748_1_;
    }

    @Nullable
    private EntityFriendlyCreature getAllyTarget() {
        return this.allyTarget;
    }

    private void setConvertingTarget(@Nullable EntityFriendlyCreature p_190748_1_) {
        this.convertTarget = p_190748_1_;
    }

    @Nullable
    private EntityFriendlyCreature getConvertingTarget() {
        return this.convertTarget;
    }

    @Override
    public void performSpecialAttack() {
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
        if (list != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                if (entity == null || this.isOnSameTeam(entity) || this.isOnSameTeam(entity)) continue;
                try {
                    ReflectionHelper.findField(entity.getClass(), (String[])new String[]{"shieldTime"}).setInt(entity, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d1 = entity.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 16.0f - 8.0f);
                double d2 = entity.field_70163_u + 20.0 + (double)(this.field_70146_Z.nextFloat() * 20.0f - 10.0f);
                double d3 = entity.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 16.0f - 8.0f);
                this.fireLightning((Entity)entity, d1, d2, d3);
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true));
            }
        }
        this.setSpecialAttackTimer(1800);
    }

    public boolean isCastingSpell() {
        return this.field_70170_p.field_72995_K ? (Byte)this.field_70180_af.func_187225_a(DATA_SPELL_CASTING_ID) > 0 : this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(int p_190753_1_) {
        this.field_70180_af.func_187227_b(DATA_SPELL_CASTING_ID, (Object)((byte)p_190753_1_));
    }

    private int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.spellCastingTickCount > 0 && this.field_70173_aa > 20) {
            --this.spellCastingTickCount;
        }
        if (this.getConvertingTarget() != null && this.func_70068_e((Entity)this.getConvertingTarget()) > 256.0) {
            this.func_70661_as().func_75497_a((Entity)this.getConvertingTarget(), 1.0);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 512.0) {
            this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 1.0);
        }
        if (this.getAllyTarget() != null && !this.getAllyTarget().func_70089_S()) {
            this.setConvertingTarget(null);
        }
        if (this.getConvertingTarget() != null && !this.getConvertingTarget().func_70089_S()) {
            this.setConvertingTarget(null);
        }
        if (this.getWololoTarget() != null && !this.getWololoTarget().func_70089_S()) {
            this.setWololoTarget(null);
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b((EntityLivingBase)((EntityFriendlyCreature)null));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.5f, 1.9f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isCastingSpell() && this.func_70089_S()) {
            byte i = (Byte)this.field_70180_af.func_187225_a(DATA_SPELL_CASTING_ID);
            double d0 = 0.7;
            double d1 = 0.5;
            double d2 = 0.2;
            if (i == 2) {
                d0 = 0.4;
                d1 = 0.3;
                d2 = 0.35;
            } else if (i == 1) {
                d0 = 0.7;
                d1 = 0.7;
                d2 = 0.8;
            } else if (i == 4) {
                d0 = 0.8;
                d1 = 0.56;
                d2 = 0.0;
            } else if (i == 5) {
                d0 = 0.0;
                d1 = 1.0;
                d2 = 0.82;
            } else if (i == 6) {
                d0 = 1.0;
                d1 = 0.0;
                d2 = 1.0;
            } else if (i == 7) {
                d0 = 0.625;
                d1 = 0.925;
                d2 = 1.0;
            } else if (i == 8) {
                d0 = 1.0;
                d1 = 0.3;
                d2 = 0.0;
            } else if (i == 9) {
                d0 = 0.0;
                d1 = 0.784;
                d2 = 0.0;
            } else if (i == 10) {
                d0 = 1.0;
                d1 = 0.784;
                d2 = 0.0;
            } else if (i == 11) {
                d0 = 0.0;
                d1 = 1.0;
                d2 = 0.0;
            } else if (i == 12) {
                d0 = 0.784;
                d1 = 0.94;
                d2 = 0.94;
            } else if (i == 13) {
                d0 = 1.0;
                d1 = 0.5;
                d2 = 0.0;
            }
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)f1 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70163_u + (this.func_70631_g_() ? 0.9 : 1.8) * (double)this.getFittness(), this.field_70161_v + (double)f2 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), d0, d1, d2, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t - (double)f1 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70163_u + (this.func_70631_g_() ? 0.9 : 1.8) * (double)this.getFittness(), this.field_70161_v - (double)f2 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), d0, d1, d2, new int[0]);
            if (i == 13) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t + (double)f1 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70163_u + (this.func_70631_g_() ? 0.9 : 1.8) * (double)this.getFittness(), this.field_70161_v + (double)f2 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), d0, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t - (double)f1 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70163_u + (this.func_70631_g_() ? 0.9 : 1.8) * (double)this.getFittness(), this.field_70161_v - (double)f2 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), d0, d1, d2, new int[0]);
            }
        }
        if (this.getJukeboxToDanceTo() != null) {
            if (this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_191248_br, this.func_70093_af() ? 0.1f : 1.0f, this.field_70146_Z.nextFloat() * 2.0f);
            }
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.5f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)f1 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70163_u + (this.func_70631_g_() ? 0.9 : 1.8) * (double)this.getFittness(), this.field_70161_v + (double)f2 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t - (double)f1 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70163_u + (this.func_70631_g_() ? 0.9 : 1.8) * (double)this.getFittness(), this.field_70161_v - (double)f2 * ((this.func_70631_g_() ? 0.3 : 0.6) * (double)this.getFittness()), this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), new int[0]);
        }
        if (!this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.func_184582_a(EntityEquipmentSlot.HEAD));
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (!this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.func_184582_a(EntityEquipmentSlot.CHEST));
            this.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
        }
        if (!this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.func_184582_a(EntityEquipmentSlot.LEGS));
            this.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
        }
        if (!this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.func_184582_a(EntityEquipmentSlot.LEGS));
            this.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_190929_cY));
        this.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_190929_cY));
        this.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Items.field_190929_cY));
        this.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Items.field_190929_cY));
        this.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() - 0.3f);
        }
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() - 0.3f);
        }
        return SoundEvents.field_191246_bp;
    }

    private void setWololoTarget(@Nullable EntitySheep p_190748_1_) {
        this.wololoTarget = p_190748_1_;
    }

    @Nullable
    private EntitySheep getWololoTarget() {
        return this.wololoTarget;
    }

    @Override
    protected float func_70672_c(DamageSource p_70672_1_, float p_70672_2_) {
        p_70672_2_ = super.func_70672_c(p_70672_1_, p_70672_2_);
        if (p_70672_1_.func_76346_g() instanceof EntityLivingBase && this.isOnSameTeam((EntityLivingBase)p_70672_1_.func_76346_g())) {
            p_70672_2_ = 0.0f;
        }
        if (p_70672_1_.func_82725_o() && p_70672_1_.func_76355_l() != "antimatter") {
            p_70672_2_ = (float)((double)p_70672_2_ * 0.05);
        }
        return p_70672_2_;
    }

    public class AIReinforcingSpell
    extends AIUseSpell {
        final Predicate<EntityFriendlyCreature> wololoSelector;

        public AIReinforcingSpell() {
            this.wololoSelector = new Predicate<EntityFriendlyCreature>(){

                public boolean apply(EntityFriendlyCreature p_apply_1_) {
                    return !p_apply_1_.isWild();
                }
            };
        }

        @Override
        public boolean func_75250_a() {
            if (EntityEvoker.this.isWild()) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            if (EntityEvoker.this.field_70173_aa < this.nextCastTime) {
                return false;
            }
            List list = EntityEvoker.this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, EntityEvoker.this.func_174813_aQ().func_186662_g(32.0), this.wololoSelector);
            if (list.isEmpty()) {
                return false;
            }
            EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(EntityEvoker.this.field_70146_Z.nextInt(list.size()));
            if (!((!entity.func_70644_a(MobEffects.field_76429_m) || entity.func_70644_a(MobEffects.field_76437_t) || entity.func_70644_a(MobEffects.field_76421_d) || entity.func_70644_a(MobEffects.field_76431_k) || entity.func_70644_a(MobEffects.field_188424_y) || entity.func_70644_a(MobEffects.field_76440_q) || entity.func_70644_a(MobEffects.field_76436_u) || entity.func_70644_a(MobEffects.field_82731_v) || entity.func_70027_ad()) && !(entity instanceof EntityVex))) {
                list.remove(entity);
                return false;
            }
            EntityEvoker.this.setAllyTarget(entity);
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return EntityEvoker.this.getAllyTarget() != null && EntityEvoker.this.getAllyTarget().func_70089_S() && EntityEvoker.this.isOnSameTeam((EntityLivingBase)EntityEvoker.this.getAllyTarget()) && (!EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_76429_m) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_76431_k) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_188424_y) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_76437_t) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_76440_q) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_76421_d) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_82731_v) || EntityEvoker.this.getAllyTarget().func_70644_a(MobEffects.field_76436_u) || EntityEvoker.this.getAllyTarget().func_70027_ad()) && this.spellWarmup > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityEvoker.this.setAllyTarget(null);
        }

        @Override
        protected void castSpell() {
            Potion potion;
            EntityFriendlyCreature entitysheep = EntityEvoker.this.getAllyTarget();
            if (entitysheep != null && entitysheep.func_70089_S() && EntityEvoker.this.isOnSameTeam((EntityLivingBase)entitysheep) && (!entitysheep.func_70644_a(potion = MobEffects.field_76429_m) || entitysheep.func_70027_ad() || entitysheep.func_70644_a(MobEffects.field_188424_y) || entitysheep.func_70644_a(MobEffects.field_76437_t) || entitysheep.func_70644_a(MobEffects.field_76440_q) || entitysheep.func_70644_a(MobEffects.field_188424_y) || entitysheep.func_70644_a(MobEffects.field_76431_k) || entitysheep.func_70644_a(MobEffects.field_76421_d) || entitysheep.func_70644_a(MobEffects.field_76436_u) || entitysheep.func_70644_a(MobEffects.field_82731_v))) {
                if (entitysheep instanceof net.minecraft.entity.helpful.tier1.EntitySheep) {
                    entitysheep.func_96094_a("jeb_");
                }
                entitysheep.func_70656_aK();
                entitysheep.func_70066_B();
                entitysheep.func_184596_c(MobEffects.field_76436_u);
                entitysheep.func_184596_c(MobEffects.field_82731_v);
                entitysheep.func_184596_c(MobEffects.field_76421_d);
                entitysheep.func_184596_c(MobEffects.field_76437_t);
                entitysheep.func_184596_c(MobEffects.field_76440_q);
                entitysheep.func_184596_c(MobEffects.field_76431_k);
                entitysheep.func_184596_c(MobEffects.field_188424_y);
                entitysheep.func_184596_c(MobEffects.field_76438_s);
                entitysheep.func_70690_d(new PotionEffect(potion, 4000));
                entitysheep.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 4000));
                EntityEvoker.this.getOwner().func_70066_B();
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_76436_u);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_82731_v);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_76421_d);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_76437_t);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_76431_k);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_76440_q);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_188424_y);
                EntityEvoker.this.getOwner().func_184596_c(MobEffects.field_76438_s);
                EntityEvoker.this.getOwner().func_70690_d(new PotionEffect(potion, 4000));
                EntityEvoker.this.getOwner().func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 1));
                EntityEvoker.this.getOwner().func_70690_d(new PotionEffect(MobEffects.field_76443_y, 20));
                EntityEvoker.this.getOwner().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 4000));
                if (entitysheep instanceof EntityPig && !((EntityPig)entitysheep).getSaddled() || entitysheep instanceof EntityCreeper && !((EntityCreeper)entitysheep).getPowered()) {
                    entitysheep.func_70077_a(null);
                    entitysheep.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(entitysheep.field_70170_p, entitysheep.field_70165_t - 0.5, entitysheep.field_70163_u, entitysheep.field_70161_v - 0.5, true));
                }
                if (entitysheep instanceof EntityRabbit && ((EntityRabbit)entitysheep).getRabbitType() != 99) {
                    ((EntityRabbit)entitysheep).setRabbitType(99);
                    entitysheep.field_70173_aa = 1;
                    entitysheep.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(entitysheep.field_70170_p, entitysheep.field_70165_t - 0.5, entitysheep.field_70163_u, entitysheep.field_70161_v - 0.5, true));
                }
                if (entitysheep instanceof EntitySlime && ((EntitySlime)entitysheep).getSlimeSize() <= 1) {
                    ((EntitySlime)entitysheep).setSlimeSize(EntityEvoker.this.field_70146_Z.nextInt(4) == 0 ? 4 : 2);
                    entitysheep.field_70173_aa = 1;
                    entitysheep.func_184185_a(SoundEvents.field_187545_bE, 2.0f, 1.0f);
                    entitysheep.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(entitysheep.field_70170_p, entitysheep.field_70165_t - 0.5, entitysheep.field_70163_u, entitysheep.field_70161_v - 0.5, true));
                }
                this.func_75251_c();
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 20;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected int getSpellId() {
            return 6;
        }
    }

    public class AIConvertingSpell
    extends AIUseSpell {
        final Predicate<EntityFriendlyCreature> wololoSelector;

        public AIConvertingSpell() {
            this.wololoSelector = new Predicate<EntityFriendlyCreature>(){

                public boolean apply(EntityFriendlyCreature p_apply_1_) {
                    return p_apply_1_.isWild() && p_apply_1_.func_70089_S() && !p_apply_1_.isABoss() && p_apply_1_.getTier() != EnumTier.TIER6;
                }
            };
        }

        @Override
        public boolean func_75250_a() {
            if (EntityEvoker.this.isWild()) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            if (EntityEvoker.this.field_70173_aa < this.nextCastTime) {
                return false;
            }
            List list = EntityEvoker.this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, EntityEvoker.this.func_174813_aQ().func_186662_g(32.0), this.wololoSelector);
            if (list.isEmpty()) {
                return false;
            }
            EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(EntityEvoker.this.field_70146_Z.nextInt(list.size()));
            if (entity.func_70089_S() && !EntityEvoker.this.isOnSameTeam((EntityLivingBase)entity)) {
                EntityEvoker.this.setConvertingTarget(entity);
            }
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return EntityEvoker.this.getConvertingTarget() != null && EntityEvoker.this.getConvertingTarget().func_70089_S() && EntityEvoker.this.getConvertingTarget().isWild() && this.spellWarmup > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            if (EntityEvoker.this.getConvertingTarget() != null && !EntityEvoker.this.getConvertingTarget().isWild()) {
                EntityEvoker.this.setConvertingTarget(null);
            }
        }

        @Override
        protected void castSpell() {
            EntityFriendlyCreature entitysheep = EntityEvoker.this.getConvertingTarget();
            if (entitysheep != null && entitysheep.func_70089_S() && EntityEvoker.this.func_70068_e((Entity)entitysheep) < 900.0) {
                entitysheep.func_70656_aK();
                entitysheep.func_70661_as().func_75497_a((Entity)EntityEvoker.this, 1.2);
                entitysheep.incrementConversion((EntityPlayer)EntityEvoker.this.getOwner());
                if (EntityEvoker.this.isHero()) {
                    entitysheep.incrementConversion((EntityPlayer)EntityEvoker.this.getOwner());
                }
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 10;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191249_bs;
        }

        @Override
        protected int getSpellId() {
            return 4;
        }
    }

    public class AIWololoSpell
    extends AIUseSpell {
        final Predicate<EntitySheep> wololoSelector;

        public AIWololoSpell() {
            this.wololoSelector = new Predicate<EntitySheep>(){

                public boolean apply(EntitySheep p_apply_1_) {
                    return EntityEvoker.this.getOwner() != null ? p_apply_1_.func_175509_cj() == EnumDyeColor.RED : p_apply_1_.func_175509_cj() == EnumDyeColor.BLUE;
                }
            };
        }

        @Override
        public boolean func_75250_a() {
            if (EntityEvoker.this.func_70638_az() != null) {
                return false;
            }
            if (EntityEvoker.this.isCastingSpell()) {
                return false;
            }
            if (EntityEvoker.this.field_70173_aa < this.nextCastTime) {
                return false;
            }
            if (!EntityEvoker.this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            List list = EntityEvoker.this.field_70170_p.func_175647_a(EntitySheep.class, EntityEvoker.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.wololoSelector);
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.setWololoTarget((EntitySheep)list.get(EntityEvoker.this.field_70146_Z.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return EntityEvoker.this.getWololoTarget() != null && this.spellWarmup > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityEvoker.this.setWololoTarget(null);
        }

        @Override
        protected void castSpell() {
            EntitySheep entitysheep = EntityEvoker.this.getWololoTarget();
            if (entitysheep != null && entitysheep.func_70089_S()) {
                if (EntityEvoker.this.isWild()) {
                    entitysheep.func_175512_b(EnumDyeColor.RED);
                } else {
                    entitysheep.func_175512_b(EnumDyeColor.BLUE);
                }
            }
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 40;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191249_bs;
        }

        @Override
        protected int getSpellId() {
            return 3;
        }
    }

    abstract class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int nextCastTime;

        private AIUseSpell() {
        }

        public boolean func_75250_a() {
            if (this.nextCastTime > EntityEvoker.this.field_70173_aa) {
                this.nextCastTime = 0;
            }
            return EntityEvoker.this.func_70638_az() == null ? false : (EntityEvoker.this.isCastingSpell() ? false : !EntityEvoker.this.func_70631_g_() && EntityEvoker.this.field_70173_aa >= this.nextCastTime && EntityEvoker.this.field_70173_aa > 20);
        }

        public boolean func_75253_b() {
            return EntityEvoker.this.func_70638_az() != null && this.spellWarmup > 0 && EntityEvoker.this.field_70173_aa > 20;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityEvoker.this.spellCastingTickCount = this.getCastingTime();
            this.nextCastTime = EntityEvoker.this.field_70173_aa + this.getCastingInterval();
            EntityEvoker.this.func_184185_a(this.getSpellPrepareSound(), EntityEvoker.this.func_70093_af() ? 0.1f : 1.0f, 1.0f);
            EntityEvoker.this.spellCastId = this.getSpellId();
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                EntityEvoker.this.setCurrentStudy(EntityFriendlyCreature.EnumStudy.Mental, 5);
                EntityEvoker.this.field_70761_aq = EntityEvoker.this.field_70177_z = EntityEvoker.this.field_70759_as;
                EntityEvoker.this.func_184609_a(EnumHand.MAIN_HAND);
                this.castSpell();
                EntityEvoker.this.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract int getSpellId();
    }

    class AISummonMeteorStormSpell
    extends AIUseSpell {
        private AISummonMeteorStormSpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(20) == 0 && EntityEvoker.this.isHero();
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 240;
        }

        @Override
        protected void castSpell() {
            List list = EntityEvoker.this.field_70170_p.func_72839_b((Entity)EntityEvoker.this, EntityEvoker.this.func_174813_aQ().func_186662_g(64.0));
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (entity == null || !(entity instanceof EntityLivingBase) || EntityEvoker.this.isOnSameTeam((EntityLivingBase)entity)) continue;
                    double d1 = entity.field_70165_t + (EntityEvoker.this.field_70146_Z.nextDouble() * 50.0 - 25.0);
                    double d2 = entity.field_70163_u + 100.0 + (EntityEvoker.this.field_70146_Z.nextDouble() * 50.0 - 25.0);
                    double d3 = entity.field_70161_v + (EntityEvoker.this.field_70146_Z.nextDouble() * 50.0 - 25.0);
                    double d4 = entity.field_70165_t - d1;
                    double d5 = entity.field_70163_u - d2;
                    double d6 = entity.field_70161_v - d3;
                    EntityLargeFireballOther entitylargefireball = new EntityLargeFireballOther(EntityEvoker.this.field_70170_p, (EntityLivingBase)EntityEvoker.this, d4, d5, d6);
                    EntityEvoker.this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)entitylargefireball), 0);
                    entitylargefireball.field_92057_e = 8;
                    entitylargefireball.field_70165_t = d1;
                    entitylargefireball.field_70163_u = d2;
                    entitylargefireball.field_70161_v = d3;
                    if (EntityEvoker.this.field_70170_p.field_72995_K) continue;
                    EntityEvoker.this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected int getSpellId() {
            return 13;
        }
    }

    class AISummonSpell
    extends AIUseSpell {
        private AISummonSpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = EntityEvoker.this.field_70170_p.func_72872_a(EntityVex.class, EntityEvoker.this.func_174813_aQ().func_186662_g(32.0)).size();
            return EntityEvoker.this.field_70146_Z.nextInt(10) == 0 ? false : 4 > i;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            for (int i = 0; i < (EntityEvoker.this.isHero() ? 8 : 4); ++i) {
                BlockPos blockpos = new BlockPos((Entity)EntityEvoker.this).func_177982_a(-3 + EntityEvoker.this.field_70146_Z.nextInt(6), EntityEvoker.this.field_70146_Z.nextInt(4), -3 + EntityEvoker.this.field_70146_Z.nextInt(6));
                EntityVex entityvex = new EntityVex(EntityEvoker.this.field_70170_p);
                entityvex.func_174828_a(blockpos, 0.0f, 0.0f);
                entityvex.func_180482_a(EntityEvoker.this.field_70170_p.func_175649_E(blockpos), null);
                if (!EntityEvoker.this.isWild()) {
                    entityvex.setOwnerId(EntityEvoker.this.func_184753_b());
                }
                entityvex.setBoundOrigin(blockpos);
                entityvex.setLimitedLife(400);
                EntityEvoker.this.field_70170_p.func_72838_d((Entity)entityvex);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected int getSpellId() {
            return 1;
        }
    }

    class AICastingSpell
    extends EntityAIBase {
        public AICastingSpell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return !EntityEvoker.this.func_70631_g_() && EntityEvoker.this.getSpellCastingTime() > 0 && EntityEvoker.this.field_70173_aa > 20;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityEvoker.this.setIsCastingSpell(EntityEvoker.this.spellCastId);
            EntityEvoker.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityEvoker.this.setIsCastingSpell(0);
        }

        public void func_75246_d() {
            if (EntityEvoker.this.getConvertingTarget() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a((Entity)EntityEvoker.this.getConvertingTarget(), (float)EntityEvoker.this.func_184649_cE(), (float)EntityEvoker.this.func_70646_bf());
            } else if (EntityEvoker.this.getAllyTarget() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a((Entity)EntityEvoker.this.getAllyTarget(), (float)EntityEvoker.this.func_184649_cE(), (float)EntityEvoker.this.func_70646_bf());
            } else if (EntityEvoker.this.getWololoTarget() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a((Entity)EntityEvoker.this.getWololoTarget(), (float)EntityEvoker.this.func_184649_cE(), (float)EntityEvoker.this.func_70646_bf());
            } else if (EntityEvoker.this.func_70638_az() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a((Entity)EntityEvoker.this.func_70638_az(), (float)EntityEvoker.this.func_184649_cE(), (float)EntityEvoker.this.func_70646_bf());
            }
        }
    }

    class AILightningBoltSpell
    extends AIUseSpell {
        private AILightningBoltSpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null) {
                double d = EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az());
                double d2 = EntityEvoker.this.isHero() && EntityEvoker.this.getSpecialAttackTimer() <= 0 ? 64.0 : 30.48;
                if (d > d2) {
                    return false;
                }
            }
            return EntityEvoker.this.field_70146_Z.nextInt(3) == 0 || EntityEvoker.this.isHero() && EntityEvoker.this.getSpecialAttackTimer() <= 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                try {
                    ReflectionHelper.findField(entitylivingbase.getClass(), (String[])new String[]{"shieldTime"}).setInt(entitylivingbase, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (EntityEvoker.this.isHero() && EntityEvoker.this.getSpecialAttackTimer() <= 0) {
                    EntityEvoker.this.performSpecialAttack();
                } else {
                    float f = EntityEvoker.this.field_70761_aq * ((float)Math.PI / 180);
                    float f1 = MathHelper.func_76134_b((float)f);
                    float f2 = MathHelper.func_76126_a((float)f);
                    double d1 = EntityEvoker.this.field_70165_t - (double)(f2 * 0.4f);
                    double d2 = EntityEvoker.this.field_70163_u + 1.25;
                    double d3 = EntityEvoker.this.field_70161_v + (double)(f1 * 0.4f);
                    EntityEvoker.this.fireLightning((Entity)entitylivingbase, d1, d2, d3);
                }
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return EntityEvoker.this.isHero() && EntityEvoker.this.getSpecialAttackTimer() <= 0 ? SoundEvents.field_187754_de : SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 5;
        }
    }

    class AIFrostRaySpell
    extends AIUseSpell {
        private AIFrostRaySpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null && (double)EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az()) > 18.288) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(2) == 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                try {
                    ReflectionHelper.findField(entitylivingbase.getClass(), (String[])new String[]{"shieldTime"}).setInt(entitylivingbase, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float f = EntityEvoker.this.field_70761_aq * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76134_b((float)f);
                float f2 = MathHelper.func_76126_a((float)f);
                double d1 = EntityEvoker.this.field_70165_t - (double)(f2 * 0.4f);
                double d2 = EntityEvoker.this.field_70163_u + 1.25;
                double d3 = EntityEvoker.this.field_70161_v + (double)(f1 * 0.4f);
                EntityEvoker.this.fireCone((Entity)entitylivingbase, d1, d2, d3);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 12;
        }
    }

    class AIDisintigrationRaySpell
    extends AIUseSpell {
        private AIDisintigrationRaySpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null && (double)EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az()) > 18.288) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(4) == 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                try {
                    ReflectionHelper.findField(entitylivingbase.getClass(), (String[])new String[]{"shieldTime"}).setInt(entitylivingbase, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float f = EntityEvoker.this.field_70761_aq * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76134_b((float)f);
                float f2 = MathHelper.func_76126_a((float)f);
                double d1 = EntityEvoker.this.field_70165_t - (double)(f2 * 0.4f);
                double d2 = EntityEvoker.this.field_70163_u + 1.25;
                double d3 = EntityEvoker.this.field_70161_v + (double)(f1 * 0.4f);
                EntityEvoker.this.fireRay((Entity)entitylivingbase, d1, d2, d3);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 11;
        }
    }

    class AIMagicMissileSpell
    extends AIUseSpell {
        private AIMagicMissileSpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null && (double)EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az()) > 36.576) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(2) == 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 40;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                for (int i = 0; i < (EntityEvoker.this.isHero() ? 18 : 9); ++i) {
                    if (EntityEvoker.this.field_70170_p.field_72995_K) continue;
                    EntityMagicMissile entitymagicmissiles = new EntityMagicMissile(EntityEvoker.this.field_70170_p, (Entity)entitylivingbase, (EntityLivingBase)EntityEvoker.this, EntityEvoker.this.field_70165_t, EntityEvoker.this.field_70163_u + 2.0, EntityEvoker.this.field_70161_v);
                    entitymagicmissiles.field_70163_u = EntityEvoker.this.field_70163_u + 2.0;
                    Random random = new Random();
                    entitymagicmissiles.field_70159_w += random.nextDouble() * 2.0 - 1.0;
                    entitymagicmissiles.field_70181_x += random.nextDouble() * 2.0;
                    entitymagicmissiles.field_70179_y += random.nextDouble() * 2.0 - 1.0;
                    EntityEvoker.this.field_70170_p.func_72838_d((Entity)entitymagicmissiles);
                }
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 7;
        }
    }

    class AIPoisonSpraySpell
    extends AIUseSpell {
        private AIPoisonSpraySpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null && (double)EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az()) > 9.144) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(2) == 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                EntityEvoker.this.attackEntityWithSpray(entitylivingbase, 1.0f);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 9;
        }
    }

    class AISmallFireballSpell
    extends AIUseSpell {
        private AISmallFireballSpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null && (double)EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az()) > 36.576) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(2) == 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                EntityEvoker.this.attackEntityWithRangedAttack2(entitylivingbase, 1.0f);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 10;
        }
    }

    class AIFireballSpell
    extends AIUseSpell {
        private AIFireballSpell() {
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityEvoker.this.func_70638_az() != null && (double)EntityEvoker.this.func_70032_d((Entity)EntityEvoker.this.func_70638_az()) > 45.72 && EntityEvoker.this.func_70068_e((Entity)EntityEvoker.this.func_70638_az()) < 45.0) {
                return false;
            }
            return EntityEvoker.this.field_70146_Z.nextInt(2) == 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S()) {
                EntityEvoker.this.func_82196_d(entitylivingbase, 1.0f);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 8;
        }
    }

    class AIAttackSpell
    extends AIUseSpell {
        private AIAttackSpell() {
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 40;
        }

        @Override
        protected void castSpell() {
            EntityLivingBase entitylivingbase = EntityEvoker.this.func_70638_az();
            double d0 = EntityEvoker.this.field_70163_u;
            double d1 = EntityEvoker.this.field_70163_u;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntityEvoker.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntityEvoker.this.field_70165_t));
            if (EntityEvoker.this.func_70068_e((Entity)entitylivingbase) < 27.0) {
                float f2;
                int k;
                float f1;
                int i;
                d0 = EntityEvoker.this.field_70163_u;
                d1 = EntityEvoker.this.field_70163_u;
                for (i = 0; i < 5; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.spawnFangs(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 1.0, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 1.0, d0, d1, f1, 0);
                }
                for (i = 0; i < 10; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 0.2f;
                    this.spawnFangs(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 2.0, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 2.0, d0, d1, f1, 20);
                }
                for (k = 0; k < 20; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.1f;
                    this.spawnFangs(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.0, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.0, d0, d1, f2, 40);
                }
                for (i = 0; i < 20; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 0.1f;
                    this.spawnFangs(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 3.0, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 3.0, d0, d1, f1, 60);
                }
                for (k = 0; k < 30; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.1f;
                    this.spawnFangs(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 6.0, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 6.0, d0, d1, f2, 60);
                }
            } else if (!entitylivingbase.field_70170_p.field_72995_K && entitylivingbase != null && entitylivingbase.func_70089_S() && !EntityEvoker.this.field_70170_p.field_72995_K) {
                float j = EntityEvoker.this.field_70761_aq * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76134_b((float)j);
                float f2 = MathHelper.func_76126_a((float)j);
                EntityInvisibleFangsProjectile entitymagicmissiles = new EntityInvisibleFangsProjectile(EntityEvoker.this.field_70170_p, (Entity)entitylivingbase, (EntityLivingBase)EntityEvoker.this, EntityEvoker.this.field_70165_t - (double)(f2 * 2.0f), EntityEvoker.this.field_70163_u, EntityEvoker.this.field_70161_v + (double)(f1 * 2.0f));
                EntityEvoker.this.field_70170_p.func_72838_d((Entity)entitymagicmissiles);
            }
        }

        private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = true;
            double d0 = 0.0;
            if (flag && !EntityEvoker.this.field_70170_p.field_72995_K) {
                EntityEvokerFangOther entityevokerfangs = new EntityEvokerFangOther(EntityEvoker.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (EntityLivingBase)EntityEvoker.this);
                EntityEvoker.this.field_70170_p.func_72838_d((Entity)entityevokerfangs);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected int getSpellId() {
            return 2;
        }
    }
}

