/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.MobChunkLoader;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.Ender;
import net.minecraft.entity.helpful.EntityBodyHelperDragon;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.tier5.dragonphases.EntityDragonFireballOther;
import net.minecraft.entity.helpful.tier5.dragonphases.IPhase;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseList;
import net.minecraft.entity.helpful.tier5.dragonphases.PhaseManager;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnderDragon
extends EntityFriendlyCreature
implements IEntityMultiPart,
Massive,
Flying,
Armored,
Ender {
    private static final DataParameter<Boolean> CARRIES_CRYSTAL = EntityDataManager.func_187226_a(EntityEnderDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityEnderDragon.class, (DataSerializer)DataSerializers.field_187192_b);
    public int innerRotation;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public EntityDragonPart[] dragonPartArray;
    public EntityDragonPart dragonPartHead;
    public EntityDragonPart dragonPartNeck;
    public EntityDragonPart dragonPartBody;
    public EntityDragonPart dragonPartTail1;
    public EntityDragonPart dragonPartTail2;
    public EntityDragonPart dragonPartTail3;
    public EntityDragonPart dragonPartWing1;
    public EntityDragonPart dragonPartWing2;
    double sitPosX;
    double sitPosY;
    double sitPosZ;
    public float prevAnimTime;
    public float animTime;
    public boolean slowed;
    public boolean sitting;
    private final PhaseManager phaseManager;
    private int field_184678_bK = 200;
    private int sittingDamageReceived;
    private final PathPoint[] pathPoints = new PathPoint[24];
    private final int[] neighbors = new int[24];
    private final PathHeap pathFindQueue = new PathHeap();

    public EntityEnderDragon(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.dragonPartHead = new EntityDragonPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);
        this.dragonPartNeck = new EntityDragonPart((IEntityMultiPart)this, "neck", 6.0f, 6.0f);
        this.dragonPartBody = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 8.0f);
        this.dragonPartTail1 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartTail2 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartTail3 = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        this.dragonPartWing1 = new EntityDragonPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.dragonPartWing2 = new EntityDragonPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
        this.dragonPartArray = new EntityDragonPart[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(16.0f, 3.6f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.phaseManager = new PhaseManager(this);
        this.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
        this.field_98038_p = true;
        this.field_70728_aV = 500;
    }

    @Override
    public int getNextLevelRequirement() {
        return 2500;
    }

    @Override
    public void func_70071_h_() {
        ItemStack charge = this.isCarryingCrystal() ? new ItemStack(Items.field_185158_cP) : ItemStack.field_190927_a;
        charge.func_151001_c("Carrying Crystal");
        this.basicInventory.func_70299_a(7, charge);
        super.func_70071_h_();
        ++this.innerRotation;
    }

    @Override
    public void updateBossBar() {
        super.updateBossBar();
        this.bossInfo.func_186745_a(this.getTier() == EnumTier.TIER6 ? BossInfo.Color.RED : BossInfo.Color.PINK);
        this.bossInfo.func_186742_b(true);
    }

    @Override
    public boolean isABoss() {
        return true;
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public boolean affectedByCommandingStaff() {
        return false;
    }

    @Override
    public boolean canWearEasterEggs() {
        return false;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.5f;
    }

    @Override
    public float getBonusVSFlying() {
        return 3.0f;
    }

    @Override
    public float getBonusVSMassive() {
        return 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.ENDER;
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 64.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 64.0f + this.field_70146_Z.nextFloat() * 32.0f;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDarkness() {
        return true;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(27.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(15.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PHASE, (Object)PhaseList.HOLDING_PATTERN.getId());
        this.func_184212_Q().func_187214_a(CARRIES_CRYSTAL, (Object)false);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean isCarryingCrystal() {
        return (Boolean)this.func_184212_Q().func_187225_a(CARRIES_CRYSTAL);
    }

    public void setCarryingCrystal(boolean childZombie) {
        this.func_184212_Q().func_187227_b(CARRIES_CRYSTAL, (Object)childZombie);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return 2.325f;
    }

    public double[] getMovementOffsets(int p_70974_1_, float p_70974_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = MathHelper.func_76138_g((double)(this.ringBuffer[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = this.ringBuffer[i][2] + (this.ringBuffer[j][2] - this.ringBuffer[i][2]) * (double)p_70974_2_;
        return adouble;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_ENDER_DRAGON;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151061_bv && (this.hasOwner(player) || player.func_184191_r((Entity)this))) {
            this.func_184185_a(this.func_184639_G(), 0.25f, 0.75f);
            if (!this.func_184207_aI()) {
                if (this.sitting) {
                    this.sitting = false;
                } else {
                    this.sitting = true;
                    this.sitPosX = this.field_70165_t;
                    this.sitPosY = this.field_70163_u;
                    this.sitPosZ = this.field_70161_v;
                }
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_185158_cP && (this.hasOwner(player) || player.func_184191_r((Entity)this))) {
            if (!this.isCarryingCrystal()) {
                this.setCarryingCrystal(true);
                this.func_70642_aH();
                this.field_70170_p.func_175718_b(3000, this.func_180425_c(), 0);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        return 3.25;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 5;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f3 = this.field_70761_aq * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f3);
            float f4 = MathHelper.func_76134_b((float)f3);
            if (i == 5) {
                passenger.func_70107_b(this.dragonPartTail3.field_70165_t, this.dragonPartTail3.field_70163_u + 1.0, this.dragonPartTail3.field_70161_v);
            }
            if (i == 4) {
                passenger.func_70107_b(this.dragonPartTail2.field_70165_t, this.dragonPartTail2.field_70163_u + 1.0, this.dragonPartTail2.field_70161_v);
            }
            if (i == 3) {
                passenger.func_70107_b(this.dragonPartTail1.field_70165_t, this.dragonPartTail1.field_70163_u + 1.0, this.dragonPartTail1.field_70161_v);
            }
            if (i == 2) {
                passenger.func_70107_b(this.field_70165_t + (double)(f11 * 1.0f), this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v - (double)(f4 * 1.0f));
            }
            if (i == 1) {
                passenger.func_70107_b(this.field_70165_t + (double)(f11 * -1.0f), this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v - (double)(f4 * -1.0f));
            }
            if (i == 0) {
                passenger.func_70107_b(this.dragonPartNeck.field_70165_t, this.dragonPartNeck.field_70163_u + 1.0, this.dragonPartNeck.field_70161_v);
            }
        }
    }

    @Override
    public void performSpecialAttack() {
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.func_70642_aH();
        this.setSpecialAttackTimer(2000);
    }

    public void func_70625_a(Entity entityIn, float maxYawIncrease, float maxPitchIncrease) {
        double d1;
        double d0 = entityIn.field_70165_t - this.field_70165_t;
        double d2 = entityIn.field_70161_v - this.field_70161_v;
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d1 = (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f1, maxPitchIncrease);
        this.field_70759_as = this.updateRotation(this.field_70759_as, f, maxYawIncrease);
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    @Override
    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityPlayer;
    }

    @Override
    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    protected EntityBodyHelper func_184650_s() {
        return new EntityBodyHelperDragon((EntityLivingBase)this);
    }

    @Override
    public void func_70636_d() {
        int j;
        EntityPlayer player;
        if (this.convertionInt > 0) {
            this.phaseManager.setPhase(PhaseList.LANDING);
            this.field_70159_w *= 0.75;
            this.field_70181_x *= 0.75;
            this.field_70179_y *= 0.75;
        }
        if (this.convertionInt > 0 && this.field_70173_aa % 10 == 0 && (player = this.field_70170_p.func_72890_a((Entity)this, -1.0)) != null) {
            for (int i1 = 0; i1 < this.convertionInt; ++i1) {
                float f1 = (float)i1 * (float)Math.PI / ((float)this.timesToConvert() * 0.5f);
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 10.0, this.field_70163_u + (double)this.field_70131_O + 1.0, this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 10.0, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
        if (this.getPhaseManager().getCurrentPhase() == PhaseList.LANDING_APPROACH) {
            this.func_70624_b(null);
            double d0 = (this.isWild() ? 0.0 : this.getOwner().field_70165_t) - this.field_70165_t;
            double d1 = (this.isWild() ? (double)this.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a).func_177956_o() : this.getOwner().field_70163_u + 4.0) - this.field_70163_u;
            double d2 = (this.isWild() ? 0.0 : this.getOwner().field_70161_v) - this.field_70161_v;
            double d3 = d0 * d0 + d2 * d2;
            double d5 = MathHelper.func_76133_a((double)d3);
            this.func_70091_d(MoverType.SELF, d0 / d5 * 0.99 - this.field_70159_w, d1 / d5 * 0.99 - this.field_70181_x, d2 / d5 * 0.99 - this.field_70179_y);
        }
        if (!this.func_70089_S()) {
            this.func_70674_bp();
        }
        if (this.sitting) {
            this.phaseManager.setPhase(PhaseList.HOLDING_PATTERN);
            this.func_70012_b(this.sitPosX, this.sitPosY, this.sitPosZ, this.field_70177_z, this.field_70125_A);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            if (this.func_70638_az() != null && this.phaseManager.getCurrentPhase() != PhaseList.LANDING_APPROACH && this.phaseManager.getCurrentPhase() != PhaseList.LANDING) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 90.0f);
                this.field_70761_aq = this.field_70177_z = this.field_70759_as + 180.0f;
            }
            if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) > 10000.0) {
                this.sitPosX = this.getOwner().field_70165_t;
                this.sitPosY = this.getOwner().field_70163_u + 12.0;
                this.sitPosZ = this.getOwner().field_70161_v;
            }
        }
        if (this.field_70729_aU) {
            this.phaseManager.setPhase(PhaseList.DYING);
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 5.0f && !this.phaseManager.getCurrentPhase().getIsStationary()) {
            this.phaseManager.setPhase(PhaseList.LANDING_APPROACH);
            this.func_70624_b(null);
        }
        if (this.getJukeboxToDanceTo() != null) {
            Vec3d vec3d = this.getHeadLookVec(1.0f).func_72432_b();
            vec3d.func_178785_b(-0.7853982f);
            double d0 = this.dragonPartHead.field_70165_t;
            double d1 = this.dragonPartHead.field_70163_u + (double)(this.dragonPartHead.field_70131_O / 2.0f);
            double d2 = this.dragonPartHead.field_70161_v;
            for (int i = 0; i < 8; ++i) {
                double d3 = d0 + this.func_70681_au().nextGaussian() / 2.0;
                double d4 = d1 + this.func_70681_au().nextGaussian() / 2.0;
                double d5 = d2 + this.func_70681_au().nextGaussian() / 2.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRAGON_BREATH, d3, d4, d5, -vec3d.field_72450_a * (double)0.08f + this.field_70159_w, -vec3d.field_72448_b * (double)0.3f + this.field_70181_x, -vec3d.field_72449_c * (double)0.08f + this.field_70179_y, new int[0]);
                vec3d.func_178785_b(0.19634955f);
            }
        }
        if (this.moralRaisedTimer <= 0) {
            this.moralRaisedTimer = 0;
        }
        if (this.moralRaisedTimer > 0) {
            --this.moralRaisedTimer;
        }
        if (this.func_175446_cd()) {
            this.func_94061_f(this.func_175446_cd());
            this.field_70172_ad = this.field_70771_an;
            if (this.field_70173_aa > 21) {
                --this.field_70173_aa;
            }
        } else {
            if (this.func_110143_aJ() > this.func_110138_aP() / 5.0f) {
                this.field_70715_bh.func_75774_a();
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
                    double d = this.func_70068_e((Entity)this.func_70638_az());
                    float f = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                    float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                    if (d < (double)(this.reachWidth * this.reachWidth + f * f2) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 10 == 0) {
                        this.func_70652_k((Entity)this.func_70638_az());
                    }
                }
                if (this.func_70089_S()) {
                    MobChunkLoader.updateLoaded((Entity)this);
                } else {
                    MobChunkLoader.stopLoading((Entity)this);
                }
            }
        }
        this.func_174810_b(this.func_175446_cd());
        this.field_70703_bu = false;
        this.field_70160_al = false;
        this.field_70122_E = true;
        if (this.getJukeboxToDanceTo() != null) {
            this.func_70661_as().func_75499_g();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(this.getJukeboxToDanceTo());
            Block block = iblockstate.func_177230_c();
            if (this.field_70173_aa > 100) {
                this.field_70173_aa = 20;
            }
            if (this.innerRotation > 500) {
                this.innerRotation = 0;
            }
            this.sitting = true;
            this.func_70634_a(this.getJukeboxToDanceTo().func_177958_n(), (double)this.getJukeboxToDanceTo().func_177956_o() + 12.0, this.getJukeboxToDanceTo().func_177952_p());
            if (block != Blocks.field_150421_aI || block == Blocks.field_150421_aI && !((Boolean)iblockstate.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue() || this.func_174831_c(this.jukeBoxToDanceTo) > 10000.0) {
                this.setJukeboxToDanceTo(null);
                this.getPhaseManager().setPhase(PhaseList.SITTING_SCANNING);
                this.sitting = false;
            }
        }
        if (this.getJukeboxToDanceTo() == null && this.field_70173_aa % 60 == 0) {
            int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
            boolean flag = false;
            for (int k2 = -12 - (int)this.field_70130_N; k2 <= 12 + (int)this.field_70130_N; ++k2) {
                for (int l2 = -12 - (int)this.field_70130_N; l2 <= 12 + (int)this.field_70130_N; ++l2) {
                    for (int j2 = -18 - (int)this.field_70131_O; j2 <= 18 + (int)this.field_70131_O; ++j2) {
                        int i3 = l1 + k2;
                        int k = i11 + j2;
                        int l = i2 + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = iblockstate.func_177230_c();
                        if (block != Blocks.field_150421_aI || !((Boolean)iblockstate.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) continue;
                        this.setJukeboxToDanceTo(blockpos);
                        if (this.field_70173_aa > 100) {
                            this.field_70173_aa = 20;
                        }
                        if (this.innerRotation > 500) {
                            this.innerRotation = 0;
                        }
                        this.getPhaseManager().setPhase(PhaseList.SITTING_SCANNING);
                    }
                }
            }
        }
        this.dragonPartHead.field_70130_N = this.dragonPartHead.field_70131_O = 2.5f * this.getFittness();
        this.dragonPartNeck.field_70130_N = this.dragonPartNeck.field_70131_O = 2.5f * this.getFittness();
        this.dragonPartTail1.field_70130_N = this.dragonPartTail1.field_70131_O = 2.0f * this.getFittness();
        this.dragonPartTail2.field_70130_N = this.dragonPartTail2.field_70131_O = 2.0f * this.getFittness();
        this.dragonPartTail3.field_70130_N = this.dragonPartTail3.field_70131_O = 2.0f * this.getFittness();
        this.dragonPartBody.field_70131_O = 3.5f * this.getFittness();
        this.dragonPartBody.field_70130_N = 5.0f * this.getFittness();
        this.dragonPartWing1.field_70131_O = 3.0f * this.getFittness();
        this.dragonPartWing1.field_70130_N = 4.0f * this.getFittness();
        this.dragonPartWing2.field_70131_O = 3.0f * this.getFittness();
        this.dragonPartWing2.field_70130_N = 4.0f * this.getFittness();
        Vec3d[] avec3d = new Vec3d[this.dragonPartArray.length];
        for (int j3 = 0; j3 < this.dragonPartArray.length; ++j3) {
            avec3d[j3] = new Vec3d(this.dragonPartArray[j3].field_70165_t, this.dragonPartArray[j3].field_70163_u, this.dragonPartArray[j3].field_70161_v);
        }
        float f14 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
        float f16 = MathHelper.func_76134_b((float)f14);
        float f18 = MathHelper.func_76126_a((float)f14);
        float f2 = this.field_70177_z * ((float)Math.PI / 180);
        float f19 = MathHelper.func_76126_a((float)f2);
        float f3 = MathHelper.func_76134_b((float)f2);
        double[] adouble = this.getMovementOffsets(5, 1.0f);
        double[] adouble1 = this.getMovementOffsets(14, 1.0f);
        double[] adouble2 = this.getMovementOffsets(16, 1.0f);
        this.dragonPartBody.func_70071_h_();
        this.dragonPartBody.func_70012_b(this.field_70165_t, this.field_70163_u - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2) - 0.5f)) * 0.1f * this.getFittness()), this.field_70161_v, 0.0f, 0.0f);
        this.dragonPartWing1.func_70071_h_();
        this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f3 * (4.5f * this.getFittness())), this.field_70163_u + 1.0 + (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2))) * 3.0f), this.field_70161_v + (double)(f19 * (4.5f * this.getFittness())), 0.0f, 0.0f);
        this.dragonPartWing2.func_70071_h_();
        this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f3 * (4.5f * this.getFittness())), this.field_70163_u + 1.0 + (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2))) * 3.0f), this.field_70161_v - (double)(f19 * (4.5f * this.getFittness())), 0.0f, 0.0f);
        this.dragonPartNeck.func_70071_h_();
        this.dragonPartNeck.func_70012_b(this.field_70165_t + (double)(f19 * (3.5f * this.getFittness())), this.field_70163_u + 1.0 - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2) + 1.0f)) * 0.1f * this.getFittness()) + (double)(f18 * (2.0f * this.getFittness())) - (double)(this.field_70125_A / 90.0f) * Math.PI * 0.25, this.field_70161_v - (double)(f3 * (3.5f * this.getFittness())), 0.0f, 0.0f);
        this.dragonPartHead.func_70071_h_();
        this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f19 * (6.0f * this.getFittness())), this.field_70163_u + 1.0 - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2))) * 0.1f * this.getFittness()) + (double)(f18 * (4.0f * this.getFittness())) - (double)(this.field_70125_A / 90.0f) * Math.PI * 1.0, this.field_70161_v - (double)(f3 * (6.0f * this.getFittness())), 0.0f, 0.0f);
        for (j = 0; j < 3; ++j) {
            EntityDragonPart entitydragonpart = null;
            if (j == 0) {
                entitydragonpart = this.dragonPartTail1;
            }
            if (j == 1) {
                entitydragonpart = this.dragonPartTail2;
            }
            if (j == 2) {
                entitydragonpart = this.dragonPartTail3;
            }
            adouble1 = this.getMovementOffsets(12 + j * 2, 1.0f);
            float f21 = this.field_70177_z * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
            float f22 = MathHelper.func_76126_a((float)f21);
            float f7 = MathHelper.func_76134_b((float)f21);
            float f23 = 1.5f;
            float f24 = (float)(j + 1) * 2.0f;
            entitydragonpart.func_70071_h_();
            entitydragonpart.func_70012_b(this.field_70165_t - (double)((f19 * f23 + f22 * f24 * this.getFittness()) * f16), this.field_70163_u - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2) + (float)j)) * (0.2f * (float)(j + 1) * this.getFittness())) - (double)(f18 * (2.0f + (float)(1 * j))) + (double)f23, this.field_70161_v + (double)((f3 * f23 + f7 * f24 * this.getFittness()) * f16), 0.0f, 0.0f);
        }
        for (int l = 0; l < this.dragonPartArray.length; ++l) {
            this.dragonPartArray[l].field_70169_q = avec3d[l].field_72450_a;
            this.dragonPartArray[l].field_70167_r = avec3d[l].field_72448_b;
            this.dragonPartArray[l].field_70166_s = avec3d[l].field_72449_c;
        }
        if (this.isWild() && this.func_184753_b() == null) {
            if (this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
            }
        } else {
            if (this.func_70638_az() != null && this.getJukeboxToDanceTo() == null && this.phaseManager.getCurrentPhase() != PhaseList.LANDING_APPROACH && this.phaseManager.getCurrentPhase() != PhaseList.LANDING) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 90.0f);
                if (this.sitting) {
                    this.field_70761_aq = this.field_70177_z = this.field_70759_as + 180.0f;
                }
            } else {
                this.field_70759_as = this.field_70177_z - 180.0f;
                this.field_70125_A = this.getPhaseManager().getCurrentPhase().getIsStationary() || this.sitting ? 20.0f : 0.0f;
            }
            this.convertionInt = 0;
            if (this.isHero()) {
                for (j = 0; j < this.dragonPartArray.length; ++j) {
                    avec3d[j] = new Vec3d(this.dragonPartArray[j].field_70165_t, this.dragonPartArray[j].field_70163_u, this.dragonPartArray[j].field_70161_v);
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d3 = 10.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.dragonPartArray[j].field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.dragonPartArray[j].field_70130_N * 2.0f) - (double)this.dragonPartArray[j].field_70130_N - d0 * d3, this.dragonPartArray[j].field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.dragonPartArray[j].field_70131_O) - d1 * d3, this.dragonPartArray[j].field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.dragonPartArray[j].field_70130_N * 2.0f) - (double)this.dragonPartArray[j].field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                }
            }
        }
        if (this.field_70146_Z.nextInt(5) == 0 && !this.isWild() && this.getOwner().func_70643_av() != null && this.isOffensive) {
            this.func_70624_b(this.getOwner().func_70643_av());
        }
        this.field_70145_X = true;
        this.reachWidth = 8.0f;
        this.func_70105_a(16.0f, 3.6f);
        this.field_70122_E = false;
        this.field_70160_al = true;
        if (this.field_70173_aa % 5 == 0) {
            this.slowed = false;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
            if (!this.func_174814_R()) {
                float f = MathHelper.func_76134_b((float)(this.animTime * ((float)Math.PI * 2)));
                float f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * ((float)Math.PI * 2)));
                if (f1 <= -0.3f && f >= -0.3f) {
                    if (this.func_70093_af()) {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    } else {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    }
                }
                if (!this.phaseManager.getCurrentPhase().getIsStationary() && --this.field_184678_bK < 0) {
                    if (this.func_70093_af()) {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    } else {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    }
                    this.field_184678_bK = 200 + this.field_70146_Z.nextInt(200);
                }
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_175446_cd()) {
            this.animTime = 0.0f;
        } else if (this.func_70089_S()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.field_70163_u;
                }
            }
            if (++this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
            this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70716_bi > 0) {
                    double d5 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                    double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                    double d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                    double d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                    this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                    this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                    --this.field_70716_bi;
                    this.func_70107_b(d5, d0, d1);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
                this.phaseManager.getCurrentPhase().doClientRenderEffects();
            } else {
                Vec3d vec3d;
                IPhase iphase = this.phaseManager.getCurrentPhase();
                iphase.doLocalUpdate();
                if (this.phaseManager.getCurrentPhase() != iphase) {
                    iphase = this.phaseManager.getCurrentPhase();
                    iphase.doLocalUpdate();
                }
                if ((vec3d = iphase.getTargetLocation()) != null) {
                    double d6 = vec3d.field_72450_a - this.field_70165_t;
                    double d7 = vec3d.field_72448_b - this.field_70163_u;
                    double d8 = vec3d.field_72449_c - this.field_70161_v;
                    if (this.func_184207_aI()) {
                        double look = 2.0;
                        Vec3d vec3 = this.func_70676_i(1.0f);
                        d6 = this.field_70165_t + vec3d.field_72450_a * look;
                        d7 = this.field_70163_u + vec3d.field_72448_b * look;
                        d8 = this.field_70165_t + vec3d.field_72449_c * look;
                    }
                    double d3 = d6 * d6 + d7 * d7 + d8 * d8;
                    float f6 = iphase.getMaxRiseOrFall();
                    d7 = MathHelper.func_151237_a((double)(d7 / (double)MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8))), (double)(-f6), (double)f6);
                    this.field_70181_x += d7 * (double)0.1f;
                    this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                    double d4 = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)d6, (double)d8) * 57.29577951308232 - (double)this.field_70177_z)), (double)-50.0, (double)50.0);
                    Vec3d vec3d1 = new Vec3d(vec3d.field_72450_a - this.field_70165_t, vec3d.field_72448_b - this.field_70163_u, vec3d.field_72449_c - this.field_70161_v).func_72432_b();
                    Vec3d vec3d2 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
                    float f8 = Math.max(((float)vec3d2.func_72430_b(vec3d1) + 0.5f) / 1.5f, 0.0f);
                    this.field_70704_bt *= 0.8f;
                    this.field_70704_bt = (float)((double)this.field_70704_bt + d4 * (double)iphase.getYawFactor());
                    this.field_70177_z += this.field_70704_bt * 0.1f;
                    float f9 = (float)(2.0 / (d3 + 1.0));
                    float f10 = 0.06f;
                    if (this.field_70173_aa > 20 && !this.sitting) {
                        this.func_70060_a(0.0f, -1.0f, f10 * (f8 * f9 + (1.0f - f9)));
                    }
                    if (this.field_70173_aa > 20 && !this.sitting) {
                        if (this.getPhaseManager().getCurrentPhase() == PhaseList.CHARGING_PLAYER) {
                            if (this.func_70093_af()) {
                                this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 0.375 : 0.25), this.field_70181_x * (this.func_184207_aI() ? 0.375 : 0.25), this.field_70179_y * (this.func_184207_aI() ? 0.375 : 0.25));
                            } else if (this.moralRaisedTimer > 200) {
                                this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 15.0 : 10.0), this.field_70181_x * (this.func_184207_aI() ? 15.0 : 10.0), this.field_70179_y * (this.func_184207_aI() ? 15.0 : 10.0));
                            } else {
                                this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 7.5 : 5.0), this.field_70181_x * (this.func_184207_aI() ? 7.5 : 5.0), this.field_70179_y * (this.func_184207_aI() ? 7.5 : 5.0));
                            }
                        } else {
                            if (this.func_70093_af()) {
                                this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 0.375 : 0.25), this.field_70181_x * (this.func_184207_aI() ? 0.375 : 0.25), this.field_70179_y * (this.func_184207_aI() ? 0.375 : 0.25));
                            }
                            if (this.moralRaisedTimer > 200) {
                                this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 3.0 : 2.0), this.field_70181_x * (this.func_184207_aI() ? 3.0 : 2.0), this.field_70179_y * (this.func_184207_aI() ? 3.0 : 2.0));
                            } else {
                                this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 1.5 : 1.0), this.field_70181_x * (this.func_184207_aI() ? 1.5 : 1.0), this.field_70179_y * (this.func_184207_aI() ? 1.5 : 1.0));
                            }
                        }
                    }
                    Vec3d vec3d3 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
                    float f11 = ((float)vec3d3.func_72430_b(vec3d2) + 1.0f) / 2.0f;
                    f11 = 0.8f + 0.15f * f11;
                    if (this.func_184207_aI()) {
                        f11 = 0.91f;
                    }
                    this.field_70159_w *= (double)f11;
                    this.field_70179_y *= (double)f11;
                    this.field_70181_x *= (double)0.91f;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.collideWithEntities(this.dragonPartHead, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.dragonPartNeck, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartNeck.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.dragonPartBody, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartBody.func_174813_aQ().func_186662_g(1.0)));
                this.flingEntities(this.dragonPartWing1, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.func_174813_aQ().func_186662_g(4.0).func_72317_d(0.0, -2.0, 0.0)));
                this.flingEntities(this.dragonPartWing2, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.func_174813_aQ().func_186662_g(4.0).func_72317_d(0.0, -2.0, 0.0)));
                this.collideWithEntities(this.dragonPartTail1, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail1.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.dragonPartTail2, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail2.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.dragonPartTail3, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail3.func_174813_aQ().func_186662_g(1.0)));
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(3.0)));
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartNeck.func_174813_aQ().func_186662_g(2.0)));
            }
            this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartNeck.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartWing1.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartWing2.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartTail1.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartTail2.func_174813_aQ());
            this.destroyBlocksInAABB(this.dragonPartTail3.func_174813_aQ());
        }
        if (this.getSpecialAttackTimer() > 0) {
            if (this.moralRaisedTimer > 200) {
                this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 2);
            } else {
                this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 1);
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.deathTicks > 0) {
            for (int j4 = 0; j4 < this.dragonPartArray.length; ++j4) {
                avec3d[j4] = new Vec3d(this.dragonPartArray[j4].field_70165_t, this.dragonPartArray[j4].field_70163_u, this.dragonPartArray[j4].field_70161_v);
                double d1 = this.field_70146_Z.nextFloat() * this.dragonPartArray[j4].field_70130_N - this.dragonPartArray[j4].field_70130_N / 2.0f;
                double d2 = this.field_70146_Z.nextFloat() * this.dragonPartArray[j4].field_70131_O - this.dragonPartArray[j4].field_70131_O / 2.0f;
                double d3 = this.field_70146_Z.nextFloat() * this.dragonPartArray[j4].field_70130_N - this.dragonPartArray[j4].field_70130_N / 2.0f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.dragonPartArray[j4].field_70165_t + d1, this.dragonPartArray[j4].field_70163_u + d2, this.dragonPartArray[j4].field_70161_v + d3, 0.0, (double)0.1f, 0.0, new int[0]);
            }
            float f13 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f15 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f17 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f13, this.field_70163_u + (double)f15, this.field_70161_v + (double)f17, 0.0, 0.0, 0.0, new int[0]);
        } else {
            List list;
            if (this.func_70638_az() != null && !this.getPhaseManager().getCurrentPhase().getIsStationary() && this.getPhaseManager().getCurrentPhase() != PhaseList.CHARGING_PLAYER && this.getPhaseManager().getCurrentPhase() != PhaseList.STRAFE_PLAYER && this.func_70638_az() != null && this.field_70173_aa % 60 == 0 && this.func_70681_au().nextInt(5) == 0 && !this.sitting) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.getPhaseManager().setPhase(PhaseList.CHARGING_PLAYER);
                        this.getPhaseManager().getPhase(PhaseList.CHARGING_PLAYER).func_188668_a(new Vec3d(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
                        break;
                    }
                    case 1: {
                        this.getPhaseManager().setPhase(PhaseList.STRAFE_PLAYER);
                        this.getPhaseManager().getPhase(PhaseList.STRAFE_PLAYER).func_188686_a(this.func_70638_az());
                    }
                }
            }
            if (this.isHero() && this.getSpecialAttackTimer() > 1995 && (list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(256.0, 256.0, 256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    double d6 = this.field_70165_t + (this.field_70146_Z.nextDouble() * 32.0 - 16.0);
                    double d7 = this.field_70163_u + 64.0 + (this.field_70146_Z.nextDouble() * 32.0 - 16.0);
                    double d8 = this.field_70161_v + (this.field_70146_Z.nextDouble() * 32.0 - 16.0);
                    double d9 = entity.field_70165_t - d6;
                    double d10 = entity.field_70163_u + (double)(entity.field_70131_O / 2.0f) - (d7 + (double)(this.field_70131_O / 2.0f));
                    double d11 = entity.field_70161_v - d8;
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                    EntityDragonFireballOther entitydragonfireball = new EntityDragonFireballOther(this.field_70170_p, (EntityLivingBase)this, d9, d10, d11);
                    entitydragonfireball.field_70165_t = d6;
                    entitydragonfireball.field_70163_u = d7;
                    entitydragonfireball.field_70161_v = d8;
                    this.field_70170_p.func_72838_d((Entity)entitydragonfireball);
                }
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                this.performSpecialAttack();
            }
            if (this.func_184207_aI() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
                EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
                passenger.field_70143_R *= 0.0f;
                passenger.field_70172_ad = 40;
                passenger.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 40, 4));
                this.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
                this.field_70761_aq = this.field_70177_z = passenger.field_70759_as + 180.0f;
                this.field_70125_A = 0.0f;
                for (int i = 0; i < 256; ++i) {
                    double d1 = 0.005;
                    if (this.moralRaisedTimer > 200) {
                        d1 *= 2.0;
                    }
                    if (this.func_70051_ag()) {
                        d1 *= 2.0;
                    }
                    Vec3d vec3 = passenger.func_70676_i(1.0f);
                    if (passenger.field_70701_bs > 0.0f) {
                        this.func_70107_b(this.field_70165_t + vec3.field_72450_a * d1, this.field_70163_u + vec3.field_72448_b * d1, this.field_70161_v + vec3.field_72449_c * d1);
                        Entity[] aentity = this.func_70021_al();
                        if (aentity != null) {
                            for (Entity entity : aentity) {
                                entity.func_70012_b(entity.field_70165_t + vec3.field_72450_a * d1, entity.field_70163_u + vec3.field_72448_b * d1, entity.field_70161_v + vec3.field_72449_c * d1, 0.0f, 0.0f);
                            }
                        }
                    }
                    if (!(passenger.field_70701_bs < 0.0f)) continue;
                    this.func_70107_b(this.field_70165_t - vec3.field_72450_a * d1, this.field_70163_u - vec3.field_72448_b * d1, this.field_70161_v - vec3.field_72449_c * d1);
                }
            }
            if (!this.isWild() && this.getOwner().func_70051_ag()) {
                this.func_70031_b(true);
            } else {
                this.func_70031_b(false);
            }
            if (!this.isWild() && this.getOwner().func_70093_af()) {
                this.func_70095_a(true);
            } else {
                this.func_70095_a(false);
            }
            if (this.func_70093_af() && !this.getPhaseManager().getCurrentPhase().getIsStationary() && this.field_70146_Z.nextInt(100) == 0) {
                this.getPhaseManager().setPhase(PhaseList.LANDING_APPROACH);
            }
            if (!this.getPhaseManager().getCurrentPhase().getIsStationary() && !this.isWild() && (this.getOwner().func_110143_aJ() <= 6.0f || !this.getOwner().func_184614_ca().func_190926_b() && this.getOwner().func_184614_ca().func_77973_b() == Items.field_151069_bo) && this.func_70681_au().nextInt(20) == 0) {
                this.getPhaseManager().setPhase(PhaseList.STRAFE_PLAYER);
                this.getPhaseManager().getPhase(PhaseList.STRAFE_PLAYER).func_188686_a(this.getOwner());
            }
            if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70737_aN <= 5) {
                this.func_70691_i(this.func_70638_az() != null || this.func_70644_a(MobEffects.field_76438_s) ? 0.02f : 0.1f);
            }
            if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) >= 48400.0) {
                this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().func_70685_l((Entity)this) && this.field_70146_Z.nextInt(120) == 0) {
                double d1 = this.dragonPartHead.field_70165_t;
                double d2 = this.dragonPartHead.field_70163_u + 0.25;
                double d3 = this.dragonPartHead.field_70161_v;
                this.fireLightning((Entity)this.func_70638_az(), d1, d2, d3);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().func_70685_l((Entity)this) && this.field_70146_Z.nextInt(120) == 0) {
                double d6 = this.dragonPartHead.field_70165_t;
                double d7 = this.dragonPartHead.field_70163_u + 0.5;
                double d8 = this.dragonPartHead.field_70161_v;
                double d9 = this.func_70638_az().field_70165_t - d6;
                double d10 = this.func_70638_az().field_70163_u + 1.0 - d7;
                double d11 = this.func_70638_az().field_70161_v - d8;
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                EntityDragonFireballOther entitydragonfireball = new EntityDragonFireballOther(this.field_70170_p, (EntityLivingBase)this, d9, d10, d11);
                entitydragonfireball.field_70165_t = d6;
                entitydragonfireball.field_70163_u = d7;
                entitydragonfireball.field_70161_v = d8;
                this.field_70170_p.func_72838_d((Entity)entitydragonfireball);
            }
            if (this.field_70146_Z.nextInt(2) == 0 && !this.isWild() && this.getOwner().func_70643_av() != null) {
                this.func_70624_b(this.getOwner().func_70643_av());
            }
            if (!(this.func_70638_az() == null || this.func_70638_az().func_70089_S() && this.isOffensive && !this.isOnSameTeam(this.func_70638_az()))) {
                this.func_70624_b(null);
            }
            this.updateDragonEnderCrystal();
            float f12 = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            f12 *= (float)Math.pow(2.0, this.field_70181_x);
            if (this.field_70173_aa > 20) {
                this.animTime = this.phaseManager.getCurrentPhase().getIsStationary() || this.func_184207_aI() && ((EntityLivingBase)this.func_184179_bs()).field_70701_bs == 0.0f || this.getPhaseManager().getCurrentPhase() == PhaseList.CHARGING_PLAYER || this.sitting ? (this.func_70093_af() ? (this.animTime += 0.05f) : (this.animTime += 0.1f)) : (this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += f12));
            }
            this.field_70760_ar = this.field_70761_aq = this.field_70177_z;
        }
        if (this.field_70173_aa % 20 == 0) {
            this.func_70691_i(1.0f);
        }
    }

    private float func_184662_q(float p_184662_1_) {
        double d0 = 0.0;
        if (this.phaseManager.getCurrentPhase().getIsStationary() || this.getPhaseManager().getCurrentPhase() == PhaseList.HOVER) {
            d0 = -1.0;
        } else {
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            double[] adouble1 = this.getMovementOffsets(0, 1.0f);
            d0 = adouble[1] - adouble1[0];
        }
        return (float)d0;
    }

    private void updateDragonEnderCrystal() {
        if (this.field_70173_aa % 5 == 0 && this.func_70089_S() && this.isCarryingCrystal()) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
    }

    protected void collideWithEntities(EntityDragonPart part, List list) {
        double d0 = (part.func_174813_aQ().field_72340_a + part.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (part.func_174813_aQ().field_72339_c + part.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : list) {
            if (!this.func_70089_S() || !(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity) || this.field_70170_p.field_72995_K) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 4.0, 0.75, d3 / d4 * 4.0);
            this.slowed = true;
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as = (float)MathHelper.func_181159_b((double)entity.field_70179_y, (double)entity.field_70159_w) * 57.295776f - 90.0f;
                ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
                ((EntityLivingBase)entity).func_70604_c(null);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_70624_b(null);
                }
            }
            if (!(entity instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
        }
    }

    protected void flingEntities(EntityDragonPart part, List list) {
        double d0 = (part.func_174813_aQ().field_72340_a + part.func_174813_aQ().field_72336_d) / 1.5;
        double d1 = (part.func_174813_aQ().field_72339_c + part.func_174813_aQ().field_72334_f) / 1.5;
        for (Entity entity : list) {
            if (!this.func_70089_S() || !(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity) || this.field_70170_p.field_72995_K) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 32.0, 1.5, d3 / d4 * 32.0);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as = (float)MathHelper.func_181159_b((double)entity.field_70179_y, (double)entity.field_70159_w) * 57.295776f - 90.0f;
                ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
                ((EntityLivingBase)entity).func_70604_c(null);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_70624_b(null);
                }
            }
            entity.func_70097_a(DamageSource.field_188406_j, 4.0f);
            if (!(entity instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
        }
    }

    protected void attackEntitiesInList(List p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = (Entity)p_70971_1_.get(i);
            if (!this.func_70089_S() || entity.field_70173_aa + entity.func_145782_y() % 10 != 0 || this.field_70170_p.field_72995_K || !(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
            this.func_70652_k(entity);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as = (float)MathHelper.func_181159_b((double)entity.field_70179_y, (double)entity.field_70159_w) * 57.295776f - 90.0f;
                ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
                ((EntityLivingBase)entity).func_70604_c(null);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_70624_b(null);
                }
            }
            this.func_184185_a(SoundEvents.field_187685_dH, 5.0f, 0.5f);
            this.slowed = true;
        }
    }

    private float simplifyAngle(double p_70973_1_) {
        return (float)MathHelper.func_76138_g((double)p_70973_1_);
    }

    protected boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || !this.func_70089_S() || block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this)) continue;
                    if (block != Blocks.field_150384_bq && block != Blocks.field_150380_bt && block != Blocks.field_150357_h && block != Blocks.field_150377_bs && block != Blocks.field_150343_Z && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db) {
                        if (this.field_70170_p.field_72995_K) continue;
                        flag1 = this.field_70170_p.func_175698_g(blockpos) || flag1;
                        continue;
                    }
                    this.slowed = true;
                }
            }
        }
        return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
    }

    @Override
    public int getDamageCap() {
        return 50;
    }

    public boolean func_70965_a(EntityDragonPart dragonPart, DamageSource source, float damage) {
        if (this.func_110143_aJ() <= 0.0f) {
            this.phaseManager.setPhase(PhaseList.DYING);
        }
        damage = this.phaseManager.getCurrentPhase().getAdjustedDamage(dragonPart, source, damage);
        if (dragonPart != this.dragonPartHead) {
            damage = damage / 5.0f + Math.min(damage, 1.0f);
        }
        if (this.func_180431_b(source) || damage < 0.01f || source == DamageSource.field_82727_n || source == DamageSource.field_76368_d || source == DamageSource.field_76369_e || source == DamageSource.field_191291_g || source == DamageSource.field_76367_g) {
            return false;
        }
        float f = this.func_110143_aJ();
        super.func_70097_a(source, damage);
        if (this.func_110143_aJ() <= 0.0f && !this.phaseManager.getCurrentPhase().getIsStationary() && !this.isWild()) {
            this.phaseManager.setPhase(PhaseList.DYING);
        }
        if (this.phaseManager.getCurrentPhase().getIsStationary()) {
            this.sittingDamageReceived = (int)((float)this.sittingDamageReceived + (f - this.func_110143_aJ()));
            if ((float)this.sittingDamageReceived > 50.0f) {
                this.sittingDamageReceived = 0;
                if (source.func_76346_g() instanceof EntityLivingBase) {
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            this.getPhaseManager().setPhase(PhaseList.CHARGING_PLAYER);
                            this.getPhaseManager().getPhase(PhaseList.CHARGING_PLAYER).func_188668_a(new Vec3d(((EntityLivingBase)source.func_76346_g()).field_70165_t, ((EntityLivingBase)source.func_76346_g()).field_70163_u, ((EntityLivingBase)source.func_76346_g()).field_70161_v));
                            break;
                        }
                        case 1: {
                            this.getPhaseManager().setPhase(PhaseList.STRAFE_PLAYER);
                            this.getPhaseManager().getPhase(PhaseList.STRAFE_PLAYER).func_188686_a((EntityLivingBase)source.func_76346_g());
                        }
                    }
                }
            }
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
            if (!this.isWild() && source.func_76346_g() == this.getOwner()) {
                this.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
            } else {
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.getPhaseManager().setPhase(PhaseList.CHARGING_PLAYER);
                    this.getPhaseManager().getPhase(PhaseList.CHARGING_PLAYER).func_188668_a(new Vec3d(source.func_76346_g().field_70165_t, source.func_76346_g().field_70163_u, source.func_76346_g().field_70161_v));
                }
            }
        }
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_70965_a(this.dragonPartBody, source, amount);
    }

    @Override
    protected void func_70609_aI() {
        ArrayList list = Lists.newArrayList();
        List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.func_180425_c()).func_186662_g(256.0));
        for (Entity entity : entities) {
            if (!(entity instanceof EntityEnderCrystal)) continue;
            entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
            this.func_70606_j(50.0f);
            this.field_70729_aU = false;
            this.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
            break;
        }
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                for (int i = 1000; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                if (Loader.isModLoaded((String)"draconicevolution")) {
                    Entity var8 = EntityList.func_188429_b((ResourceLocation)new ResourceLocation("draconicevolution:dragonheartitem"), (World)this.field_70170_p);
                    this.field_70170_p.func_72838_d(var8);
                }
                this.field_70170_p.func_175669_a(1028, new BlockPos((Entity)this), 0);
                if (this.getOwner() != null) {
                    for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                        this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), SoundEvents.field_187522_aL, this.func_184176_by(), this.func_70599_aP(), 1.0f);
                        entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s " + this.func_70005_c_() + " has been killed!!!", new Object[0]), true);
                    }
                    ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Ender Dragon has fallen in battle.", new Object[0]));
                }
            }
        }
        double d0 = (this.isWild() ? 0.0 : this.getOwner().field_70165_t) - this.field_70165_t;
        double d1 = (this.isWild() ? (double)this.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a).func_177956_o() : this.getOwner().field_70163_u + 4.0) - this.field_70163_u;
        double d2 = (this.isWild() ? 0.0 : this.getOwner().field_70161_v) - this.field_70161_v;
        double d3 = d0 * d0 + d2 * d2;
        if (this.field_70173_aa > 20) {
            if (d3 > 1.0 && this.deathTicks < 1) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70177_z = this.field_70759_as = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f + 180.0f;
                this.field_70761_aq = this.field_70759_as;
                this.field_70159_w += d0 / d5 * 0.75 - this.field_70159_w;
                this.field_70181_x += d1 / d5 * 0.75 - this.field_70181_x;
                this.field_70179_y += d2 / d5 * 0.75 - this.field_70179_y;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            } else {
                this.func_70091_d(MoverType.SELF, 0.0, 0.1f, 0.0);
                this.field_70759_as = this.field_70177_z += 10.0f;
                this.field_70761_aq = this.field_70177_z;
                ++this.deathTicks;
            }
        }
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 2000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
            }
            this.field_70170_p.func_180501_a(new BlockPos(this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v), Blocks.field_150380_bt.func_176223_P(), 3);
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 5), 4.0f);
            this.func_145778_a(Items.field_185160_cR, 1, 4.0f);
            this.func_70106_y();
        }
    }

    private void func_184668_a(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    public int initPathPoints() {
        if (this.pathPoints[0] == null) {
            int i = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int i1 = 0; i1 < 24; ++i1) {
                int j1 = 5;
                if (i1 < 12) {
                    i = (int)(60.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i1))));
                    k = (int)(60.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i1))));
                } else if (i1 < 20) {
                    l = i1 - 12;
                    i = (int)(40.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)l))));
                    k = (int)(40.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)l))));
                    j1 += 10;
                } else {
                    l = i1 - 20;
                    i = (int)(20.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)l))));
                    k = (int)(20.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)l))));
                }
                j = Math.max(this.field_70170_p.func_181545_F() + 10, this.field_70170_p.func_175672_r(new BlockPos(i, 0, k)).func_177956_o() + j1);
                this.pathPoints[i1] = new PathPoint(i, j, k);
            }
            this.neighbors[0] = 6146;
            this.neighbors[1] = 8197;
            this.neighbors[2] = 8202;
            this.neighbors[3] = 16404;
            this.neighbors[4] = 32808;
            this.neighbors[5] = 32848;
            this.neighbors[6] = 65696;
            this.neighbors[7] = 131392;
            this.neighbors[8] = 131712;
            this.neighbors[9] = 263424;
            this.neighbors[10] = 526848;
            this.neighbors[11] = 525313;
            this.neighbors[12] = 1581057;
            this.neighbors[13] = 3166214;
            this.neighbors[14] = 2138120;
            this.neighbors[15] = 6373424;
            this.neighbors[16] = 4358208;
            this.neighbors[17] = 12910976;
            this.neighbors[18] = 9044480;
            this.neighbors[19] = 9706496;
            this.neighbors[20] = 15216640;
            this.neighbors[21] = 0xD0E000;
            this.neighbors[22] = 11763712;
            this.neighbors[23] = 0x7E0000;
        }
        return this.getNearestPpIdx(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public int getNearestPpIdx(double x, double y, double z) {
        int j;
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        for (int k = j = 12; k < 24; ++k) {
            float f1;
            if (this.pathPoints[k] == null || !((f1 = this.pathPoints[k].func_75832_b(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    public Path findPath(int startIdx, int finishIdx, PathPoint andThen) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.pathPoints[i];
            pathpoint.field_75842_i = false;
            pathpoint.field_75834_g = 0.0f;
            pathpoint.field_75836_e = 0.0f;
            pathpoint.field_75833_f = 0.0f;
            pathpoint.field_75841_h = null;
            pathpoint.field_75835_d = -1;
        }
        PathPoint pathpoint4 = this.pathPoints[startIdx];
        PathPoint pathpoint5 = this.pathPoints[finishIdx];
        pathpoint4.field_75836_e = 0.0f;
        pathpoint4.field_75834_g = pathpoint4.field_75833_f = pathpoint4.func_75829_a(pathpoint5);
        this.pathFindQueue.func_75848_a();
        this.pathFindQueue.func_75849_a(pathpoint4);
        PathPoint pathpoint1 = pathpoint4;
        int j = 12;
        while (!this.pathFindQueue.func_75845_e()) {
            PathPoint pathpoint2 = this.pathFindQueue.func_75844_c();
            if (pathpoint2.equals((Object)pathpoint5)) {
                if (andThen != null) {
                    andThen.field_75841_h = pathpoint5;
                    pathpoint5 = andThen;
                }
                return this.makePath(pathpoint4, pathpoint5);
            }
            if (pathpoint2.func_75829_a(pathpoint5) < pathpoint1.func_75829_a(pathpoint5)) {
                pathpoint1 = pathpoint2;
            }
            pathpoint2.field_75842_i = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.pathPoints[l] != pathpoint2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.neighbors[k] & 1 << i1) <= 0) continue;
                PathPoint pathpoint3 = this.pathPoints[i1];
                if (pathpoint3.field_75842_i) continue;
                float f = pathpoint2.field_75836_e + pathpoint2.func_75829_a(pathpoint3);
                if (pathpoint3.func_75831_a() && !(f < pathpoint3.field_75836_e)) continue;
                pathpoint3.field_75841_h = pathpoint2;
                pathpoint3.field_75836_e = f;
                pathpoint3.field_75833_f = pathpoint3.func_75829_a(pathpoint5);
                if (pathpoint3.func_75831_a()) {
                    this.pathFindQueue.func_75850_a(pathpoint3, pathpoint3.field_75836_e + pathpoint3.field_75833_f);
                    continue;
                }
                pathpoint3.field_75834_g = pathpoint3.field_75836_e + pathpoint3.field_75833_f;
                this.pathFindQueue.func_75849_a(pathpoint3);
            }
        }
        if (pathpoint1 == pathpoint4) {
            return null;
        }
        if (andThen != null) {
            andThen.field_75841_h = pathpoint1;
            pathpoint1 = andThen;
        }
        return this.makePath(pathpoint4, pathpoint1);
    }

    private Path makePath(PathPoint start, PathPoint finish) {
        int i = 1;
        PathPoint pathpoint = finish;
        while (pathpoint.field_75841_h != null) {
            ++i;
            pathpoint = pathpoint.field_75841_h;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint1 = finish;
        apathpoint[--i] = finish;
        while (pathpoint1.field_75841_h != null) {
            pathpoint1 = pathpoint1.field_75841_h;
            apathpoint[--i] = pathpoint1;
        }
        return new Path(apathpoint);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("DragonPhase", this.phaseManager.getCurrentPhase().getPhaseList().getId());
        tagCompound.func_74757_a("CarryingCrystal", this.isCarryingCrystal());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("DragonPhase")) {
            this.phaseManager.setPhase(PhaseList.getById(tagCompund.func_74762_e("DragonPhase")));
        }
        this.setCarryingCrystal(tagCompund.func_74767_n("CarryingCrystal"));
    }

    @Override
    protected void func_70623_bb() {
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    @Override
    public boolean func_70067_L() {
        return this.field_70170_p.func_72890_a((Entity)this, (double)this.field_70130_N) != null && this.func_70089_S();
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    protected void func_85033_bc() {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187526_aP;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187533_aW;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadPartYOffset(int p_184667_1_, double[] p_184667_2_, double[] p_184667_3_) {
        BlockPos blockpos = this.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a);
        if (this.getOwner() != null) {
            blockpos = new BlockPos((Entity)this.getOwner());
        }
        float f = Math.max(MathHelper.func_76133_a((double)this.func_174831_c(blockpos)) / 4.0f, 1.0f);
        return (float)p_184667_1_ / f;
    }

    public Vec3d getHeadLookVec(float p_184665_1_) {
        Vec3d vec3d;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseList<? extends IPhase> phaselist = iphase.getPhaseList();
        if (phaselist != PhaseList.LANDING && phaselist != PhaseList.TAKEOFF) {
            if (iphase.getIsStationary()) {
                float f4 = this.field_70125_A;
                float f5 = 1.5f;
                this.field_70125_A = -6.0f * f5 * 5.0f;
                vec3d = this.func_70676_i(p_184665_1_);
                this.field_70125_A = f4;
            } else {
                vec3d = this.func_70676_i(p_184665_1_);
            }
        } else {
            BlockPos blockpos = this.field_70170_p.func_175672_r(WorldGenEndPodium.field_186139_a);
            if (this.getOwner() != null) {
                blockpos = new BlockPos((Entity)this.getOwner());
            }
            float f = Math.max(MathHelper.func_76133_a((double)this.func_174831_c(blockpos)) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.field_70125_A;
            float f3 = 1.5f;
            this.field_70125_A = -f1 * f3 * 5.0f;
            vec3d = this.func_70676_i(p_184665_1_);
            this.field_70125_A = f2;
        }
        return vec3d;
    }

    public void onCrystalDestroyed(EntityEnderCrystal crystal, BlockPos pos, DamageSource dmgSrc) {
        EntityPlayer entityplayer = dmgSrc.func_76346_g() instanceof EntityPlayer ? (EntityPlayer)dmgSrc.func_76346_g() : this.field_70170_p.func_184139_a(pos, 64.0, 64.0);
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(crystal, pos, dmgSrc, entityplayer);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (PHASE.equals(key) && this.field_70170_p.field_72995_K) {
            this.phaseManager.setPhase(PhaseList.getById((Integer)this.func_184212_Q().func_187225_a(PHASE)));
        }
        super.func_184206_a(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        if (!potioneffectIn.func_188419_a().func_76398_f()) {
            super.func_70690_d(potioneffectIn);
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrushHeavy;
    }

    public boolean func_184222_aU() {
        return EngenderMod.sensorsShowJzahars(this.field_70170_p);
    }

    @Override
    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }
}

