/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier5;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.Elemental;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier5.EntitySnowballHarmful;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAbomniableSnowman
extends EntityFriendlyCreature
implements IRangedAttackMob,
Armored,
Massive,
Elemental {
    private AISpecialRangedAttack aiArrowAttack = new AISpecialRangedAttack(this, 1.0, 40, 32.0f);
    private EntityAIFriendlyAttackMelee aiAttackOnCollide = new EntityAIFriendlyAttackMelee(this, 1.0, true);

    public EntityAbomniableSnowman(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.5f, 5.36f);
        this.field_70728_aV = 50;
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 48.0f, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.67, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public int getNextLevelRequirement() {
        return 1500;
    }

    @Override
    public void updateBossBar() {
        super.updateBossBar();
        this.bossInfo.func_186745_a(BossInfo.Color.WHITE);
    }

    @Override
    public boolean isABoss() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityAbomniableSnowman(this.field_70170_p);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.CONSTRUCT;
    }

    @Override
    public float getBonusVSLight() {
        return 3.0f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 64.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(15.0);
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!(this.isWild() || !this.isOnSameTeam((EntityLivingBase)player) || this.func_70631_g_() || player.func_70093_af() || this.field_70170_p.field_72995_K)) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int i = this.func_184188_bt().indexOf(passenger);
            float f3 = this.field_70761_aq * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f3);
            float f4 = MathHelper.func_76134_b((float)f3);
            float sho = this.field_184619_aG - this.field_70721_aZ * (1.0f - (float)this.field_70173_aa * 0.001f) + 6.0f;
            float sho1 = (Math.abs(sho % 13.0f - 6.5f) - 3.25f) / 3.25f;
            if (i == 1) {
                passenger.func_70107_b(this.field_70165_t - (double)f4 * ((double)1.3f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.4 : 0.0)), this.field_70163_u + 3.5, this.field_70161_v - (double)f11 * ((double)1.3f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.4 : 0.0)));
            }
            if (i == 0) {
                passenger.func_70107_b(this.field_70165_t + (double)f4 * ((double)1.3f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.4 : 0.0)), this.field_70163_u + 3.5, this.field_70161_v + (double)f11 * ((double)1.3f + ((double)this.field_70721_aZ >= 0.01 ? (double)sho1 * 0.4 : 0.0)));
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br / 3.0f;
            forward = entitylivingbase.field_70701_bs / 3.0f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(1.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity) || this.field_70170_p.field_72995_K || this.field_70173_aa % 10 != 0) continue;
                this.func_70652_k(entity);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean func_184222_aU() {
        return EngenderMod.sensorsShowJzahars(this.field_70170_p);
    }

    @Override
    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        this.func_70105_a(2.5f, 5.36f);
        if (this.func_70638_az() != null) {
            if (this.func_70068_e((Entity)this.func_70638_az()) > 100.0 || this.func_70638_az() instanceof EntityFlying || this.func_70638_az().field_70163_u > this.field_70163_u + 4.0) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiArrowAttack);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            } else {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        AttributeModifier irongolemrandomizer = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D839"), "Iron Golem randomizer", this.field_70146_Z.nextDouble() * 2.5, 1).func_111168_a(false);
        IAttributeInstance iattributeinstanceattack = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (!iattributeinstanceattack.func_180374_a(irongolemrandomizer)) {
            iattributeinstanceattack.func_111121_a(irongolemrandomizer);
        }
        if (super.func_70652_k(entityIn)) {
            if (iattributeinstanceattack.func_180374_a(irongolemrandomizer)) {
                iattributeinstanceattack.func_111124_b(irongolemrandomizer);
            }
            return true;
        }
        return false;
    }

    @Override
    public void attackWithAdditionalEffects(Entity entity) {
        double amount = 1.0;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
            amount *= 0.75;
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            amount *= 1.5;
        }
        if (!entity.func_70089_S() && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70758_at = ((EntityLivingBase)entity).field_70759_as = this.field_70759_as;
            ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70126_B = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
            ((EntityLivingBase)entity).field_70760_ar = ((EntityLivingBase)entity).field_70759_as;
            float xRatio = MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180)));
            float zRatio = -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)));
            entity.field_70160_al = true;
            float f = MathHelper.func_76129_c((float)(xRatio * xRatio + zRatio * zRatio));
            entity.field_70159_w /= 3.0;
            entity.field_70179_y /= 3.0;
            entity.field_70159_w -= (double)xRatio / (double)f * 2.0;
            entity.field_70179_y -= (double)zRatio / (double)f * 2.0;
            entity.field_70181_x /= 2.0;
            entity.field_70181_x += amount;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
            }
        }
        entity.field_70181_x += amount;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.setSpecialAttackTimer(300);
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 1.0f);
            EntityAbomniableSnowman.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v, 3.0f, false);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(24.0, 3.0, 24.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity)) {
                        entity.field_70181_x += 1.5;
                        if (entity instanceof IMob) {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 24.0f);
                        } else {
                            entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this), 12.0f);
                        }
                        entity.field_70160_al = true;
                        float f = MathHelper.func_76129_c((float)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) + -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        entity.field_70159_w /= 2.0;
                        entity.field_70179_y /= 2.0;
                        entity.field_70159_w -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                        entity.field_70179_y -= (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                    }
                    if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was blown up by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, (this.func_70631_g_() ? 1.5f : 1.0f) / this.getFittness());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_IRON_GOLEM;
    }

    @Override
    protected void func_70609_aI() {
        double d1;
        double d0;
        int k;
        this.field_70737_aN = 10;
        ++this.deathTicks;
        if (this.deathTicks == 100) {
            if (!this.field_70170_p.field_72995_K && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v, j));
                }
            }
            for (k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
            this.func_70106_y();
        }
        this.func_184185_a(SoundEvents.field_187807_fF, 1.0f, 1.0f);
        for (k = 0; k < this.deathTicks; ++k) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            d0 = this.field_70146_Z.nextGaussian() * 0.02;
            d1 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, d2, d0, d1, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150433_aE.func_176223_P())});
        }
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 1) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
            if (this.getOwner() != null) {
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), 1.0f);
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s " + this.func_70005_c_() + " has been killed!!!", new Object[0]), true);
                }
                ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Wither has been destroyed!", new Object[0]));
            }
        }
    }

    public void throwSnowball(double x, double y, double z) {
        EntitySnowballHarmful entitysnowball = new EntitySnowballHarmful(this.field_70170_p, (EntityLivingBase)this);
        float f = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.25f;
        entitysnowball.func_70186_c(x, y + (double)f, z, 1.6f, 1.0f);
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitysnowball);
        entitysnowball.damage = 8.0f;
    }

    public void whirlSnowball(EntityLivingBase target) {
        EntitySnowballHarmful entitysnowball = new EntitySnowballHarmful(this.field_70170_p, (EntityLivingBase)this);
        float f2 = this.field_70761_aq * ((float)Math.PI / 180);
        float f19 = MathHelper.func_76126_a((float)f2);
        float f3 = MathHelper.func_76134_b((float)f2);
        double d1 = target.field_70165_t + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) - (this.field_70165_t + (double)(f19 * 1.5f));
        double d2 = target.field_70163_u - 2.0 - this.field_70146_Z.nextDouble() * 4.0 + (double)target.field_70131_O - (this.field_70163_u + (double)this.func_70047_e());
        double d3 = target.field_70161_v + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) - (this.field_70161_v - (double)(f3 * 1.5f));
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.25f;
        entitysnowball.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 1.0f);
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitysnowball);
        entitysnowball.damage = 4.0f;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        float f2 = this.field_70761_aq * ((float)Math.PI / 180);
        float f19 = MathHelper.func_76126_a((float)f2);
        float f3 = MathHelper.func_76134_b((float)f2);
        double d1 = target.field_70165_t - (this.field_70165_t + (double)(f19 * 1.5f));
        double d2 = target.field_70163_u - 3.0 + (double)target.field_70131_O - (this.field_70163_u + (double)this.func_70047_e());
        double d3 = target.field_70161_v - (this.field_70161_v - (double)(f3 * 1.5f));
        this.throwSnowball(d1, d2, d3);
    }

    public class AISpecialRangedAttack
    extends EntityAIBase {
        private final EntityAbomniableSnowman entityHost;
        private final IRangedAttackMob rangedAttackEntityHost;
        private EntityLivingBase attackTarget;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private int seeTime;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public AISpecialRangedAttack(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public AISpecialRangedAttack(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            if (!(attacker instanceof EntityLivingBase)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackEntityHost = attacker;
            this.entityHost = (EntityAbomniableSnowman)attacker;
            this.entityMoveSpeed = movespeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            this.attackTarget = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
        }

        public void func_75251_c() {
            this.attackTarget = null;
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        }

        public void func_75246_d() {
            double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
            boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20 || !this.entityHost.field_70122_E || this.entityMoveSpeed == 0.0) {
                this.entityHost.func_70661_as().func_75499_g();
            } else {
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            --this.rangedAttackTime;
            if (this.rangedAttackTime <= 0) {
                if (!flag) {
                    return;
                }
                if (this.entityHost.func_110143_aJ() <= this.entityHost.func_110138_aP() / 2.0f) {
                    if (this.rangedAttackTime % 2 == 0 && this.rangedAttackTime <= -20 && this.rangedAttackTime >= -100) {
                        this.entityHost.whirlSnowball(this.attackTarget);
                    }
                    if (this.rangedAttackTime <= -120) {
                        this.rangedAttackTime = 20;
                    }
                } else {
                    if (this.rangedAttackTime % 20 == 0) {
                        float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                        float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                        this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
                    }
                    if (this.rangedAttackTime <= -80) {
                        this.rangedAttackTime = 40;
                    }
                }
            }
        }
    }
}

