/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.init.MiscHandler;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIAttackRangedAlly;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier4.EntityPotionOther;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitch
extends EntityFriendlyCreature
implements IRangedAttackMob,
Light {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static final DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.func_187226_a(EntityWitch.class, (DataSerializer)DataSerializers.field_187198_h);
    private int witchAttackTimer;

    public EntityWitch(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.95f);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 32.0f, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRangedAlly(this, 1.0, 40, 10.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 10;
    }

    @Override
    public int getNextLevelRequirement() {
        return 100;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityWitch(this.field_70170_p);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_AGGRESSIVE, (Object)false);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ILLAGER;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187923_gw;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187921_gu;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                EntityWitch baby = new EntityWitch(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-32000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.25f : super.func_70647_i();
    }

    public void setAggressive(boolean aggressive) {
        this.func_184212_Q().func_187227_b(IS_AGGRESSIVE, (Object)aggressive);
    }

    public boolean func_184730_o() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AGGRESSIVE);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void performSpecialAttack() {
        this.func_184185_a(ModSoundEvents.witchSpecial, 10.0f, 1.0f);
        this.setSpecialAttackTimer(1200);
    }

    @Override
    public void func_70636_d() {
        List list;
        this.func_70105_a(0.5f, 1.95f);
        if (this.isHero() && this.getSpecialAttackTimer() == 1180 && (list = this.field_70170_p.func_175647_a(EntityLiving.class, this.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLiving entity = (EntityLiving)list.get(i1);
                if (entity == null || !entity.func_184222_aU() || entity instanceof EntityFriendlyCreature || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                EntityPig entityzombie = new EntityPig(this.field_70170_p);
                entityzombie.func_82149_j((Entity)entity);
                this.field_70170_p.func_72900_e((Entity)entity);
                entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                entityzombie.func_70656_aK();
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)entityzombie);
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 256.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.witchAttackTimer <= 28 && this.witchAttackTimer > 0 && this.field_70173_aa % 4 == 0 && this.func_70089_S()) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187664_bz, this.func_184176_by(), this.func_70599_aP(), this.func_70647_i() - 0.2f);
            }
            if (this.func_184730_o() && this.func_110143_aJ() > 0.0f && this.field_70173_aa > 20) {
                if (this.witchAttackTimer-- <= 0) {
                    this.field_70761_aq = this.field_70177_z = this.field_70759_as;
                    this.setAggressive(false);
                    ItemStack itemstack = this.func_184614_ca();
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    if (itemstack.func_77973_b() == Items.field_151068_bn) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187739_dZ, this.func_184176_by(), this.func_70599_aP(), this.func_70647_i());
                        List list2 = PotionUtils.func_185189_a((ItemStack)itemstack);
                        if (list2 != null) {
                            for (PotionEffect potioneffect : list2) {
                                this.func_70690_d(new PotionEffect(potioneffect));
                            }
                        }
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
                }
            } else {
                PotionType potiontype = null;
                if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76427_o)) {
                    potiontype = PotionTypes.field_185249_u;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76426_n)) {
                    potiontype = PotionTypes.field_185242_n;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76424_c)) {
                    potiontype = PotionTypes.field_185245_q;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76428_l)) {
                    potiontype = PotionTypes.field_185221_D;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76439_r)) {
                    potiontype = PotionTypes.field_185235_g;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76430_j)) {
                    potiontype = PotionTypes.field_185240_l;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && !this.func_70644_a(MobEffects.field_76420_g) && this.func_70638_az() != null) {
                    potiontype = PotionTypes.field_185225_H;
                } else if (this.field_70146_Z.nextFloat() < 0.1f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potiontype = PotionTypes.field_185251_w;
                }
                if (potiontype != null && this.func_110143_aJ() > 0.0f && this.field_70173_aa > 20 && !this.func_70631_g_()) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                    this.witchAttackTimer = this.func_184614_ca().func_77988_m();
                    this.setAggressive(true);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), this.func_70599_aP(), this.func_70647_i());
                    IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    iattributeinstance.func_111124_b(MODIFIER);
                    iattributeinstance.func_111121_a(MODIFIER);
                }
            }
            if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.getOwner() != null && this.field_70170_p.func_72890_a((Entity)this, 128.0) != null && this.field_70170_p.func_72890_a((Entity)this, 128.0) == this.getOwner() && this.func_70068_e((Entity)this.getOwner()) < 128.0 && this.field_70146_Z.nextInt(200) == 0) {
                this.func_82196_d(this.getOwner(), 0.0f);
                this.func_70671_ap().func_75651_a((Entity)this.getOwner(), 180.0f, 30.0f);
            }
            if (this.field_70146_Z.nextFloat() < 0.01f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            }
        }
        super.func_70636_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 15) {
            for (int i = 0; i < 50; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.13f, this.func_174813_aQ().field_72337_e + 0.5 + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    @Override
    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (source.func_82725_o()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_WITCH;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        for (int i = 0; i < (this.isHero() ? 3 : 1); ++i) {
            if (this.func_184730_o() || !this.func_70685_l((Entity)target)) continue;
            double d0 = target.field_70163_u + (double)target.func_70047_e();
            double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double d2 = d0 - this.field_70163_u;
            double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
            PotionType potiontype = PotionTypes.field_185253_y;
            if (this.isOnSameTeam(target)) {
                switch (this.field_70146_Z.nextInt(8)) {
                    case 0: {
                        potiontype = PotionTypes.field_185251_w;
                        break;
                    }
                    case 1: {
                        potiontype = PotionTypes.field_185242_n;
                        break;
                    }
                    case 2: {
                        potiontype = PotionTypes.field_185235_g;
                        break;
                    }
                    case 3: {
                        potiontype = PotionTypes.field_185249_u;
                        break;
                    }
                    case 4: {
                        potiontype = PotionTypes.field_185222_E;
                        break;
                    }
                    case 5: {
                        potiontype = PotionTypes.field_185245_q;
                        break;
                    }
                    case 6: {
                        potiontype = PotionTypes.field_185225_H;
                        break;
                    }
                    case 7: {
                        potiontype = PotionTypes.field_185240_l;
                    }
                }
            }
            if ((target instanceof EntityWitch || target instanceof net.minecraft.entity.monster.EntityWitch) && !this.isOnSameTeam(target)) {
                target.func_70097_a(DamageSource.field_76368_d, 5.0f);
                potiontype = PotionTypes.field_185233_e;
                target.field_70172_ad = 0;
                target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 100, 4));
            } else if (target.func_70662_br() && !this.isOnSameTeam(target)) {
                potiontype = PotionTypes.field_185251_w;
            } else if (target.func_184222_aU() && !target.func_70644_a(MobEffects.field_76421_d) && target.func_70687_e(new PotionEffect(MobEffects.field_76421_d)) && target != this.getOwner()) {
                potiontype = PotionTypes.field_185247_s;
            } else if (target.func_184222_aU() && target.func_110143_aJ() >= 2.0f && !target.func_70662_br() && target.func_70687_e(new PotionEffect(MobEffects.field_76436_u)) && !(target instanceof net.minecraft.entity.helpful.tier3.EntitySpider) && !(target instanceof EntitySpider) && !target.func_70644_a(MobEffects.field_76436_u) && !this.isOnSameTeam(target)) {
                potiontype = PotionTypes.field_185219_B;
            } else if (target.func_184222_aU() && !target.func_70644_a(MobEffects.field_76437_t) && target.func_70687_e(new PotionEffect(MobEffects.field_76437_t)) && !this.isOnSameTeam(target)) {
                potiontype = PotionTypes.field_185227_J;
            } else if (target.func_184222_aU() && Loader.isModLoaded((String)"abyssalcraft") && target.func_70687_e(new PotionEffect(AbyssalCraftAPI.antimatter_potion)) && !EntityUtil.isEntityAnti((EntityLivingBase)target) && this.isAntiMob() && !target.func_70644_a(AbyssalCraftAPI.antimatter_potion) && !this.isOnSameTeam(target)) {
                potiontype = MiscHandler.antiMatter_long;
            }
            EntityPotionOther entitypotion = new EntityPotionOther(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
            entitypotion.field_70125_A -= -20.0f;
            entitypotion.func_70186_c(d1, d2 + (double)(f * (this.func_70032_d((Entity)target) * (this.isOnSameTeam(target) ? 1.0E-4f : 0.025f))), d3, 1.0f, 9.0f);
            this.func_70642_aH();
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.field_70170_p.func_72838_d((Entity)entitypotion);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.84f;
    }
}

