/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.ai.EntityAIVindicatorBreakDoor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVindicator
extends EntityFriendlyCreature {
    protected static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(EntityVindicator.class, (DataSerializer)DataSerializers.field_187191_a);
    private boolean johnny;

    public EntityVindicator(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.9f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6, 80));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.isOffensive = true;
        this.field_70728_aV = 10;
    }

    @Override
    public int getNextLevelRequirement() {
        return 150;
    }

    @Override
    public float getBonusVSLight() {
        return 0.75f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 1.5f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityVindicator(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.4f : super.func_70647_i();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                EntityVindicator baby = new EntityVindicator(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-60000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ILLAGER;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_VINDICATION_ILLAGER;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean getVindicatorFlag(int p_190637_1_) {
        byte i = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        return (i & p_190637_1_) != 0;
    }

    private void setVindicatorFlag(int p_190638_1_, boolean p_190638_2_) {
        int i = ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID)).byteValue();
        i = p_190638_2_ ? (i |= p_190638_1_) : (i &= ~p_190638_1_);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public void setAggressive(boolean p_190636_1_) {
        this.setVindicatorFlag(1, p_190636_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAggressive() {
        return this.getVindicatorFlag(1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.johnny) {
            compound.func_74757_a("Johnny", true);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Johnny", 99)) {
            this.johnny = compound.func_74767_n("Johnny");
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ientitylivingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return ientitylivingdata;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151036_c));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.5f, 1.9f);
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.func_70031_b(true);
        }
        this.setAggressive(this.johnny ? true : this.func_70638_az() != null);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && stack.func_77973_b() instanceof ItemAxe) {
            this.func_70642_aH();
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && stack.func_190926_b()) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(hand);
            this.func_184185_a(SoundEvents.field_191268_hm, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (!this.johnny && "Johnny".equals(name)) {
            this.field_70173_aa = 0;
            this.func_184185_a(ModSoundEvents.heresJohnny, 2.0f, 1.0f);
            this.johnny = true;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIVindicatorBreakDoor((EntityLiving)this));
        } else {
            this.johnny = false;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(false);
            this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIVindicatorBreakDoor((EntityLiving)this));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() - 0.3f);
        }
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() - 0.3f);
        }
        return SoundEvents.field_191270_ho;
    }
}

