/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.Ender;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Structure;
import net.minecraft.entity.helpful.tier4.EntityShulkerBulletFriendly;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShulker
extends EntityFriendlyCreature
implements Armored,
Structure,
Ender {
    private static final UUID COVERED_ARMOR_BONUS_ID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_BONUS_MODIFIER = new AttributeModifier(COVERED_ARMOR_BONUS_ID, "Covered armor bonus", 20.0, 0).func_111168_a(false);
    protected static final DataParameter<EnumFacing> ATTACHED_FACE = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> ATTACHED_BLOCK_POS = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> PEEK_TICK = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(EntityShulker.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final EnumDyeColor DEFAULT_COLOR = EnumDyeColor.PURPLE;
    private float prevPeekAmount;
    private float peekAmount;
    private BlockPos currentAttachmentPosition;
    private int clientSideTeleportInterpolation;

    public EntityShulker(World p_i46779_1_) {
        super(p_i46779_1_);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.currentAttachmentPosition = null;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIAttack());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIPeek());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public int getNextLevelRequirement() {
        return 200;
    }

    @Override
    public float getBonusVSLight() {
        return 1.5f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.1f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 1.0f;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityShulker(this.field_70170_p);
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        this.setColor(DEFAULT_COLOR);
        return super.func_180482_a(difficulty, livingdata);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.ENDER;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    public void func_70642_aH() {
        if (!this.isClosed()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    protected SoundEvent func_184601_bQ() {
        return this.isClosed() ? SoundEvents.field_187785_eU : SoundEvents.field_187783_eT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PEEK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)((byte)DEFAULT_COLOR.func_176765_a()));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper((EntityLivingBase)this);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)compound.func_74771_c("Peek"));
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74771_c("Color"));
        if (compound.func_74764_b("APX")) {
            int i = compound.func_74762_e("APX");
            int j = compound.func_74762_e("APY");
            int k = compound.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("AttachFace", (byte)((EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        compound.func_74774_a("Peek", ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue());
        compound.func_74774_a("Color", ((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue());
        BlockPos blockpos = this.getAttachmentPos();
        if (blockpos != null) {
            compound.func_74768_a("APX", blockpos.func_177958_n());
            compound.func_74768_a("APY", blockpos.func_177956_o());
            compound.func_74768_a("APZ", blockpos.func_177952_p());
        }
    }

    public EnumDyeColor getColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue());
    }

    public void setColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(COLOR);
        this.field_70180_af.func_187227_b(COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (stack != null && stack.func_77973_b() == Items.field_151100_aR && this.hasOwner(player)) {
            EnumDyeColor enumdyecolor = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
            if (this.getColor() != enumdyecolor) {
                this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
                player.func_184609_a(hand);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(new ItemStack(Items.field_151100_aR, 1, this.getColor().func_176767_b()), 1.0f);
                    this.setColor(enumdyecolor);
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151152_bP && this.hasOwner(player)) {
            this.func_184185_a(SoundEvents.field_187649_bu, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                if (!this.func_184614_ca().func_190926_b()) {
                    this.func_70099_a(this.func_184614_ca(), 1.0f);
                }
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        BlockPos blockpos;
        ItemStack charge = new ItemStack(Items.field_151100_aR, 1, this.getColor().func_176767_b());
        charge.func_151001_c("Color: " + this.getColor().func_176610_l());
        this.basicInventory.func_70299_a(7, charge);
        super.func_70071_h_();
        if (this.field_70725_aQ > 0) {
            this.field_70181_x = -0.6;
        }
        if (this.field_70725_aQ == 1) {
            this.func_184185_a(ModSoundEvents.buildingDeath, 2.0f, 1.0f);
            for (int k = 0; k < 200; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.1;
                double d0 = this.field_70146_Z.nextGaussian() * 0.1;
                double d1 = this.field_70146_Z.nextGaussian() * 0.1;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, -0.25, d1, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, -0.25, d1, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, 0.25, d1, new int[0]);
            }
        }
        if ((blockpos = (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull()) == null && !this.field_70170_p.field_72995_K) {
            blockpos = new BlockPos((Entity)this);
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
        }
        if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) >= 576.0) {
            this.teleportTo(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v);
        }
        if (this.func_184218_aH()) {
            float f;
            blockpos = null;
            this.field_70177_z = f = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.clientSideTeleportInterpolation = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos2;
            BlockPos blockpos1;
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                if (iblockstate.func_177230_c() == Blocks.field_180384_M) {
                    EnumFacing enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockPistonBase.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(enumfacing))) {
                        blockpos = blockpos.func_177972_a(enumfacing);
                        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
                    } else {
                        this.teleportShulkerToBlock();
                    }
                } else if (iblockstate.func_177230_c() == Blocks.field_150332_K) {
                    EnumFacing enumfacing3 = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockPistonExtension.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(enumfacing3))) {
                        blockpos = blockpos.func_177972_a(enumfacing3);
                        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
                    } else {
                        this.teleportShulkerToBlock();
                    }
                } else {
                    this.teleportShulkerToBlock();
                }
            }
            if (!this.field_70170_p.func_175677_d(blockpos1 = blockpos.func_177972_a(this.getAttachmentFacing()), false)) {
                boolean flag = false;
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    blockpos1 = blockpos.func_177972_a(enumfacing1);
                    if (!this.field_70170_p.func_175677_d(blockpos1, false)) continue;
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)enumfacing1);
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.teleportShulkerToBlock();
                }
            }
            if (this.field_70170_p.func_175677_d(blockpos2 = blockpos.func_177972_a(this.getAttachmentFacing().func_176734_d()), false)) {
                this.teleportShulkerToBlock();
            }
        }
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = MathHelper.func_76131_a((float)(this.peekAmount - 0.05f), (float)f1, (float)1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = MathHelper.func_76131_a((float)(this.peekAmount + 0.05f), (float)0.0f, (float)f1);
        }
        if (blockpos != null && this.field_70170_p.func_180495_p(blockpos) != Blocks.field_150350_a) {
            List list;
            if (this.field_70170_p.field_72995_K) {
                if (this.clientSideTeleportInterpolation > 0 && this.currentAttachmentPosition != null) {
                    --this.clientSideTeleportInterpolation;
                } else {
                    this.currentAttachmentPosition = blockpos;
                }
            }
            if (this.func_70089_S() && this.field_70170_p.func_180495_p(blockpos) != Blocks.field_150350_a) {
                this.field_70169_q = this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
                this.field_70142_S = this.field_70165_t;
                this.field_70167_r = this.field_70163_u = (double)blockpos.func_177956_o();
                this.field_70137_T = this.field_70163_u;
                this.field_70166_s = this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
                this.field_70136_U = this.field_70161_v;
            }
            double d3 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.peekAmount) * (float)Math.PI)) * 0.5;
            double d4 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.prevPeekAmount) * (float)Math.PI)) * 0.5;
            double d5 = d3 - d4;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            if (d5 > 0.0 && !(list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof EntityShulker || entity.field_70145_X) continue;
                    entity.func_70091_d(MoverType.SHULKER, d0, d1, d2);
                }
            }
            if (this.func_70631_g_()) {
                float f = 0.0f;
                if (f > f1) {
                    f = MathHelper.func_76131_a((float)(f - 0.05f), (float)f1, (float)1.0f);
                } else if (f < f1) {
                    f = MathHelper.func_76131_a((float)(f + 0.05f), (float)0.0f, (float)f1);
                }
                d3 = 0.25 - (double)MathHelper.func_76126_a((float)((0.5f + f) * (float)Math.PI)) * 0.25;
                EnumFacing enumfacing2 = this.getAttachmentFacing();
                switch (enumfacing2) {
                    default: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.25, this.field_70163_u, this.field_70161_v - 0.25, this.field_70165_t + 0.25, this.field_70163_u + 0.5 + d3, this.field_70161_v + 0.25));
                        break;
                    }
                    case UP: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.25, this.field_70163_u - d3 + 0.5, this.field_70161_v - 0.25, this.field_70165_t + 0.25, this.field_70163_u + 1.0, this.field_70161_v + 0.25));
                        break;
                    }
                    case NORTH: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.25, this.field_70163_u + 0.25, this.field_70161_v - 0.5, this.field_70165_t + 0.25, this.field_70163_u + 0.75, this.field_70161_v + 0.0 + d3));
                        break;
                    }
                    case SOUTH: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.25, this.field_70163_u + 0.25, this.field_70161_v - 0.0 - d3, this.field_70165_t + 0.25, this.field_70163_u + 0.75, this.field_70161_v + 0.5));
                        break;
                    }
                    case WEST: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u + 0.25, this.field_70161_v - 0.25, this.field_70165_t + 0.0 + d3, this.field_70163_u + 0.75, this.field_70161_v + 0.25));
                        break;
                    }
                    case EAST: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.0 - d3, this.field_70163_u + 0.25, this.field_70161_v - 0.25, this.field_70165_t + 0.5, this.field_70163_u + 0.75, this.field_70161_v + 0.25));
                        break;
                    }
                }
            } else {
                List list2;
                EnumFacing enumfacing2 = this.getAttachmentFacing();
                switch (enumfacing2) {
                    case DOWN: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0 + d3, this.field_70161_v + 0.5));
                        d1 = d5;
                        break;
                    }
                    case UP: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - d3, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                        d1 = -d5;
                        break;
                    }
                    case NORTH: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5 + d3));
                        d2 = d5;
                        break;
                    }
                    case SOUTH: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5 - d3, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                        d2 = -d5;
                        break;
                    }
                    case WEST: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5 + d3, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                        d0 = d5;
                        break;
                    }
                    case EAST: {
                        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5 - d3, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                        d0 = -d5;
                    }
                }
                if (d5 > 0.0 && !(list2 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).isEmpty()) {
                    for (Entity entity : list2) {
                        if (entity instanceof EntityShulker || entity.field_70145_X) continue;
                        entity.func_70091_d(MoverType.SHULKER, d0, d1, d2);
                    }
                }
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70180_af != null && this.func_70089_S()) {
            Optional optional = (Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS);
            Optional optional1 = Optional.of((Object)new BlockPos(x, y, z));
            if (!optional1.equals((Object)optional)) {
                this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)optional1);
                this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
                this.field_70160_al = true;
            }
        }
    }

    public boolean teleportTo(double x, double y, double z) {
        this.currentAttachmentPosition = null;
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187791_eX, this.func_184176_by(), this.func_70599_aP(), 0.95f);
        this.func_184185_a(SoundEvents.field_187791_eX, this.func_70599_aP(), 0.95f);
        return true;
    }

    protected boolean teleportShulkerToBlock() {
        if (!this.func_175446_cd() && this.func_70089_S() && !this.func_184218_aH()) {
            BlockPos blockpos = new BlockPos((Entity)this);
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(16 - this.field_70146_Z.nextInt(32), 16 - this.field_70146_Z.nextInt(32), 16 - this.field_70146_Z.nextInt(32));
                if (blockpos1.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockpos1) || !this.field_70170_p.func_191503_g((Entity)this) || !this.field_70170_p.func_184144_a((Entity)this, new AxisAlignedBB(blockpos1)).isEmpty()) continue;
                boolean flag = false;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    if (!this.field_70170_p.func_175677_d(blockpos1.func_177972_a(enumfacing), false)) continue;
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)enumfacing);
                    flag = true;
                    break;
                }
                if (!flag) continue;
                this.func_184185_a(SoundEvents.field_187791_eX, this.func_70599_aP(), 0.95f);
                this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos1));
                this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
                this.func_70624_b(null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void performSpecialAttack() {
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 48.0, 48.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
        if (list != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                if (entity == null || this.isOnSameTeam(entity)) continue;
                EntityShulkerBulletFriendly entityshulkerbullet = new EntityShulkerBulletFriendly(this.field_70170_p, this, (Entity)entity, this.getAttachmentFacing().func_176740_k());
                this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                this.func_184185_a(SoundEvents.field_187789_eW, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.7f);
            }
        }
        this.setSpecialAttackTimer(800);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttachedToBlock() {
        return this.currentAttachmentPosition != null && this.getAttachmentPos() != null;
    }

    @Override
    public void func_70636_d() {
        List list;
        super.func_70636_d();
        if (!this.getCurrentBook().func_190926_b()) {
            this.updateArmorModifier(100);
        }
        this.func_70105_a(1.0f, 1.0f);
        if (this.func_70089_S() && this.field_70170_p.func_180495_p(this.getAttachmentPos()) != Blocks.field_150350_a) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.field_70170_p.func_180495_p(this.getAttachmentPos()) == Blocks.field_150350_a && !this.func_184218_aH()) {
            this.teleportShulkerToBlock();
        }
        if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) >= 2304.0) {
            this.field_70173_aa = 0;
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), this.func_70599_aP(), 2.0f / this.field_70131_O);
            this.func_184185_a(SoundEvents.field_187534_aX, this.func_70599_aP(), 2.0f / this.field_70131_O);
            this.func_70661_as().func_75499_g();
            this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
        }
        this.field_70177_z = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70160_al = false;
        this.field_70122_E = true;
        this.func_70031_b(false);
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if ((list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty() && this.field_70173_aa % 60 == 0 && this.isPositiveShulker() && !this.func_175446_cd()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                if (this.field_70170_p.field_72995_K || entity == null || !this.isOnSameTeam(entity) || this.field_70146_Z.nextInt(60) != 0 || entity instanceof IMob) continue;
                EntityShulkerBulletFriendly entityshulkerbullet = new EntityShulkerBulletFriendly(this.field_70170_p, this, (Entity)entity, this.getAttachmentFacing().func_176740_k());
                this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                this.func_184185_a(SoundEvents.field_187789_eW, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                break;
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        BlockPos blockpos;
        if (ATTACHED_BLOCK_POS.equals(key) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (blockpos = this.getAttachmentPos()) != null) {
            if (this.currentAttachmentPosition == null) {
                this.currentAttachmentPosition = blockpos;
            } else {
                this.clientSideTeleportInterpolation = 6;
            }
            if (this.func_70089_S() && this.field_70170_p.func_180495_p(this.getAttachmentPos()) != Blocks.field_150350_a) {
                this.field_70169_q = this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
                this.field_70142_S = this.field_70165_t;
                this.field_70167_r = this.field_70163_u = (double)blockpos.func_177956_o();
                this.field_70137_T = this.field_70163_u;
                this.field_70166_s = this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
                this.field_70136_U = this.field_70161_v;
            }
        }
        super.func_184206_a(key);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
        this.field_70716_bi = 0;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.isClosed() && (entity = source.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.updateArmorModifier(0);
            }
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5) {
                this.teleportShulkerToBlock();
            }
            return true;
        }
        return false;
    }

    private boolean isClosed() {
        return this.getPeekTick() == 0;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public EnumFacing getAttachmentFacing() {
        return (EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    @Nullable
    public BlockPos getAttachmentPos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull();
    }

    public void setAttachmentPos(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.fromNullable((Object)pos));
    }

    public int getPeekTick() {
        return ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue();
    }

    public void updateArmorModifier(int p_184691_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(COVERED_ARMOR_BONUS_MODIFIER);
            if (p_184691_1_ == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(COVERED_ARMOR_BONUS_MODIFIER);
                if (this.getCurrentBook().func_190926_b()) {
                    this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
                }
            } else if (this.getCurrentBook().func_190926_b()) {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)((byte)p_184691_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public float getClientPeekAmount(float p_184688_1_) {
        return this.prevPeekAmount + (this.peekAmount - this.prevPeekAmount) * p_184688_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientTeleportInterp() {
        return this.clientSideTeleportInterpolation;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOldAttachPos() {
        return this.currentAttachmentPosition;
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? (this.getAttachmentFacing() == EnumFacing.UP ? 0.75f : (this.getAttachmentFacing() == EnumFacing.DOWN ? 0.25f : 0.5f)) : 0.5f;
    }

    @Override
    public int func_70646_bf() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
        this.teleportShulkerToBlock();
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getColor()) {
            default: {
                return LootTableListEngender.ENTITIES_SHULKER_WHITE;
            }
            case ORANGE: {
                return LootTableListEngender.ENTITIES_SHULKER_ORANGE;
            }
            case MAGENTA: {
                return LootTableListEngender.ENTITIES_SHULKER_MAGENTA;
            }
            case LIGHT_BLUE: {
                return LootTableListEngender.ENTITIES_SHULKER_LIGHT_BLUE;
            }
            case YELLOW: {
                return LootTableListEngender.ENTITIES_SHULKER_YELLOW;
            }
            case LIME: {
                return LootTableListEngender.ENTITIES_SHULKER_LIME;
            }
            case PINK: {
                return LootTableListEngender.ENTITIES_SHULKER_PINK;
            }
            case GRAY: {
                return LootTableListEngender.ENTITIES_SHULKER_GRAY;
            }
            case SILVER: {
                return LootTableListEngender.ENTITIES_SHULKER_SILVER;
            }
            case CYAN: {
                return LootTableListEngender.ENTITIES_SHULKER_CYAN;
            }
            case PURPLE: {
                return LootTableListEngender.ENTITIES_SHULKER_PURPLE;
            }
            case BLUE: {
                return LootTableListEngender.ENTITIES_SHULKER_BLUE;
            }
            case BROWN: {
                return LootTableListEngender.ENTITIES_SHULKER_BROWN;
            }
            case GREEN: {
                return LootTableListEngender.ENTITIES_SHULKER_GREEN;
            }
            case RED: {
                return LootTableListEngender.ENTITIES_SHULKER_RED;
            }
            case BLACK: 
        }
        return LootTableListEngender.ENTITIES_SHULKER_BLACK;
    }

    public void inflictShulkerEffects(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K) {
            switch (this.getColor()) {
                case WHITE: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76441_p, 2400, 0);
                    break;
                }
                case ORANGE: {
                    entity.func_70015_d(15);
                    break;
                }
                case MAGENTA: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76431_k, 400, 0);
                    if (entity.func_70662_br()) {
                        this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76432_h, 1, 0);
                        break;
                    }
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76433_i, 1, 1);
                    break;
                }
                case LIGHT_BLUE: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_188425_z, 2400, 0);
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76420_g, 1200, 1);
                    break;
                }
                case YELLOW: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76426_n, 2400, 0);
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76422_e, 1200, 0);
                    break;
                }
                case LIME: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76430_j, 2400, 1);
                    break;
                }
                case PINK: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76429_m, 2400, 0);
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76428_l, 600, 1);
                    break;
                }
                case GRAY: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76440_q, 400, 0);
                    break;
                }
                case SILVER: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76421_d, 200, 1);
                    break;
                }
                case CYAN: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76439_r, 2400, 0);
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76424_c, 2400, 1);
                    break;
                }
                case BLUE: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76427_o, 2400, 0);
                    break;
                }
                case BROWN: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76419_f, 200, 1);
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76437_t, 200, 0);
                    break;
                }
                case GREEN: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76436_u, 200, 1);
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76438_s, 200, 0);
                    break;
                }
                case RED: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76443_y, 1, 1);
                    if (entity.func_70662_br()) {
                        this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76433_i, 1, 1);
                        break;
                    }
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_76432_h, 1, 1);
                    break;
                }
                case BLACK: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_82731_v, 200, 1);
                    break;
                }
                default: {
                    this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, entity, MobEffects.field_188424_y, 200, 0);
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        this.inflictShulkerEffects((EntityLivingBase)p_70652_1_);
        return this.isOnSameTeam((EntityLivingBase)p_70652_1_) ? true : super.func_70652_k(p_70652_1_);
    }

    public boolean isPositiveShulker() {
        switch (this.getColor()) {
            case WHITE: 
            case LIGHT_BLUE: 
            case YELLOW: 
            case LIME: 
            case PINK: 
            case CYAN: 
            case BLUE: 
            case RED: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase p_i47062_2_) {
            super(p_i47062_2_);
        }

        public void func_75664_a() {
        }
    }

    class AIPeek
    extends EntityAIBase {
        private int field_188522_b;

        private AIPeek() {
        }

        public boolean func_75250_a() {
            return EntityShulker.this.func_70638_az() == null && EntityShulker.this.field_70146_Z.nextInt(20) == 0 || EntityShulker.this.func_70093_af();
        }

        public boolean func_75253_b() {
            return EntityShulker.this.func_70638_az() == null && this.field_188522_b > 0;
        }

        public void func_75249_e() {
            this.field_188522_b = EntityShulker.this.func_70093_af() ? 100 : 40 * (1 + EntityShulker.this.field_70146_Z.nextInt(3));
            EntityShulker.this.updateArmorModifier(30);
        }

        public void func_75251_c() {
            if (EntityShulker.this.func_70638_az() == null) {
                this.field_188522_b = 0;
                EntityShulker.this.updateArmorModifier(0);
            }
        }

        public void func_75246_d() {
            --this.field_188522_b;
        }
    }

    class AIAttack
    extends EntityAIBase {
        private int field_188520_b;

        public AIAttack() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            return !EntityShulker.this.isPositiveShulker() && entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            EntityShulker.this.updateArmorModifier(100);
            this.field_188520_b = 60;
        }

        public void func_75251_c() {
            EntityShulker.this.updateArmorModifier(0);
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            if (entitylivingbase != null && !entitylivingbase.func_70089_S()) {
                EntityShulker.this.func_70624_b(null);
            }
        }

        public void func_75246_d() {
            --this.field_188520_b;
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            EntityShulker.this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
            double d0 = EntityShulker.this.func_70068_e((Entity)entitylivingbase);
            if (d0 < 2000.0) {
                if (this.field_188520_b <= 0 && EntityShulker.this.func_70685_l((Entity)entitylivingbase)) {
                    this.field_188520_b = EntityShulker.this.moralRaisedTimer > 200 ? 5 : 20 + EntityShulker.this.field_70146_Z.nextInt(10) * 20 / 2;
                    if (d0 < 16.0) {
                        EntityShulker.this.func_184185_a(SoundEvents.field_187789_eW, 1.0f, (EntityShulker.this.field_70146_Z.nextFloat() - EntityShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.25f);
                        EntityShulker.this.func_70652_k((Entity)entitylivingbase);
                        if (d0 < 12.0) {
                            EntityShulker.this.teleportShulkerToBlock();
                        }
                    } else {
                        EntityShulkerBulletFriendly entityshulkerbullet = new EntityShulkerBulletFriendly(EntityShulker.this.field_70170_p, EntityShulker.this, (Entity)entitylivingbase, EntityShulker.this.getAttachmentFacing().func_176740_k());
                        EntityShulker.this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                        EntityShulker.this.func_184185_a(SoundEvents.field_187789_eW, 1.0f, (EntityShulker.this.field_70146_Z.nextFloat() - EntityShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                }
            } else {
                EntityShulker.this.func_70624_b(null);
                this.func_75251_c();
            }
            super.func_75246_d();
        }
    }
}

