/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPigZombie
extends EntityZombie
implements IJumpingMount {
    private static final DataParameter<Boolean> OLDPEPIGMAN = EntityDataManager.func_187226_a(EntityPigZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.075, 0).func_111168_a(false);
    private int angerLevel;
    private int randomSoundDelay = 40;
    private UUID angerTargetUUID;
    protected float jumpPower;

    public EntityPigZombie(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.randomSoundDelay = 0;
        this.setToNotVillager();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OLDPEPIGMAN, (Object)false);
    }

    public boolean isOldPEPigman() {
        return (Boolean)this.func_184212_Q().func_187225_a(OLDPEPIGMAN);
    }

    public void setOldPEPigman(boolean childZombie) {
        this.func_184212_Q().func_187227_b(OLDPEPIGMAN, (Object)childZombie);
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityPigZombie(this.field_70170_p);
    }

    @Override
    public int getNextLevelRequirement() {
        return 50;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public boolean canBeMatedWith() {
        return EngenderMod.useMobTalkerModels && this.field_70131_O >= 1.365f && !this.func_70631_g_();
    }

    @Override
    public void createChild() {
        int i;
        this.func_184185_a(ModSoundEvents.girlMoan, 1.0f, this.func_70647_i() + 0.1f);
        for (i = 0; i < 10; ++i) {
            this.spawnHeartParticle();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                EntityPigZombie baby = new EntityPigZombie(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-60000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                baby.setToNotVillager();
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    @Override
    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.2f : super.func_70647_i();
    }

    @Override
    public void performSpecialAttack() {
        this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 5.0f);
        this.func_184185_a(ModSoundEvents.pigmanSpecial, this.func_70599_aP(), 1.0f);
        this.setSpecialAttackTimer(500);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.field_70173_aa % 1 == 0 && this.moralRaisedTimer > 200) {
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < (double)this.func_70638_az().field_70130_N + 9.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.func_70664_aZ();
            this.func_70638_az().field_70181_x += 2.0;
            this.func_184185_a(ModSoundEvents.pigmanSpecial, this.func_70599_aP(), 1.0f);
            this.performSpecialAttack();
        }
    }

    @Override
    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            if (!iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                this.func_70031_b(true);
                iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
            iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_184185_a(SoundEvents.field_187936_hj, 10000.0f, this.func_70647_i() + 1.8f);
        }
        if (this.moralRaisedTimer > 200) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20, 9));
            this.angerLevel = 600;
            this.func_184185_a(SoundEvents.field_187936_hj, 1.0f, this.func_70647_i() + 1.8f);
            this.field_70172_ad = 0;
            this.field_70721_aZ *= 6.0f;
        }
        super.func_70619_bc();
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74777_a("Anger", (short)this.angerLevel);
        tagCompound.func_74757_a("OldPEPigman", this.isOldPEPigman());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.angerLevel = tagCompund.func_74765_d("Anger");
        this.setOldPEPigman(tagCompund.func_74767_n("OldPEPigman"));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    public void becomeAngryAt(Entity p_70835_1_) {
        this.angerLevel = 600;
        this.randomSoundDelay = this.field_70146_Z.nextInt(150);
        if (p_70835_1_ instanceof EntityLivingBase && !this.isOnSameTeam((EntityLivingBase)p_70835_1_)) {
            this.func_70624_b((EntityLivingBase)p_70835_1_);
        }
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            this.field_70138_W = 1.0f;
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.field_70181_x = 0.8 * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187935_hi;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187938_hl;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187937_hk;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_ZOMBIE_PIGMAN;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
        if (this.func_70681_au().nextInt(3) == 0) {
            i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185159_cQ));
            } else {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151010_B));
            }
        }
        if (this.field_70146_Z.nextFloat() < 0.25f * difficulty.func_180170_c()) {
            float f;
            i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.325f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.1f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.15f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.2f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = EntityPigZombie.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.setToNotVillager();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.setOldPEPigman(true);
        }
        return livingdata;
    }
}

