/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier5.EntityElderGuardian;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGuardian
extends EntityFriendlyCreature
implements Armored {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityGuardian.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityGuardian.class, (DataSerializer)DataSerializers.field_187192_b);
    private float field_175482_b;
    private float field_175484_c;
    private float tailSwiping;
    private float spineExtention;
    private float field_175486_bm;
    private EntityLivingBase targetedEntity;
    private int field_175479_bo;
    private boolean field_175480_bp;
    protected EntityAIWander wander;

    public EntityGuardian(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70728_aV = 10;
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.75f);
        } else {
            this.func_70105_a(1.0f, 1.0f);
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 48.0f, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIGuardianAttack());
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.wander = new EntityAIWander((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.wander.func_75248_a(3);
        entityaimovetowardsrestriction.func_75248_a(3);
        this.field_70765_h = new GuardianMoveHelper(this);
        this.field_175484_c = this.field_175482_b = this.field_70146_Z.nextFloat();
    }

    @Override
    public int getNextLevelRequirement() {
        return 100;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return this.isElder() ? new EntityElderGuardian(this.field_70170_p) : new EntityGuardian(this.field_70170_p);
    }

    @Override
    public float getBonusVSLight() {
        return 3.0f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.25f;
    }

    @Override
    public float getBonusVSFlying() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                int e;
                EntityGuardian baby;
                if (this.isElder()) {
                    baby = new EntityGuardian(this.field_70170_p);
                    baby.func_82149_j((Entity)this);
                    baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                    if (this.field_70146_Z.nextFloat() < 0.25f) {
                        baby = new EntityElderGuardian(this.field_70170_p);
                        baby.setGrowingAge(-100000);
                        baby.setElder();
                    } else {
                        baby.setGrowingAge(-24000);
                    }
                    baby.setChild(true);
                    baby.setOwnerId(this.func_184753_b());
                    if (this.isMarried()) {
                        for (e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                            baby.levelUp();
                        }
                    }
                    this.field_70170_p.func_72838_d((Entity)baby);
                    continue;
                }
                baby = new EntityGuardian(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                if (this.field_70146_Z.nextFloat() < 0.01f) {
                    baby = new EntityElderGuardian(this.field_70170_p);
                    baby.setGrowingAge(-100000);
                    baby.setElder();
                } else {
                    baby.setGrowingAge(-24000);
                }
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + (this.isElder() ? 0.1f : 0.3f) : super.func_70647_i();
    }

    @Override
    public EnumTier getTier() {
        return this.isElder() ? EnumTier.TIER5 : EnumTier.TIER4;
    }

    public float func_70603_bj() {
        return EngenderMod.useMobTalkerModels ? (this.isElder() ? 1.35f : 1.0f) : (this.isElder() ? 2.35f : 1.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public float getAttackAnimationScale(float p_175477_1_) {
        return ((float)this.field_175479_bo + p_175477_1_) / (float)this.func_175464_ck();
    }

    protected PathNavigate getNewNavigator(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    private boolean isSyncedFlagSet(int flagId) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & flagId) != 0;
    }

    private void setSyncedFlag(int flagId, boolean state) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (state) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | flagId)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~flagId)));
        }
    }

    public boolean func_175472_n() {
        return this.isSyncedFlagSet(2);
    }

    private void func_175476_l(boolean p_175476_1_) {
        this.setSyncedFlag(2, p_175476_1_);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int func_175464_ck() {
        return this.isElder() ? 60 : 80;
    }

    public boolean isElder() {
        return this instanceof EntityElderGuardian;
    }

    @SideOnly(value=Side.CLIENT)
    public void setElder() {
        this.spineExtention = 1.0f;
        this.field_175486_bm = 1.0f;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0 && this.func_70089_S();
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (STATUS.equals(key)) {
            if (this.isElder()) {
                if (EngenderMod.useMobTalkerModels) {
                    this.func_70105_a(0.6f, 2.35f);
                } else {
                    this.func_70105_a(2.35f, 2.35f);
                }
            }
        } else if (TARGET_ENTITY.equals(key)) {
            this.field_175479_bo = 0;
            this.targetedEntity = null;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isElder() ? SoundEvents.field_187512_aB : SoundEvents.field_187670_cb;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return this.isElder() ? SoundEvents.field_187517_aG : SoundEvents.field_187687_ch;
    }

    protected SoundEvent func_184615_bR() {
        this.func_70624_b(null);
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        if (!this.func_70090_H()) {
            this.func_184185_a(this.isElder() ? SoundEvents.field_187516_aF : SoundEvents.field_187681_cf, this.func_70599_aP(), this.func_70647_i());
        }
        return this.isElder() ? SoundEvents.field_187515_aE : SoundEvents.field_187678_ce;
    }

    protected boolean func_70041_e_() {
        return !this.func_70090_H() && EngenderMod.useMobTalkerModels;
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.8f + (!this.isElder() ? 0.05f : 0.1f) + (this.func_184218_aH() || this.func_70090_H() || this.func_180799_ab() || this.isSitResting() || this.isElder() && !this.func_70631_g_() ? MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.2f)) * 0.1f : 0.0f) : (this.isElder() && this.field_70122_E && !this.func_70093_af() && !this.func_70090_H() ? this.field_70131_O * 0.75f : this.field_70131_O * 0.5f);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_190929_cY && !this.isElder()) {
            EntityElderGuardian baby = new EntityElderGuardian(this.field_70170_p);
            baby.func_82149_j((Entity)this);
            baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            baby.setOwnerId(this.func_184753_b());
            this.field_70170_p.func_72838_d((Entity)baby);
            this.field_70170_p.func_72900_e((Entity)this);
            stack.func_190918_g(1);
            Minecraft.func_71410_x().field_71452_i.func_191271_a((Entity)this, EnumParticleTypes.TOTEM, 30);
            this.func_184185_a(SoundEvents.field_191263_gW, 1.0f, 1.0f);
            this.field_70173_aa = 0;
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.isElder()) {
            this.field_70143_R = 0.0f;
        }
        if (EngenderMod.useMobTalkerModels && this.isElder() && !this.func_70631_g_() && this.field_70122_E && this.field_70173_aa % 30 == 0) {
            this.func_184185_a(SoundEvents.field_189426_aK, 0.1f, 0.5f);
            this.func_184185_a(SoundEvents.field_191244_bn, 0.1f, 0.75f);
        }
        if (EngenderMod.useMobTalkerModels && this.isElder() && !this.func_70631_g_() && this.field_70122_E) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 0.75 + (double)(MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.2f)) * 0.1f), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        GuardianMoveHelper guardianMoveHelper = this.field_70765_h = !this.func_70090_H() && EngenderMod.useMobTalkerModels ? new EntityMoveHelper((EntityLiving)this) : new GuardianMoveHelper(this);
        if (!EngenderMod.useMobTalkerModels) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        }
        if (this.field_70725_aQ > 0) {
            this.field_70181_x = -0.6;
        }
        if (this.isElder()) {
            if (EngenderMod.useMobTalkerModels) {
                this.func_70105_a(0.6f, 2.35f);
            } else {
                this.func_70105_a(2.35f, 2.35f);
            }
        } else if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.75f);
        } else {
            this.func_70105_a(1.0f, 1.0f);
        }
        this.func_70031_b(false);
        if (this.field_70170_p.field_72995_K) {
            this.field_175484_c = this.field_175482_b;
            if (!(this.func_70090_H() || this.isElder() || this.func_70644_a(MobEffects.field_188424_y))) {
                this.tailSwiping = 1.0f;
                this.field_175480_bp = this.field_70181_x < 0.0 && this.field_70170_p.func_175677_d(new BlockPos((Entity)this).func_177977_b(), false);
            } else {
                this.tailSwiping = this.func_175472_n() ? (this.tailSwiping < 0.5f ? 4.0f : (this.tailSwiping += (0.5f - this.tailSwiping) * 0.1f)) : (this.func_70631_g_() ? 1.0f : (this.tailSwiping += (0.125f - this.tailSwiping) * 0.2f));
            }
            if (!this.func_175446_cd()) {
                this.field_175482_b += this.tailSwiping;
                this.field_175486_bm = this.spineExtention;
            }
            this.spineExtention = !(this.func_70090_H() || this.func_184218_aH() || this.func_70644_a(MobEffects.field_188424_y)) ? (this.isElder() ? (this.field_70122_E && !this.func_70093_af() ? (this.spineExtention += (0.7f - this.spineExtention) * 0.05f) : (this.spineExtention += (-0.7f - this.spineExtention) * 0.25f)) : this.field_70146_Z.nextFloat() - 0.5f) : (this.func_175472_n() || this.func_184218_aH() || this.func_70644_a(MobEffects.field_188424_y) ? (this.spineExtention += (-0.7f - this.spineExtention) * 0.25f) : (this.spineExtention += (0.25f - this.spineExtention) * 0.06f));
            if (this.func_175446_cd()) {
                this.spineExtention = 0.0f;
            }
            if (this.func_175472_n() && this.func_70090_H()) {
                Vec3d vec3 = this.func_70676_i(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (this.hasTargetedEntity()) {
                EntityLivingBase entitylivingbase;
                if (this.field_175479_bo < this.func_175464_ck()) {
                    ++this.field_175479_bo;
                }
                if ((entitylivingbase = this.getTargetedEntity()) != null) {
                    this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, (float)this.func_70646_bf());
                    this.func_70671_ap().func_75649_a();
                    double d5 = this.func_175477_p(0.0f);
                    double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
                    double d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
                    double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_70146_Z.nextDouble();
                    while (d4 < d3) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (!(this.func_184207_aI() || !this.func_70089_S() || !this.field_70122_E || this.func_184207_aI() || this.isInLove() || this.func_70093_af() || this.isElder() || EngenderMod.useMobTalkerModels)) {
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * (this.func_70631_g_() ? 0.2f : 0.4f));
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * (this.func_70631_g_() ? 0.2f : 0.4f));
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.func_70664_aZ();
        }
        if (this.hasTargetedEntity()) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        }
        if (this.field_70173_aa % 20 == 0) {
            this.func_175476_l(false);
        }
        super.func_70636_d();
    }

    public double func_70042_X() {
        return this.isElder() && !EngenderMod.useMobTalkerModels && this.field_70122_E && !this.func_70090_H() ? (double)this.field_70131_O * 1.1 : (double)this.field_70131_O * 0.85;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    protected void func_70664_aZ() {
        this.field_70737_aN = 0;
        if (EngenderMod.useMobTalkerModels && this.isElder() && !this.func_70631_g_()) {
            this.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.75f + this.field_70146_Z.nextFloat() * 0.25f);
        } else {
            this.func_184185_a(SoundEvents.field_187684_cg, 1.0f, this.func_70631_g_() ? 1.5f : 1.0f);
        }
        this.field_70181_x += (this.func_70631_g_() ? 0.5 : 0.6) - this.field_70181_x;
        this.field_70122_E = false;
        this.field_70160_al = true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175471_a(float p_175471_1_) {
        return this.field_175484_c + (this.field_175482_b - this.field_175484_c) * p_175471_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175469_o(float p_175469_1_) {
        return this.field_175486_bm + (this.spineExtention - this.field_175486_bm) * p_175469_1_;
    }

    public float func_175477_p(float p_175477_1_) {
        return ((float)this.field_175479_bo + p_175477_1_) / (float)this.func_175464_ck();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_GUARDIAN;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (!this.func_175472_n() && !source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
                if (!source.func_94541_c() && (!entitylivingbase.func_184191_r((Entity)this) || this.getOwner() != null && entitylivingbase == this.getOwner())) {
                    this.inflictEngenderMobDamage(entitylivingbase, " died trying to attack ", DamageSource.func_92087_a((Entity)this), 2.0f);
                    this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), this.func_70647_i());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int func_70646_bf() {
        return EngenderMod.useMobTalkerModels ? 40 : (this.isElder() && this.field_70122_E && this.func_70638_az() == null ? 5 : 180);
    }

    public void func_70612_e(float strafe, float forward) {
        EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
        if (this.func_184207_aI() && this.func_82171_bF()) {
            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 200, 0, true, true));
            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 200, 0, true, true));
            if (this.func_70638_az() == null) {
                this.field_70177_z = this.field_70759_as = entitylivingbase.field_70177_z;
                this.field_70761_aq = this.field_70759_as;
                this.field_70125_A = 0.0f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            }
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.1f;
            if (this.func_184186_bw()) {
                Vec3d vec3 = entitylivingbase.func_70676_i(1.0f);
                double d0 = this.field_70165_t - (this.field_70165_t + vec3.field_72450_a * 50.0);
                double d1 = this.field_70163_u - (this.field_70163_u + vec3.field_72448_b * 50.0);
                double d2 = this.field_70161_v - (this.field_70161_v + vec3.field_72449_c * 50.0);
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                if ((forward != 0.0f || strafe != 0.0f) && this.func_70090_H()) {
                    this.field_70159_w -= d0 / d3 * (this.moralRaisedTimer > 0 ? 0.1 : 0.05);
                    this.field_70181_x -= d1 / d3 * (this.moralRaisedTimer > 0 ? 0.1 : 0.05);
                    this.field_70179_y -= d2 / d3 * (this.moralRaisedTimer > 0 ? 0.1 : 0.05);
                    double d = this.isElder() ? 0.3 : 0.6;
                    if (this.field_70159_w > d) {
                        this.field_70159_w = this.isElder() ? 0.3 : 0.6;
                    }
                    double d4 = this.isElder() ? 0.3 : 0.6;
                    if (this.field_70181_x > d4) {
                        this.field_70181_x = this.isElder() ? 0.3 : 0.6;
                    }
                    double d5 = this.isElder() ? 0.3 : 0.6;
                    if (this.field_70179_y > d5) {
                        this.field_70179_y = this.isElder() ? 0.3 : 0.6;
                    }
                    double d6 = this.isElder() ? 0.3 : 0.6;
                    if (this.field_70159_w < -d6) {
                        this.field_70159_w = -(this.isElder() ? 0.3 : 0.6);
                    }
                    double d7 = this.isElder() ? 0.3 : 0.6;
                    if (this.field_70181_x < -d7) {
                        this.field_70181_x = -(this.isElder() ? 0.3 : 0.6);
                    }
                    double d8 = this.isElder() ? 0.3 : 0.6;
                    if (this.field_70179_y < -d8) {
                        this.field_70179_y = -(this.isElder() ? 0.3 : 0.6);
                    }
                    this.func_175476_l(true);
                }
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                if (this.func_70090_H() && this.field_70725_aQ <= 0) {
                    this.func_70060_a(strafe, forward, 0.1f);
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= (double)0.9f;
                    this.field_70181_x *= (double)0.9f;
                    this.field_70179_y *= (double)0.9f;
                    if (this.func_70090_H() && !this.func_175472_n() && this.func_70638_az() == null && !this.func_184207_aI()) {
                        this.field_70181_x -= 0.005;
                    }
                } else {
                    if ((forward != 0.0f || strafe != 0.0f) && this.field_70122_E && !EngenderMod.useMobTalkerModels) {
                        this.func_70664_aZ();
                    }
                    super.func_70612_e(strafe, forward);
                }
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else if (this.func_70613_aW()) {
            if (this.func_70090_H() && this.field_70725_aQ <= 0) {
                this.func_70060_a(strafe, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (this.func_70090_H() && !this.func_175472_n() && this.func_70638_az() == null && !this.func_184207_aI()) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    class GuardianMoveHelper
    extends EntityMoveHelper {
        private EntityGuardian entityGuardian;

        public GuardianMoveHelper(EntityGuardian guardian) {
            super((EntityLiving)guardian);
            this.entityGuardian = guardian;
        }

        public void func_75641_c() {
            if ((this.entityGuardian.func_70090_H() || this.entityGuardian.func_70644_a(MobEffects.field_188424_y)) && this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.entityGuardian.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entityGuardian.field_70165_t;
                double d1 = this.field_75647_c - this.entityGuardian.field_70163_u;
                double d2 = this.field_75644_d - this.entityGuardian.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityGuardian.func_70659_e(this.entityGuardian.func_70689_ay() + (f1 - this.entityGuardian.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entityGuardian.field_70177_z * ((float)Math.PI / 180));
                this.entityGuardian.field_70159_w += d4 * d5;
                this.entityGuardian.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityGuardian.field_70181_x += (double)this.entityGuardian.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityGuardian.func_70671_ap();
                double d7 = this.entityGuardian.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityGuardian.func_70047_e() + this.entityGuardian.field_70163_u + d1 / d3;
                double d9 = this.entityGuardian.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityGuardian.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityGuardian.func_175476_l(true);
            } else {
                if ((this.entityGuardian.func_70090_H() || this.entityGuardian.func_70644_a(MobEffects.field_188424_y)) && this.entityGuardian.field_70122_E && (this.entityGuardian.field_70701_bs != 0.0f || this.entityGuardian.field_70702_br != 0.0f)) {
                    this.entityGuardian.func_70664_aZ();
                }
                this.entityGuardian.func_70659_e(0.0f);
                this.entityGuardian.func_175476_l(false);
            }
        }
    }

    class AIGuardianAttack
    extends EntityAIBase {
        private EntityGuardian guardian;
        private int tickCounter;

        public AIGuardianAttack() {
            this.guardian = EntityGuardian.this;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.guardian.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S() && !this.guardian.func_70631_g_();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.guardian.func_70638_az() != null && this.tickCounter < this.guardian.func_175464_ck();
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)this.guardian.func_70638_az(), 180.0f, (float)this.guardian.func_70646_bf());
            this.guardian.field_70160_al = true;
            this.guardian.setSitResting(false);
        }

        public void func_75251_c() {
            this.guardian.setTargetedEntity(0);
            this.guardian.func_70624_b(null);
            this.guardian.wander.func_179480_f();
        }

        public void func_75246_d() {
            this.guardian.setSitResting(false);
            EntityLivingBase entitylivingbase = this.guardian.func_70638_az();
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, (float)this.guardian.func_70646_bf());
            if (!this.guardian.func_70685_l((Entity)entitylivingbase)) {
                this.guardian.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.guardian.moralRaisedTimer > 200) {
                    ++this.tickCounter;
                }
                if (this.tickCounter > 0) {
                    this.guardian.func_184185_a(SoundEvents.field_187675_cd, 1.0f, 0.5f + (float)((double)this.tickCounter * 0.025));
                }
                if (this.tickCounter > 0 && this.guardian.isHero() && this.guardian.getSpecialAttackTimer() <= 0) {
                    this.guardian.func_184185_a(SoundEvents.field_187675_cd, 10.0f, 0.5f + (float)((double)this.tickCounter * 0.025));
                }
                if (this.tickCounter == 0) {
                    this.guardian.setTargetedEntity(this.guardian.func_70638_az().func_145782_y());
                } else if (this.tickCounter >= this.guardian.func_175464_ck() && (entitylivingbase.field_70172_ad == 0 || this.guardian.isElder())) {
                    float f = 1.0f;
                    if (this.guardian.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    if (this.guardian.isElder()) {
                        f += 2.0f;
                        entitylivingbase.field_70758_at = entitylivingbase.field_70759_as = this.guardian.field_70759_as;
                        entitylivingbase.field_70177_z = entitylivingbase.field_70759_as;
                        entitylivingbase.field_70126_B = entitylivingbase.field_70759_as;
                        entitylivingbase.field_70761_aq = entitylivingbase.field_70759_as;
                        entitylivingbase.field_70760_ar = entitylivingbase.field_70759_as;
                        float xRatio = MathHelper.func_76126_a((float)(entitylivingbase.field_70759_as * ((float)Math.PI / 180)));
                        float zRatio = -MathHelper.func_76134_b((float)(entitylivingbase.field_70759_as * ((float)Math.PI / 180)));
                        float f1 = MathHelper.func_76129_c((float)(xRatio * xRatio + zRatio * zRatio));
                        entitylivingbase.field_70159_w -= (double)xRatio / (double)f1 / (double)this.guardian.func_70032_d((Entity)entitylivingbase) * 4.0;
                        entitylivingbase.field_70179_y -= (double)zRatio / (double)f1 / (double)this.guardian.func_70032_d((Entity)entitylivingbase) * 4.0;
                        entitylivingbase.field_70181_x += 1.0;
                        if (entitylivingbase instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)entitylivingbase).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entitylivingbase)));
                        }
                    }
                    this.guardian.inflictEngenderMobDamage(entitylivingbase, " was laser beamed by ", DamageSource.func_76358_a((EntityLivingBase)this.guardian).func_82726_p(), (float)this.guardian.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111125_b() + f);
                    if (this.guardian.isHero() && this.guardian.getSpecialAttackTimer() <= 0) {
                        this.guardian.func_184185_a(SoundEvents.field_187855_gD, 10.0f, 1.25f);
                        entitylivingbase.field_70172_ad = 0;
                        EntityFriendlyCreature.createEngenderModExplosion((Entity)this.guardian, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O / 2.0f), entitylivingbase.field_70161_v, 7.0f, true, false);
                        entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.guardian), (float)this.guardian.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 3.0f);
                        this.guardian.setSpecialAttackTimer(600);
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

