/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.ai.EntityAIAvoidEntitySPC;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier4.EntityLargeFireballOther;
import net.minecraft.entity.helpful.tier4.EntitySmallFireballOther;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGhast
extends EntityFriendlyCreature
implements Massive,
Flying,
Light {
    private static final DataParameter<Boolean> SHOULD_FLY = EntityDataManager.func_187226_a(EntityGhast.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityGhast.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean eleanor;
    private int explosionStrength = 1;

    public EntityGhast(World worldIn) {
        super(worldIn);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.5f, 1.95f);
        } else {
            this.func_70105_a(4.5f, 4.5f);
        }
        this.field_70178_ae = true;
        this.isOffensive = true;
        this.field_70765_h = new GhastMoveHelper(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, EngenderMod.useMobTalkerModels ? 64.0f : 100.0f, EngenderMod.useMobTalkerModels ? 9.0f : 16.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILookAround());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 20;
    }

    @Override
    public int getNextLevelRequirement() {
        return 250;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityGhast(this.field_70170_p);
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public float getBonusVSLight() {
        return 0.5f;
    }

    @Override
    public float getBonusVSArmored() {
        return 3.0f;
    }

    @Override
    public float getBonusVSFlying() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 2.0f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    public int func_70641_bl() {
        return 1;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public void setFlying(boolean attacking) {
        this.field_70180_af.func_187227_b(SHOULD_FLY, (Object)attacking);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_FLY);
    }

    @Override
    public void performSpecialAttack() {
        this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i());
        this.setSpecialAttackTimer(1200);
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.25f : super.func_70647_i();
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                EntityGhast baby = new EntityGhast(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-60000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_184207_aI() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
            this.field_70177_z = this.field_70759_as = passenger.field_70177_z;
            this.field_70761_aq = this.field_70759_as;
            float f = this.field_70125_A = EngenderMod.useMobTalkerModels ? passenger.field_70125_A : 0.0f;
        }
        if (this.isHero() && this.getSpecialAttackTimer() > 1100) {
            this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i());
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    if (this.getSpecialAttackTimer() > 1190 && entity instanceof EntityCreature && !(entity instanceof EntityFriendlyCreature)) {
                        ((EntityCreature)entity).field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<EntityGhast>((EntityCreature)entity, EntityGhast.class, 128.0f, 1.5, 1.5));
                    }
                    entity.field_70172_ad = 0;
                    this.inflictEngenderMobDamage(entity, "'s ears exploded thanks to ", DamageSource.field_82727_n, 0.25f);
                    entity.func_70024_g(this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05);
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 2048.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.5f, 1.95f);
        } else {
            this.func_70105_a(4.5f, 4.5f);
        }
        if (!EngenderMod.useMobTalkerModels && this.eleanor) {
            this.eleanor = false;
        }
        if (EngenderMod.useMobTalkerModels && !this.isHero() && this.eleanor) {
            this.becomeAHero();
        }
        if (!EngenderMod.useMobTalkerModels) {
            this.setFlying(true);
        } else {
            this.setFlying(this.func_70638_az() != null && !this.func_70631_g_());
        }
        if (!this.isFlying() && !this.func_184207_aI() && this.func_70089_S()) {
            this.field_70181_x *= 0.6;
        }
        if (!this.isFlying() && (this.func_70090_H() || this.func_180799_ab()) && this.func_70681_au().nextFloat() < 0.8f && this.func_70089_S()) {
            this.func_70683_ar().func_75660_a();
        }
        if (this.func_70638_az() != null && this.getOwner() != null && !this.func_70685_l((Entity)this.func_70638_az()) && this.field_70146_Z.nextInt(80) == 0) {
            this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i() + 0.25f);
        }
        if (this.getOwner() != null && this.func_70638_az() == null && this.field_70173_aa % 10 == 0) {
            double d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(d0, d0, d0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity != null && entity.func_70089_S() && this.func_70685_l(entity) && !this.isOnSameTeam((EntityLivingBase)entity) && entity.func_70068_e((Entity)this.getOwner()) <= 256.0) {
                        this.func_70624_b((EntityLivingBase)entity);
                        continue;
                    }
                    list.remove(entity);
                }
            }
        }
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_70612_e(float strafe, float forward) {
        if ((this.isFlying() || this.func_184207_aI()) && this.func_70089_S()) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_180799_ab()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float f = 0.95f;
                float f1 = 0.16277136f / (f * f * f);
                this.func_70060_a(strafe, forward, 0.02f);
                f = 0.95f;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.eleanor && source instanceof EntityDamageSourceIndirect) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && EngenderMod.useMobTalkerModels && this.eleanor && amount < 50.0f) {
            EntityLivingBase creature = (EntityLivingBase)entity;
            creature.func_70097_a(DamageSource.field_76377_j.func_76348_h().func_76359_i().func_151518_m(), amount);
            creature.func_70653_a((Entity)this, amount * 0.1f, (double)(-MathHelper.func_76126_a((float)(creature.field_70759_as * ((float)Math.PI / 180)))), (double)MathHelper.func_76134_b((float)(creature.field_70759_as * ((float)Math.PI / 180))));
        }
        if (this.eleanor && (source.func_76347_k() || source.func_94541_c() || source.func_76352_a() || source.func_82725_o() || amount < 50.0f)) {
            return false;
        }
        if (EngenderMod.useMobTalkerModels && amount >= 1.0f && this.eleanor) {
            amount *= 1.0E-4f;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if ("fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(source, 1000.0f);
            ((EntityPlayer)source.func_76346_g()).func_71029_a((StatBase)AchievementList.field_76028_y);
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_FLY, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(17.0);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(40.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187553_bI;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_GHAST;
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 10.0f;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ExplosionPower", this.explosionStrength);
        if (this.eleanor) {
            tagCompound.func_74757_a("Eleanor", true);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = tagCompund.func_74762_e("ExplosionPower");
        }
        if (tagCompund.func_150297_b("Eleanor", 99)) {
            this.eleanor = tagCompund.func_74767_n("Eleanor");
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (EngenderMod.useMobTalkerModels && !this.eleanor && "Eleanor".equals(name)) {
            this.field_70173_aa = 0;
            this.becomeAHero();
            this.eleanor = true;
        } else {
            this.eleanor = false;
        }
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O * 0.66f;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * (EngenderMod.useMobTalkerModels ? 0.75 : 0.95);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getCrushHurtSound() : ModSoundEvents.fleshHitCrushHeavy;
    }

    static class GhastMoveHelper
    extends EntityMoveHelper {
        private EntityGhast parentEntity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityGhast ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.parentEntity.func_184179_bs() != null && this.parentEntity.func_184179_bs() instanceof EntityPlayer && this.parentEntity.func_184207_aI()) {
                EntityPlayer passenger = (EntityPlayer)this.parentEntity.func_184179_bs();
                this.parentEntity.field_70177_z = this.parentEntity.field_70759_as = passenger.field_70177_z;
                this.parentEntity.field_70761_aq = this.parentEntity.field_70759_as;
                this.parentEntity.field_70125_A = EngenderMod.useMobTalkerModels ? passenger.field_70125_A : 0.0f;
                Vec3d vec3 = passenger.func_70676_i(1.0f);
                double d0 = this.parentEntity.field_70165_t - (this.parentEntity.field_70165_t + vec3.field_72450_a * 50.0);
                double d1 = this.parentEntity.field_70163_u - (this.parentEntity.field_70163_u + vec3.field_72448_b * 50.0);
                double d2 = this.parentEntity.field_70161_v - (this.parentEntity.field_70161_v + vec3.field_72449_c * 50.0);
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                if (passenger.field_70701_bs > 0.0f) {
                    this.parentEntity.field_70159_w = this.parentEntity.field_70159_w - d0 / d3 * (this.parentEntity.moralRaisedTimer > 0 ? 0.2 : 0.1);
                    this.parentEntity.field_70181_x = this.parentEntity.field_70181_x - d1 / d3 * (this.parentEntity.moralRaisedTimer > 0 ? 0.2 : 0.1);
                    this.parentEntity.field_70179_y = this.parentEntity.field_70179_y - d2 / d3 * (this.parentEntity.moralRaisedTimer > 0 ? 0.2 : 0.1);
                    if (this.parentEntity.field_70159_w > 0.5) {
                        this.parentEntity.field_70159_w = 0.5;
                    }
                    if (this.parentEntity.field_70181_x > 0.5) {
                        this.parentEntity.field_70181_x = 0.5;
                    }
                    if (this.parentEntity.field_70179_y > 0.5) {
                        this.parentEntity.field_70179_y = 0.5;
                    }
                    if (this.parentEntity.field_70159_w < -0.5) {
                        this.parentEntity.field_70159_w = -0.5;
                    }
                    if (this.parentEntity.field_70181_x < -0.5) {
                        this.parentEntity.field_70181_x = -0.5;
                    }
                    if (this.parentEntity.field_70179_y < -0.5) {
                        this.parentEntity.field_70179_y = -0.5;
                    }
                }
            }
            if (this.parentEntity.isFlying() && !this.parentEntity.func_184207_aI()) {
                if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && this.parentEntity.getJukeboxToDanceTo() == null) {
                    double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                    double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                    double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (this.courseChangeCooldown-- <= 0) {
                        this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                        if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                            this.parentEntity.field_70159_w = this.parentEntity.field_70159_w + d0 / d3 * (this.parentEntity.moralRaisedTimer > 200 ? 0.2 : 0.1);
                            this.parentEntity.field_70181_x = this.parentEntity.field_70181_x + d1 / d3 * (this.parentEntity.moralRaisedTimer > 200 ? 0.2 : 0.1);
                            this.parentEntity.field_70179_y = this.parentEntity.field_70179_y + d2 / d3 * (this.parentEntity.moralRaisedTimer > 200 ? 0.2 : 0.1);
                        } else {
                            this.field_188491_h = EntityMoveHelper.Action.WAIT;
                        }
                    }
                }
            } else {
                super.func_75641_c();
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityGhast ghast;

        public AIRandomFly(EntityGhast ghast) {
            this.ghast = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.ghast.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.ghast.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.ghast.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.ghast.field_70161_v) * d2;
            return (d3 < 1.0 || d3 > 3600.0) && !this.ghast.func_184207_aI();
        }

        public boolean func_75253_b() {
            return !this.ghast.isFlying() && !this.ghast.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.ghast.func_184207_aI()) {
                this.func_75251_c();
            }
            Random random = this.ghast.func_70681_au();
            if (this.ghast.getOwner() != null) {
                if (this.ghast.getOwner().func_70093_af() || !this.ghast.getCurrentBook().func_190926_b()) {
                    double d0 = this.ghast.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    double d1 = this.ghast.getOwner().field_70163_u + 8.0 + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    double d2 = this.ghast.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else if (!this.ghast.getCurrentBook().func_190926_b()) {
                    double d0 = this.ghast.getOwner().field_70165_t;
                    double d1 = this.ghast.getOwner().field_70163_u + 4.0;
                    double d2 = this.ghast.getOwner().field_70161_v;
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                } else {
                    double d0 = this.ghast.getOwner().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d1 = this.ghast.getOwner().field_70163_u + (EngenderMod.useMobTalkerModels || this.ghast.func_70631_g_() ? 16.0 : 32.0) + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.ghast.getOwner().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                }
            } else {
                double d0 = this.ghast.field_70165_t + random.nextGaussian() * 32.0;
                double d1 = this.ghast.field_70163_u + random.nextGaussian() * 32.0;
                double d2 = this.ghast.field_70161_v + random.nextGaussian() * 32.0;
                this.ghast.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityGhast parentEntity;

        public AILookAround() {
            this.parentEntity = EntityGhast.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.parentEntity.isFlying();
        }

        public void func_75246_d() {
            if (this.parentEntity.func_184179_bs() != null) {
                this.parentEntity.field_70126_B = this.parentEntity.field_70177_z = this.parentEntity.func_184179_bs().field_70177_z;
                this.parentEntity.field_70125_A = 0.0f;
                this.parentEntity.func_70101_b(this.parentEntity.field_70177_z, this.parentEntity.field_70125_A);
                this.parentEntity.field_70759_as = this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z;
            } else if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70177_z = this.parentEntity.field_70759_as = -((float)Math.atan2(this.parentEntity.field_70159_w, this.parentEntity.field_70179_y)) * 180.0f / (float)Math.PI;
                this.parentEntity.field_70761_aq = this.parentEntity.field_70759_as;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = this.parentEntity.field_70759_as;
                this.parentEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, EngenderMod.useMobTalkerModels ? 40.0f : 180.0f);
            }
        }
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityGhast ghast;
        public int attackTimer;

        public AIFireballAttack(EntityGhast ghast) {
            this.ghast = ghast;
        }

        public boolean func_75250_a() {
            return this.ghast.func_70638_az() != null && !this.ghast.func_70093_af();
        }

        public void func_75249_e() {
            this.attackTimer = 0;
            this.ghast.setArmsRaised(true);
        }

        public void func_75251_c() {
            this.ghast.setAttacking(false);
            this.ghast.setArmsRaised(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.ghast.func_70638_az();
            double d0 = 100.0;
            if (entitylivingbase != null && entitylivingbase.func_70068_e((Entity)this.ghast) < d0 * d0) {
                World world = this.ghast.field_70170_p;
                ++this.attackTimer;
                if (this.ghast.moralRaisedTimer > 200) {
                    ++this.attackTimer;
                }
                if (this.attackTimer == 10) {
                    this.ghast.func_184185_a(SoundEvents.field_187559_bL, 10.0f, 0.8f + this.ghast.func_70681_au().nextFloat() * 0.4f + (this.ghast.func_70631_g_() ? 0.5f : 0.0f) + (EngenderMod.useMobTalkerModels ? 0.25f : 0.0f));
                }
                if (this.attackTimer == 20) {
                    double d1 = EngenderMod.useMobTalkerModels ? (this.ghast.func_70631_g_() ? 0.25 : 0.5) : (this.ghast.func_70631_g_() ? 2.0 : 4.0);
                    Vec3d vec3 = this.ghast.func_70676_i(1.0f);
                    double d2 = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w * 10.0 - (this.ghast.field_70165_t + vec3.field_72450_a * d1);
                    double d3 = entitylivingbase.field_70163_u + (entitylivingbase.field_70131_O > 8.0f ? 7.0 : (double)entitylivingbase.field_70131_O * 0.5) + entitylivingbase.field_70181_x * 10.0 - (this.ghast.field_70163_u + 1.0);
                    double d4 = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y * 10.0 - (this.ghast.field_70161_v + vec3.field_72449_c * d1);
                    if (this.ghast.func_70631_g_()) {
                        float dm;
                        EntitySmallFireballOther entitylargefireball = new EntitySmallFireballOther(world, (EntityLivingBase)this.ghast, d2, d3, d4);
                        entitylargefireball.field_70165_t = this.ghast.field_70165_t + vec3.field_72450_a * d1;
                        entitylargefireball.field_70163_u = this.ghast.field_70163_u + 1.0;
                        entitylargefireball.field_70161_v = this.ghast.field_70161_v + vec3.field_72449_c * d1;
                        entitylargefireball.damage = dm = (float)this.ghast.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                        this.ghast.func_184185_a(SoundEvents.field_187557_bK, 10.0f, 1.5f);
                        world.func_72838_d((Entity)entitylargefireball);
                        this.attackTimer = this.ghast.moralRaisedTimer > 200 ? -15 : -30;
                    } else {
                        float dm;
                        EntityLargeFireballOther entitylargefireball = new EntityLargeFireballOther(world, (EntityLivingBase)this.ghast, d2, d3, d4);
                        entitylargefireball.field_92057_e = this.ghast.getFireballStrength() * (this.ghast.isHero() ? 2 : 1);
                        entitylargefireball.field_70165_t = this.ghast.field_70165_t + vec3.field_72450_a * d1;
                        entitylargefireball.field_70163_u = this.ghast.field_70163_u + 1.0;
                        entitylargefireball.field_70161_v = this.ghast.field_70161_v + vec3.field_72449_c * d1;
                        entitylargefireball.damage = dm = (float)this.ghast.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                        this.ghast.func_184185_a(SoundEvents.field_187557_bK, 10.0f, 1.0f);
                        world.func_72838_d((Entity)entitylargefireball);
                        this.attackTimer = this.ghast.moralRaisedTimer > 200 ? -20 : -40;
                    }
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.ghast.setAttacking(this.attackTimer > 10 || this.ghast.getSpecialAttackTimer() > 1100);
        }
    }
}

