/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.Ender;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier2.EntityEndermite;
import net.minecraft.entity.helpful.tier6.EntityWitherStorm;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEnderman
extends EntityFriendlyCreature
implements IJumpingMount,
Armored,
Ender {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final Set<Block> carriableBlocks = Sets.newIdentityHashSet();
    private static final DataParameter<Optional<IBlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(EntityEnderman.class, (DataSerializer)DataSerializers.field_187197_g);
    private int field_184720_bx = 0;
    private int field_184721_by = 0;
    public boolean andr;
    private static final DataParameter<Boolean> OMNI_DODGE = EntityDataManager.func_187226_a(EntityEnderman.class, (DataSerializer)DataSerializers.field_187198_h);
    protected float jumpPower;

    public EntityEnderman(World worldIn) {
        super(worldIn);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.55f, 2.75f);
        } else {
            this.func_70105_a(0.5f, 2.875f);
        }
        this.field_70138_W = 1.0f;
        this.isOffensive = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, -1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIPlaceBlock(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AITakeBlock(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.5, 48.0f, 12.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.5, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 10;
    }

    @Override
    public int getNextLevelRequirement() {
        return 100;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityEnderman(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
    }

    @Override
    public int timesToConvert() {
        return 27;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.25f;
    }

    @Override
    public float getBonusVSMassive() {
        return 2.5f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 40.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 64.0f + this.field_70146_Z.nextFloat() * 16.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 100.0f;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.field_184721_by = 0;
            iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
        } else {
            this.field_184721_by = this.field_70173_aa;
            if (!iattributeinstance.func_180374_a(attackingSpeedBoostModifier)) {
                iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(OMNI_DODGE, (Object)false);
    }

    @Override
    public EnumTier getTier() {
        return this.canDodgeAllAttacks() || this.andr ? EnumTier.TIER6 : EnumTier.TIER4;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.ENDER;
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(10); ++i) {
                EntityEnderman baby = new EntityEnderman(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-100000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    public void func_184716_o() {
        if (this.field_70173_aa >= this.field_184720_bx + 400) {
            this.field_184720_bx = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), this.func_70093_af() ? 1.0f : 2.5f, EngenderMod.useMobTalkerModels ? 1.25f : 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.isArmsRaised() && this.field_70170_p.field_72995_K) {
            this.func_184716_o();
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        IBlockState iblockstate = this.getHeldBlockState();
        tagCompound.func_74757_a("Andrea", this.andr);
        tagCompound.func_74757_a("OmniDodge", this.canDodgeAllAttacks());
        if (iblockstate != null) {
            tagCompound.func_74777_a("carried", (short)Block.func_149682_b((Block)iblockstate.func_177230_c()));
            tagCompound.func_74777_a("carriedData", (short)iblockstate.func_177230_c().func_176201_c(iblockstate));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setDodgeAllAttacks(tagCompund.func_74767_n("OmniDodge"));
        this.andr = tagCompund.func_74767_n("Andrea");
        IBlockState iblockstate = tagCompund.func_150297_b("carried", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("carried")).func_176203_a(tagCompund.func_74765_d("carriedData") & 0xFFFF) : Block.func_149729_e((int)tagCompund.func_74765_d("carried")).func_176203_a(tagCompund.func_74765_d("carriedData") & 0xFFFF);
        if (iblockstate == null || iblockstate.func_177230_c() == null || iblockstate.func_185904_a() == Material.field_151579_a) {
            iblockstate = null;
        }
        this.setHeldBlockState(iblockstate);
    }

    public boolean canDodgeAllAttacks() {
        return (Boolean)this.field_70180_af.func_187225_a(OMNI_DODGE);
    }

    public void setDodgeAllAttacks(boolean powered) {
        this.field_70180_af.func_187227_b(OMNI_DODGE, (Object)powered);
    }

    protected float func_70647_i() {
        return this.andr ? super.func_70647_i() - 0.25f : (EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.25f : super.func_70647_i());
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.88f : this.field_70131_O * 0.89f;
    }

    @Override
    public void performSpecialAttack() {
        List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
        if (list != null && !list.isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                if (entity == null || this.isOnSameTeam(entity)) continue;
                this.teleportTo(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                this.teleportRandomly();
                this.func_70652_k((Entity)entity);
            }
        }
        this.setSpecialAttackTimer(this.andr ? 20 : 1200);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (EngenderMod.useMobTalkerModels && !this.andr && "Andrea".equals(name)) {
            this.field_70173_aa = 0;
            this.becomeAHero();
            this.andr = true;
        } else {
            this.andr = false;
        }
    }

    @Override
    public void func_70636_d() {
        ItemStack block = this.getHeldBlockState() != null ? new ItemStack(this.getHeldBlockState().func_177230_c()) : ItemStack.field_190927_a;
        this.basicInventory.func_70299_a(7, block);
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof EntityWitherStorm && this.field_70146_Z.nextInt(100) == 0) {
            this.teleportTo(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
            this.func_70638_az().field_70181_x = -0.1;
            ((EntityWitherStorm)this.func_70638_az()).Grow(((EntityWitherStorm)this.func_70638_az()).getSize() - 2);
            this.func_70638_az().field_70172_ad = 0;
            this.setHeldBlockState(Blocks.field_150343_Z.func_176223_P());
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.getLevel() >= 300 && this.getStrength() >= 100.0f && this.getStamina() >= 100.0f && this.getIntelligence() >= 100.0f && this.getDexterity() >= 100.0f && this.getAgility() >= 100.0f) {
            this.setDodgeAllAttacks(true);
        }
        if (this.func_70638_az() != null && this.canDodgeAllAttacks() && this.func_70661_as().func_75500_f()) {
            this.teleportToEntity((Entity)this.func_70638_az());
        }
        if (this.canDodgeAllAttacks()) {
            this.func_70674_bp();
            this.func_70066_B();
            if (this.getEnergy() <= 0.0f) {
                this.func_70606_j(0.0f);
                this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
            }
        }
        if (EngenderMod.useMobTalkerModels && !this.isHero() && this.andr) {
            this.becomeAHero();
        }
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.5f, 2.75f);
        } else {
            this.func_70105_a(0.5f, 2.875f);
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.func_70026_G() && !this.andr && this.field_70172_ad <= 10) {
            this.func_70097_a(new DamageSource("waterburn").func_76361_j().func_76348_h(), 2.0f);
        }
        if (this.func_70638_az() != null) {
            if (this.field_70173_aa % 400 == 0) {
                this.func_184185_a(SoundEvents.field_187533_aW, this.func_70093_af() ? 1.0f : 2.5f, EngenderMod.useMobTalkerModels ? 1.25f : 1.0f);
            }
            if (this.func_70638_az().field_70131_O <= 2.25f && this.func_70638_az().func_184222_aU() && this.func_70638_az() instanceof EntityLiving && !(this.func_70638_az() instanceof EntityFriendlyCreature)) {
                ((EntityLiving)this.func_70638_az()).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 9));
                ((EntityLiving)this.func_70638_az()).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 0));
                ((EntityLiving)this.func_70638_az()).func_70671_ap().func_75650_a(this.func_70638_az().field_70165_t + (this.field_70146_Z.nextDouble() * 60.0 - 30.0), this.func_70638_az().field_70163_u + (this.field_70146_Z.nextDouble() * 60.0 - 30.0), this.func_70638_az().field_70161_v + (this.field_70146_Z.nextDouble() * 60.0 - 30.0), 180.0f, 180.0f);
                ((EntityLiving)this.func_70638_az()).func_70624_b((EntityLivingBase)null);
                this.func_70638_az().field_70761_aq = this.func_70638_az().field_70177_z = this.func_70638_az().field_70759_as;
                ((EntityLiving)this.func_70638_az()).field_70715_bh.field_75782_a.clear();
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70089_S()) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                if (!this.canDodgeAllAttacks()) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.DRAGON_BREATH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            for (i = 0; i < 2; ++i) {
                double d0 = (double)((float)this.field_70165_t) - 0.5 + (double)this.field_70146_Z.nextFloat();
                double d1 = (float)this.field_70163_u + this.field_70146_Z.nextFloat();
                double d2 = (double)((float)this.field_70161_v) - 0.5 + (double)this.field_70146_Z.nextFloat();
                double d3 = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double d4 = -this.field_70146_Z.nextDouble();
                double d5 = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d0, d1 += this.field_70146_Z.nextDouble() * (double)this.field_70131_O, d2, d3, d4, d5, new int[0]);
            }
        }
        if (!(!this.func_70089_S() || this.func_184207_aI() || this.getGuardBlock() != null || this.getOwner() == null || !(this.func_70068_e((Entity)this.getOwner()) > 4096.0) && this.func_70685_l((Entity)this.getOwner()) || this.field_70170_p.field_72995_K)) {
            this.func_70624_b(null);
            this.func_70661_as().func_75499_g();
            this.teleportTo(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v);
        }
        if (this.func_70089_S() && !this.func_184207_aI() && this.func_70643_av() != null && this.func_70681_au().nextInt(20) == 0) {
            if (this.func_70643_av().func_70068_e((Entity)this) < 2.0 && !this.field_70170_p.field_72995_K) {
                this.teleportRandomly();
            }
            if (this.func_70643_av().func_70068_e((Entity)this) > 128.0 && !this.field_70170_p.field_72995_K) {
                this.teleportToEntity((Entity)this.func_70643_av());
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        if (!EngenderMod.useMobTalkerModels && this.andr) {
            this.andr = false;
        }
        if (this.func_70089_S() && this.func_70026_G() && !this.andr) {
            this.func_70015_d(10);
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        if (this.field_70170_p.func_72935_r() || this.func_70026_G()) {
            this.func_70642_aH();
        }
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double x, double y, double z) {
        boolean flag;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean bl = flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ()) && !this.isInLove() && !this.func_184218_aH();
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextFloat() < 0.01f) {
                EntityEndermite entityendermite = new EntityEndermite(this.field_70170_p);
                entityendermite.setOwnerId(this.func_184753_b());
                entityendermite.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70170_p.func_72838_d((Entity)entityendermite);
            }
        }
        return flag;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.func_184207_aI()) {
                    this.func_184179_bs().func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (this instanceof EntityCreature) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    protected SoundEvent func_184639_G() {
        return this.isArmsRaised() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i());
        }
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i());
        }
        return SoundEvents.field_187530_aT;
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            IBlockState iblockstate = this.getHeldBlockState();
            if (this.hasOwner(player) && iblockstate != null) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(new ItemStack(iblockstate.func_177230_c(), 1, iblockstate.func_177230_c().func_176201_c(iblockstate)), 0.0f);
                }
                this.setHeldBlockState(null);
            } else if (!(this.isWild() || !this.isOnSameTeam((EntityLivingBase)player) || this.func_70631_g_() || player.func_70093_af() || this.field_70170_p.field_72995_K)) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151061_bv && (this.hasOwner(player) || player.func_184191_r((Entity)this))) {
            List list = this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, this.func_174813_aQ().func_186662_g(256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(i1);
                    if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity)) continue;
                    this.field_70170_p.func_184133_a((EntityPlayer)null, entity.func_180425_c(), SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                    entity.func_184204_a(1);
                }
            }
            this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.field_70170_p.func_184133_a((EntityPlayer)null, player.func_180425_c(), SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184204_a(1);
            player.func_184204_a(1);
            return true;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double d8 = 0.5;
            Vec3d vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            passenger.func_70107_b(this.field_70165_t + dx, this.field_70163_u + 0.25, this.field_70161_v + dz);
        }
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70177_z = this.field_70759_as = entitylivingbase.field_70177_z;
            this.field_70126_B = this.field_70759_as;
            this.field_70125_A = 0.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (EngenderMod.useMobTalkerModels && this.andr ? 15.0f : 1.5f));
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_70747_aH = EngenderMod.useMobTalkerModels && this.andr ? 1.0f : 0.02f;
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.field_70181_x = (double)this.jumpPower * (double)(EngenderMod.useMobTalkerModels && this.andr ? 25 : 1) * (double)this.getFittness();
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            Item item = Item.func_150898_a((Block)iblockstate.func_177230_c());
            int i = item.func_77614_k() ? iblockstate.func_177230_c().func_176201_c(iblockstate) : 0;
            this.func_70099_a(new ItemStack(item, 1, i), 0.0f);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_ENDERMAN;
    }

    public void setHeldBlockState(IBlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    public IBlockState getHeldBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orNull();
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (this.canDodgeAllAttacks() && this.getEnergy() > 0.0f) {
            this.teleportRandomly();
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.setEnergy(this.getEnergy() - 0.25f);
            if (entity instanceof EntityLivingBase && !this.isOnSameTeam((EntityLivingBase)entity)) {
                this.func_70652_k((Entity)((EntityLivingBase)entity));
            }
            return false;
        }
        if (this.andr && source instanceof EntityDamageSourceIndirect) {
            return false;
        }
        if (entity instanceof EntityLivingBase && EngenderMod.useMobTalkerModels && this.andr && amount < 50.0f) {
            EntityLivingBase creature = (EntityLivingBase)entity;
            creature.func_70097_a(DamageSource.field_76377_j.func_76348_h().func_76359_i().func_151518_m(), amount);
            creature.func_70653_a((Entity)this, amount * 0.1f, (double)(-MathHelper.func_76126_a((float)(creature.field_70759_as * ((float)Math.PI / 180)))), (double)MathHelper.func_76134_b((float)(creature.field_70759_as * ((float)Math.PI / 180))));
        }
        if (this.andr && (source.func_76347_k() || source.func_94541_c() || source.func_76352_a() || source.func_82725_o() || amount < 50.0f)) {
            return false;
        }
        if (EngenderMod.useMobTalkerModels && amount >= 1.0f && this.andr) {
            amount *= 1.0E-4f;
        }
        this.setSitResting(false);
        if (this.func_70089_S() && !this.andr && (this.func_180431_b(source) || source.func_76346_g() instanceof EntityCreeper || source instanceof EntityDamageSourceIndirect || source.func_94541_c() || source.func_76352_a())) {
            return this.teleportRandomly();
        }
        boolean flag = super.func_70097_a(source, amount);
        if (this.func_70089_S() && source.func_76363_c() && !this.andr) {
            this.teleportRandomly();
        }
        return flag;
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (canCarry) {
            carriableBlocks.add(block);
        } else {
            carriableBlocks.remove(block);
        }
    }

    public static boolean getCarriable(Block block) {
        return carriableBlocks.contains(block);
    }

    static {
        carriableBlocks.add((Block)Blocks.field_150349_c);
        carriableBlocks.add(Blocks.field_150346_d);
        carriableBlocks.add((Block)Blocks.field_150354_m);
        carriableBlocks.add(Blocks.field_150322_A);
        carriableBlocks.add(Blocks.field_180395_cM);
        carriableBlocks.add(Blocks.field_150322_A);
        carriableBlocks.add(Blocks.field_150406_ce);
        carriableBlocks.add(Blocks.field_150405_ch);
        carriableBlocks.add(Blocks.field_150407_cf);
        carriableBlocks.add(Blocks.field_150351_n);
        carriableBlocks.add((Block)Blocks.field_150328_O);
        carriableBlocks.add((Block)Blocks.field_150327_N);
        carriableBlocks.add((Block)Blocks.field_150338_P);
        carriableBlocks.add((Block)Blocks.field_150337_Q);
        carriableBlocks.add(Blocks.field_150344_f);
        carriableBlocks.add(Blocks.field_150364_r);
        carriableBlocks.add(Blocks.field_150363_s);
        carriableBlocks.add(Blocks.field_185766_cS);
        carriableBlocks.add(Blocks.field_185765_cR);
        carriableBlocks.add(Blocks.field_150335_W);
        carriableBlocks.add((Block)Blocks.field_150434_aF);
        carriableBlocks.add(Blocks.field_150435_aG);
        carriableBlocks.add(Blocks.field_150423_aK);
        carriableBlocks.add(Blocks.field_150440_ba);
        carriableBlocks.add(Blocks.field_189880_di);
        carriableBlocks.add(Blocks.field_189878_dg);
        carriableBlocks.add(Blocks.field_150385_bj);
        carriableBlocks.add(Blocks.field_189877_df);
        carriableBlocks.add((Block)Blocks.field_150391_bh);
        carriableBlocks.add(Blocks.field_150424_aL);
        carriableBlocks.add(Blocks.field_150447_bR);
        carriableBlocks.add((Block)Blocks.field_150479_bC);
        carriableBlocks.add(Blocks.field_150473_bD);
        carriableBlocks.add(Blocks.field_150404_cg);
        carriableBlocks.add(Blocks.field_150432_aD);
        carriableBlocks.add(Blocks.field_185778_de);
        carriableBlocks.add(Blocks.field_150367_z);
        carriableBlocks.add(Blocks.field_189879_dh);
        carriableBlocks.add(Blocks.field_150359_w);
        carriableBlocks.add(Blocks.field_150410_aZ);
        carriableBlocks.add(Blocks.field_150426_aN);
        carriableBlocks.add(Blocks.field_150425_aM);
        carriableBlocks.add((Block)Blocks.field_150362_t);
        carriableBlocks.add((Block)Blocks.field_150361_u);
        carriableBlocks.add(Blocks.field_150403_cj);
        carriableBlocks.add(Blocks.field_150365_q);
        carriableBlocks.add(Blocks.field_150366_p);
        carriableBlocks.add(Blocks.field_150369_x);
        carriableBlocks.add(Blocks.field_150450_ax);
        carriableBlocks.add(Blocks.field_150352_o);
        carriableBlocks.add(Blocks.field_150482_ag);
        carriableBlocks.add(Blocks.field_150412_bA);
    }

    static class AITakeBlock
    extends EntityAIBase {
        private final EntityEnderman enderman;

        public AITakeBlock(EntityEnderman p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            return this.enderman.getHeldBlockState() == null && !this.enderman.func_184207_aI() && (this.enderman.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || EngenderMod.useMobTalkerModels && this.enderman.func_82150_aj());
        }

        public void func_75246_d() {
            boolean flag;
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 3.0 + random.nextDouble() * 6.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u - 1.0 + random.nextDouble() * 4.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 3.0 + random.nextDouble() * 6.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            RayTraceResult raytraceresult = world.func_147447_a(new Vec3d((double)((float)MathHelper.func_76128_c((double)this.enderman.field_70165_t) + 0.5f), (double)((float)j + 0.5f), (double)((float)MathHelper.func_76128_c((double)this.enderman.field_70161_v) + 0.5f)), new Vec3d((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f)), false, true, false);
            boolean bl = flag = raytraceresult != null && raytraceresult.func_178782_a().equals((Object)blockpos);
            if (carriableBlocks.contains(block) && flag) {
                this.enderman.func_184609_a(EnumHand.MAIN_HAND);
                this.enderman.func_184609_a(EnumHand.OFF_HAND);
                this.enderman.func_70671_ap().func_75650_a((double)i, (double)j, (double)k, 180.0f, 40.0f);
                this.enderman.field_70170_p.func_175718_b(1021, blockpos, 0);
                this.enderman.field_70170_p.func_175718_b(2001, blockpos, Block.func_149682_b((Block)block));
                this.enderman.setHeldBlockState(iblockstate);
                world.func_175698_g(blockpos);
            }
        }
    }

    static class AIPlaceBlock
    extends EntityAIBase {
        private final EntityEnderman enderman;

        public AIPlaceBlock(EntityEnderman p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            return this.enderman.getHeldBlockState() != null && (!this.enderman.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || this.enderman.func_70681_au().nextInt(2000) == 0 || this.enderman.func_184218_aH());
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            IBlockState iblockstate1 = world.func_180495_p(blockpos.func_177977_b());
            IBlockState iblockstate2 = this.enderman.getHeldBlockState();
            if (iblockstate2 != null && this.func_188518_a(world, blockpos, iblockstate2.func_177230_c(), iblockstate, iblockstate1)) {
                this.enderman.field_70170_p.func_175718_b(2001, blockpos, Block.func_149682_b((Block)iblockstate2.func_177230_c()));
                world.func_180501_a(blockpos, iblockstate2, 3);
                this.enderman.setHeldBlockState(null);
            }
        }

        private boolean func_188518_a(World p_188518_1_, BlockPos p_188518_2_, Block p_188518_3_, IBlockState p_188518_4_, IBlockState p_188518_5_) {
            return p_188518_5_.func_185904_a() == Material.field_151579_a ? false : (p_188518_4_.func_185904_a() != Material.field_151579_a ? false : (!p_188518_3_.func_176196_c(p_188518_1_, p_188518_2_) ? false : p_188518_5_.func_185917_h()));
        }
    }
}

