/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIAvoidEntitySPC;
import net.minecraft.entity.helpful.tier3.EntitySpider;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeder
extends EntitySpider
implements Light {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeder.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeder.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeder.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 5;

    public EntityCreeder(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<EntityOcelot>(this, EntityOcelot.class, new Predicate<EntityOcelot>(){

            public boolean apply(EntityOcelot p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70089_S() && EntityCreeder.this.getIntelligence() < 10.0f;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<net.minecraft.entity.helpful.tier1.EntityOcelot>(this, net.minecraft.entity.helpful.tier1.EntityOcelot.class, new Predicate<net.minecraft.entity.helpful.tier1.EntityOcelot>(){

            public boolean apply(net.minecraft.entity.helpful.tier1.EntityOcelot p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70089_S() && EntityCreeder.this.getIntelligence() < 10.0f;
            }
        }, 6.0f, 1.0, 1.2));
        this.func_70105_a(0.5f, 1.85f);
        this.field_70728_aV = 10;
    }

    @Override
    public int getNextLevelRequirement() {
        return 200;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityCreeder(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.33);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    @Override
    public float getBonusVSLight() {
        return 1.1f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    @Override
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return this.getPowered() ? I18n.func_74838_a((String)"entity.ChargedCreederHelpful.name") : I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.hasIgnited());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_187227_b(POWERED, (Object)tagCompund.func_74767_n("powered"));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        if (this.field_70725_aQ == 1 && EngenderMod.useMobTalkerModels && this.getPowered()) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i() + 0.2f);
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
        super.func_70071_h_();
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187570_aq;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && cause.func_76346_g() instanceof AbstractSkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        }
    }

    @Override
    public void inflictEngenderMobDamage(EntityLivingBase entity, String killmessage, DamageSource attacktype, float damage) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && !entity.func_70089_S() && this.getPowered() && (this.field_70146_Z.nextInt(20) == 0 || this.isHero())) {
            if (entity instanceof EntitySkeleton) {
                entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
            }
            if (entity instanceof EntityWitherSkeleton) {
                entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
            }
            if (entity instanceof EntityZombie && !(entity instanceof EntityPigZombie)) {
                entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
            }
            if (entity instanceof EntityCreeper) {
                entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
            if (entity instanceof EntityDragon) {
                entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 5), 0.0f);
            }
        }
        if (this.getPowered()) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
            entity.func_70077_a(new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
        }
        super.inflictEngenderMobDamage(entity, killmessage, attacktype, damage);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && !entity.func_70089_S() && this.getPowered() && (this.field_70146_Z.nextInt(20) == 0 || this.isHero())) {
                if (entity instanceof EntitySkeleton) {
                    entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
                }
                if (entity instanceof EntityWitherSkeleton) {
                    entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
                }
                if (entity instanceof EntityZombie && !(entity instanceof EntityPigZombie)) {
                    entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
                }
                if (entity instanceof EntityCreeper) {
                    entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
                }
                if (entity instanceof EntityDragon) {
                    entity.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 5), 0.0f);
                }
            }
            if (this.getPowered()) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
                entity.func_70077_a(new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
            }
            return true;
        }
        return false;
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        float f = super.func_180428_a(explosionIn, worldIn, pos, blockStateIn) * 0.5f;
        Block block = blockStateIn.func_177230_c();
        if (EntityWither.func_181033_a((Block)block)) {
            f = Math.min(0.8f, f);
        }
        return f;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setPowered(boolean powered) {
        if (powered) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        }
        this.field_70180_af.func_187227_b(POWERED, (Object)powered);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_CREEDER;
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.setPowered(true);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                if (this.hasOwner(player)) {
                    if (player.func_70093_af()) {
                        this.ignite();
                    }
                    if (!this.getPowered()) {
                        if (this.field_70170_p.func_175710_j(this.func_180425_c())) {
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u + 1.625, this.field_70161_v - 0.5, false));
                        } else {
                            this.func_70656_aK();
                        }
                    } else {
                        this.func_70691_i(1.0f);
                    }
                } else {
                    this.ignite();
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void performSpecialAttack() {
        this.ignite();
        this.func_184185_a(SoundEvents.field_187941_ho, 10.0f, 1.0f);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            float f;
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f2 = f = this.getPowered() ? 2.0f : 1.0f;
            if (this.func_70638_az() != null && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                EntityCreeder.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 20.0f * f, flag);
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
                this.setCreeperState(-1);
                this.setSpecialAttackTimer(800);
                this.timeSinceIgnited = 0;
                this.field_70181_x = 0.0;
            } else {
                this.timeSinceIgnited = 0;
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
                this.setCreeperState(-1);
                EntityCreeder.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (float)this.explosionRadius * f, flag);
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f || this.isWild()) {
                this.field_70729_aU = true;
                this.func_70106_y();
                Collection collection = this.func_70651_bq();
                if (!collection.isEmpty()) {
                    EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    entityareaeffectcloud.func_184483_a(2.5f);
                    entityareaeffectcloud.func_184495_b(-0.5f);
                    entityareaeffectcloud.func_184485_d(10);
                    entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
                    entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                    for (PotionEffect potioneffect : collection) {
                        entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
                    }
                    this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
                }
                if (!this.field_70170_p.field_72995_K && EngenderMod.enableMessages && !this.isWild() && this.getOwner() instanceof EntityPlayerMP) {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation("death.attack.explosion", new Object[]{this.func_145748_c_()}));
                }
            } else {
                this.timeSinceIgnited = 0;
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getPowered()) {
            this.func_70066_B();
        }
        if (this.func_70638_az() != null && !this.hasIgnited() && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public class EntityAICreeperSwell
    extends EntityAIBase {
        EntityCreeder swellingCreeper;
        EntityLivingBase creeperAttackTarget;

        public EntityAICreeperSwell(EntityCreeder p_i1655_1_) {
            this.swellingCreeper = p_i1655_1_;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.swellingCreeper.func_70638_az();
            return (this.swellingCreeper.getCreeperState() > 0 || entitylivingbase != null && this.swellingCreeper.func_70068_e((Entity)entitylivingbase) < 9.0) && this.swellingCreeper.func_110143_aJ() <= this.swellingCreeper.func_110138_aP() / 2.0f;
        }

        public void func_75249_e() {
            this.swellingCreeper.func_70661_as().func_75499_g();
            this.creeperAttackTarget = this.swellingCreeper.func_70638_az();
        }

        public void func_75251_c() {
            this.creeperAttackTarget = null;
        }

        public void func_75246_d() {
            if (this.creeperAttackTarget == null) {
                this.swellingCreeper.setCreeperState(-1);
            } else if (this.swellingCreeper.func_70068_e((Entity)this.creeperAttackTarget) > 49.0) {
                this.swellingCreeper.setCreeperState(-1);
            } else if (!this.swellingCreeper.func_70635_at().func_75522_a((Entity)this.creeperAttackTarget)) {
                this.swellingCreeper.setCreeperState(-1);
            } else {
                this.swellingCreeper.setCreeperState(1);
            }
        }
    }
}

