/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.tier3.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityCaveSpider
extends EntitySpider {
    public EntityCaveSpider(World worldIn) {
        super(worldIn);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.35f, 1.365f);
        } else {
            this.func_70105_a(0.8f, 0.475f);
        }
        this.field_70728_aV = 2;
    }

    @Override
    public int getNextLevelRequirement() {
        return 30;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
    }

    @Override
    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.1f : super.func_70647_i();
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityCaveSpider(this.field_70170_p);
    }

    @Override
    public int timesToConvert() {
        return 17;
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            if (p_70652_1_ instanceof EntityLivingBase) {
                int b0 = 7;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    b0 = 15;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    b0 = 21;
                }
                if (b0 > 0) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(MobEffects.field_76436_u, b0 * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    public boolean func_70058_J() {
        if (this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
            BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            if (this.field_70170_p.func_175710_j(blockpos.func_177984_a())) {
                return false;
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos.func_177977_b());
            Block block = iblockstate.func_177230_c();
            if (block == Blocks.field_150344_f) {
                return true;
            }
        }
        return false;
    }

    @Override
    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O * 0.74f;
    }

    public void updateRiderPosition() {
        Entity entity = this.func_184179_bs();
        if (entity != null) {
            double d8 = -0.13;
            Vec3d vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            entity.func_70107_b(this.field_70165_t + dx, this.field_70163_u + this.func_70042_X() + entity.func_70033_W(), this.field_70161_v + dz);
        }
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.5;
    }

    @Override
    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        this.field_70701_bs *= 1.5f;
        this.field_70702_br *= 1.5f;
        super.func_70612_e(p_70612_1_, p_70612_2_);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_CAVE_SPIDER;
    }
}

