/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier4;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Elemental;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier4.EntitySmallFireballOther;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlaze
extends EntityFriendlyCreature
implements IJumpingMount,
Light,
Flying,
Elemental {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(EntityBlaze.class, (DataSerializer)DataSerializers.field_187191_a);
    protected float jumpPower;

    public EntityBlaze(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.isOffensive = true;
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 48.0f, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    @Override
    public int getNextLevelRequirement() {
        return 50;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityBlaze(this.field_70170_p);
    }

    @Override
    public float getBonusVSLight() {
        return 0.8f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.25f;
    }

    @Override
    public float getBonusVSFlying() {
        return 2.0f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() - 0.1f);
        }
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() - 0.1f);
        }
        return SoundEvents.field_187600_C;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                EntityBlaze baby = new EntityBlaze(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-72000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(800);
    }

    @Override
    public void func_70636_d() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.5f, 1.95f);
        } else {
            this.func_70105_a(0.6f, 1.8f);
        }
        if (this.func_70026_G()) {
            this.func_184185_a(SoundEvents.field_187658_bx, 1.0f, 1.0f);
            this.func_70097_a(new DamageSource("cooler").func_76348_h().func_151518_m().func_76351_m(), 4.0f);
        }
        if (this.isHero() && this.getSpecialAttackTimer() > 790) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    entity.field_70172_ad = 0;
                    entity.func_70097_a(DamageSource.field_76372_a, 2.0f);
                    entity.func_70015_d(60);
                    if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was scorched by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 256.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0 && this.func_70089_S()) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isHero() && this.getSpecialAttackTimer() > 790) {
                for (int i = 0; i < 3000; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                }
            }
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), this.func_70599_aP(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            if (!this.func_70026_G() && this.func_70089_S()) {
                for (int i = 0; i < 2; ++i) {
                    if (this.func_70093_af() || this.func_70631_g_()) {
                        this.field_70170_p.func_175688_a(this.isAntiMob() ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                        continue;
                    }
                    this.field_70170_p.func_175688_a(this.isAntiMob() ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        EntityLivingBase entitylivingbase;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = this.field_70146_Z.nextFloat() * 6.0f;
        }
        if ((entitylivingbase = this.func_70638_az()) != null && this.field_70163_u + (double)this.func_70047_e() - (double)this.heightOffset < entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e()) {
            this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected boolean func_70041_e_() {
        return EngenderMod.useMobTalkerModels;
    }

    public boolean func_70027_ad() {
        return this.func_70845_n();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_BLAZE;
    }

    public boolean func_70845_n() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && stack.func_77973_b() != Items.field_151063_bx && (EntityBlaze.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.MAINHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_151031_f)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b() && (EntityBlaze.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.OFFHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemFood && !(stack.func_77973_b() instanceof ItemAppleGold) || stack.func_77973_b() == Items.field_185167_i || stack.func_77973_b() == Items.field_185159_cQ)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && EntityBlaze.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && EntityBlaze.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.CHEST, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && EntityBlaze.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            this.func_184201_a(EntityEquipmentSlot.LEGS, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.LEGS, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() && EntityBlaze.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            this.func_184201_a(EntityEquipmentSlot.FEET, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.FEET, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_190926_b() && player.func_70093_af()) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(hand);
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A - 5.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.03f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            this.field_184618_aE = this.field_70721_aZ;
            if (((EntityLivingBase)this.func_184179_bs()).field_70702_br != 0.0f && this.field_70173_aa % 40 == 0 && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
                Vec3d vec3 = this.func_70676_i(1.0f);
                EntitySmallFireballOther entitysmallfireball = new EntitySmallFireballOther(this.field_70170_p, (EntityLivingBase)this, this.field_70165_t + vec3.field_72450_a * 16.0 - (this.field_70165_t + vec3.field_72450_a), this.field_70163_u + (double)this.func_70047_e() + vec3.field_72448_b * 16.0 - (this.field_70163_u + (double)this.func_70047_e() + vec3.field_72448_b), this.field_70161_v + vec3.field_72449_c * 16.0 - (this.field_70161_v + vec3.field_72449_c));
                entitysmallfireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                this.func_184609_a(EnumHand.MAIN_HAND);
                float dm = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entitysmallfireball.damage = dm * 0.6f;
            }
            for (int i = 0; i < 64; ++i) {
                int k;
                int j;
                int in = MathHelper.func_76128_c((double)this.field_70165_t);
                BlockPos blockpos = new BlockPos(in, j = MathHelper.func_76128_c((double)(this.field_70163_u - this.field_70146_Z.nextDouble() * (4.0 + (double)this.heightOffset))), k = MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (block == Blocks.field_150350_a) continue;
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.005, this.field_70161_v);
            }
            if (this.jumpPower > 0.0f) {
                this.field_70181_x += (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public void setOnFire(boolean onFire) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        b0 = onFire && !this.func_70026_G() ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)b0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (amount == 0.0f && source.func_76355_l() == "thrown" && source instanceof EntityDamageSourceIndirect && ((EntityDamageSourceIndirect)source).func_76346_g() instanceof EntitySnowball) {
            amount = 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getRegularHurtSound() : ModSoundEvents.metalHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getPierceHurtSound() : ModSoundEvents.metalHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getCrushHurtSound() : ModSoundEvents.metalHitCrush;
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.15f : super.func_70647_i();
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private EntityBlaze blaze;
        private int field_179467_b;
        private int field_179468_c;

        public AIFireballAttack(EntityBlaze blazeIn) {
            this.blaze = blazeIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.field_179467_b = 0;
        }

        public void func_75251_c() {
            this.blaze.setOnFire(false);
        }

        public void func_75246_d() {
            --this.field_179468_c;
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            double d0 = this.blaze.func_70068_e((Entity)entitylivingbase);
            if (this.blaze.field_70122_E && d0 > (double)(entitylivingbase.field_70130_N * entitylivingbase.field_70130_N) + 36.0) {
                this.blaze.func_70661_as().func_75497_a((Entity)entitylivingbase, (double)this.blaze.func_70689_ay());
            }
            float f = this.blaze.reachWidth * this.blaze.reachWidth;
            float f2 = entitylivingbase instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)entitylivingbase).reachWidth : entitylivingbase.field_70130_N;
            float f3 = entitylivingbase instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)entitylivingbase).reachWidth : entitylivingbase.field_70130_N;
            if (d0 < (double)(f + f2 * f3) + 9.0) {
                if (this.field_179468_c <= 0) {
                    this.field_179468_c = 20;
                    this.blaze.func_70652_k((Entity)entitylivingbase);
                }
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            } else if (d0 < 2048.0) {
                double d1 = entitylivingbase.field_70165_t - this.blaze.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 5.0f) - (this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 5.0f));
                double d3 = entitylivingbase.field_70161_v - this.blaze.field_70161_v;
                if (this.field_179468_c <= 0) {
                    ++this.field_179467_b;
                    if (this.field_179467_b == 1) {
                        this.field_179468_c = this.blaze.moralRaisedTimer > 200 ? 1 : 60;
                        this.blaze.setOnFire(true);
                    } else if (this.field_179467_b <= 4) {
                        this.field_179468_c = this.blaze.moralRaisedTimer > 200 ? 2 : 6;
                    } else {
                        this.field_179468_c = this.blaze.moralRaisedTimer > 200 ? 1 : 100;
                        this.field_179467_b = 0;
                        this.blaze.setOnFire(false);
                    }
                    if (this.field_179467_b > 1) {
                        float f4 = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.25f;
                        this.blaze.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.blaze.field_70165_t, (int)this.blaze.field_70163_u, (int)this.blaze.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntitySmallFireballOther entitysmallfireball = new EntitySmallFireballOther(this.blaze.field_70170_p, (EntityLivingBase)this.blaze, d1 + this.blaze.func_70681_au().nextGaussian() * (double)f4, d2, d3 + this.blaze.func_70681_au().nextGaussian() * (double)f4);
                            entitysmallfireball.field_70163_u = this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 2.0f) + 0.5;
                            entitysmallfireball.damage = (float)this.blaze.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 0.66f;
                            this.blaze.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                        }
                    }
                }
                this.blaze.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 30.0f);
            } else {
                this.blaze.func_70661_as().func_75499_g();
                if (this.blaze.moralRaisedTimer > 200) {
                    this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 4.5);
                } else {
                    this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 3.0);
                }
            }
            super.func_75246_d();
        }
    }
}

