/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier1.EntityChicken;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier4.EntityPigZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityZombie
extends EntityFriendlyCreature
implements Undead {
    private static final UUID UUID1 = UUID.fromString("648D7064-6A60-4F59-8ABE-C2C23A6DD7A1");
    private static final UUID UUID2 = UUID.fromString("648D7064-6A60-4F59-8ABE-C2C23A6DD7A2");
    private static final UUID UUID3 = UUID.fromString("648D7064-6A60-4F59-8ABE-C2C23A6DD7A3");
    private static final AttributeModifier attackDamageBoost1 = new AttributeModifier(UUID1, "First Boost", 1.0, 0);
    private static final AttributeModifier attackDamageBoost2 = new AttributeModifier(UUID2, "Second Boost", 1.0, 0);
    private static final AttributeModifier attackDamageBoost3 = new AttributeModifier(UUID3, "Third Boost", 1.0, 0);
    protected static final IAttribute SPAWN_REINFORCEMENTS_CHANCE = new RangedAttribute((IAttribute)null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final DataParameter<Integer> ZOMBIE_VARIANT = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VILLAGER_TYPE = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.func_187226_a(EntityZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    private int conversionTime;
    private float zombieWidth = -1.0f;
    private float zombieHeight;
    private int helmetCount = 1;

    public EntityZombie(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(0.5f, 1.95f);
        this.field_70728_aV = 5;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SPAWN_REINFORCEMENTS_CHANCE).func_111128_a(this.field_70146_Z.nextDouble() * 0.5);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ZOMBIE_VARIANT, (Object)0);
        this.func_184212_Q().func_187214_a(VILLAGER_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(CONVERTING, (Object)false);
    }

    @Override
    public int getNextLevelRequirement() {
        return this.getTier() == EnumTier.TIER4 ? 100 : 25;
    }

    @Override
    public boolean isASwarmingMob() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityZombie(this.field_70170_p);
    }

    @Override
    public boolean canBeMatedWith() {
        return super.canBeMatedWith();
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels && (this.isVillager() || this.func_70631_g_()) ? super.func_70647_i() + 0.25f : super.func_70647_i();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            switch (this.getZombieType()) {
                case 1: {
                    return I18n.func_74838_a((String)"entity.HuskHelpful.cmm.name");
                }
                case 2: {
                    return I18n.func_74838_a((String)"entity.PrisonZombieHelpful.cmm.name");
                }
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        switch (this.getZombieType()) {
            case 1: {
                return I18n.func_74838_a((String)"entity.HuskHelpful.name");
            }
            case 2: {
                return I18n.func_74838_a((String)"entity.PrisonZombieHelpful.name");
            }
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 2.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public EnumTier getTier() {
        return this.getZombieType() != 0 ? EnumTier.TIER4 : EnumTier.TIER3;
    }

    public boolean isVillager() {
        return this.isAntiMob() ? false : (Integer)this.func_184212_Q().func_187225_a(VILLAGER_TYPE) > 0;
    }

    public int getVillagerType() {
        return (Integer)this.func_184212_Q().func_187225_a(VILLAGER_TYPE) - 1;
    }

    public void setVillagerType(int villagerType) {
        this.func_184212_Q().func_187227_b(VILLAGER_TYPE, (Object)(this.isAntiMob() ? 0 : villagerType + 1));
    }

    public int getZombieType() {
        return (Integer)this.func_184212_Q().func_187225_a(ZOMBIE_VARIANT) - 1;
    }

    public void setZombieType(int villagerType) {
        this.func_184212_Q().func_187227_b(ZOMBIE_VARIANT, (Object)(villagerType + 1));
    }

    public void setToNotVillager() {
        this.func_184212_Q().func_187227_b(VILLAGER_TYPE, (Object)0);
    }

    @Override
    public void attackWithAdditionalEffects(Entity entity) {
        float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
        if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151033_d || this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151059_bz)) {
            entity.func_70015_d(12);
        }
        if (this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.5f) {
            entity.func_70015_d(5 * (int)f);
        }
        if (this.getZombieType() == 1 && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70181_x += 0.2;
            this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, (EntityLivingBase)entity, MobEffects.field_76438_s, 200 * (int)f, 0);
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL ? EnumDifficulty.PEACEFUL : EnumDifficulty.EASY, (EntityLivingBase)entity, MobEffects.field_76437_t, 200, 0);
            }
        }
        if (this.getZombieType() == 2 && entity instanceof EntityLivingBase) {
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            this.inflictCustomStatusEffect(this.field_70170_p.func_175659_aa(), (EntityLivingBase)entity, MobEffects.field_76421_d, 5, 1);
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_70638_az() != null && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70146_Z.nextInt(3) == 0) {
                ((EntityLiving)entity).func_70624_b(null);
            }
        }
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(700);
    }

    @Override
    protected boolean func_70610_aX() {
        return this.getSpecialAttackTimer() > 600 || super.func_70610_aX();
    }

    @Override
    public void createChild() {
        int i;
        this.func_184185_a(this.isVillager() ? ModSoundEvents.girlMoan : ModSoundEvents.guyDeath, 1.0f, this.func_70647_i() + 0.1f);
        this.func_184185_a(this.func_184615_bR(), 1.0f, this.func_70647_i() + 0.15f);
        for (i = 0; i < 10; ++i) {
            this.spawnHeartParticle();
        }
        if (!this.field_70170_p.field_72995_K && this.isVillager()) {
            for (i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                EntityZombie baby = new EntityZombie(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-48000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                baby.setVillagerType(this.getVillagerType());
                baby.setZombieType(this.getZombieType());
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    @Override
    public void func_70636_d() {
        float f;
        ItemStack head;
        this.func_70105_a(0.5f, 1.95f);
        if (this.isVillager() && (this.getZombieType() == 1 || this.getZombieType() == 2 || this.getZombieType() == 3)) {
            this.setToNotVillager();
        }
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.75 && !iattributeinstance.func_180374_a(attackDamageBoost1)) {
            iattributeinstance.func_111121_a(attackDamageBoost1);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() * 0.5f && !iattributeinstance.func_180374_a(attackDamageBoost2)) {
            iattributeinstance.func_111121_a(attackDamageBoost2);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() * 0.25f && !iattributeinstance.func_180374_a(attackDamageBoost3)) {
            iattributeinstance.func_111121_a(attackDamageBoost3);
        }
        if ((double)this.func_110143_aJ() >= (double)this.func_110138_aP() * 0.75 && iattributeinstance.func_180374_a(attackDamageBoost1)) {
            iattributeinstance.func_111124_b(attackDamageBoost1);
        }
        if (this.func_110143_aJ() >= this.func_110138_aP() * 0.5f && iattributeinstance.func_180374_a(attackDamageBoost2)) {
            iattributeinstance.func_111124_b(attackDamageBoost2);
        }
        if (this.func_110143_aJ() >= this.func_110138_aP() * 0.25f && iattributeinstance.func_180374_a(attackDamageBoost3)) {
            iattributeinstance.func_111124_b(attackDamageBoost3);
        }
        if (this.func_184614_ca().func_77973_b() instanceof ItemAppleGold && this.isVillager() && this.func_70644_a(MobEffects.field_76437_t)) {
            if (this.field_70173_aa > 53) {
                this.field_70173_aa = 20;
            }
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.func_184598_c(EnumHand.MAIN_HAND);
            this.field_70125_A = this.field_70173_aa % 2 == 0 ? 40.0f : 0.0f;
            if (this.field_70173_aa == 50) {
                for (int ai = 0; ai < ((ItemFood)this.func_184614_ca().func_77973_b()).func_150905_g(this.func_184614_ca()); ++ai) {
                    this.spawnHeartParticle();
                }
                this.func_70691_i(((ItemFood)this.func_184614_ca().func_77973_b()).func_150905_g(this.func_184614_ca()));
                this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.startConversion(200);
            }
        }
        if (this.func_70089_S() && this.func_184592_cb().func_77973_b() instanceof ItemAppleGold && this.isVillager() && this.func_70644_a(MobEffects.field_76437_t)) {
            if (this.field_70173_aa > 53) {
                this.field_70173_aa = 20;
            }
            this.field_70125_A = this.field_70173_aa % 2 == 0 ? 40.0f : 0.0f;
            this.func_184609_a(EnumHand.OFF_HAND);
            this.func_184598_c(EnumHand.OFF_HAND);
            if (this.field_70173_aa == 50) {
                this.spawnHeartParticle();
                this.func_70691_i(((ItemFood)this.func_184592_cb().func_77973_b()).func_150905_g(this.func_184592_cb()));
                this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.startConversion(200);
            }
        }
        if (this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) >= 2304.0 && this.func_184613_cA()) {
            double d01 = this.getOwner().field_70165_t - this.field_70165_t;
            double d11 = this.getOwner().field_70163_u - this.field_70163_u;
            double d21 = this.getOwner().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
            this.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + this.field_70159_w * 0.5;
            this.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
            this.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
            this.func_70625_a((Entity)this.getOwner(), 180.0f, 180.0f);
        }
        if (this.field_70170_p.func_175678_i(this.func_180425_c()) && (this.func_70638_az() != null && this.field_70122_E || !this.isWild() && this.getOwner().field_70163_u > this.field_70163_u && this.getOwner().func_184613_cA()) && this.func_184582_a(EntityEquipmentSlot.CHEST) != null && this.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Items.field_185160_cR) {
            this.field_70181_x = 1.0;
            this.func_70052_a(7, true);
        }
        if (!this.field_70122_E && this.func_184582_a(EntityEquipmentSlot.CHEST) != null && this.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Items.field_185160_cR && !this.func_184613_cA()) {
            this.func_70052_a(7, true);
        }
        if (this.func_184613_cA()) {
            this.field_70761_aq = this.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f;
        }
        if (!(this instanceof EntityPigZombie)) {
            List list;
            int i1;
            if (this.isHero() && this.getSpecialAttackTimer() > 600) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                List list2 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                if (list2 != null && !list2.isEmpty()) {
                    for (i1 = 0; i1 < list2.size(); ++i1) {
                        EntityLivingBase entity = (EntityLivingBase)list2.get(i1);
                        if (entity == null || this.isOnSameTeam(entity)) continue;
                        entity.field_70172_ad = 0;
                        this.inflictEngenderMobDamage(entity, " was yelled at to death by ", DamageSource.field_82727_n, 0.05f);
                    }
                }
            }
            if (this.isHero() && this.getSpecialAttackTimer() > 600 && this.getSpecialAttackTimer() < 640) {
                this.field_70125_A = -50.0f;
            }
            if (this.isHero() && this.getSpecialAttackTimer() == 600 && (list = this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
                for (i1 = 0; i1 < list.size(); ++i1) {
                    EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(i1);
                    if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity)) continue;
                    this.moralRaisedTimer = 600;
                    entity.moralRaisedTimer = 600;
                }
            }
            if (this.isHero() && this.getSpecialAttackTimer() == 640) {
                if (this.func_70631_g_()) {
                    this.func_184185_a(ModSoundEvents.zombieSpecial, 10.0f, 1.5f);
                } else {
                    this.func_184185_a(ModSoundEvents.zombieSpecial, 10.0f, 1.0f);
                }
            }
            if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                this.performSpecialAttack();
            }
        }
        if (this.helmetCount < 0) {
            this.helmetCount = 0;
        }
        if ((this instanceof EntityPigZombie || this.isAntiMob() || this.getZombieType() == 1 || this.func_70631_g_() || this.isHero()) && this.helmetCount != 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a((Item)Items.field_151024_Q, 1);
            }
            --this.helmetCount;
        }
        if (!(head = this.func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && head.func_77973_b() == Items.field_151024_Q && this.func_70089_S() && !this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            ++this.helmetCount;
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        }
        if (this.func_70089_S() && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && !this.func_70045_F() && !this.isAntiMob() && this.getZombieType() != 1 && !this.isHero() && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70173_aa % (!this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() ? 80 : 10) == 0 && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77972_a(1, (EntityLivingBase)this);
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                if (this.helmetCount > 0) {
                    this.func_184609_a(EnumHand.MAIN_HAND);
                    --this.helmetCount;
                    this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                } else {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public void func_70071_h_() {
        ItemStack hats = this.helmetCount > 0 ? new ItemStack((Item)Items.field_151024_Q, this.helmetCount) : ItemStack.field_190927_a;
        this.basicInventory.func_70299_a(7, hats);
        if (!this.field_70170_p.field_72995_K && this.isConverting()) {
            int i = this.getConversionTimeBoost();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.convertToVillager();
            }
        }
        super.func_70071_h_();
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
            entitycreature.field_70125_A = this.field_70125_A;
            entitycreature.field_70759_as = this.field_70759_as;
            if (this.func_70638_az() != null) {
                entitycreature.func_70624_b(this.func_70638_az());
            }
            if (this.field_70173_aa % 40 == 0) {
                this.field_70761_aq = this.field_70177_z = this.field_70759_as;
                if (this.func_70638_az() == null) {
                    entitycreature.func_70691_i(5.0f);
                } else {
                    entitycreature.func_70691_i(1.0f);
                }
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.getZombieType() == 1 ? SoundEvents.field_190022_cI : (this.isVillager() ? SoundEvents.field_187940_hn : SoundEvents.field_187899_gZ);
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(this.isVillager() ? ModSoundEvents.girlHurt : ModSoundEvents.guyHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return this.getZombieType() == 1 ? SoundEvents.field_190024_cK : (this.isVillager() ? SoundEvents.field_187944_hr : SoundEvents.field_187934_hh);
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(this.isVillager() ? ModSoundEvents.girlDeath : ModSoundEvents.guyDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return this.getZombieType() == 1 ? SoundEvents.field_190023_cJ : (this.isVillager() ? SoundEvents.field_187943_hq : SoundEvents.field_187930_hd);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this instanceof EntityPigZombie) {
            this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f / this.getFittness());
        }
        this.func_184185_a(this.getZombieType() == 1 ? SoundEvents.field_190025_cL : (this.isVillager() ? SoundEvents.field_187946_ht : SoundEvents.field_187939_hm), 0.15f, 1.0f / this.getFittness());
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.helmetCount > 0) {
            this.func_145779_a((Item)Items.field_151024_Q, this.helmetCount);
        }
        if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).getPowered()) {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getZombieType()) {
            case 1: {
                return LootTableListEngender.ENTITIES_HUSK;
            }
            case 2: {
                return LootTableListEngender.ENTITIES_PRISON_ZOMBIE;
            }
        }
        if (this.isVillager()) {
            return LootTableListEngender.ENTITIES_ZOMBIE_VILLAGER;
        }
        return LootTableListEngender.ENTITIES_ZOMBIE;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
    }

    public boolean func_70662_br() {
        return true;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.1f : 0.05f;
        if (f < f2) {
            i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                if (this.func_70681_au().nextInt(3) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151040_l));
                }
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a));
                if (this.func_70681_au().nextInt(3) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151037_a));
                }
            }
        }
        if (this.field_70146_Z.nextFloat() < 0.25f * difficulty.func_180170_c()) {
            float f3;
            i = this.field_70146_Z.nextInt(2);
            float f4 = f3 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.325f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.1f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.15f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.2f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f3) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = EntityZombie.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ZombieType", this.getZombieType());
        if (this.isVillager()) {
            tagCompound.func_74757_a("IsVillager", true);
            tagCompound.func_74768_a("VillagerProfession", this.getVillagerType());
        }
        tagCompound.func_74768_a("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        tagCompound.func_74768_a("Helmets", this.helmetCount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setZombieType(tagCompund.func_74762_e("ZombieType"));
        if (tagCompund.func_74767_n("IsVillager")) {
            if (tagCompund.func_150297_b("VillagerProfession", 99)) {
                this.setVillagerType(tagCompund.func_74762_e("VillagerProfession"));
            } else {
                this.setVillagerType(this.field_70170_p.field_73012_v.nextInt(5));
            }
        }
        if (tagCompund.func_150297_b("ConversionTime", 99) && tagCompund.func_74762_e("ConversionTime") > -1) {
            this.startConversion(tagCompund.func_74762_e("ConversionTime"));
        }
        if (tagCompund.func_150297_b("Helmets", 99)) {
            this.helmetCount = tagCompund.func_74762_e("Helmets");
        }
    }

    @Override
    public void func_70074_a(EntityLivingBase entityLivingIn) {
        EntityZombie entityzombie;
        Object entityvillager;
        super.func_70074_a(entityLivingIn);
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingIn instanceof EntityVillager) {
            entityvillager = (EntityVillager)entityLivingIn;
            entityzombie = new EntityZombie(this.field_70170_p);
            entityzombie.field_70125_A = ((EntityVillager)entityvillager).field_70125_A;
            entityzombie.field_70177_z = entityzombie.field_70759_as = ((EntityVillager)entityvillager).field_70759_as;
            entityzombie.field_70761_aq = entityzombie.field_70759_as;
            entityzombie.func_82149_j((Entity)entityLivingIn);
            this.field_70170_p.func_72900_e((Entity)entityLivingIn);
            entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), new GroupData(false, true));
            entityzombie.setVillagerType(entityvillager.func_70946_n());
            entityzombie.setChild(entityLivingIn.func_70631_g_());
            entityzombie.func_94061_f(entityvillager.func_175446_cd());
            if (!this.isWild()) {
                entityzombie.setOwnerId(this.func_184753_b());
            }
            if (entityvillager.func_145818_k_()) {
                entityzombie.func_96094_a(entityvillager.func_95999_t());
                entityzombie.func_174805_g(entityvillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        }
        if (entityLivingIn instanceof net.minecraft.entity.helpful.tier2.EntityVillager) {
            entityvillager = (net.minecraft.entity.helpful.tier2.EntityVillager)entityLivingIn;
            entityzombie = new EntityZombie(this.field_70170_p);
            entityzombie.field_70125_A = ((net.minecraft.entity.helpful.tier2.EntityVillager)entityvillager).field_70125_A;
            entityzombie.field_70177_z = entityzombie.field_70759_as = ((net.minecraft.entity.helpful.tier2.EntityVillager)entityvillager).field_70759_as;
            entityzombie.field_70761_aq = entityzombie.field_70759_as;
            entityzombie.func_82149_j((Entity)entityLivingIn);
            this.field_70170_p.func_72900_e((Entity)entityLivingIn);
            entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), new GroupData(false, true));
            entityzombie.setVillagerType(((net.minecraft.entity.helpful.tier2.EntityVillager)entityvillager).getProfession());
            entityzombie.setChild(entityLivingIn.func_70631_g_());
            entityzombie.func_94061_f(entityvillager.func_175446_cd());
            if (!this.isWild()) {
                entityzombie.setOwnerId(this.func_184753_b());
            }
            if (entityvillager.func_145818_k_()) {
                entityzombie.func_96094_a(entityvillager.func_95999_t());
                entityzombie.func_174805_g(entityvillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        }
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? (this.getZombieType() == 1 ? this.field_70131_O * 0.9f : this.field_70131_O * 0.84f) : (this.getZombieType() == 1 ? this.field_70131_O * 0.9f : this.field_70131_O * 0.87f);
    }

    protected boolean func_175448_a(ItemStack p_175448_1_) {
        return p_175448_1_.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(p_175448_1_);
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        double d0;
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        if (livingdata == null) {
            livingdata = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, this.field_70170_p.field_73012_v.nextFloat() < 0.05f);
        }
        if (livingdata instanceof GroupData) {
            GroupData groupdata = (GroupData)livingdata;
            Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
            if (biome instanceof BiomeDesert && this.field_70146_Z.nextInt(5) != 0) {
                this.setZombieType(1);
                this.setToNotVillager();
            }
            if (groupdata.isVillager) {
                this.setVillagerType(this.field_70146_Z.nextInt(5));
            }
            if (groupdata.isChild) {
                this.setChild(true);
                this.setGrowingAge(-60000);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.setChickenJockey(true);
                        this.func_184220_m((Entity)entitychicken);
                        entitychicken.setOwnerId(this.func_184753_b());
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken entitychicken1 = new EntityChicken(this.field_70170_p);
                    entitychicken1.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    entitychicken1.func_180482_a(difficulty, null);
                    entitychicken1.setChickenJockey(true);
                    entitychicken1.setOwnerId(this.func_184753_b());
                    this.field_70170_p.func_72838_d((Entity)entitychicken1);
                    this.func_184220_m((Entity)entitychicken1);
                }
            }
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        if ((d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f) > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
        }
        return livingdata;
    }

    @Override
    public void becomeAHero() {
        super.becomeAHero();
        this.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (this.isOnSameTeam((EntityLivingBase)player) && this.func_70631_g_() && stack.func_190926_b() && player.func_70093_af() && this.func_184187_bx() == null) {
            List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityChicken entity = (EntityChicken)list.get(i1);
                    if (entity == null || entity.func_184207_aI() || !this.isOnSameTeam((EntityLivingBase)entity) || !this.func_70631_g_() || this.field_70170_p.field_72995_K) continue;
                    entity.field_70173_aa = 0;
                    this.func_184220_m((Entity)entity);
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                    break;
                }
            }
            return true;
        }
        if (this instanceof EntityPigZombie && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151141_av && this.func_184187_bx() == null && (this.hasOwner(player) || player.func_184191_r((Entity)this))) {
            this.func_184185_a(SoundEvents.field_187706_dO, 0.5f, 1.0f);
            player.func_184220_m((Entity)this);
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151024_Q) {
            ++this.helmetCount;
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD || stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_185764_cQ) || stack.func_77973_b() == Items.field_151008_G) && stack.func_77973_b() != Items.field_151024_Q) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.CHEST, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            this.func_184201_a(EntityEquipmentSlot.LEGS, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.LEGS, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() && EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            this.func_184201_a(EntityEquipmentSlot.FEET, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.FEET, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && stack.func_77973_b() != Items.field_151057_cb && (EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.MAINHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_151031_f)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b() && (EntityZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.OFFHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemFood && (!(stack.func_77973_b() instanceof ItemAppleGold) || stack.func_77973_b() == Items.field_151153_ao && stack.func_77960_j() == 0 && this.isVillager() && this.func_70644_a(MobEffects.field_76437_t)) || stack.func_77973_b() == Items.field_185167_i || stack.func_77973_b().func_77661_b(stack) == EnumAction.BLOCK || stack.func_77973_b() == Items.field_190929_cY)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && stack.func_190926_b()) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    protected void startConversion(int ticks) {
        this.conversionTime = ticks;
        this.func_184212_Q().func_187227_b(CONVERTING, (Object)true);
        this.func_184589_d(MobEffects.field_76437_t);
        this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, ticks, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && source.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)source.func_76346_g();
            }
            if (entitylivingbase != null && (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD || this.isHero())) {
                this.spawnZombieAlly();
            }
            return true;
        }
        return false;
    }

    public void spawnZombieAlly() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if ((double)this.field_70146_Z.nextFloat() < this.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111126_e() && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
            for (int l = 0; l < 50; ++l) {
                int k1;
                int j1;
                int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                if (!this.field_70170_p.func_180495_p(new BlockPos(i1, (j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1, k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1))).isSideSolid((IBlockAccess)this.field_70170_p, new BlockPos(i1, j1 - 1, k1), EnumFacing.UP) || this.field_70170_p.func_175671_l(new BlockPos(i1, j1, k1)) >= 10) continue;
                EntityZombie entityzombie = new EntityZombie(this.field_70170_p);
                entityzombie.func_70107_b(i1, j1, k1);
                if (this.field_70170_p.func_175636_b((double)i1, (double)j1, (double)k1, 7.0) || !this.field_70170_p.func_72917_a(entityzombie.func_174813_aQ(), (Entity)entityzombie) || !this.field_70170_p.func_184144_a((Entity)entityzombie, entityzombie.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(entityzombie.func_174813_aQ())) continue;
                this.field_70170_p.func_72838_d((Entity)entityzombie);
                entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                entityzombie.setZombieType(this.getZombieType());
                entityzombie.setOwnerId(this.func_184753_b());
                entityzombie.setIsAntiMob(this.isAntiMob());
                entityzombie.setGrowingAge(this.func_70654_ax());
                if (!this.isVillager() || !(this.field_70146_Z.nextFloat() < 0.25f)) break;
                entityzombie.setVillagerType(this.field_70146_Z.nextInt(5));
                break;
            }
        }
    }

    public boolean isConverting() {
        return (Boolean)this.func_184212_Q().func_187225_a(CONVERTING);
    }

    protected void convertToVillager() {
        net.minecraft.entity.helpful.tier2.EntityVillager entityvillager = new net.minecraft.entity.helpful.tier2.EntityVillager(this.field_70170_p);
        entityvillager.func_82149_j((Entity)this);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        entityvillager.field_70177_z = entityvillager.field_70759_as = this.field_70759_as;
        entityvillager.field_70761_aq = entityvillager.field_70759_as;
        entityvillager.field_70125_A = this.field_70125_A;
        entityvillager.func_94061_f(this.func_175446_cd());
        entityvillager.setProfession(this.getVillagerType());
        entityvillager.setOwnerId(this.func_184753_b());
        if (this.func_145818_k_()) {
            entityvillager.func_96094_a(this.func_95999_t());
            entityvillager.func_174805_g(this.func_174833_aM());
        }
        if (!this.field_70170_p.field_72995_K && this.helmetCount > 0) {
            this.func_145779_a((Item)Items.field_151024_Q, this.helmetCount);
        }
        this.field_70170_p.func_72838_d((Entity)entityvillager);
        entityvillager.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1027, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        this.field_70170_p.func_72900_e((Entity)this);
    }

    protected int getConversionTimeBoost() {
        int i = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.field_70165_t - 4; k < (int)this.field_70165_t + 4 && j < 14; ++k) {
                for (int l = (int)this.field_70163_u - 4; l < (int)this.field_70163_u + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.field_70161_v - 4; i1 < (int)this.field_70161_v + 4 && j < 14; ++i1) {
                        Block block = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k, l, i1)).func_177230_c();
                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return this.func_70658_aO() >= 10 ? ModSoundEvents.metalHit : ModSoundEvents.fleshHit;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild = false;
        public boolean isVillager = false;

        private GroupData(boolean isBaby, boolean isVillagerZombie) {
            this.isChild = isBaby;
            this.isVillager = isVillagerZombie;
        }
    }
}

