/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.Elemental;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVex
extends EntityFriendlyCreature
implements Light,
Flying,
Elemental {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(EntityVex.class, (DataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockPos boundOrigin;
    private boolean limitedLifespan;
    private int limitedLifeTicks;

    public EntityVex(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(0.4f, 0.8f);
        this.field_70728_aV = 3;
    }

    @Override
    public int getNextLevelRequirement() {
        return 20;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    @Override
    protected void dropEquipmentUndamaged() {
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public float getBonusVSLight() {
        return 1.1f;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.9f;
    }

    @Override
    public float getBonusVSFlying() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityVex(this.field_70170_p);
    }

    @Override
    public void func_70071_h_() {
        this.func_70105_a(0.4f, 0.8f);
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        if (this.func_70089_S()) {
            this.func_189654_d(true);
        } else {
            this.func_189654_d(false);
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        if (!this.isWild()) {
            if (this.func_70638_az() != null) {
                this.setBoundOrigin(this.func_70638_az().func_180425_c());
            } else {
                this.setBoundOrigin(this.getJukeboxToDanceTo() != null ? this.getJukeboxToDanceTo().func_177981_b(2) : (this.getGuardBlock() != null ? new BlockPos(this.randPosX, this.randPosY, this.randPosZ) : this.getOwner().func_180425_c().func_177981_b((int)this.getOwner().func_70047_e())));
            }
        }
        if (this.limitedLifespan && this.limitedLifeTicks <= 80 && this.field_70173_aa > 20 && this.field_70173_aa < 40) {
            this.func_70097_a(DamageSource.field_76366_f.func_76348_h(), Float.MAX_VALUE);
        }
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.func_70097_a(DamageSource.field_76366_f, 5.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70638_az() == null && this.getSpecialAttackTimer() > 600) {
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(24.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                if (entitylivingbase == this || this.isOnSameTeam(entitylivingbase) || !entitylivingbase.func_70089_S()) continue;
                this.func_70624_b(entitylivingbase);
                Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                break;
            }
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
        if (compound.func_74764_b("LifeTicks")) {
            this.setLimitedLife(compound.func_74762_e("LifeTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
        if (this.limitedLifespan) {
            compound.func_74768_a("LifeTicks", this.limitedLifeTicks);
        }
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    private boolean getVexFlag(int p_190656_1_) {
        byte i = (Byte)this.field_70180_af.func_187225_a(VEX_FLAGS);
        return (i & p_190656_1_) != 0;
    }

    private void setVexFlag(int p_190660_1_, boolean p_190660_2_) {
        int i = ((Byte)this.field_70180_af.func_187225_a(VEX_FLAGS)).byteValue();
        i = p_190660_2_ ? (i |= p_190660_1_) : (i &= ~p_190660_1_);
        this.field_70180_af.func_187227_b(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1) || this.getJukeboxToDanceTo() != null;
    }

    public void setIsCharging(boolean p_190648_1_) {
        this.setVexFlag(1, p_190648_1_);
    }

    public void setLimitedLife(int limitedLifeTicksIn) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = limitedLifeTicksIn;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_191267_hf;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return 0xF000F0;
    }

    public float func_70013_c(float partialTicks) {
        return 1.0f;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_VEX;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityVex.this.func_70605_aq().func_75640_a() && (EntityVex.this.field_70146_Z.nextInt(7) == 0 || EntityVex.this.getJukeboxToDanceTo() != null);
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityVex.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityVex.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityVex.this.field_70146_Z.nextInt(15) - 7, EntityVex.this.field_70146_Z.nextInt(11) - 5, EntityVex.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityVex.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityVex.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityVex.this.func_70638_az() != null) break;
                if (EntityVex.this.getJukeboxToDanceTo() != null) {
                    EntityVex.this.func_70671_ap().func_75650_a((double)EntityVex.this.getJukeboxToDanceTo().func_177958_n() + 0.5, (double)EntityVex.this.getJukeboxToDanceTo().func_177956_o() + 0.5, (double)EntityVex.this.getJukeboxToDanceTo().func_177952_p() + 0.5, 180.0f, 0.0f);
                    break;
                }
                EntityVex.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityVex vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityVex.this.field_70165_t;
                double d1 = this.field_75647_c - EntityVex.this.field_70163_u;
                double d2 = this.field_75644_d - EntityVex.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityVex.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityVex.this.field_70159_w *= 0.5;
                    EntityVex.this.field_70181_x *= 0.5;
                    EntityVex.this.field_70179_y *= 0.5;
                } else {
                    EntityVex.this.field_70159_w += d0 / d3 * 0.2 * this.field_75645_e;
                    EntityVex.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityVex.this.field_70179_y += d2 / d3 * 0.2 * this.field_75645_e;
                    if (EntityVex.this.func_70638_az() == null) {
                        EntityVex.this.field_70761_aq = EntityVex.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityVex.this.field_70159_w, (double)EntityVex.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityVex.this.func_70638_az().field_70165_t - EntityVex.this.field_70165_t;
                        double d5 = EntityVex.this.func_70638_az().field_70161_v - EntityVex.this.field_70161_v;
                        EntityVex.this.field_70761_aq = EntityVex.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                        EntityVex.this.func_70625_a((Entity)EntityVex.this.func_70638_az(), 10.0f, 40.0f);
                    }
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return EntityVex.this.func_70638_az() != null && EntityVex.this.getSpecialAttackTimer() > 600 ? true : (EntityVex.this.func_70638_az() != null && !EntityVex.this.func_70605_aq().func_75640_a() && EntityVex.this.field_70146_Z.nextInt(7) == 0 ? EntityVex.this.func_70068_e((Entity)EntityVex.this.func_70638_az()) > 4.0 : false);
        }

        public boolean func_75253_b() {
            return EntityVex.this.func_70638_az() != null && EntityVex.this.getSpecialAttackTimer() > 600 ? true : EntityVex.this.func_70605_aq().func_75640_a() && EntityVex.this.isCharging() && EntityVex.this.func_70638_az() != null && EntityVex.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityVex.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityVex.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityVex.this.setIsCharging(true);
            EntityVex.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
            if (EntityVex.this.func_70638_az() != null && EntityVex.this.getSpecialAttackTimer() <= 0 && EntityVex.this.isHero()) {
                EntityVex.this.setSpecialAttackTimer(900);
                EntityVex.this.func_184185_a(SoundEvents.field_191265_hd, 10.0f, 0.75f);
            }
        }

        public void func_75251_c() {
            EntityVex.this.setIsCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityVex.this.func_70638_az();
            if (EntityVex.this.func_70068_e((Entity)entitylivingbase) <= (double)(EntityVex.this.field_70130_N * EntityVex.this.field_70130_N + entitylivingbase.field_70130_N * entitylivingbase.field_70130_N) + 9.0) {
                EntityVex.this.func_70652_k((Entity)entitylivingbase);
            } else {
                double d0 = EntityVex.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    EntityVex.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

