/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAICustomLeapAttack;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier4.EntityCaveSpider;
import net.minecraft.entity.helpful.tier4.EntityCreeder;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpider
extends EntityFriendlyCreature
implements IJumpingMount,
Light {
    private static final DataParameter<Boolean> SURVIVAL_TEST_SKIN = EntityDataManager.func_187226_a(EntitySpider.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntitySpider.class, (DataSerializer)DataSerializers.field_187191_a);
    protected float jumpPower;

    public EntitySpider(World worldIn) {
        super(worldIn);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.7f);
        } else {
            this.func_70105_a(1.5f, 0.78f);
        }
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICustomLeapAttack((EntityLiving)this, 0.6f, 0.6f, 0.8f, 0.5f, 4.0, 16.0, 6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.1, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 3;
    }

    @Override
    public int getNextLevelRequirement() {
        return 25;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntitySpider(this.field_70170_p);
    }

    @Override
    public boolean isASwarmingMob() {
        return true;
    }

    @Override
    public float getBonusVSLight() {
        return 1.5f;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.75f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.5f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 40.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 40.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.2f : super.func_70647_i();
    }

    protected PathNavigate getNewNavigator(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SURVIVAL_TEST_SKIN, (Object)false);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public boolean isSurvivalTestSkin() {
        return (Boolean)this.func_184212_Q().func_187225_a(SURVIVAL_TEST_SKIN);
    }

    public void setSurvivalTestSkin(boolean childZombie) {
        this.func_184212_Q().func_187227_b(SURVIVAL_TEST_SKIN, (Object)childZombie);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setSurvivalTestSkin(tagCompund.func_74767_n("EasterEgg"));
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (((Boolean)this.field_70180_af.func_187225_a(SURVIVAL_TEST_SKIN)).booleanValue()) {
            tagCompound.func_74757_a("EasterEgg", true);
        }
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER3;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (this.func_184207_aI() && !this.field_70122_E && this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(4.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                if (list != null && !list.isEmpty() && this.jumpPower >= 1.0f) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntityLivingBase entity1 = (EntityLivingBase)list.get(i1);
                        if (entity1 == null || !entity1.func_70089_S()) continue;
                        this.func_70652_k((Entity)entity1);
                    }
                }
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.1f, (EngenderMod.useMobTalkerModels ? 1.25f : 1.0f) / this.getFittness());
        if (EngenderMod.useMobTalkerModels) {
            super.func_180429_a(pos, blockIn);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_SPIDER;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(3); ++i) {
                int e;
                EntitySpider baby;
                if (this instanceof EntityCaveSpider) {
                    baby = new EntityCaveSpider(this.field_70170_p);
                    baby.func_82149_j((Entity)this);
                    baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                    baby.setGrowingAge(-24000);
                    baby.setChild(true);
                    baby.setOwnerId(this.func_184753_b());
                    if (this.isMarried()) {
                        for (e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                            baby.levelUp();
                        }
                    }
                    this.field_70170_p.func_72838_d((Entity)baby);
                    continue;
                }
                baby = new EntitySpider(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.setGrowingAge(-32000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                if (this.isMarried()) {
                    for (e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.setSurvivalTestSkin(true);
        }
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0 && this.getGrowingAge() >= 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_184220_m((Entity)this);
            if (!this.isWild()) {
                entityskeleton.setOwnerId(this.func_184753_b());
            }
        }
        if (livingdata == null) {
            livingdata = new GroupData();
            if (this.field_70170_p.field_73012_v.nextFloat() < 0.25f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).field_188478_a) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public float func_70047_e() {
        return this instanceof EntityCreeder ? this.field_70131_O * 0.88f : (EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O * 0.74f);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && stack.func_190926_b() && this.func_184187_bx() == null) {
            List list = this.field_70170_p.func_175647_a(EntitySkeleton.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (this.func_184187_bx() == null && list != null && !list.isEmpty() && !this.func_184207_aI() && this.hasOwner(player)) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntitySkeleton entity = (EntitySkeleton)list.get(i1);
                    if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity) || entity.func_184218_aH() || this.field_70170_p.field_72995_K) continue;
                    player.func_184609_a(EnumHand.MAIN_HAND);
                    entity.func_184220_m((Entity)this);
                    this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
                    break;
                }
            }
            return true;
        }
        if (!player.func_70093_af() && stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (passenger instanceof EntityAmbientCreature) {
                double d8 = 1.1;
                Vec3d vec3 = this.func_70676_i(1.0f);
                double dx = vec3.field_72450_a * d8;
                double dz = vec3.field_72449_c * d8;
                passenger.func_70107_b(this.field_70165_t + dx, this.field_70163_u + 0.25, this.field_70161_v + dz);
            } else {
                float f2 = this.field_70761_aq * (float)Math.PI / 180.0f;
                float f19 = MathHelper.func_76126_a((float)f2);
                float f3 = MathHelper.func_76134_b((float)f2);
                passenger.func_70107_b(this.field_70165_t + (double)(f19 * 0.2f), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v - (double)(f3 * 0.2f));
            }
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.725;
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70617_f_() || this.func_184218_aH() && this.func_184187_bx() instanceof EntityPlayer && ((EntityPlayer)this.func_184187_bx()).field_70721_aZ != 0.0f) {
            this.field_70721_aZ += 1.0f;
        }
        if (this instanceof EntityCaveSpider) {
            if (EngenderMod.useMobTalkerModels) {
                this.func_70105_a(0.35f, 1.365f);
            } else {
                this.func_70105_a(0.8f, 0.475f);
            }
        } else if (this instanceof EntityCreeder) {
            this.func_70105_a(0.75f, 1.75f);
        } else if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.7f);
        } else {
            this.func_70105_a(1.5f, 0.78f);
        }
        if (!(this.func_70638_az() == null || this.func_70638_az().func_70685_l((Entity)this) && this.field_70122_E && !(this.field_70163_u < this.func_70638_az().field_70163_u))) {
            this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 1024.0 && this.func_70068_e((Entity)this.func_70638_az()) > 64.0 && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
            this.performSpecialAttack();
        }
    }

    @Override
    public void performSpecialAttack() {
        double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
        double hor = (double)(f21 / 16.0f) * 1.3;
        double ver = 0.9;
        this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
        this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
        this.field_70181_x = ver;
        this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
        this.setSpecialAttackTimer(100);
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            if (jumpPowerIn >= 90) {
                this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
                this.jumpPower = 1.0f;
            } else {
                this.jumpPower = 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 30) {
            this.setSurvivalTestSkin(true);
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
        if (this.func_184207_aI() && this.func_82171_bF() && !(entitylivingbase instanceof EntityAmbientCreature)) {
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.field_70181_x = 0.6 * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                this.field_70159_w = (this instanceof EntityCaveSpider ? -2.5f : -2.0f) * f * this.jumpPower;
                this.field_70179_y = (this instanceof EntityCaveSpider ? 2.5f : 2.0f) * f1 * this.jumpPower;
                this.jumpPower = 0.0f;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion field_188478_a;

        public void func_111104_a(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.field_188478_a = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.field_188478_a = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.field_188478_a = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.field_188478_a = MobEffects.field_76441_p;
            }
        }
    }
}

