/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier3.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeHooks;

public class EntitySlime
extends EntityFriendlyCreature
implements IJumpingMount {
    private static final DataParameter<Integer> SLIME_SIZE = EntityDataManager.func_187226_a(EntitySlime.class, (DataSerializer)DataSerializers.field_187192_b);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private int field_179924_h;
    protected float jumpPower;

    public EntitySlime(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        if (EngenderMod.useMobTalkerModels) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 32.0f, 6.0f));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.2, true));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        } else {
            this.field_70765_h = new SlimeMoveHelper(this);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 32.0f, 6.0f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeFloat(this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeAttack(this));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISlimeFaceRandom(this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        }
    }

    @Override
    public int getNextLevelRequirement() {
        return 10 * this.getSlimeSize();
    }

    @Override
    public float getBonusVSLight() {
        return 1.25f;
    }

    @Override
    public float getBonusVSArmored() {
        return 2.0f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.5f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 1.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public boolean canBeMatedWith() {
        return this.getSlimeSize() >= 1;
    }

    @Override
    public boolean canBeMarried() {
        return this.getSlimeSize() >= 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLIME_SIZE, (Object)1);
    }

    @Override
    public int timesToConvert() {
        return 4 * this.getSlimeSize();
    }

    public void setSlimeSize(int size) {
        this.field_70180_af.func_187227_b(SLIME_SIZE, (Object)size);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a((float)size * 0.125f, (float)size * 0.5f - 0.05f);
            if (size <= 1) {
                this.func_70105_a(0.2f, 0.85f);
            }
            if (size == 2 || size == 3) {
                this.func_70105_a(0.35f, 1.5f);
            }
        } else {
            this.func_70105_a(0.5f * (float)size, 0.5f * (float)size);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(size * size));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EngenderMod.useMobTalkerModels ? 0.25 : (double)(0.35f + 0.15f * (float)size));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = size;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER3;
    }

    public int getSlimeSize() {
        return (Integer)this.field_70180_af.func_187225_a(SLIME_SIZE);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
        tagCompound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public boolean func_189101_db() {
        return this.getSlimeSize() <= 1;
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        int i = tagCompund.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1);
        this.wasOnGround = tagCompund.func_74767_n("wasOnGround");
    }

    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.SLIME;
    }

    protected SoundEvent getJumpSound() {
        return this.isSmallSlime() ? SoundEvents.field_189110_fE : SoundEvents.field_187882_fq;
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(3); ++i) {
                EntitySlime baby = this.createInstance();
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-12000 * this.getSlimeSize());
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                baby.setSlimeSize(this.getSlimeSize() / 4);
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        ItemStack size = new ItemStack(this instanceof EntityMagmaCube ? Items.field_151064_bs : Items.field_151123_aH, this.getSlimeSize());
        size.func_151001_c("Size: " + this.getSlimeSize());
        this.basicInventory.func_70299_a(7, size);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getAttackStrength());
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.getSlimeSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * this.field_70130_N * f1;
                float f3 = MathHelper.func_76134_b((float)f) * this.field_70130_N * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.getParticleType();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / (EngenderMod.useMobTalkerModels ? 1.05f : 0.8f));
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        if (EngenderMod.useMobTalkerModels) {
            this.squishAmount *= 0.3f;
        } else {
            this.alterSquishAmount();
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.moralRaisedTimer > 200 ? this.field_70146_Z.nextInt(10) + 5 : this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntitySlime createInstance() {
        return new EntitySlime(this.field_70170_p);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SLIME_SIZE.equals(key)) {
            int size = this.getSlimeSize();
            if (EngenderMod.useMobTalkerModels) {
                this.func_70105_a((float)size * 0.125f, (float)size * 0.5f - 0.05f);
                if (this.getSlimeSize() <= 1) {
                    this.func_70105_a(0.2f, 0.85f);
                }
                if (this.getSlimeSize() == 2 || size == 3) {
                    this.func_70105_a(0.35f, 1.5f);
                }
            } else {
                this.func_70105_a(0.5f * (float)size, 0.5f * (float)size);
            }
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntitySlime entityslime = this.createInstance();
                entityslime.func_70014_b(this.getEntityData());
                entityslime.setSlimeSize(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        super.func_70106_y();
    }

    @Override
    public void performSpecialAttack() {
        this.func_70664_aZ();
        for (int k = 0; k < this.getSlimeSize(); ++k) {
            this.field_70181_x += 0.25;
        }
        this.func_184185_a(this.func_184710_cZ(), this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 64.0 * (double)this.getSlimeSize() && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            List list;
            this.setSpecialAttackTimer(100 * this.getSlimeSize());
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 2.0f - (float)this.getSlimeSize() * 0.25f);
            EntitySlime.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v, this.getSlimeSize(), false);
            if (this.func_70638_az() != null && !this.isOnSameTeam(this.func_70638_az())) {
                double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
                double hor = (double)(f21 / 16.0f) * 1.25;
                this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
                this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
                this.field_70181_x = 0.6f;
                double dou = this.func_70068_e((Entity)this.func_70638_az());
                if (dou <= 16.0) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            }
            if ((list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(16.0 * (double)this.getSlimeSize()), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam(entity)) continue;
                    entity.field_70181_x += 0.75;
                    this.func_70652_k((Entity)entity);
                }
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_85033_bc();
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntityLivingBase) {
            this.field_70177_z = this.field_70759_as = ((EntityLivingBase)this.func_184187_bx()).field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
        if (this.func_70638_az() != null && !this.field_70122_E && EngenderMod.useMobTalkerModels && this.func_70068_e((Entity)this.func_70638_az()) > (double)(this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 16.0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            double d3 = d0 * d0 + d1 * d1;
            double d5 = MathHelper.func_76133_a((double)d3);
            this.field_70159_w += d0 / d5 * 0.5 - this.field_70159_w;
            this.field_70179_y += d1 / d5 * 0.5 - this.field_70179_y;
        }
        if (this.func_70638_az() != null && this.field_70122_E && EngenderMod.useMobTalkerModels && this.field_179924_h-- <= 0) {
            this.field_179924_h = this.getJumpDelay();
            if (this.func_70638_az() != null) {
                this.field_179924_h /= 3;
            }
            if (this.func_70027_ad()) {
                this.field_179924_h /= 3;
            }
            if (!this.func_70093_af()) {
                this.func_70683_ar().func_75660_a();
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 32.0 * (double)this.getSlimeSize() && this.getSpecialAttackTimer() <= 0 && this.field_70122_E && this.isHero()) {
            this.performSpecialAttack();
        }
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return this.getSlimeSize() >= 4 ? I18n.func_74838_a((String)"entity.SlimeHelpful.cmm4.name") : (this.isSmallSlime() ? I18n.func_74838_a((String)"entity.SlimeHelpful.cmm1.name") : I18n.func_74838_a((String)"entity.SlimeHelpful.cmm2.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (this.field_70173_aa > 10 && this.func_70685_l(entityIn) && this.func_70068_e(entityIn) < (double)this.field_70130_N * 1.5 * ((double)this.field_70130_N * 1.5) && !this.func_184191_r(entityIn)) {
            this.func_70652_k(entityIn);
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            if ((this.func_70090_H() || this.func_180799_ab()) && this.func_70681_au().nextFloat() < 0.8f) {
                this.field_70181_x += 0.1 - this.field_70181_x;
            }
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.05f;
            if (this.func_184186_bw()) {
                this.func_70659_e(EngenderMod.useMobTalkerModels ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : 0.0f);
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.func_70664_aZ();
                this.field_70181_x += (double)this.jumpPower * (this instanceof EntityMagmaCube ? 1.0 : 0.25);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_184185_a(this.func_184710_cZ(), this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
    }

    public void func_184777_r_() {
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.isOnSameTeam((EntityLivingBase)player) && this.getSlimeSize() < (this.isHero() ? 16 : 4) && stack.func_77973_b() == (this instanceof EntityMagmaCube ? Items.field_151064_bs : Items.field_151123_aH)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / (EngenderMod.useMobTalkerModels ? 1.05f : 0.8f));
            this.setSlimeSize(this.getSlimeSize() + 1);
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / (EngenderMod.useMobTalkerModels ? 1.05f : 0.8f));
            int i = this.getSlimeSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.getParticleType();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        if (this.isSmallSlime()) {
            if (this.hasOwner(player) && EngenderMod.useMobTalkerModels) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (this.func_184187_bx() == null) {
                    this.func_184205_a((Entity)player, true);
                } else {
                    this.func_184210_p();
                }
            }
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null && !this.isSmallSlime()) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.8f : 0.625f * this.field_70131_O;
    }

    protected boolean canDamagePlayer() {
        return true;
    }

    protected int getAttackStrength() {
        return this.moralRaisedTimer > 200 ? this.getSlimeSize() * 2 : this.getSlimeSize();
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + (this.getSlimeSize() > 6 ? 0.15f : 0.6f - (float)this.getSlimeSize() * 0.15f));
        }
        return this.func_189101_db() ? SoundEvents.field_187898_fy : SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + (this.getSlimeSize() > 6 ? 0.15f : 0.6f - (float)this.getSlimeSize() * 0.15f));
        }
        return this.func_189101_db() ? SoundEvents.field_187896_fx : SoundEvents.field_187874_fm;
    }

    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187898_fy : SoundEvents.field_187886_fs;
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.25f : super.func_70647_i();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isSmallSlime() ? LootTableListEngender.ENTITIES_SLIME : LootTableList.field_186419_a;
    }

    public boolean isSmallSlime() {
        return this.getSlimeSize() <= 1;
    }

    @Override
    protected float func_70599_aP() {
        return (this.func_70093_af() ? 0.025f : 0.25f) * (float)this.getSlimeSize();
    }

    @Override
    public int func_70646_bf() {
        return 40;
    }

    protected boolean makesSoundOnJump() {
        return false;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    @Override
    protected void func_70664_aZ() {
        this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / (EngenderMod.useMobTalkerModels ? 1.35f : 1.1f));
        this.field_70181_x += 0.42;
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 0.25 + (double)this.squishFactor * ((double)this.getSlimeSize() * 0.25) * (this instanceof EntityMagmaCube ? 3.0 : 1.5);
    }

    @Override
    public double func_70033_W() {
        return EngenderMod.useMobTalkerModels ? 0.0 : 0.5;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficulty.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.setSlimeSize(8);
        } else {
            this.setSlimeSize(j);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    protected SoundEvent func_184710_cZ() {
        return this.func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntitySlime slime;
        private boolean isAggressive;

        public SlimeMoveHelper(EntitySlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO || this.slime.getJukeboxToDanceTo() != null) {
                this.field_75648_a.func_70657_f(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E && !this.field_75648_a.func_184207_aI() && !this.field_75648_a.func_184218_aH()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        if (this.field_75648_a.func_70027_ad()) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_70701_bs = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private final EntitySlime slime;

        public AISlimeHop(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private final EntitySlime slime;

        public AISlimeFloat(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private final EntitySlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimeFaceRandom(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private final EntitySlime slime;
        private int growTieredTimer;

        public AISlimeAttack(EntitySlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a ? false : --this.growTieredTimer > 0));
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }
}

