/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityPEGunPellet;
import net.minecraft.AgeOfMinecraft.abyssalcraft.items.ItemPEGun;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIAttackRangedBowAlly;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier3.EntityTippedArrowOther;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeSnow;

public class EntitySkeleton
extends EntityFriendlyCreature
implements IRangedAttackMob,
Undead {
    private static final DataParameter<Integer> SKELETON_VARIANT = EntityDataManager.func_187226_a(EntitySkeleton.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntitySkeleton.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIAttackRangedBowAlly aiArrowAttack = new EntityAIAttackRangedBowAlly(this, 1.0, 5, 15.0f);
    private final EntityAIFriendlyAttackMelee aiAttackOnCollide = new EntityAIFriendlyAttackMelee(this, 1.2, true){

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ItemStack itemstack = EntitySkeleton.this.func_184586_b(EnumHand.MAIN_HAND);
            if ((itemstack == null || !(itemstack.func_77973_b() instanceof ItemBow)) && EntitySkeleton.this.func_184187_bx() != null && EntitySkeleton.this.func_184187_bx() instanceof EntitySkeletonHorse) {
                ((EntitySkeletonHorse)EntitySkeleton.this.func_184187_bx()).func_70661_as().func_75484_a(EntitySkeleton.this.func_70661_as().func_75494_a((Entity)EntitySkeleton.this.func_70638_az()), 1.2);
            }
        }
    };
    private int helmetCount = 1;

    public EntitySkeleton(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (this.getSkeletonType() == 1) {
            this.func_70105_a(0.6f, 2.39f);
        } else {
            this.func_70105_a(0.5f, 1.95f);
        }
        if (worldIn != null && !worldIn.field_72995_K) {
            this.setCombatTask();
        }
        this.field_70728_aV = 4;
    }

    @Override
    public int getNextLevelRequirement() {
        return this.getTier() == EnumTier.TIER4 ? 100 : 25;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntitySkeleton(this.field_70170_p);
    }

    @Override
    public int timesToConvert() {
        return this.getSkeletonType() != 0 ? 27 : 13;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public EnumTier getTier() {
        return this.getSkeletonType() != 0 ? EnumTier.TIER4 : EnumTier.TIER3;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntitySkeletonHorse) {
                switch (this.getSkeletonType()) {
                    case 1: {
                        return I18n.func_74838_a((String)"entity.WitherSkeletonHorsemanHelpful.cmm.name");
                    }
                    case 2: {
                        return I18n.func_74838_a((String)"entity.StrayHorsemanHelpful.cmm.name");
                    }
                }
                return I18n.func_74838_a((String)"entity.SkeletonHorsemanHelpful.cmm.name");
            }
            switch (this.getSkeletonType()) {
                case 1: {
                    return I18n.func_74838_a((String)"entity.WitherSkeletonHelpful.cmm.name");
                }
                case 2: {
                    return I18n.func_74838_a((String)"entity.StrayHelpful.cmm.name");
                }
            }
            return I18n.func_74838_a((String)"entity.SkeletonHelpful.cmm.name");
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntitySkeletonHorse) {
            switch (this.getSkeletonType()) {
                case 1: {
                    return I18n.func_74838_a((String)"entity.WitherSkeletonHorsemanHelpful.name");
                }
                case 2: {
                    return I18n.func_74838_a((String)"entity.StrayHorsemanHelpful.name");
                }
            }
            return I18n.func_74838_a((String)"entity.SkeletonHorsemanHelpful.name");
        }
        switch (this.getSkeletonType()) {
            case 1: {
                return I18n.func_74838_a((String)"entity.WitherSkeletonHelpful.name");
            }
            case 2: {
                return I18n.func_74838_a((String)"entity.StrayHelpful.name");
            }
        }
        return I18n.func_74838_a((String)"entity.SkeletonHelpful.name");
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKELETON_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                EntitySkeleton baby = new EntitySkeleton(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-48000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                baby.setSkeletonType(this.getSkeletonType());
                baby.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                baby.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                baby.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                baby.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
                baby.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
                baby.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        switch (this.getSkeletonType()) {
            case 1: {
                return SoundEvents.field_190036_ha;
            }
            case 2: {
                return SoundEvents.field_190032_gu;
            }
        }
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.05f);
        }
        switch (this.getSkeletonType()) {
            case 1: {
                return SoundEvents.field_190038_hc;
            }
            case 2: {
                return SoundEvents.field_190034_gw;
            }
        }
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.05f);
        }
        switch (this.getSkeletonType()) {
            case 1: {
                return SoundEvents.field_190037_hb;
            }
            case 2: {
                return SoundEvents.field_190033_gv;
            }
        }
        return SoundEvents.field_187856_fd;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        switch (this.getSkeletonType()) {
            case 1: {
                this.func_184185_a(SoundEvents.field_190039_hd, 0.1f, (EngenderMod.useMobTalkerModels ? 1.25f : 1.0f) / this.getFittness());
            }
            case 2: {
                this.func_184185_a(SoundEvents.field_190035_gx, 0.1f, (EngenderMod.useMobTalkerModels ? 1.25f : 1.0f) / this.getFittness());
            }
        }
        this.func_184185_a(SoundEvents.field_187868_fj, 0.1f, (EngenderMod.useMobTalkerModels ? 1.25f : 1.0f) / this.getFittness());
        if (EngenderMod.useMobTalkerModels) {
            super.func_180429_a(pos, blockIn);
        }
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.15f : super.func_70647_i();
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            int i;
            if (this.getSkeletonType() == 1 && p_70652_1_ instanceof EntityLivingBase) {
                i = 5;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 20;
                }
                if (i > 0) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(MobEffects.field_82731_v, i * 20, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                }
            }
            if (this.getSkeletonType() == 2 && p_70652_1_ instanceof EntityLivingBase) {
                i = 10;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 20;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 40;
                }
                if (i > 0) {
                    ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(MobEffects.field_76421_d, i * 20, 0 + this.field_70170_p.func_175659_aa().func_151525_a()));
                }
            }
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemBow) {
                this.func_184609_a(EnumHand.OFF_HAND);
                this.func_184185_a(SoundEvents.field_187721_dT, this.func_70599_aP(), 1.0f);
                this.func_70653_a((Entity)this, 0.5f, MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180))));
                ((EntityLivingBase)p_70652_1_).func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)))));
            }
            if (this.func_184582_a(EntityEquipmentSlot.OFFHAND) != null && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_77973_b() == Items.field_185159_cQ) {
                this.func_184185_a(SoundEvents.field_187767_eL, this.func_70599_aP(), 1.0f);
                this.func_70653_a((Entity)this, 0.5f, -MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))), MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180))));
                ((EntityLivingBase)p_70652_1_).func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)))));
            }
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151033_d || this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151059_bz)) {
                p_70652_1_.func_70015_d(12);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_82731_v && this.getSkeletonType() == 1 ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    public void performSpecialAttack() {
        if (this.func_184586_b(EnumHand.MAIN_HAND) != null && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemBow) {
            this.setSpecialAttackTimer(500);
            this.func_184185_a(ModSoundEvents.skeletonSpecial, 10.0f, 1.0f);
        } else {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 5.0f);
            this.setSpecialAttackTimer(500);
        }
    }

    @Override
    public void func_70636_d() {
        float f;
        ItemStack head;
        ItemStack hats = this.helmetCount > 0 ? new ItemStack((Item)Items.field_151024_Q, this.helmetCount) : ItemStack.field_190927_a;
        this.basicInventory.func_70299_a(7, hats);
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntitySkeletonHorse) {
            this.func_184188_bt().clear();
        }
        if (this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) >= 2304.0 && this.func_184613_cA()) {
            double d01 = this.getOwner().field_70165_t - this.field_70165_t;
            double d11 = this.getOwner().field_70163_u - this.field_70163_u;
            double d21 = this.getOwner().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
            this.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + this.field_70159_w * 0.5;
            this.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
            this.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
            this.func_70625_a((Entity)this.getOwner(), 180.0f, 180.0f);
        }
        if (this.field_70170_p.func_175678_i(this.func_180425_c()) && (this.func_70638_az() != null && this.field_70122_E || !this.isWild() && this.getOwner().field_70163_u > this.field_70163_u && this.getOwner().func_184613_cA()) && this.func_184582_a(EntityEquipmentSlot.CHEST) != null && this.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Items.field_185160_cR) {
            this.field_70181_x = 1.0;
            this.func_70052_a(7, true);
        }
        if (!this.field_70122_E && this.func_184582_a(EntityEquipmentSlot.CHEST) != null && this.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Items.field_185160_cR && !this.func_184613_cA()) {
            this.func_70052_a(7, true);
        }
        if (this.field_70122_E && this.func_184613_cA()) {
            this.func_70052_a(7, false);
        }
        if (this.func_184613_cA()) {
            this.field_70761_aq = this.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f;
        }
        if (this.getSkeletonType() == 1) {
            this.func_70105_a(0.6f, 2.39f);
        } else {
            this.func_70105_a(0.5f, 1.95f);
        }
        ItemStack item = this.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack secitem = this.func_184586_b(EnumHand.OFF_HAND);
        if (!item.func_190926_b() && !secitem.func_190926_b() && item.func_77973_b() instanceof ItemBow && !(secitem.func_77973_b() instanceof ItemBow) && secitem.func_77973_b() != Items.field_185167_i && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) <= 128.0 && this.func_70638_az().field_70163_u <= this.field_70163_u + 3.0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, secitem);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, item);
        }
        if (!item.func_190926_b() && !secitem.func_190926_b() && secitem.func_77973_b() instanceof ItemBow && !(item.func_77973_b() instanceof ItemBow) && item.func_77973_b() != Items.field_185167_i && this.func_70638_az() != null && (this.func_70068_e((Entity)this.func_70638_az()) > 128.0 || this.func_70638_az().field_70163_u > this.field_70163_u + 3.0)) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, secitem);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, item);
        }
        if (!item.func_190926_b() && item.func_77973_b() instanceof ItemBow) {
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < 512.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                this.performSpecialAttack();
            }
            if (this.func_70638_az() != null && this.isHero() && this.getSpecialAttackTimer() < 490 && this.getSpecialAttackTimer() > 470) {
                this.func_82196_d(this.func_70638_az(), 2.0f);
            }
        } else if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70068_e((Entity)this.func_70638_az()) < 32.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntitySkeletonHorse) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
            if (this.func_70093_af()) {
                this.func_184187_bx().func_70095_a(true);
            } else {
                this.func_184187_bx().func_70095_a(false);
            }
            if (this.func_70051_ag()) {
                this.func_184187_bx().func_70031_b(true);
            } else {
                this.func_184187_bx().func_70031_b(false);
            }
        }
        if (this.getSkeletonType() == 1 && this.func_184187_bx() == null) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        }
        if (this.field_70170_p.field_72995_K && this.getSkeletonType() == 1) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.helmetCount < 0) {
            this.helmetCount = 0;
        }
        if ((this.getSkeletonType() == 1 || this.isAntiMob() || this.func_70631_g_() || this.isHero()) && this.helmetCount != 0 && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.helmetCount; ++i) {
                this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                this.func_145779_a((Item)Items.field_151024_Q, 1);
                --this.helmetCount;
            }
        }
        if (!(head = this.func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && head.func_77973_b() == Items.field_151024_Q && this.func_70089_S() && !this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            ++this.helmetCount;
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        }
        if (this.func_70089_S() && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.getSkeletonType() != 1 && !this.isAntiMob() && !this.isHero() && !this.func_70045_F() && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70173_aa % (!this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() ? 80 : 10) == 0 && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                if (this.helmetCount > 0) {
                    this.func_184609_a(EnumHand.MAIN_HAND);
                    this.func_184609_a(EnumHand.OFF_HAND);
                    --this.helmetCount;
                    this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                } else {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
            entitycreature.field_70125_A = this.field_70125_A;
            entitycreature.field_70759_as = this.field_70759_as;
            if (this.func_70638_az() != null) {
                entitycreature.func_70624_b(this.func_70638_az());
            }
            if (this.field_70173_aa % 40 == 0) {
                this.field_70761_aq = this.field_70177_z = this.field_70759_as;
                if (this.func_70638_az() == null) {
                    entitycreature.func_70691_i(5.0f);
                } else {
                    entitycreature.func_70691_i(1.0f);
                }
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.helmetCount; ++i) {
                this.func_145779_a((Item)Items.field_151024_Q, 1);
                --this.helmetCount;
            }
        }
        if (cause.func_76364_f() instanceof EntityArrow && cause.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)cause.func_76346_g();
            double d0 = entityplayer.field_70165_t - this.field_70165_t;
            double d1 = entityplayer.field_70161_v - this.field_70161_v;
            if (d0 * d0 + d1 * d1 >= 2500.0) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187994_v);
            }
        } else if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).getPowered()) {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, this.getSkeletonType() == 1 ? 1 : 0), 0.0f);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getSkeletonType()) {
            case 1: {
                return LootTableListEngender.ENTITIES_WITHER_SKELETON;
            }
            case 2: {
                return LootTableListEngender.ENTITIES_STRAY;
            }
        }
        return LootTableListEngender.ENTITIES_SKELETON;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        if (this.field_70146_Z.nextFloat() < 0.25f * difficulty.func_180170_c()) {
            float f;
            i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.325f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.1f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.15f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.2f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = EntitySkeleton.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
        if (this.getSkeletonType() == 1) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
            if (this.func_70681_au().nextInt(3) == 0) {
                i = this.field_70146_Z.nextInt(3);
                if (i == 0) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185159_cQ));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151052_q));
                }
            }
        } else {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
            float f = this.field_70146_Z.nextFloat();
            float f3 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
            if (f < f3) {
                i = this.field_70146_Z.nextInt(3);
                ItemStack stack = new ItemStack(Items.field_185167_i);
                if (i == 0) {
                    PotionUtils.func_185188_a((ItemStack)stack, (PotionType)PotionTypes.field_185219_B);
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
                } else {
                    PotionUtils.func_185188_a((ItemStack)stack, (PotionType)PotionTypes.field_185227_J);
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
                }
            } else if (this.func_70681_au().nextInt(20) == 0) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151041_m));
            }
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        if (this.field_70170_p.field_73011_w instanceof WorldProviderHell && this.field_70146_Z.nextInt(5) != 0 || this.getSkeletonType() == 1) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            this.setSkeletonType(1);
        } else if (biome instanceof BiomeSnow && this.field_70146_Z.nextInt(5) != 0) {
            this.setSkeletonType(2);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        return livingdata;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemBow) {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        if (this.func_184614_ca().func_77973_b() instanceof ItemPEGun) {
            if (((ItemPEGun)this.func_184614_ca().func_77973_b()).getContainedEnergy(this.func_184614_ca()) > 0.0f) {
                float f = MathHelper.func_76134_b((float)((this.field_70759_as + (float)(180 * ((this.func_184638_cS() ? 1 : 2) - 1))) * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76126_a((float)((this.field_70759_as + (float)(180 * ((this.func_184638_cS() ? 1 : 2) - 1))) * ((float)Math.PI / 180)));
                ((ItemPEGun)this.func_184614_ca().func_77973_b()).consumeEnergy(this.func_184614_ca(), 1.0f);
                double d22 = 64.0;
                Vec3d vec3 = this.func_70676_i(1.0f);
                double d2 = target.field_70165_t - (this.field_70165_t + (double)f * 0.35 + vec3.field_72450_a);
                double d3 = target.field_70163_u + 0.5 - (this.field_70163_u + (double)this.func_70047_e() - (double)0.1f + vec3.field_72448_b);
                double d4 = target.field_70161_v - (this.field_70161_v + (double)f1 * 0.35 + vec3.field_72449_c);
                EntityPEGunPellet entitywitherskull = new EntityPEGunPellet(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
                entitywitherskull.field_70165_t = this.field_70165_t + (double)f * 0.35 + vec3.field_72450_a;
                entitywitherskull.field_70163_u = this.field_70163_u + (double)this.func_70047_e() - (double)0.1f + vec3.field_72448_b;
                entitywitherskull.field_70161_v = this.field_70161_v + (double)f1 * 0.35 + vec3.field_72449_c;
                entitywitherskull.damage = ((ItemPEGun)this.func_184614_ca().func_77973_b()).getProjectileDamage(this.func_184614_ca());
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitywitherskull);
                }
                this.func_184185_a(SoundEvents.field_187539_bB, 0.5f, 0.5f + this.func_70681_au().nextFloat() * 0.25f);
                this.func_184185_a(ModSoundEvents.pegunfire, 0.5f, 0.6f + this.func_70681_au().nextFloat() * 0.2f + entitywitherskull.damage / 100.0f);
            } else {
                this.func_184185_a(ModSoundEvents.pegunjam, 0.5f, 1.0f);
                this.func_70099_a(this.func_184614_ca(), 1.4f);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            }
        } else {
            EntityTippedArrowOther entityarrow = new EntityTippedArrowOther(this.field_70170_p, (EntityLivingBase)this);
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.field_70163_u + (double)target.func_70047_e() - 0.5 - (this.field_70163_u + (double)this.func_70047_e() - (double)0.1f);
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70186_c(d0, d1 + d3 * ((double)this.func_70032_d((Entity)target) * 0.013), d2, 1.4f, this.isHero() ? 1.0f : 9.0f);
            int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
            int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
            if (this.func_184187_bx() != null) {
                entityarrow.func_70239_b((double)(p_82196_2_ * 3.0f) + this.field_70146_Z.nextGaussian() * 0.25 + 0.5);
            } else {
                entityarrow.func_70239_b((double)(p_82196_2_ * 1.5f) + this.field_70146_Z.nextGaussian() * 0.25 + 0.5);
            }
            if (target instanceof EntityDragon && this.field_70163_u < target.field_70163_u - 10.0) {
                entityarrow.field_70181_x += 1.0;
            }
            if (i > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
            }
            if (this.isHero()) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() * 2.0);
            }
            if (this.moralRaisedTimer > 200) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() * 1.5);
            }
            if (this.func_184187_bx() != null) {
                j += 2;
                entityarrow.func_70243_d(true);
            }
            if (j > 0) {
                entityarrow.func_70240_a(j);
            }
            if (this.getSkeletonType() == 2) {
                entityarrow.func_184558_a(new PotionEffect(MobEffects.field_76421_d, 600));
            }
            if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0 || this.getSkeletonType() == 1) {
                entityarrow.func_70015_d(100);
            }
            if (this.func_184592_cb() != null && this.func_184592_cb().func_77973_b() == Items.field_185167_i) {
                entityarrow.func_184555_a(this.func_184592_cb());
            }
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        }
    }

    public boolean func_70027_ad() {
        return this.getSkeletonType() == 1 ? false : super.func_70027_ad();
    }

    public int getSkeletonType() {
        return (Integer)this.field_70180_af.func_187225_a(SKELETON_VARIANT);
    }

    public void setSkeletonType(int p_82201_1_) {
        this.field_70180_af.func_187227_b(SKELETON_VARIANT, (Object)p_82201_1_);
        boolean bl = this.field_70178_ae = p_82201_1_ == 1;
        if (p_82201_1_ == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("SkeletonType", 99)) {
            byte i = tagCompund.func_74771_c("SkeletonType");
            this.setSkeletonType(i);
        }
        if (tagCompund.func_150297_b("Helmets", 99)) {
            this.helmetCount = tagCompund.func_74762_e("Helmets");
        }
        this.setCombatTask();
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("SkeletonType", (byte)this.getSkeletonType());
        tagCompound.func_74768_a("Helmets", this.helmetCount);
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.82f : this.field_70131_O * 0.84f;
    }

    @Override
    public double func_70033_W() {
        return this.getSkeletonType() == 1 ? super.func_70033_W() - 0.54 : super.func_70033_W() - 0.45;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (this.isOnSameTeam((EntityLivingBase)player) && stack.func_190926_b() && player.func_70093_af() && this.func_184187_bx() == null) {
            List list = this.field_70170_p.func_175647_a(EntitySkeletonHorse.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntitySkeletonHorse entity = (EntitySkeletonHorse)list.get(i1);
                    if (entity == null || entity.func_184207_aI() || this.field_70170_p.field_72995_K) continue;
                    entity.func_110234_j(true);
                    entity.func_110219_q(true);
                    entity.field_70173_aa = 0;
                    this.func_184220_m((Entity)entity);
                    this.func_184185_a(SoundEvents.field_187702_cm, 1.0f, 1.0f);
                    break;
                }
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && stack.func_190926_b() && player.func_70093_af() && this.func_184218_aH()) {
            this.func_184210_p();
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151024_Q) {
            ++this.helmetCount;
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && (EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD || stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_185764_cQ) || stack.func_77973_b() == Items.field_151008_G) && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD && stack.func_77973_b() != Items.field_151024_Q) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.CHEST, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            this.func_184201_a(EntityEquipmentSlot.LEGS, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.LEGS, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() && EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            this.func_184201_a(EntityEquipmentSlot.FEET, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.FEET, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && stack.func_77973_b() != Items.field_151057_cb && (EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.MAINHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemBow)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b() && (EntitySkeleton.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.OFFHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemFood && !(stack.func_77973_b() instanceof ItemAppleGold) || stack.func_77973_b() == Items.field_185167_i || stack.func_77973_b().func_77661_b(stack) == EnumAction.BLOCK || stack.func_77973_b() == Items.field_190929_cY)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && stack.func_190926_b()) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return this.func_70658_aO() > 10 ? ModSoundEvents.metalHit : (EngenderMod.useMobTalkerModels ? super.getRegularHurtSound() : ModSoundEvents.woodHit);
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getPierceHurtSound() : ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return EngenderMod.useMobTalkerModels ? super.getCrushHurtSound() : ModSoundEvents.woodHitCrush;
    }
}

