/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPolarBear
extends EntityFriendlyCreature
implements Light,
Animal {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityPolarBear.class, (DataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;

    public EntityPolarBear(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.func_70105_a(1.3f, 1.4f);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 32.0f, 9.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    public int getNextLevelRequirement() {
        return 50;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityPolarBear(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(1.3f, 1.4f + this.clientSideStandAnimation * 0.275f);
    }

    @Override
    public boolean canBeButchered() {
        return true;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 20.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f / this.getFittness());
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.warningSoundTicks = 20;
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_POLAR_BEAR;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getJukeboxToDanceTo() != null) {
            if (this.field_70173_aa % 10 == 0 || this.field_70173_aa % 10 == 1 || this.field_70173_aa % 10 == 2 || this.field_70173_aa % 10 == 3 || this.field_70173_aa % 10 == 4) {
                this.setStanding(false);
            } else {
                this.setStanding(true);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
            double d = this.func_70068_e((Entity)this.func_70638_az());
            float f = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
            float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
            if (d < (double)(this.reachWidth * this.reachWidth + f * f2) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 20 == 0) {
                this.func_70652_k((Entity)this.func_70638_az());
                this.func_184609_a(EnumHand.MAIN_HAND);
                if (!this.func_184592_cb().func_190926_b()) {
                    this.func_184609_a(EnumHand.OFF_HAND);
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.25f);
        }
        return flag;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            this.field_70138_W = 1.0f;
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70759_as = entitylivingbase.field_70759_as;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            strafe = entitylivingbase.field_70702_br * (this.func_70090_H() ? 1.0f : 0.5f);
            forward = entitylivingbase.field_70701_bs * (this.func_70090_H() ? 1.0f : 0.5f);
            if (forward != 0.0f) {
                this.field_70177_z = this.field_70761_aq = this.field_70759_as;
                this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            }
            if (this.func_70090_H() || this.func_180799_ab()) {
                this.field_70181_x += 0.025;
                if (entitylivingbase.field_70701_bs == 0.0f) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                } else {
                    if (this.field_70159_w > 3.0) {
                        this.field_70159_w = 3.0;
                    }
                    if (this.field_70179_y > 3.0) {
                        this.field_70179_y = 3.0;
                    }
                    if (this.field_70159_w < -3.0) {
                        this.field_70159_w = -3.0;
                    }
                    if (this.field_70179_y < -3.0) {
                        this.field_70179_y = -3.0;
                    }
                    this.field_70159_w *= this.isHero() ? 1.5 : 1.125;
                    this.field_70179_y *= this.isHero() ? 1.5 : 1.125;
                }
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (this.func_70090_H() || this.func_180799_ab() ? 20.0f : 1.0f));
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (entitylivingbase.field_70701_bs > 0.0f && this.field_70173_aa % 7 == 0) {
                this.func_180429_a(new BlockPos((Entity)this), this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_177230_c());
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING) != false || !this.func_70089_S();
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return (this.clientSideStandAnimation0 + (this.clientSideStandAnimation - this.clientSideStandAnimation0) * p_189795_1_) / 6.0f;
    }

    protected float func_189749_co() {
        return 0.99f;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean madeParent;

        private GroupData() {
        }
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super((EntityCreature)EntityPolarBear.this, 2.0);
        }

        public boolean func_75250_a() {
            return !EntityPolarBear.this.func_70631_g_() && !EntityPolarBear.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class AIMeleeAttack
    extends EntityAIFriendlyAttackMelee {
        public AIMeleeAttack() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void checkAndPerformAttack(EntityLivingBase p_190102_1_, double p_190102_2_) {
            double d0 = this.getAttackReachSqr(p_190102_1_);
            if (p_190102_2_ <= d0 && this.attackTick <= 0.0) {
                this.attackTick = 20.0;
                EntityPolarBear.this.func_70652_k((Entity)p_190102_1_);
                EntityPolarBear.this.setStanding(false);
                List list1 = EntityPolarBear.this.field_70170_p.func_175647_a(EntityLivingBase.class, p_190102_1_.func_174813_aQ().func_186662_g(2.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                if (list1 != null && !list1.isEmpty()) {
                    for (int i1 = 0; i1 < list1.size(); ++i1) {
                        EntityLivingBase entity1 = (EntityLivingBase)list1.get(i1);
                        if (EntityPolarBear.this.isOnSameTeam(entity1)) continue;
                        EntityPolarBear.this.func_70652_k((Entity)entity1);
                    }
                }
            } else if (p_190102_2_ <= d0 * 2.0) {
                if (this.attackTick <= 0.0) {
                    EntityPolarBear.this.setStanding(false);
                    this.attackTick = 20.0;
                }
                if (this.attackTick <= 10.0) {
                    EntityPolarBear.this.setStanding(true);
                    EntityPolarBear.this.playWarningSound();
                }
            } else {
                this.attackTick = 20.0;
                EntityPolarBear.this.setStanding(false);
            }
        }

        @Override
        public void func_75251_c() {
            EntityPolarBear.this.setStanding(false);
            super.func_75251_c();
        }

        @Override
        protected double getAttackReachSqr(EntityLivingBase attackTarget) {
            return (double)(this.attacker.field_70130_N * this.attacker.field_70130_N + attackTarget.field_70130_N * attackTarget.field_70130_N) + 9.0;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityPolarBear.this, false, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityPolarBear.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof EntityPolarBear && !((EntityPolarBear)creatureIn).func_70631_g_()) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }
    }
}

